/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about an activity that was performed by a campaign.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ActivityResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<ActivityResponse.Builder, ActivityResponse> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationId").getter(getter(ActivityResponse::applicationId)).setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationId").build()).build();

    private static final SdkField<String> CAMPAIGN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CampaignId").getter(getter(ActivityResponse::campaignId)).setter(setter(Builder::campaignId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CampaignId").build()).build();

    private static final SdkField<String> END_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("End")
            .getter(getter(ActivityResponse::end)).setter(setter(Builder::end))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("End").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(ActivityResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> RESULT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Result")
            .getter(getter(ActivityResponse::result)).setter(setter(Builder::result))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Result").build()).build();

    private static final SdkField<String> SCHEDULED_START_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScheduledStart").getter(getter(ActivityResponse::scheduledStart))
            .setter(setter(Builder::scheduledStart))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledStart").build()).build();

    private static final SdkField<String> START_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Start")
            .getter(getter(ActivityResponse::start)).setter(setter(Builder::start))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Start").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(ActivityResponse::state)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<Integer> SUCCESSFUL_ENDPOINT_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SuccessfulEndpointCount").getter(getter(ActivityResponse::successfulEndpointCount))
            .setter(setter(Builder::successfulEndpointCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuccessfulEndpointCount").build())
            .build();

    private static final SdkField<Integer> TIMEZONES_COMPLETED_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TimezonesCompletedCount").getter(getter(ActivityResponse::timezonesCompletedCount))
            .setter(setter(Builder::timezonesCompletedCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimezonesCompletedCount").build())
            .build();

    private static final SdkField<Integer> TIMEZONES_TOTAL_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TimezonesTotalCount").getter(getter(ActivityResponse::timezonesTotalCount))
            .setter(setter(Builder::timezonesTotalCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimezonesTotalCount").build())
            .build();

    private static final SdkField<Integer> TOTAL_ENDPOINT_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TotalEndpointCount").getter(getter(ActivityResponse::totalEndpointCount))
            .setter(setter(Builder::totalEndpointCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalEndpointCount").build())
            .build();

    private static final SdkField<String> TREATMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TreatmentId").getter(getter(ActivityResponse::treatmentId)).setter(setter(Builder::treatmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TreatmentId").build()).build();

    private static final SdkField<Map<String, String>> EXECUTION_METRICS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("ExecutionMetrics")
            .getter(getter(ActivityResponse::executionMetrics))
            .setter(setter(Builder::executionMetrics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionMetrics").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            CAMPAIGN_ID_FIELD, END_FIELD, ID_FIELD, RESULT_FIELD, SCHEDULED_START_FIELD, START_FIELD, STATE_FIELD,
            SUCCESSFUL_ENDPOINT_COUNT_FIELD, TIMEZONES_COMPLETED_COUNT_FIELD, TIMEZONES_TOTAL_COUNT_FIELD,
            TOTAL_ENDPOINT_COUNT_FIELD, TREATMENT_ID_FIELD, EXECUTION_METRICS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String applicationId;

    private final String campaignId;

    private final String end;

    private final String id;

    private final String result;

    private final String scheduledStart;

    private final String start;

    private final String state;

    private final Integer successfulEndpointCount;

    private final Integer timezonesCompletedCount;

    private final Integer timezonesTotalCount;

    private final Integer totalEndpointCount;

    private final String treatmentId;

    private final Map<String, String> executionMetrics;

    private ActivityResponse(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.campaignId = builder.campaignId;
        this.end = builder.end;
        this.id = builder.id;
        this.result = builder.result;
        this.scheduledStart = builder.scheduledStart;
        this.start = builder.start;
        this.state = builder.state;
        this.successfulEndpointCount = builder.successfulEndpointCount;
        this.timezonesCompletedCount = builder.timezonesCompletedCount;
        this.timezonesTotalCount = builder.timezonesTotalCount;
        this.totalEndpointCount = builder.totalEndpointCount;
        this.treatmentId = builder.treatmentId;
        this.executionMetrics = builder.executionMetrics;
    }

    /**
     * <p>
     * The unique identifier for the application that the campaign applies to.
     * </p>
     * 
     * @return The unique identifier for the application that the campaign applies to.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The unique identifier for the campaign that the activity applies to.
     * </p>
     * 
     * @return The unique identifier for the campaign that the activity applies to.
     */
    public final String campaignId() {
        return campaignId;
    }

    /**
     * <p>
     * The actual time, in ISO 8601 format, when the activity was marked CANCELLED or COMPLETED.
     * </p>
     * 
     * @return The actual time, in ISO 8601 format, when the activity was marked CANCELLED or COMPLETED.
     */
    public final String end() {
        return end;
    }

    /**
     * <p>
     * The unique identifier for the activity.
     * </p>
     * 
     * @return The unique identifier for the activity.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * Specifies whether the activity succeeded. Possible values are SUCCESS and FAIL.
     * </p>
     * 
     * @return Specifies whether the activity succeeded. Possible values are SUCCESS and FAIL.
     */
    public final String result() {
        return result;
    }

    /**
     * <p>
     * The scheduled start time, in ISO 8601 format, for the activity.
     * </p>
     * 
     * @return The scheduled start time, in ISO 8601 format, for the activity.
     */
    public final String scheduledStart() {
        return scheduledStart;
    }

    /**
     * <p>
     * The actual start time, in ISO 8601 format, of the activity.
     * </p>
     * 
     * @return The actual start time, in ISO 8601 format, of the activity.
     */
    public final String start() {
        return start;
    }

    /**
     * <p>
     * The current status of the activity. Possible values are: PENDING, INITIALIZING, RUNNING, PAUSED, CANCELLED, and
     * COMPLETED.
     * </p>
     * 
     * @return The current status of the activity. Possible values are: PENDING, INITIALIZING, RUNNING, PAUSED,
     *         CANCELLED, and COMPLETED.
     */
    public final String state() {
        return state;
    }

    /**
     * <p>
     * The total number of endpoints that the campaign successfully delivered messages to.
     * </p>
     * 
     * @return The total number of endpoints that the campaign successfully delivered messages to.
     */
    public final Integer successfulEndpointCount() {
        return successfulEndpointCount;
    }

    /**
     * <p>
     * The total number of time zones that were completed.
     * </p>
     * 
     * @return The total number of time zones that were completed.
     */
    public final Integer timezonesCompletedCount() {
        return timezonesCompletedCount;
    }

    /**
     * <p>
     * The total number of unique time zones that are in the segment for the campaign.
     * </p>
     * 
     * @return The total number of unique time zones that are in the segment for the campaign.
     */
    public final Integer timezonesTotalCount() {
        return timezonesTotalCount;
    }

    /**
     * <p>
     * The total number of endpoints that the campaign attempted to deliver messages to.
     * </p>
     * 
     * @return The total number of endpoints that the campaign attempted to deliver messages to.
     */
    public final Integer totalEndpointCount() {
        return totalEndpointCount;
    }

    /**
     * <p>
     * The unique identifier for the campaign treatment that the activity applies to. A treatment is a variation of a
     * campaign that's used for A/B testing of a campaign.
     * </p>
     * 
     * @return The unique identifier for the campaign treatment that the activity applies to. A treatment is a variation
     *         of a campaign that's used for A/B testing of a campaign.
     */
    public final String treatmentId() {
        return treatmentId;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExecutionMetrics property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasExecutionMetrics() {
        return executionMetrics != null && !(executionMetrics instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A JSON object that contains metrics relating to the campaign execution for this campaign activity. For
     * information about the structure and contents of the results, see <a
     * href="https://docs.aws.amazon.com//pinpoint/latest/developerguide/analytics-standard-metrics.html">Standard
     * Amazon Pinpoint analytics metrics</a> in the <i>Amazon Pinpoint Developer Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExecutionMetrics} method.
     * </p>
     * 
     * @return A JSON object that contains metrics relating to the campaign execution for this campaign activity. For
     *         information about the structure and contents of the results, see <a
     *         href="https://docs.aws.amazon.com//pinpoint/latest/developerguide/analytics-standard-metrics.html"
     *         >Standard Amazon Pinpoint analytics metrics</a> in the <i>Amazon Pinpoint Developer Guide</i>.
     */
    public final Map<String, String> executionMetrics() {
        return executionMetrics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(campaignId());
        hashCode = 31 * hashCode + Objects.hashCode(end());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(result());
        hashCode = 31 * hashCode + Objects.hashCode(scheduledStart());
        hashCode = 31 * hashCode + Objects.hashCode(start());
        hashCode = 31 * hashCode + Objects.hashCode(state());
        hashCode = 31 * hashCode + Objects.hashCode(successfulEndpointCount());
        hashCode = 31 * hashCode + Objects.hashCode(timezonesCompletedCount());
        hashCode = 31 * hashCode + Objects.hashCode(timezonesTotalCount());
        hashCode = 31 * hashCode + Objects.hashCode(totalEndpointCount());
        hashCode = 31 * hashCode + Objects.hashCode(treatmentId());
        hashCode = 31 * hashCode + Objects.hashCode(hasExecutionMetrics() ? executionMetrics() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActivityResponse)) {
            return false;
        }
        ActivityResponse other = (ActivityResponse) obj;
        return Objects.equals(applicationId(), other.applicationId()) && Objects.equals(campaignId(), other.campaignId())
                && Objects.equals(end(), other.end()) && Objects.equals(id(), other.id())
                && Objects.equals(result(), other.result()) && Objects.equals(scheduledStart(), other.scheduledStart())
                && Objects.equals(start(), other.start()) && Objects.equals(state(), other.state())
                && Objects.equals(successfulEndpointCount(), other.successfulEndpointCount())
                && Objects.equals(timezonesCompletedCount(), other.timezonesCompletedCount())
                && Objects.equals(timezonesTotalCount(), other.timezonesTotalCount())
                && Objects.equals(totalEndpointCount(), other.totalEndpointCount())
                && Objects.equals(treatmentId(), other.treatmentId()) && hasExecutionMetrics() == other.hasExecutionMetrics()
                && Objects.equals(executionMetrics(), other.executionMetrics());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ActivityResponse").add("ApplicationId", applicationId()).add("CampaignId", campaignId())
                .add("End", end()).add("Id", id()).add("Result", result()).add("ScheduledStart", scheduledStart())
                .add("Start", start()).add("State", state()).add("SuccessfulEndpointCount", successfulEndpointCount())
                .add("TimezonesCompletedCount", timezonesCompletedCount()).add("TimezonesTotalCount", timezonesTotalCount())
                .add("TotalEndpointCount", totalEndpointCount()).add("TreatmentId", treatmentId())
                .add("ExecutionMetrics", hasExecutionMetrics() ? executionMetrics() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "CampaignId":
            return Optional.ofNullable(clazz.cast(campaignId()));
        case "End":
            return Optional.ofNullable(clazz.cast(end()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Result":
            return Optional.ofNullable(clazz.cast(result()));
        case "ScheduledStart":
            return Optional.ofNullable(clazz.cast(scheduledStart()));
        case "Start":
            return Optional.ofNullable(clazz.cast(start()));
        case "State":
            return Optional.ofNullable(clazz.cast(state()));
        case "SuccessfulEndpointCount":
            return Optional.ofNullable(clazz.cast(successfulEndpointCount()));
        case "TimezonesCompletedCount":
            return Optional.ofNullable(clazz.cast(timezonesCompletedCount()));
        case "TimezonesTotalCount":
            return Optional.ofNullable(clazz.cast(timezonesTotalCount()));
        case "TotalEndpointCount":
            return Optional.ofNullable(clazz.cast(totalEndpointCount()));
        case "TreatmentId":
            return Optional.ofNullable(clazz.cast(treatmentId()));
        case "ExecutionMetrics":
            return Optional.ofNullable(clazz.cast(executionMetrics()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ApplicationId", APPLICATION_ID_FIELD);
        map.put("CampaignId", CAMPAIGN_ID_FIELD);
        map.put("End", END_FIELD);
        map.put("Id", ID_FIELD);
        map.put("Result", RESULT_FIELD);
        map.put("ScheduledStart", SCHEDULED_START_FIELD);
        map.put("Start", START_FIELD);
        map.put("State", STATE_FIELD);
        map.put("SuccessfulEndpointCount", SUCCESSFUL_ENDPOINT_COUNT_FIELD);
        map.put("TimezonesCompletedCount", TIMEZONES_COMPLETED_COUNT_FIELD);
        map.put("TimezonesTotalCount", TIMEZONES_TOTAL_COUNT_FIELD);
        map.put("TotalEndpointCount", TOTAL_ENDPOINT_COUNT_FIELD);
        map.put("TreatmentId", TREATMENT_ID_FIELD);
        map.put("ExecutionMetrics", EXECUTION_METRICS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ActivityResponse, T> g) {
        return obj -> g.apply((ActivityResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ActivityResponse> {
        /**
         * <p>
         * The unique identifier for the application that the campaign applies to.
         * </p>
         * 
         * @param applicationId
         *        The unique identifier for the application that the campaign applies to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The unique identifier for the campaign that the activity applies to.
         * </p>
         * 
         * @param campaignId
         *        The unique identifier for the campaign that the activity applies to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder campaignId(String campaignId);

        /**
         * <p>
         * The actual time, in ISO 8601 format, when the activity was marked CANCELLED or COMPLETED.
         * </p>
         * 
         * @param end
         *        The actual time, in ISO 8601 format, when the activity was marked CANCELLED or COMPLETED.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder end(String end);

        /**
         * <p>
         * The unique identifier for the activity.
         * </p>
         * 
         * @param id
         *        The unique identifier for the activity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * Specifies whether the activity succeeded. Possible values are SUCCESS and FAIL.
         * </p>
         * 
         * @param result
         *        Specifies whether the activity succeeded. Possible values are SUCCESS and FAIL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder result(String result);

        /**
         * <p>
         * The scheduled start time, in ISO 8601 format, for the activity.
         * </p>
         * 
         * @param scheduledStart
         *        The scheduled start time, in ISO 8601 format, for the activity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledStart(String scheduledStart);

        /**
         * <p>
         * The actual start time, in ISO 8601 format, of the activity.
         * </p>
         * 
         * @param start
         *        The actual start time, in ISO 8601 format, of the activity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder start(String start);

        /**
         * <p>
         * The current status of the activity. Possible values are: PENDING, INITIALIZING, RUNNING, PAUSED, CANCELLED,
         * and COMPLETED.
         * </p>
         * 
         * @param state
         *        The current status of the activity. Possible values are: PENDING, INITIALIZING, RUNNING, PAUSED,
         *        CANCELLED, and COMPLETED.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(String state);

        /**
         * <p>
         * The total number of endpoints that the campaign successfully delivered messages to.
         * </p>
         * 
         * @param successfulEndpointCount
         *        The total number of endpoints that the campaign successfully delivered messages to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successfulEndpointCount(Integer successfulEndpointCount);

        /**
         * <p>
         * The total number of time zones that were completed.
         * </p>
         * 
         * @param timezonesCompletedCount
         *        The total number of time zones that were completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timezonesCompletedCount(Integer timezonesCompletedCount);

        /**
         * <p>
         * The total number of unique time zones that are in the segment for the campaign.
         * </p>
         * 
         * @param timezonesTotalCount
         *        The total number of unique time zones that are in the segment for the campaign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timezonesTotalCount(Integer timezonesTotalCount);

        /**
         * <p>
         * The total number of endpoints that the campaign attempted to deliver messages to.
         * </p>
         * 
         * @param totalEndpointCount
         *        The total number of endpoints that the campaign attempted to deliver messages to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalEndpointCount(Integer totalEndpointCount);

        /**
         * <p>
         * The unique identifier for the campaign treatment that the activity applies to. A treatment is a variation of
         * a campaign that's used for A/B testing of a campaign.
         * </p>
         * 
         * @param treatmentId
         *        The unique identifier for the campaign treatment that the activity applies to. A treatment is a
         *        variation of a campaign that's used for A/B testing of a campaign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder treatmentId(String treatmentId);

        /**
         * <p>
         * A JSON object that contains metrics relating to the campaign execution for this campaign activity. For
         * information about the structure and contents of the results, see <a
         * href="https://docs.aws.amazon.com//pinpoint/latest/developerguide/analytics-standard-metrics.html">Standard
         * Amazon Pinpoint analytics metrics</a> in the <i>Amazon Pinpoint Developer Guide</i>.
         * </p>
         * 
         * @param executionMetrics
         *        A JSON object that contains metrics relating to the campaign execution for this campaign activity. For
         *        information about the structure and contents of the results, see <a
         *        href="https://docs.aws.amazon.com//pinpoint/latest/developerguide/analytics-standard-metrics.html"
         *        >Standard Amazon Pinpoint analytics metrics</a> in the <i>Amazon Pinpoint Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionMetrics(Map<String, String> executionMetrics);
    }

    static final class BuilderImpl implements Builder {
        private String applicationId;

        private String campaignId;

        private String end;

        private String id;

        private String result;

        private String scheduledStart;

        private String start;

        private String state;

        private Integer successfulEndpointCount;

        private Integer timezonesCompletedCount;

        private Integer timezonesTotalCount;

        private Integer totalEndpointCount;

        private String treatmentId;

        private Map<String, String> executionMetrics = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ActivityResponse model) {
            applicationId(model.applicationId);
            campaignId(model.campaignId);
            end(model.end);
            id(model.id);
            result(model.result);
            scheduledStart(model.scheduledStart);
            start(model.start);
            state(model.state);
            successfulEndpointCount(model.successfulEndpointCount);
            timezonesCompletedCount(model.timezonesCompletedCount);
            timezonesTotalCount(model.timezonesTotalCount);
            totalEndpointCount(model.totalEndpointCount);
            treatmentId(model.treatmentId);
            executionMetrics(model.executionMetrics);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getCampaignId() {
            return campaignId;
        }

        public final void setCampaignId(String campaignId) {
            this.campaignId = campaignId;
        }

        @Override
        public final Builder campaignId(String campaignId) {
            this.campaignId = campaignId;
            return this;
        }

        public final String getEnd() {
            return end;
        }

        public final void setEnd(String end) {
            this.end = end;
        }

        @Override
        public final Builder end(String end) {
            this.end = end;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getResult() {
            return result;
        }

        public final void setResult(String result) {
            this.result = result;
        }

        @Override
        public final Builder result(String result) {
            this.result = result;
            return this;
        }

        public final String getScheduledStart() {
            return scheduledStart;
        }

        public final void setScheduledStart(String scheduledStart) {
            this.scheduledStart = scheduledStart;
        }

        @Override
        public final Builder scheduledStart(String scheduledStart) {
            this.scheduledStart = scheduledStart;
            return this;
        }

        public final String getStart() {
            return start;
        }

        public final void setStart(String start) {
            this.start = start;
        }

        @Override
        public final Builder start(String start) {
            this.start = start;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final Integer getSuccessfulEndpointCount() {
            return successfulEndpointCount;
        }

        public final void setSuccessfulEndpointCount(Integer successfulEndpointCount) {
            this.successfulEndpointCount = successfulEndpointCount;
        }

        @Override
        public final Builder successfulEndpointCount(Integer successfulEndpointCount) {
            this.successfulEndpointCount = successfulEndpointCount;
            return this;
        }

        public final Integer getTimezonesCompletedCount() {
            return timezonesCompletedCount;
        }

        public final void setTimezonesCompletedCount(Integer timezonesCompletedCount) {
            this.timezonesCompletedCount = timezonesCompletedCount;
        }

        @Override
        public final Builder timezonesCompletedCount(Integer timezonesCompletedCount) {
            this.timezonesCompletedCount = timezonesCompletedCount;
            return this;
        }

        public final Integer getTimezonesTotalCount() {
            return timezonesTotalCount;
        }

        public final void setTimezonesTotalCount(Integer timezonesTotalCount) {
            this.timezonesTotalCount = timezonesTotalCount;
        }

        @Override
        public final Builder timezonesTotalCount(Integer timezonesTotalCount) {
            this.timezonesTotalCount = timezonesTotalCount;
            return this;
        }

        public final Integer getTotalEndpointCount() {
            return totalEndpointCount;
        }

        public final void setTotalEndpointCount(Integer totalEndpointCount) {
            this.totalEndpointCount = totalEndpointCount;
        }

        @Override
        public final Builder totalEndpointCount(Integer totalEndpointCount) {
            this.totalEndpointCount = totalEndpointCount;
            return this;
        }

        public final String getTreatmentId() {
            return treatmentId;
        }

        public final void setTreatmentId(String treatmentId) {
            this.treatmentId = treatmentId;
        }

        @Override
        public final Builder treatmentId(String treatmentId) {
            this.treatmentId = treatmentId;
            return this;
        }

        public final Map<String, String> getExecutionMetrics() {
            if (executionMetrics instanceof SdkAutoConstructMap) {
                return null;
            }
            return executionMetrics;
        }

        public final void setExecutionMetrics(Map<String, String> executionMetrics) {
            this.executionMetrics = MapOf__stringCopier.copy(executionMetrics);
        }

        @Override
        public final Builder executionMetrics(Map<String, String> executionMetrics) {
            this.executionMetrics = MapOf__stringCopier.copy(executionMetrics);
            return this;
        }

        @Override
        public ActivityResponse build() {
            return new ActivityResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
