/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pinpoint.model.PinpointRequest;
import software.amazon.awssdk.services.pinpoint.model.SMSTemplateRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateSmsTemplateRequest
extends PinpointRequest
implements ToCopyableBuilder<Builder, UpdateSmsTemplateRequest> {
    private static final SdkField<Boolean> CREATE_NEW_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CreateNewVersion").getter(UpdateSmsTemplateRequest.getter(UpdateSmsTemplateRequest::createNewVersion)).setter(UpdateSmsTemplateRequest.setter(Builder::createNewVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("create-new-version").build()}).build();
    private static final SdkField<SMSTemplateRequest> SMS_TEMPLATE_REQUEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SMSTemplateRequest").getter(UpdateSmsTemplateRequest.getter(UpdateSmsTemplateRequest::smsTemplateRequest)).setter(UpdateSmsTemplateRequest.setter(Builder::smsTemplateRequest)).constructor(SMSTemplateRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SMSTemplateRequest").build(), PayloadTrait.create()}).build();
    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateName").getter(UpdateSmsTemplateRequest.getter(UpdateSmsTemplateRequest::templateName)).setter(UpdateSmsTemplateRequest.setter(Builder::templateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("template-name").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Version").getter(UpdateSmsTemplateRequest.getter(UpdateSmsTemplateRequest::version)).setter(UpdateSmsTemplateRequest.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("version").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATE_NEW_VERSION_FIELD, SMS_TEMPLATE_REQUEST_FIELD, TEMPLATE_NAME_FIELD, VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateSmsTemplateRequest.memberNameToFieldInitializer();
    private final Boolean createNewVersion;
    private final SMSTemplateRequest smsTemplateRequest;
    private final String templateName;
    private final String version;

    private UpdateSmsTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.createNewVersion = builder.createNewVersion;
        this.smsTemplateRequest = builder.smsTemplateRequest;
        this.templateName = builder.templateName;
        this.version = builder.version;
    }

    public final Boolean createNewVersion() {
        return this.createNewVersion;
    }

    public final SMSTemplateRequest smsTemplateRequest() {
        return this.smsTemplateRequest;
    }

    public final String templateName() {
        return this.templateName;
    }

    public final String version() {
        return this.version;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.createNewVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.smsTemplateRequest());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSmsTemplateRequest)) {
            return false;
        }
        UpdateSmsTemplateRequest other = (UpdateSmsTemplateRequest)((Object)obj);
        return Objects.equals(this.createNewVersion(), other.createNewVersion()) && Objects.equals(this.smsTemplateRequest(), other.smsTemplateRequest()) && Objects.equals(this.templateName(), other.templateName()) && Objects.equals(this.version(), other.version());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateSmsTemplateRequest").add("CreateNewVersion", (Object)this.createNewVersion()).add("SMSTemplateRequest", (Object)this.smsTemplateRequest()).add("TemplateName", (Object)this.templateName()).add("Version", (Object)this.version()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreateNewVersion": {
                return Optional.ofNullable(clazz.cast(this.createNewVersion()));
            }
            case "SMSTemplateRequest": {
                return Optional.ofNullable(clazz.cast(this.smsTemplateRequest()));
            }
            case "TemplateName": {
                return Optional.ofNullable(clazz.cast(this.templateName()));
            }
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("create-new-version", CREATE_NEW_VERSION_FIELD);
        map.put("SMSTemplateRequest", SMS_TEMPLATE_REQUEST_FIELD);
        map.put("template-name", TEMPLATE_NAME_FIELD);
        map.put("version", VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateSmsTemplateRequest, T> g) {
        return obj -> g.apply((UpdateSmsTemplateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointRequest.BuilderImpl
    implements Builder {
        private Boolean createNewVersion;
        private SMSTemplateRequest smsTemplateRequest;
        private String templateName;
        private String version;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSmsTemplateRequest model) {
            super(model);
            this.createNewVersion(model.createNewVersion);
            this.smsTemplateRequest(model.smsTemplateRequest);
            this.templateName(model.templateName);
            this.version(model.version);
        }

        public final Boolean getCreateNewVersion() {
            return this.createNewVersion;
        }

        public final void setCreateNewVersion(Boolean createNewVersion) {
            this.createNewVersion = createNewVersion;
        }

        @Override
        public final Builder createNewVersion(Boolean createNewVersion) {
            this.createNewVersion = createNewVersion;
            return this;
        }

        public final SMSTemplateRequest.Builder getSmsTemplateRequest() {
            return this.smsTemplateRequest != null ? this.smsTemplateRequest.toBuilder() : null;
        }

        public final void setSmsTemplateRequest(SMSTemplateRequest.BuilderImpl smsTemplateRequest) {
            this.smsTemplateRequest = smsTemplateRequest != null ? smsTemplateRequest.build() : null;
        }

        @Override
        public final Builder smsTemplateRequest(SMSTemplateRequest smsTemplateRequest) {
            this.smsTemplateRequest = smsTemplateRequest;
            return this;
        }

        public final String getTemplateName() {
            return this.templateName;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSmsTemplateRequest build() {
            return new UpdateSmsTemplateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PinpointRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateSmsTemplateRequest> {
        public Builder createNewVersion(Boolean var1);

        public Builder smsTemplateRequest(SMSTemplateRequest var1);

        default public Builder smsTemplateRequest(Consumer<SMSTemplateRequest.Builder> smsTemplateRequest) {
            return this.smsTemplateRequest((SMSTemplateRequest)((SMSTemplateRequest.Builder)SMSTemplateRequest.builder().applyMutation(smsTemplateRequest)).build());
        }

        public Builder templateName(String var1);

        public Builder version(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

