/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EndpointLocation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EndpointLocation> {
    private static final SdkField<String> CITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("City").getter(EndpointLocation.getter(EndpointLocation::city)).setter(EndpointLocation.setter(Builder::city)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("City").build()}).build();
    private static final SdkField<String> COUNTRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Country").getter(EndpointLocation.getter(EndpointLocation::country)).setter(EndpointLocation.setter(Builder::country)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Country").build()}).build();
    private static final SdkField<Double> LATITUDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Latitude").getter(EndpointLocation.getter(EndpointLocation::latitude)).setter(EndpointLocation.setter(Builder::latitude)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Latitude").build()}).build();
    private static final SdkField<Double> LONGITUDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Longitude").getter(EndpointLocation.getter(EndpointLocation::longitude)).setter(EndpointLocation.setter(Builder::longitude)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Longitude").build()}).build();
    private static final SdkField<String> POSTAL_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PostalCode").getter(EndpointLocation.getter(EndpointLocation::postalCode)).setter(EndpointLocation.setter(Builder::postalCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PostalCode").build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Region").getter(EndpointLocation.getter(EndpointLocation::region)).setter(EndpointLocation.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CITY_FIELD, COUNTRY_FIELD, LATITUDE_FIELD, LONGITUDE_FIELD, POSTAL_CODE_FIELD, REGION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("City", CITY_FIELD);
            this.put("Country", COUNTRY_FIELD);
            this.put("Latitude", LATITUDE_FIELD);
            this.put("Longitude", LONGITUDE_FIELD);
            this.put("PostalCode", POSTAL_CODE_FIELD);
            this.put("Region", REGION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String city;
    private final String country;
    private final Double latitude;
    private final Double longitude;
    private final String postalCode;
    private final String region;

    private EndpointLocation(BuilderImpl builder) {
        this.city = builder.city;
        this.country = builder.country;
        this.latitude = builder.latitude;
        this.longitude = builder.longitude;
        this.postalCode = builder.postalCode;
        this.region = builder.region;
    }

    public final String city() {
        return this.city;
    }

    public final String country() {
        return this.country;
    }

    public final Double latitude() {
        return this.latitude;
    }

    public final Double longitude() {
        return this.longitude;
    }

    public final String postalCode() {
        return this.postalCode;
    }

    public final String region() {
        return this.region;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.city());
        hashCode = 31 * hashCode + Objects.hashCode(this.country());
        hashCode = 31 * hashCode + Objects.hashCode(this.latitude());
        hashCode = 31 * hashCode + Objects.hashCode(this.longitude());
        hashCode = 31 * hashCode + Objects.hashCode(this.postalCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EndpointLocation)) {
            return false;
        }
        EndpointLocation other = (EndpointLocation)obj;
        return Objects.equals(this.city(), other.city()) && Objects.equals(this.country(), other.country()) && Objects.equals(this.latitude(), other.latitude()) && Objects.equals(this.longitude(), other.longitude()) && Objects.equals(this.postalCode(), other.postalCode()) && Objects.equals(this.region(), other.region());
    }

    public final String toString() {
        return ToString.builder((String)"EndpointLocation").add("City", (Object)this.city()).add("Country", (Object)this.country()).add("Latitude", (Object)this.latitude()).add("Longitude", (Object)this.longitude()).add("PostalCode", (Object)this.postalCode()).add("Region", (Object)this.region()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "City": {
                return Optional.ofNullable(clazz.cast(this.city()));
            }
            case "Country": {
                return Optional.ofNullable(clazz.cast(this.country()));
            }
            case "Latitude": {
                return Optional.ofNullable(clazz.cast(this.latitude()));
            }
            case "Longitude": {
                return Optional.ofNullable(clazz.cast(this.longitude()));
            }
            case "PostalCode": {
                return Optional.ofNullable(clazz.cast(this.postalCode()));
            }
            case "Region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<EndpointLocation, T> g) {
        return obj -> g.apply((EndpointLocation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String city;
        private String country;
        private Double latitude;
        private Double longitude;
        private String postalCode;
        private String region;

        private BuilderImpl() {
        }

        private BuilderImpl(EndpointLocation model) {
            this.city(model.city);
            this.country(model.country);
            this.latitude(model.latitude);
            this.longitude(model.longitude);
            this.postalCode(model.postalCode);
            this.region(model.region);
        }

        public final String getCity() {
            return this.city;
        }

        public final void setCity(String city) {
            this.city = city;
        }

        @Override
        public final Builder city(String city) {
            this.city = city;
            return this;
        }

        public final String getCountry() {
            return this.country;
        }

        public final void setCountry(String country) {
            this.country = country;
        }

        @Override
        public final Builder country(String country) {
            this.country = country;
            return this;
        }

        public final Double getLatitude() {
            return this.latitude;
        }

        public final void setLatitude(Double latitude) {
            this.latitude = latitude;
        }

        @Override
        public final Builder latitude(Double latitude) {
            this.latitude = latitude;
            return this;
        }

        public final Double getLongitude() {
            return this.longitude;
        }

        public final void setLongitude(Double longitude) {
            this.longitude = longitude;
        }

        @Override
        public final Builder longitude(Double longitude) {
            this.longitude = longitude;
            return this;
        }

        public final String getPostalCode() {
            return this.postalCode;
        }

        public final void setPostalCode(String postalCode) {
            this.postalCode = postalCode;
        }

        @Override
        public final Builder postalCode(String postalCode) {
            this.postalCode = postalCode;
            return this;
        }

        public final String getRegion() {
            return this.region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public EndpointLocation build() {
            return new EndpointLocation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EndpointLocation> {
        public Builder city(String var1);

        public Builder country(String var1);

        public Builder latitude(Double var1);

        public Builder longitude(Double var1);

        public Builder postalCode(String var1);

        public Builder region(String var1);
    }
}

