/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies a batch of endpoints and events to process.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EventsBatch implements SdkPojo, Serializable, ToCopyableBuilder<EventsBatch.Builder, EventsBatch> {
    private static final SdkField<PublicEndpoint> ENDPOINT_FIELD = SdkField.<PublicEndpoint> builder(MarshallingType.SDK_POJO)
            .memberName("Endpoint").getter(getter(EventsBatch::endpoint)).setter(setter(Builder::endpoint))
            .constructor(PublicEndpoint::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoint").build()).build();

    private static final SdkField<Map<String, Event>> EVENTS_FIELD = SdkField
            .<Map<String, Event>> builder(MarshallingType.MAP)
            .memberName("Events")
            .getter(getter(EventsBatch::events))
            .setter(setter(Builder::events))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Events").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Event> builder(MarshallingType.SDK_POJO)
                                            .constructor(Event::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_FIELD, EVENTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final PublicEndpoint endpoint;

    private final Map<String, Event> events;

    private EventsBatch(BuilderImpl builder) {
        this.endpoint = builder.endpoint;
        this.events = builder.events;
    }

    /**
     * <p>
     * A set of properties and attributes that are associated with the endpoint.
     * </p>
     * 
     * @return A set of properties and attributes that are associated with the endpoint.
     */
    public final PublicEndpoint endpoint() {
        return endpoint;
    }

    /**
     * For responses, this returns true if the service returned a value for the Events property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEvents() {
        return events != null && !(events instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A set of properties that are associated with the event.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEvents} method.
     * </p>
     * 
     * @return A set of properties that are associated with the event.
     */
    public final Map<String, Event> events() {
        return events;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(hasEvents() ? events() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventsBatch)) {
            return false;
        }
        EventsBatch other = (EventsBatch) obj;
        return Objects.equals(endpoint(), other.endpoint()) && hasEvents() == other.hasEvents()
                && Objects.equals(events(), other.events());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EventsBatch").add("Endpoint", endpoint()).add("Events", hasEvents() ? events() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Endpoint":
            return Optional.ofNullable(clazz.cast(endpoint()));
        case "Events":
            return Optional.ofNullable(clazz.cast(events()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EventsBatch, T> g) {
        return obj -> g.apply((EventsBatch) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EventsBatch> {
        /**
         * <p>
         * A set of properties and attributes that are associated with the endpoint.
         * </p>
         * 
         * @param endpoint
         *        A set of properties and attributes that are associated with the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoint(PublicEndpoint endpoint);

        /**
         * <p>
         * A set of properties and attributes that are associated with the endpoint.
         * </p>
         * This is a convenience method that creates an instance of the {@link PublicEndpoint.Builder} avoiding the need
         * to create one manually via {@link PublicEndpoint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PublicEndpoint.Builder#build()} is called immediately and its
         * result is passed to {@link #endpoint(PublicEndpoint)}.
         * 
         * @param endpoint
         *        a consumer that will call methods on {@link PublicEndpoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endpoint(PublicEndpoint)
         */
        default Builder endpoint(Consumer<PublicEndpoint.Builder> endpoint) {
            return endpoint(PublicEndpoint.builder().applyMutation(endpoint).build());
        }

        /**
         * <p>
         * A set of properties that are associated with the event.
         * </p>
         * 
         * @param events
         *        A set of properties that are associated with the event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder events(Map<String, Event> events);
    }

    static final class BuilderImpl implements Builder {
        private PublicEndpoint endpoint;

        private Map<String, Event> events = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EventsBatch model) {
            endpoint(model.endpoint);
            events(model.events);
        }

        public final PublicEndpoint.Builder getEndpoint() {
            return endpoint != null ? endpoint.toBuilder() : null;
        }

        public final void setEndpoint(PublicEndpoint.BuilderImpl endpoint) {
            this.endpoint = endpoint != null ? endpoint.build() : null;
        }

        @Override
        public final Builder endpoint(PublicEndpoint endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final Map<String, Event.Builder> getEvents() {
            Map<String, Event.Builder> result = MapOfEventCopier.copyToBuilder(this.events);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setEvents(Map<String, Event.BuilderImpl> events) {
            this.events = MapOfEventCopier.copyFromBuilder(events);
        }

        @Override
        public final Builder events(Map<String, Event> events) {
            this.events = MapOfEventCopier.copy(events);
            return this;
        }

        @Override
        public EventsBatch build() {
            return new EventsBatch(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
