/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the settings that define the relationships between segment groups for a segment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SegmentGroupList implements SdkPojo, Serializable,
        ToCopyableBuilder<SegmentGroupList.Builder, SegmentGroupList> {
    private static final SdkField<List<SegmentGroup>> GROUPS_FIELD = SdkField
            .<List<SegmentGroup>> builder(MarshallingType.LIST)
            .memberName("Groups")
            .getter(getter(SegmentGroupList::groups))
            .setter(setter(Builder::groups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Groups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SegmentGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(SegmentGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> INCLUDE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Include")
            .getter(getter(SegmentGroupList::includeAsString)).setter(setter(Builder::include))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Include").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUPS_FIELD, INCLUDE_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<SegmentGroup> groups;

    private final String include;

    private SegmentGroupList(BuilderImpl builder) {
        this.groups = builder.groups;
        this.include = builder.include;
    }

    /**
     * For responses, this returns true if the service returned a value for the Groups property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasGroups() {
        return groups != null && !(groups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array that defines the set of segment criteria to evaluate when handling segment groups for the segment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGroups} method.
     * </p>
     * 
     * @return An array that defines the set of segment criteria to evaluate when handling segment groups for the
     *         segment.
     */
    public final List<SegmentGroup> groups() {
        return groups;
    }

    /**
     * <p>
     * Specifies how to handle multiple segment groups for the segment. For example, if the segment includes three
     * segment groups, whether the resulting segment includes endpoints that match all, any, or none of the segment
     * groups.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #include} will
     * return {@link Include#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #includeAsString}.
     * </p>
     * 
     * @return Specifies how to handle multiple segment groups for the segment. For example, if the segment includes
     *         three segment groups, whether the resulting segment includes endpoints that match all, any, or none of
     *         the segment groups.
     * @see Include
     */
    public final Include include() {
        return Include.fromValue(include);
    }

    /**
     * <p>
     * Specifies how to handle multiple segment groups for the segment. For example, if the segment includes three
     * segment groups, whether the resulting segment includes endpoints that match all, any, or none of the segment
     * groups.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #include} will
     * return {@link Include#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #includeAsString}.
     * </p>
     * 
     * @return Specifies how to handle multiple segment groups for the segment. For example, if the segment includes
     *         three segment groups, whether the resulting segment includes endpoints that match all, any, or none of
     *         the segment groups.
     * @see Include
     */
    public final String includeAsString() {
        return include;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasGroups() ? groups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(includeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SegmentGroupList)) {
            return false;
        }
        SegmentGroupList other = (SegmentGroupList) obj;
        return hasGroups() == other.hasGroups() && Objects.equals(groups(), other.groups())
                && Objects.equals(includeAsString(), other.includeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SegmentGroupList").add("Groups", hasGroups() ? groups() : null)
                .add("Include", includeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Groups":
            return Optional.ofNullable(clazz.cast(groups()));
        case "Include":
            return Optional.ofNullable(clazz.cast(includeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SegmentGroupList, T> g) {
        return obj -> g.apply((SegmentGroupList) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SegmentGroupList> {
        /**
         * <p>
         * An array that defines the set of segment criteria to evaluate when handling segment groups for the segment.
         * </p>
         * 
         * @param groups
         *        An array that defines the set of segment criteria to evaluate when handling segment groups for the
         *        segment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(Collection<SegmentGroup> groups);

        /**
         * <p>
         * An array that defines the set of segment criteria to evaluate when handling segment groups for the segment.
         * </p>
         * 
         * @param groups
         *        An array that defines the set of segment criteria to evaluate when handling segment groups for the
         *        segment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(SegmentGroup... groups);

        /**
         * <p>
         * An array that defines the set of segment criteria to evaluate when handling segment groups for the segment.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.pinpoint.model.SegmentGroup.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.pinpoint.model.SegmentGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.pinpoint.model.SegmentGroup.Builder#build()} is called immediately and
         * its result is passed to {@link #groups(List<SegmentGroup>)}.
         * 
         * @param groups
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.pinpoint.model.SegmentGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #groups(java.util.Collection<SegmentGroup>)
         */
        Builder groups(Consumer<SegmentGroup.Builder>... groups);

        /**
         * <p>
         * Specifies how to handle multiple segment groups for the segment. For example, if the segment includes three
         * segment groups, whether the resulting segment includes endpoints that match all, any, or none of the segment
         * groups.
         * </p>
         * 
         * @param include
         *        Specifies how to handle multiple segment groups for the segment. For example, if the segment includes
         *        three segment groups, whether the resulting segment includes endpoints that match all, any, or none of
         *        the segment groups.
         * @see Include
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Include
         */
        Builder include(String include);

        /**
         * <p>
         * Specifies how to handle multiple segment groups for the segment. For example, if the segment includes three
         * segment groups, whether the resulting segment includes endpoints that match all, any, or none of the segment
         * groups.
         * </p>
         * 
         * @param include
         *        Specifies how to handle multiple segment groups for the segment. For example, if the segment includes
         *        three segment groups, whether the resulting segment includes endpoints that match all, any, or none of
         *        the segment groups.
         * @see Include
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Include
         */
        Builder include(Include include);
    }

    static final class BuilderImpl implements Builder {
        private List<SegmentGroup> groups = DefaultSdkAutoConstructList.getInstance();

        private String include;

        private BuilderImpl() {
        }

        private BuilderImpl(SegmentGroupList model) {
            groups(model.groups);
            include(model.include);
        }

        public final List<SegmentGroup.Builder> getGroups() {
            List<SegmentGroup.Builder> result = ListOfSegmentGroupCopier.copyToBuilder(this.groups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroups(Collection<SegmentGroup.BuilderImpl> groups) {
            this.groups = ListOfSegmentGroupCopier.copyFromBuilder(groups);
        }

        @Override
        public final Builder groups(Collection<SegmentGroup> groups) {
            this.groups = ListOfSegmentGroupCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(SegmentGroup... groups) {
            groups(Arrays.asList(groups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(Consumer<SegmentGroup.Builder>... groups) {
            groups(Stream.of(groups).map(c -> SegmentGroup.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getInclude() {
            return include;
        }

        public final void setInclude(String include) {
            this.include = include;
        }

        @Override
        public final Builder include(String include) {
            this.include = include;
            return this;
        }

        @Override
        public final Builder include(Include include) {
            this.include(include == null ? null : include.toString());
            return this;
        }

        @Override
        public SegmentGroupList build() {
            return new SegmentGroupList(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
