/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTagsForResourceResponse extends PinpointResponse implements
        ToCopyableBuilder<ListTagsForResourceResponse.Builder, ListTagsForResourceResponse> {
    private static final SdkField<TagsModel> TAGS_MODEL_FIELD = SdkField
            .<TagsModel> builder(MarshallingType.SDK_POJO)
            .memberName("TagsModel")
            .getter(getter(ListTagsForResourceResponse::tagsModel))
            .setter(setter(Builder::tagsModel))
            .constructor(TagsModel::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagsModel").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAGS_MODEL_FIELD));

    private final TagsModel tagsModel;

    private ListTagsForResourceResponse(BuilderImpl builder) {
        super(builder);
        this.tagsModel = builder.tagsModel;
    }

    /**
     * Returns the value of the TagsModel property for this object.
     * 
     * @return The value of the TagsModel property for this object.
     */
    public final TagsModel tagsModel() {
        return tagsModel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(tagsModel());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTagsForResourceResponse)) {
            return false;
        }
        ListTagsForResourceResponse other = (ListTagsForResourceResponse) obj;
        return Objects.equals(tagsModel(), other.tagsModel());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTagsForResourceResponse").add("TagsModel", tagsModel()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TagsModel":
            return Optional.ofNullable(clazz.cast(tagsModel()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTagsForResourceResponse, T> g) {
        return obj -> g.apply((ListTagsForResourceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListTagsForResourceResponse> {
        /**
         * Sets the value of the TagsModel property for this object.
         *
         * @param tagsModel
         *        The new value for the TagsModel property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagsModel(TagsModel tagsModel);

        /**
         * Sets the value of the TagsModel property for this object.
         *
         * This is a convenience method that creates an instance of the {@link TagsModel.Builder} avoiding the need to
         * create one manually via {@link TagsModel#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TagsModel.Builder#build()} is called immediately and its result
         * is passed to {@link #tagsModel(TagsModel)}.
         * 
         * @param tagsModel
         *        a consumer that will call methods on {@link TagsModel.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagsModel(TagsModel)
         */
        default Builder tagsModel(Consumer<TagsModel.Builder> tagsModel) {
            return tagsModel(TagsModel.builder().applyMutation(tagsModel).build());
        }
    }

    static final class BuilderImpl extends PinpointResponse.BuilderImpl implements Builder {
        private TagsModel tagsModel;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTagsForResourceResponse model) {
            super(model);
            tagsModel(model.tagsModel);
        }

        public final TagsModel.Builder getTagsModel() {
            return tagsModel != null ? tagsModel.toBuilder() : null;
        }

        public final void setTagsModel(TagsModel.BuilderImpl tagsModel) {
            this.tagsModel = tagsModel != null ? tagsModel.build() : null;
        }

        @Override
        public final Builder tagsModel(TagsModel tagsModel) {
            this.tagsModel = tagsModel;
            return this;
        }

        @Override
        public ListTagsForResourceResponse build() {
            return new ListTagsForResourceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
