/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint;

import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.pinpoint.internal.PinpointServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.pinpoint.model.BadRequestException;
import software.amazon.awssdk.services.pinpoint.model.ConflictException;
import software.amazon.awssdk.services.pinpoint.model.CreateAppRequest;
import software.amazon.awssdk.services.pinpoint.model.CreateAppResponse;
import software.amazon.awssdk.services.pinpoint.model.CreateCampaignRequest;
import software.amazon.awssdk.services.pinpoint.model.CreateCampaignResponse;
import software.amazon.awssdk.services.pinpoint.model.CreateEmailTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.CreateEmailTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.CreateExportJobRequest;
import software.amazon.awssdk.services.pinpoint.model.CreateExportJobResponse;
import software.amazon.awssdk.services.pinpoint.model.CreateImportJobRequest;
import software.amazon.awssdk.services.pinpoint.model.CreateImportJobResponse;
import software.amazon.awssdk.services.pinpoint.model.CreateInAppTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.CreateInAppTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.CreateJourneyRequest;
import software.amazon.awssdk.services.pinpoint.model.CreateJourneyResponse;
import software.amazon.awssdk.services.pinpoint.model.CreatePushTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.CreatePushTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.CreateRecommenderConfigurationRequest;
import software.amazon.awssdk.services.pinpoint.model.CreateRecommenderConfigurationResponse;
import software.amazon.awssdk.services.pinpoint.model.CreateSegmentRequest;
import software.amazon.awssdk.services.pinpoint.model.CreateSegmentResponse;
import software.amazon.awssdk.services.pinpoint.model.CreateSmsTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.CreateSmsTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.CreateVoiceTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.CreateVoiceTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteAdmChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteAdmChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteApnsChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteApnsChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteApnsSandboxChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteApnsSandboxChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteApnsVoipChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteApnsVoipChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteApnsVoipSandboxChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteApnsVoipSandboxChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteAppRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteAppResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteBaiduChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteBaiduChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteCampaignRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteCampaignResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteEmailChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteEmailChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteEmailTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteEmailTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteEndpointRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteEndpointResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteEventStreamRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteEventStreamResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteGcmChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteGcmChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteInAppTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteInAppTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteJourneyRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteJourneyResponse;
import software.amazon.awssdk.services.pinpoint.model.DeletePushTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.DeletePushTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteRecommenderConfigurationRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteRecommenderConfigurationResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteSegmentRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteSegmentResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteSmsChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteSmsChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteSmsTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteSmsTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteUserEndpointsRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteUserEndpointsResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteVoiceChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteVoiceChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteVoiceTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteVoiceTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.ForbiddenException;
import software.amazon.awssdk.services.pinpoint.model.GetAdmChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.GetAdmChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.GetApnsChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.GetApnsChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.GetApnsSandboxChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.GetApnsSandboxChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.GetApnsVoipChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.GetApnsVoipChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.GetApnsVoipSandboxChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.GetApnsVoipSandboxChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.GetAppRequest;
import software.amazon.awssdk.services.pinpoint.model.GetAppResponse;
import software.amazon.awssdk.services.pinpoint.model.GetApplicationDateRangeKpiRequest;
import software.amazon.awssdk.services.pinpoint.model.GetApplicationDateRangeKpiResponse;
import software.amazon.awssdk.services.pinpoint.model.GetApplicationSettingsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetApplicationSettingsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetAppsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetAppsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetBaiduChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.GetBaiduChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignActivitiesRequest;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignActivitiesResponse;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignDateRangeKpiRequest;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignDateRangeKpiResponse;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignRequest;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignResponse;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignVersionRequest;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignVersionResponse;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignVersionsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignVersionsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetChannelsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetChannelsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetEmailChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.GetEmailChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.GetEmailTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.GetEmailTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.GetEndpointRequest;
import software.amazon.awssdk.services.pinpoint.model.GetEndpointResponse;
import software.amazon.awssdk.services.pinpoint.model.GetEventStreamRequest;
import software.amazon.awssdk.services.pinpoint.model.GetEventStreamResponse;
import software.amazon.awssdk.services.pinpoint.model.GetExportJobRequest;
import software.amazon.awssdk.services.pinpoint.model.GetExportJobResponse;
import software.amazon.awssdk.services.pinpoint.model.GetExportJobsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetExportJobsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetGcmChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.GetGcmChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.GetImportJobRequest;
import software.amazon.awssdk.services.pinpoint.model.GetImportJobResponse;
import software.amazon.awssdk.services.pinpoint.model.GetImportJobsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetImportJobsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetInAppMessagesRequest;
import software.amazon.awssdk.services.pinpoint.model.GetInAppMessagesResponse;
import software.amazon.awssdk.services.pinpoint.model.GetInAppTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.GetInAppTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.GetJourneyDateRangeKpiRequest;
import software.amazon.awssdk.services.pinpoint.model.GetJourneyDateRangeKpiResponse;
import software.amazon.awssdk.services.pinpoint.model.GetJourneyExecutionActivityMetricsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetJourneyExecutionActivityMetricsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetJourneyExecutionMetricsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetJourneyExecutionMetricsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetJourneyRequest;
import software.amazon.awssdk.services.pinpoint.model.GetJourneyResponse;
import software.amazon.awssdk.services.pinpoint.model.GetJourneyRunExecutionActivityMetricsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetJourneyRunExecutionActivityMetricsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetJourneyRunExecutionMetricsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetJourneyRunExecutionMetricsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetJourneyRunsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetJourneyRunsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetPushTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.GetPushTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.GetRecommenderConfigurationRequest;
import software.amazon.awssdk.services.pinpoint.model.GetRecommenderConfigurationResponse;
import software.amazon.awssdk.services.pinpoint.model.GetRecommenderConfigurationsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetRecommenderConfigurationsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentExportJobsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentExportJobsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentImportJobsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentImportJobsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentRequest;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentResponse;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentVersionRequest;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentVersionResponse;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentVersionsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentVersionsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetSmsChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.GetSmsChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.GetSmsTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.GetSmsTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.GetUserEndpointsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetUserEndpointsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetVoiceChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.GetVoiceChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.GetVoiceTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.GetVoiceTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.InternalServerErrorException;
import software.amazon.awssdk.services.pinpoint.model.ListJourneysRequest;
import software.amazon.awssdk.services.pinpoint.model.ListJourneysResponse;
import software.amazon.awssdk.services.pinpoint.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.pinpoint.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.pinpoint.model.ListTemplateVersionsRequest;
import software.amazon.awssdk.services.pinpoint.model.ListTemplateVersionsResponse;
import software.amazon.awssdk.services.pinpoint.model.ListTemplatesRequest;
import software.amazon.awssdk.services.pinpoint.model.ListTemplatesResponse;
import software.amazon.awssdk.services.pinpoint.model.MethodNotAllowedException;
import software.amazon.awssdk.services.pinpoint.model.NotFoundException;
import software.amazon.awssdk.services.pinpoint.model.PayloadTooLargeException;
import software.amazon.awssdk.services.pinpoint.model.PhoneNumberValidateRequest;
import software.amazon.awssdk.services.pinpoint.model.PhoneNumberValidateResponse;
import software.amazon.awssdk.services.pinpoint.model.PinpointException;
import software.amazon.awssdk.services.pinpoint.model.PutEventStreamRequest;
import software.amazon.awssdk.services.pinpoint.model.PutEventStreamResponse;
import software.amazon.awssdk.services.pinpoint.model.PutEventsRequest;
import software.amazon.awssdk.services.pinpoint.model.PutEventsResponse;
import software.amazon.awssdk.services.pinpoint.model.RemoveAttributesRequest;
import software.amazon.awssdk.services.pinpoint.model.RemoveAttributesResponse;
import software.amazon.awssdk.services.pinpoint.model.SendMessagesRequest;
import software.amazon.awssdk.services.pinpoint.model.SendMessagesResponse;
import software.amazon.awssdk.services.pinpoint.model.SendOtpMessageRequest;
import software.amazon.awssdk.services.pinpoint.model.SendOtpMessageResponse;
import software.amazon.awssdk.services.pinpoint.model.SendUsersMessagesRequest;
import software.amazon.awssdk.services.pinpoint.model.SendUsersMessagesResponse;
import software.amazon.awssdk.services.pinpoint.model.TagResourceRequest;
import software.amazon.awssdk.services.pinpoint.model.TagResourceResponse;
import software.amazon.awssdk.services.pinpoint.model.TooManyRequestsException;
import software.amazon.awssdk.services.pinpoint.model.UntagResourceRequest;
import software.amazon.awssdk.services.pinpoint.model.UntagResourceResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateAdmChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateAdmChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateApnsChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateApnsChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateApnsSandboxChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateApnsSandboxChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateApnsVoipChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateApnsVoipChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateApnsVoipSandboxChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateApnsVoipSandboxChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateApplicationSettingsRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateApplicationSettingsResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateBaiduChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateBaiduChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateCampaignRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateCampaignResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateEmailChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateEmailChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateEmailTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateEmailTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateEndpointRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateEndpointResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateEndpointsBatchRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateEndpointsBatchResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateGcmChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateGcmChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateInAppTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateInAppTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateJourneyRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateJourneyResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateJourneyStateRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateJourneyStateResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdatePushTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdatePushTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateRecommenderConfigurationRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateRecommenderConfigurationResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateSegmentRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateSegmentResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateSmsChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateSmsChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateSmsTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateSmsTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateTemplateActiveVersionRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateTemplateActiveVersionResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateVoiceChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateVoiceChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateVoiceTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateVoiceTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.VerifyOtpMessageRequest;
import software.amazon.awssdk.services.pinpoint.model.VerifyOtpMessageResponse;
import software.amazon.awssdk.services.pinpoint.transform.CreateAppRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.CreateCampaignRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.CreateEmailTemplateRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.CreateExportJobRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.CreateImportJobRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.CreateInAppTemplateRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.CreateJourneyRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.CreatePushTemplateRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.CreateRecommenderConfigurationRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.CreateSegmentRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.CreateSmsTemplateRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.CreateVoiceTemplateRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteAdmChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteApnsChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteApnsSandboxChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteApnsVoipChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteApnsVoipSandboxChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteAppRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteBaiduChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteCampaignRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteEmailChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteEmailTemplateRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteEndpointRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteEventStreamRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteGcmChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteInAppTemplateRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteJourneyRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeletePushTemplateRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteRecommenderConfigurationRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteSegmentRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteSmsChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteSmsTemplateRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteUserEndpointsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteVoiceChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteVoiceTemplateRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetAdmChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetApnsChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetApnsSandboxChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetApnsVoipChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetApnsVoipSandboxChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetAppRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetApplicationDateRangeKpiRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetApplicationSettingsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetAppsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetBaiduChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetCampaignActivitiesRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetCampaignDateRangeKpiRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetCampaignRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetCampaignVersionRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetCampaignVersionsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetCampaignsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetChannelsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetEmailChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetEmailTemplateRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetEndpointRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetEventStreamRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetExportJobRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetExportJobsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetGcmChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetImportJobRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetImportJobsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetInAppMessagesRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetInAppTemplateRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetJourneyDateRangeKpiRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetJourneyExecutionActivityMetricsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetJourneyExecutionMetricsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetJourneyRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetJourneyRunExecutionActivityMetricsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetJourneyRunExecutionMetricsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetJourneyRunsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetPushTemplateRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetRecommenderConfigurationRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetRecommenderConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetSegmentExportJobsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetSegmentImportJobsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetSegmentRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetSegmentVersionRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetSegmentVersionsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetSegmentsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetSmsChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetSmsTemplateRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetUserEndpointsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetVoiceChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetVoiceTemplateRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.ListJourneysRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.ListTemplateVersionsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.ListTemplatesRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.PhoneNumberValidateRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.PutEventStreamRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.PutEventsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.RemoveAttributesRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.SendMessagesRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.SendOtpMessageRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.SendUsersMessagesRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateAdmChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateApnsChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateApnsSandboxChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateApnsVoipChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateApnsVoipSandboxChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateApplicationSettingsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateBaiduChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateCampaignRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateEmailChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateEmailTemplateRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateEndpointRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateEndpointsBatchRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateGcmChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateInAppTemplateRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateJourneyRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateJourneyStateRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdatePushTemplateRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateRecommenderConfigurationRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateSegmentRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateSmsChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateSmsTemplateRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateTemplateActiveVersionRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateVoiceChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateVoiceTemplateRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.VerifyOtpMessageRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link PinpointClient}.
 *
 * @see PinpointClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultPinpointClient implements PinpointClient {
    private static final Logger log = Logger.loggerFor(DefaultPinpointClient.class);

    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    private final PinpointServiceClientConfiguration serviceClientConfiguration;

    protected DefaultPinpointClient(PinpointServiceClientConfiguration serviceClientConfiguration,
            SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.serviceClientConfiguration = serviceClientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Creates an application.
     * </p>
     *
     * @param createAppRequest
     * @return Result of the CreateApp operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.CreateApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateApp" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateAppResponse createApp(CreateAppRequest createAppRequest) throws BadRequestException,
            InternalServerErrorException, PayloadTooLargeException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateAppResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateAppResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createAppRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAppRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateApp");

            return clientHandler.execute(new ClientExecutionParams<CreateAppRequest, CreateAppResponse>()
                    .withOperationName("CreateApp").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(createAppRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateAppRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new campaign for an application or updates the settings of an existing campaign for an application.
     * </p>
     *
     * @param createCampaignRequest
     * @return Result of the CreateCampaign operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.CreateCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateCampaign" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateCampaignResponse createCampaign(CreateCampaignRequest createCampaignRequest) throws BadRequestException,
            InternalServerErrorException, PayloadTooLargeException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateCampaignResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateCampaignResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createCampaignRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createCampaignRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCampaign");

            return clientHandler.execute(new ClientExecutionParams<CreateCampaignRequest, CreateCampaignResponse>()
                    .withOperationName("CreateCampaign").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(createCampaignRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateCampaignRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a message template for messages that are sent through the email channel.
     * </p>
     *
     * @param createEmailTemplateRequest
     * @return Result of the CreateEmailTemplate operation returned by the service.
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.CreateEmailTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateEmailTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateEmailTemplateResponse createEmailTemplate(CreateEmailTemplateRequest createEmailTemplateRequest)
            throws MethodNotAllowedException, TooManyRequestsException, BadRequestException, InternalServerErrorException,
            ForbiddenException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateEmailTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateEmailTemplateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createEmailTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createEmailTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateEmailTemplate");

            return clientHandler.execute(new ClientExecutionParams<CreateEmailTemplateRequest, CreateEmailTemplateResponse>()
                    .withOperationName("CreateEmailTemplate").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(createEmailTemplateRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateEmailTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an export job for an application.
     * </p>
     *
     * @param createExportJobRequest
     * @return Result of the CreateExportJob operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.CreateExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateExportJob" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateExportJobResponse createExportJob(CreateExportJobRequest createExportJobRequest) throws BadRequestException,
            InternalServerErrorException, PayloadTooLargeException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateExportJobResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateExportJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createExportJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createExportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateExportJob");

            return clientHandler.execute(new ClientExecutionParams<CreateExportJobRequest, CreateExportJobResponse>()
                    .withOperationName("CreateExportJob").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(createExportJobRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateExportJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an import job for an application.
     * </p>
     *
     * @param createImportJobRequest
     * @return Result of the CreateImportJob operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.CreateImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateImportJob" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateImportJobResponse createImportJob(CreateImportJobRequest createImportJobRequest) throws BadRequestException,
            InternalServerErrorException, PayloadTooLargeException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateImportJobResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateImportJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createImportJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createImportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateImportJob");

            return clientHandler.execute(new ClientExecutionParams<CreateImportJobRequest, CreateImportJobResponse>()
                    .withOperationName("CreateImportJob").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(createImportJobRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateImportJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new message template for messages using the in-app message channel.
     * </p>
     *
     * @param createInAppTemplateRequest
     * @return Result of the CreateInAppTemplate operation returned by the service.
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.CreateInAppTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateInAppTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateInAppTemplateResponse createInAppTemplate(CreateInAppTemplateRequest createInAppTemplateRequest)
            throws MethodNotAllowedException, TooManyRequestsException, BadRequestException, InternalServerErrorException,
            ForbiddenException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateInAppTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateInAppTemplateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createInAppTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createInAppTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateInAppTemplate");

            return clientHandler.execute(new ClientExecutionParams<CreateInAppTemplateRequest, CreateInAppTemplateResponse>()
                    .withOperationName("CreateInAppTemplate").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(createInAppTemplateRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateInAppTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a journey for an application.
     * </p>
     *
     * @param createJourneyRequest
     * @return Result of the CreateJourney operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.CreateJourney
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateJourney" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateJourneyResponse createJourney(CreateJourneyRequest createJourneyRequest) throws BadRequestException,
            InternalServerErrorException, PayloadTooLargeException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateJourneyResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateJourneyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createJourneyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createJourneyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateJourney");

            return clientHandler.execute(new ClientExecutionParams<CreateJourneyRequest, CreateJourneyResponse>()
                    .withOperationName("CreateJourney").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(createJourneyRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateJourneyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a message template for messages that are sent through a push notification channel.
     * </p>
     *
     * @param createPushTemplateRequest
     * @return Result of the CreatePushTemplate operation returned by the service.
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.CreatePushTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreatePushTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreatePushTemplateResponse createPushTemplate(CreatePushTemplateRequest createPushTemplateRequest)
            throws MethodNotAllowedException, TooManyRequestsException, BadRequestException, InternalServerErrorException,
            ForbiddenException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreatePushTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreatePushTemplateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createPushTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createPushTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreatePushTemplate");

            return clientHandler.execute(new ClientExecutionParams<CreatePushTemplateRequest, CreatePushTemplateResponse>()
                    .withOperationName("CreatePushTemplate").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(createPushTemplateRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreatePushTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an Amazon Pinpoint configuration for a recommender model.
     * </p>
     *
     * @param createRecommenderConfigurationRequest
     * @return Result of the CreateRecommenderConfiguration operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.CreateRecommenderConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateRecommenderConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateRecommenderConfigurationResponse createRecommenderConfiguration(
            CreateRecommenderConfigurationRequest createRecommenderConfigurationRequest) throws BadRequestException,
            InternalServerErrorException, PayloadTooLargeException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateRecommenderConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateRecommenderConfigurationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createRecommenderConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createRecommenderConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateRecommenderConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateRecommenderConfigurationRequest, CreateRecommenderConfigurationResponse>()
                            .withOperationName("CreateRecommenderConfiguration").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withInput(createRecommenderConfigurationRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateRecommenderConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new segment for an application or updates the configuration, dimension, and other settings for an
     * existing segment that's associated with an application.
     * </p>
     *
     * @param createSegmentRequest
     * @return Result of the CreateSegment operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.CreateSegment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateSegment" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateSegmentResponse createSegment(CreateSegmentRequest createSegmentRequest) throws BadRequestException,
            InternalServerErrorException, PayloadTooLargeException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateSegmentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateSegmentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createSegmentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createSegmentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateSegment");

            return clientHandler.execute(new ClientExecutionParams<CreateSegmentRequest, CreateSegmentResponse>()
                    .withOperationName("CreateSegment").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(createSegmentRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateSegmentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a message template for messages that are sent through the SMS channel.
     * </p>
     *
     * @param createSmsTemplateRequest
     * @return Result of the CreateSmsTemplate operation returned by the service.
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.CreateSmsTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateSmsTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateSmsTemplateResponse createSmsTemplate(CreateSmsTemplateRequest createSmsTemplateRequest)
            throws MethodNotAllowedException, TooManyRequestsException, BadRequestException, InternalServerErrorException,
            ForbiddenException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateSmsTemplateResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateSmsTemplateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createSmsTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createSmsTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateSmsTemplate");

            return clientHandler.execute(new ClientExecutionParams<CreateSmsTemplateRequest, CreateSmsTemplateResponse>()
                    .withOperationName("CreateSmsTemplate").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(createSmsTemplateRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateSmsTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a message template for messages that are sent through the voice channel.
     * </p>
     *
     * @param createVoiceTemplateRequest
     * @return Result of the CreateVoiceTemplate operation returned by the service.
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.CreateVoiceTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateVoiceTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateVoiceTemplateResponse createVoiceTemplate(CreateVoiceTemplateRequest createVoiceTemplateRequest)
            throws MethodNotAllowedException, TooManyRequestsException, BadRequestException, InternalServerErrorException,
            ForbiddenException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateVoiceTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateVoiceTemplateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createVoiceTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createVoiceTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateVoiceTemplate");

            return clientHandler.execute(new ClientExecutionParams<CreateVoiceTemplateRequest, CreateVoiceTemplateResponse>()
                    .withOperationName("CreateVoiceTemplate").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(createVoiceTemplateRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateVoiceTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Disables the ADM channel for an application and deletes any existing settings for the channel.
     * </p>
     *
     * @param deleteAdmChannelRequest
     * @return Result of the DeleteAdmChannel operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.DeleteAdmChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteAdmChannel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteAdmChannelResponse deleteAdmChannel(DeleteAdmChannelRequest deleteAdmChannelRequest) throws BadRequestException,
            InternalServerErrorException, PayloadTooLargeException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteAdmChannelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteAdmChannelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAdmChannelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAdmChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAdmChannel");

            return clientHandler.execute(new ClientExecutionParams<DeleteAdmChannelRequest, DeleteAdmChannelResponse>()
                    .withOperationName("DeleteAdmChannel").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteAdmChannelRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteAdmChannelRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Disables the APNs channel for an application and deletes any existing settings for the channel.
     * </p>
     *
     * @param deleteApnsChannelRequest
     * @return Result of the DeleteApnsChannel operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.DeleteApnsChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteApnsChannel" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteApnsChannelResponse deleteApnsChannel(DeleteApnsChannelRequest deleteApnsChannelRequest)
            throws BadRequestException, InternalServerErrorException, PayloadTooLargeException, ForbiddenException,
            NotFoundException, MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException,
            PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteApnsChannelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteApnsChannelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteApnsChannelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteApnsChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteApnsChannel");

            return clientHandler.execute(new ClientExecutionParams<DeleteApnsChannelRequest, DeleteApnsChannelResponse>()
                    .withOperationName("DeleteApnsChannel").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteApnsChannelRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteApnsChannelRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Disables the APNs sandbox channel for an application and deletes any existing settings for the channel.
     * </p>
     *
     * @param deleteApnsSandboxChannelRequest
     * @return Result of the DeleteApnsSandboxChannel operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.DeleteApnsSandboxChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteApnsSandboxChannel"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteApnsSandboxChannelResponse deleteApnsSandboxChannel(
            DeleteApnsSandboxChannelRequest deleteApnsSandboxChannelRequest) throws BadRequestException,
            InternalServerErrorException, PayloadTooLargeException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteApnsSandboxChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteApnsSandboxChannelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteApnsSandboxChannelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteApnsSandboxChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteApnsSandboxChannel");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteApnsSandboxChannelRequest, DeleteApnsSandboxChannelResponse>()
                            .withOperationName("DeleteApnsSandboxChannel").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withInput(deleteApnsSandboxChannelRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteApnsSandboxChannelRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Disables the APNs VoIP channel for an application and deletes any existing settings for the channel.
     * </p>
     *
     * @param deleteApnsVoipChannelRequest
     * @return Result of the DeleteApnsVoipChannel operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.DeleteApnsVoipChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteApnsVoipChannel"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteApnsVoipChannelResponse deleteApnsVoipChannel(DeleteApnsVoipChannelRequest deleteApnsVoipChannelRequest)
            throws BadRequestException, InternalServerErrorException, PayloadTooLargeException, ForbiddenException,
            NotFoundException, MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException,
            PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteApnsVoipChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteApnsVoipChannelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteApnsVoipChannelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteApnsVoipChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteApnsVoipChannel");

            return clientHandler.execute(new ClientExecutionParams<DeleteApnsVoipChannelRequest, DeleteApnsVoipChannelResponse>()
                    .withOperationName("DeleteApnsVoipChannel").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteApnsVoipChannelRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteApnsVoipChannelRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Disables the APNs VoIP sandbox channel for an application and deletes any existing settings for the channel.
     * </p>
     *
     * @param deleteApnsVoipSandboxChannelRequest
     * @return Result of the DeleteApnsVoipSandboxChannel operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.DeleteApnsVoipSandboxChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteApnsVoipSandboxChannel"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteApnsVoipSandboxChannelResponse deleteApnsVoipSandboxChannel(
            DeleteApnsVoipSandboxChannelRequest deleteApnsVoipSandboxChannelRequest) throws BadRequestException,
            InternalServerErrorException, PayloadTooLargeException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteApnsVoipSandboxChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteApnsVoipSandboxChannelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteApnsVoipSandboxChannelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteApnsVoipSandboxChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteApnsVoipSandboxChannel");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteApnsVoipSandboxChannelRequest, DeleteApnsVoipSandboxChannelResponse>()
                            .withOperationName("DeleteApnsVoipSandboxChannel").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withInput(deleteApnsVoipSandboxChannelRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteApnsVoipSandboxChannelRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an application.
     * </p>
     *
     * @param deleteAppRequest
     * @return Result of the DeleteApp operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.DeleteApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteApp" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteAppResponse deleteApp(DeleteAppRequest deleteAppRequest) throws BadRequestException,
            InternalServerErrorException, PayloadTooLargeException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteAppResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteAppResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAppRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAppRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteApp");

            return clientHandler.execute(new ClientExecutionParams<DeleteAppRequest, DeleteAppResponse>()
                    .withOperationName("DeleteApp").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteAppRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteAppRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Disables the Baidu channel for an application and deletes any existing settings for the channel.
     * </p>
     *
     * @param deleteBaiduChannelRequest
     * @return Result of the DeleteBaiduChannel operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.DeleteBaiduChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteBaiduChannel" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteBaiduChannelResponse deleteBaiduChannel(DeleteBaiduChannelRequest deleteBaiduChannelRequest)
            throws BadRequestException, InternalServerErrorException, PayloadTooLargeException, ForbiddenException,
            NotFoundException, MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException,
            PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteBaiduChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteBaiduChannelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteBaiduChannelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteBaiduChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBaiduChannel");

            return clientHandler.execute(new ClientExecutionParams<DeleteBaiduChannelRequest, DeleteBaiduChannelResponse>()
                    .withOperationName("DeleteBaiduChannel").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteBaiduChannelRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteBaiduChannelRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a campaign from an application.
     * </p>
     *
     * @param deleteCampaignRequest
     * @return Result of the DeleteCampaign operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.DeleteCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteCampaign" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteCampaignResponse deleteCampaign(DeleteCampaignRequest deleteCampaignRequest) throws BadRequestException,
            InternalServerErrorException, PayloadTooLargeException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteCampaignResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteCampaignResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteCampaignRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteCampaignRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCampaign");

            return clientHandler.execute(new ClientExecutionParams<DeleteCampaignRequest, DeleteCampaignResponse>()
                    .withOperationName("DeleteCampaign").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteCampaignRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteCampaignRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Disables the email channel for an application and deletes any existing settings for the channel.
     * </p>
     *
     * @param deleteEmailChannelRequest
     * @return Result of the DeleteEmailChannel operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.DeleteEmailChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteEmailChannel" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteEmailChannelResponse deleteEmailChannel(DeleteEmailChannelRequest deleteEmailChannelRequest)
            throws BadRequestException, InternalServerErrorException, PayloadTooLargeException, ForbiddenException,
            NotFoundException, MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException,
            PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteEmailChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteEmailChannelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteEmailChannelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteEmailChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteEmailChannel");

            return clientHandler.execute(new ClientExecutionParams<DeleteEmailChannelRequest, DeleteEmailChannelResponse>()
                    .withOperationName("DeleteEmailChannel").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteEmailChannelRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteEmailChannelRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a message template for messages that were sent through the email channel.
     * </p>
     *
     * @param deleteEmailTemplateRequest
     * @return Result of the DeleteEmailTemplate operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.DeleteEmailTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteEmailTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteEmailTemplateResponse deleteEmailTemplate(DeleteEmailTemplateRequest deleteEmailTemplateRequest)
            throws BadRequestException, InternalServerErrorException, PayloadTooLargeException, ForbiddenException,
            NotFoundException, MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException,
            PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteEmailTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteEmailTemplateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteEmailTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteEmailTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteEmailTemplate");

            return clientHandler.execute(new ClientExecutionParams<DeleteEmailTemplateRequest, DeleteEmailTemplateResponse>()
                    .withOperationName("DeleteEmailTemplate").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteEmailTemplateRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteEmailTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an endpoint from an application.
     * </p>
     *
     * @param deleteEndpointRequest
     * @return Result of the DeleteEndpoint operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.DeleteEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteEndpointResponse deleteEndpoint(DeleteEndpointRequest deleteEndpointRequest) throws BadRequestException,
            InternalServerErrorException, PayloadTooLargeException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteEndpointResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteEndpointResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteEndpointRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteEndpoint");

            return clientHandler.execute(new ClientExecutionParams<DeleteEndpointRequest, DeleteEndpointResponse>()
                    .withOperationName("DeleteEndpoint").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteEndpointRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteEndpointRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the event stream for an application.
     * </p>
     *
     * @param deleteEventStreamRequest
     * @return Result of the DeleteEventStream operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.DeleteEventStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteEventStream" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteEventStreamResponse deleteEventStream(DeleteEventStreamRequest deleteEventStreamRequest)
            throws BadRequestException, InternalServerErrorException, PayloadTooLargeException, ForbiddenException,
            NotFoundException, MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException,
            PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteEventStreamResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteEventStreamResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteEventStreamRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteEventStreamRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteEventStream");

            return clientHandler.execute(new ClientExecutionParams<DeleteEventStreamRequest, DeleteEventStreamResponse>()
                    .withOperationName("DeleteEventStream").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteEventStreamRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteEventStreamRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Disables the GCM channel for an application and deletes any existing settings for the channel.
     * </p>
     *
     * @param deleteGcmChannelRequest
     * @return Result of the DeleteGcmChannel operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.DeleteGcmChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteGcmChannel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteGcmChannelResponse deleteGcmChannel(DeleteGcmChannelRequest deleteGcmChannelRequest) throws BadRequestException,
            InternalServerErrorException, PayloadTooLargeException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteGcmChannelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteGcmChannelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteGcmChannelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteGcmChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteGcmChannel");

            return clientHandler.execute(new ClientExecutionParams<DeleteGcmChannelRequest, DeleteGcmChannelResponse>()
                    .withOperationName("DeleteGcmChannel").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteGcmChannelRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteGcmChannelRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a message template for messages sent using the in-app message channel.
     * </p>
     *
     * @param deleteInAppTemplateRequest
     * @return Result of the DeleteInAppTemplate operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.DeleteInAppTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteInAppTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteInAppTemplateResponse deleteInAppTemplate(DeleteInAppTemplateRequest deleteInAppTemplateRequest)
            throws BadRequestException, InternalServerErrorException, PayloadTooLargeException, ForbiddenException,
            NotFoundException, MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException,
            PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteInAppTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteInAppTemplateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteInAppTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteInAppTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteInAppTemplate");

            return clientHandler.execute(new ClientExecutionParams<DeleteInAppTemplateRequest, DeleteInAppTemplateResponse>()
                    .withOperationName("DeleteInAppTemplate").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteInAppTemplateRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteInAppTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a journey from an application.
     * </p>
     *
     * @param deleteJourneyRequest
     * @return Result of the DeleteJourney operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.DeleteJourney
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteJourney" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteJourneyResponse deleteJourney(DeleteJourneyRequest deleteJourneyRequest) throws BadRequestException,
            InternalServerErrorException, PayloadTooLargeException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteJourneyResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteJourneyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteJourneyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteJourneyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteJourney");

            return clientHandler.execute(new ClientExecutionParams<DeleteJourneyRequest, DeleteJourneyResponse>()
                    .withOperationName("DeleteJourney").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteJourneyRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteJourneyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a message template for messages that were sent through a push notification channel.
     * </p>
     *
     * @param deletePushTemplateRequest
     * @return Result of the DeletePushTemplate operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.DeletePushTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeletePushTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeletePushTemplateResponse deletePushTemplate(DeletePushTemplateRequest deletePushTemplateRequest)
            throws BadRequestException, InternalServerErrorException, PayloadTooLargeException, ForbiddenException,
            NotFoundException, MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException,
            PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeletePushTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeletePushTemplateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deletePushTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deletePushTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeletePushTemplate");

            return clientHandler.execute(new ClientExecutionParams<DeletePushTemplateRequest, DeletePushTemplateResponse>()
                    .withOperationName("DeletePushTemplate").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(deletePushTemplateRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeletePushTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an Amazon Pinpoint configuration for a recommender model.
     * </p>
     *
     * @param deleteRecommenderConfigurationRequest
     * @return Result of the DeleteRecommenderConfiguration operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.DeleteRecommenderConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteRecommenderConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteRecommenderConfigurationResponse deleteRecommenderConfiguration(
            DeleteRecommenderConfigurationRequest deleteRecommenderConfigurationRequest) throws BadRequestException,
            InternalServerErrorException, PayloadTooLargeException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteRecommenderConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteRecommenderConfigurationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteRecommenderConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteRecommenderConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRecommenderConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteRecommenderConfigurationRequest, DeleteRecommenderConfigurationResponse>()
                            .withOperationName("DeleteRecommenderConfiguration").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withInput(deleteRecommenderConfigurationRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteRecommenderConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a segment from an application.
     * </p>
     *
     * @param deleteSegmentRequest
     * @return Result of the DeleteSegment operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.DeleteSegment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteSegment" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteSegmentResponse deleteSegment(DeleteSegmentRequest deleteSegmentRequest) throws BadRequestException,
            InternalServerErrorException, PayloadTooLargeException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteSegmentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteSegmentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteSegmentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteSegmentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteSegment");

            return clientHandler.execute(new ClientExecutionParams<DeleteSegmentRequest, DeleteSegmentResponse>()
                    .withOperationName("DeleteSegment").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteSegmentRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteSegmentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Disables the SMS channel for an application and deletes any existing settings for the channel.
     * </p>
     *
     * @param deleteSmsChannelRequest
     * @return Result of the DeleteSmsChannel operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.DeleteSmsChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteSmsChannel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteSmsChannelResponse deleteSmsChannel(DeleteSmsChannelRequest deleteSmsChannelRequest) throws BadRequestException,
            InternalServerErrorException, PayloadTooLargeException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteSmsChannelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteSmsChannelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteSmsChannelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteSmsChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteSmsChannel");

            return clientHandler.execute(new ClientExecutionParams<DeleteSmsChannelRequest, DeleteSmsChannelResponse>()
                    .withOperationName("DeleteSmsChannel").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteSmsChannelRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteSmsChannelRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a message template for messages that were sent through the SMS channel.
     * </p>
     *
     * @param deleteSmsTemplateRequest
     * @return Result of the DeleteSmsTemplate operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.DeleteSmsTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteSmsTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteSmsTemplateResponse deleteSmsTemplate(DeleteSmsTemplateRequest deleteSmsTemplateRequest)
            throws BadRequestException, InternalServerErrorException, PayloadTooLargeException, ForbiddenException,
            NotFoundException, MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException,
            PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteSmsTemplateResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteSmsTemplateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteSmsTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteSmsTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteSmsTemplate");

            return clientHandler.execute(new ClientExecutionParams<DeleteSmsTemplateRequest, DeleteSmsTemplateResponse>()
                    .withOperationName("DeleteSmsTemplate").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteSmsTemplateRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteSmsTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes all the endpoints that are associated with a specific user ID.
     * </p>
     *
     * @param deleteUserEndpointsRequest
     * @return Result of the DeleteUserEndpoints operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.DeleteUserEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteUserEndpoints" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteUserEndpointsResponse deleteUserEndpoints(DeleteUserEndpointsRequest deleteUserEndpointsRequest)
            throws BadRequestException, InternalServerErrorException, PayloadTooLargeException, ForbiddenException,
            NotFoundException, MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException,
            PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteUserEndpointsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteUserEndpointsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteUserEndpointsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteUserEndpointsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteUserEndpoints");

            return clientHandler.execute(new ClientExecutionParams<DeleteUserEndpointsRequest, DeleteUserEndpointsResponse>()
                    .withOperationName("DeleteUserEndpoints").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteUserEndpointsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteUserEndpointsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Disables the voice channel for an application and deletes any existing settings for the channel.
     * </p>
     *
     * @param deleteVoiceChannelRequest
     * @return Result of the DeleteVoiceChannel operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.DeleteVoiceChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteVoiceChannel" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteVoiceChannelResponse deleteVoiceChannel(DeleteVoiceChannelRequest deleteVoiceChannelRequest)
            throws BadRequestException, InternalServerErrorException, PayloadTooLargeException, ForbiddenException,
            NotFoundException, MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException,
            PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteVoiceChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteVoiceChannelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteVoiceChannelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteVoiceChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteVoiceChannel");

            return clientHandler.execute(new ClientExecutionParams<DeleteVoiceChannelRequest, DeleteVoiceChannelResponse>()
                    .withOperationName("DeleteVoiceChannel").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteVoiceChannelRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteVoiceChannelRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a message template for messages that were sent through the voice channel.
     * </p>
     *
     * @param deleteVoiceTemplateRequest
     * @return Result of the DeleteVoiceTemplate operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.DeleteVoiceTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteVoiceTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteVoiceTemplateResponse deleteVoiceTemplate(DeleteVoiceTemplateRequest deleteVoiceTemplateRequest)
            throws BadRequestException, InternalServerErrorException, PayloadTooLargeException, ForbiddenException,
            NotFoundException, MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException,
            PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteVoiceTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteVoiceTemplateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteVoiceTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteVoiceTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteVoiceTemplate");

            return clientHandler.execute(new ClientExecutionParams<DeleteVoiceTemplateRequest, DeleteVoiceTemplateResponse>()
                    .withOperationName("DeleteVoiceTemplate").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteVoiceTemplateRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteVoiceTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about the status and settings of the ADM channel for an application.
     * </p>
     *
     * @param getAdmChannelRequest
     * @return Result of the GetAdmChannel operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetAdmChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetAdmChannel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetAdmChannelResponse getAdmChannel(GetAdmChannelRequest getAdmChannelRequest) throws BadRequestException,
            InternalServerErrorException, PayloadTooLargeException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetAdmChannelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetAdmChannelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getAdmChannelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAdmChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAdmChannel");

            return clientHandler.execute(new ClientExecutionParams<GetAdmChannelRequest, GetAdmChannelResponse>()
                    .withOperationName("GetAdmChannel").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getAdmChannelRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetAdmChannelRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about the status and settings of the APNs channel for an application.
     * </p>
     *
     * @param getApnsChannelRequest
     * @return Result of the GetApnsChannel operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetApnsChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApnsChannel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetApnsChannelResponse getApnsChannel(GetApnsChannelRequest getApnsChannelRequest) throws BadRequestException,
            InternalServerErrorException, PayloadTooLargeException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetApnsChannelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetApnsChannelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getApnsChannelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getApnsChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetApnsChannel");

            return clientHandler.execute(new ClientExecutionParams<GetApnsChannelRequest, GetApnsChannelResponse>()
                    .withOperationName("GetApnsChannel").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getApnsChannelRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetApnsChannelRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about the status and settings of the APNs sandbox channel for an application.
     * </p>
     *
     * @param getApnsSandboxChannelRequest
     * @return Result of the GetApnsSandboxChannel operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetApnsSandboxChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApnsSandboxChannel"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetApnsSandboxChannelResponse getApnsSandboxChannel(GetApnsSandboxChannelRequest getApnsSandboxChannelRequest)
            throws BadRequestException, InternalServerErrorException, PayloadTooLargeException, ForbiddenException,
            NotFoundException, MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException,
            PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetApnsSandboxChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetApnsSandboxChannelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getApnsSandboxChannelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getApnsSandboxChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetApnsSandboxChannel");

            return clientHandler.execute(new ClientExecutionParams<GetApnsSandboxChannelRequest, GetApnsSandboxChannelResponse>()
                    .withOperationName("GetApnsSandboxChannel").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getApnsSandboxChannelRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetApnsSandboxChannelRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about the status and settings of the APNs VoIP channel for an application.
     * </p>
     *
     * @param getApnsVoipChannelRequest
     * @return Result of the GetApnsVoipChannel operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetApnsVoipChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApnsVoipChannel" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetApnsVoipChannelResponse getApnsVoipChannel(GetApnsVoipChannelRequest getApnsVoipChannelRequest)
            throws BadRequestException, InternalServerErrorException, PayloadTooLargeException, ForbiddenException,
            NotFoundException, MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException,
            PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetApnsVoipChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetApnsVoipChannelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getApnsVoipChannelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getApnsVoipChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetApnsVoipChannel");

            return clientHandler.execute(new ClientExecutionParams<GetApnsVoipChannelRequest, GetApnsVoipChannelResponse>()
                    .withOperationName("GetApnsVoipChannel").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getApnsVoipChannelRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetApnsVoipChannelRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about the status and settings of the APNs VoIP sandbox channel for an application.
     * </p>
     *
     * @param getApnsVoipSandboxChannelRequest
     * @return Result of the GetApnsVoipSandboxChannel operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetApnsVoipSandboxChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApnsVoipSandboxChannel"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetApnsVoipSandboxChannelResponse getApnsVoipSandboxChannel(
            GetApnsVoipSandboxChannelRequest getApnsVoipSandboxChannelRequest) throws BadRequestException,
            InternalServerErrorException, PayloadTooLargeException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetApnsVoipSandboxChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetApnsVoipSandboxChannelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getApnsVoipSandboxChannelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getApnsVoipSandboxChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetApnsVoipSandboxChannel");

            return clientHandler
                    .execute(new ClientExecutionParams<GetApnsVoipSandboxChannelRequest, GetApnsVoipSandboxChannelResponse>()
                            .withOperationName("GetApnsVoipSandboxChannel").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withInput(getApnsVoipSandboxChannelRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetApnsVoipSandboxChannelRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about an application.
     * </p>
     *
     * @param getAppRequest
     * @return Result of the GetApp operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApp" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetAppResponse getApp(GetAppRequest getAppRequest) throws BadRequestException, InternalServerErrorException,
            PayloadTooLargeException, ForbiddenException, NotFoundException, MethodNotAllowedException, TooManyRequestsException,
            AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetAppResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetAppResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getAppRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAppRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetApp");

            return clientHandler.execute(new ClientExecutionParams<GetAppRequest, GetAppResponse>().withOperationName("GetApp")
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getAppRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new GetAppRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves (queries) pre-aggregated data for a standard metric that applies to an application.
     * </p>
     *
     * @param getApplicationDateRangeKpiRequest
     * @return Result of the GetApplicationDateRangeKpi operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetApplicationDateRangeKpi
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApplicationDateRangeKpi"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetApplicationDateRangeKpiResponse getApplicationDateRangeKpi(
            GetApplicationDateRangeKpiRequest getApplicationDateRangeKpiRequest) throws BadRequestException,
            InternalServerErrorException, PayloadTooLargeException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetApplicationDateRangeKpiResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetApplicationDateRangeKpiResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getApplicationDateRangeKpiRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getApplicationDateRangeKpiRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetApplicationDateRangeKpi");

            return clientHandler
                    .execute(new ClientExecutionParams<GetApplicationDateRangeKpiRequest, GetApplicationDateRangeKpiResponse>()
                            .withOperationName("GetApplicationDateRangeKpi").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withInput(getApplicationDateRangeKpiRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetApplicationDateRangeKpiRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about the settings for an application.
     * </p>
     *
     * @param getApplicationSettingsRequest
     * @return Result of the GetApplicationSettings operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetApplicationSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApplicationSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetApplicationSettingsResponse getApplicationSettings(GetApplicationSettingsRequest getApplicationSettingsRequest)
            throws BadRequestException, InternalServerErrorException, PayloadTooLargeException, ForbiddenException,
            NotFoundException, MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException,
            PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetApplicationSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetApplicationSettingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getApplicationSettingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getApplicationSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetApplicationSettings");

            return clientHandler
                    .execute(new ClientExecutionParams<GetApplicationSettingsRequest, GetApplicationSettingsResponse>()
                            .withOperationName("GetApplicationSettings").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withInput(getApplicationSettingsRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetApplicationSettingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about all the applications that are associated with your Amazon Pinpoint account.
     * </p>
     *
     * @param getAppsRequest
     * @return Result of the GetApps operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetApps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApps" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetAppsResponse getApps(GetAppsRequest getAppsRequest) throws BadRequestException, InternalServerErrorException,
            PayloadTooLargeException, ForbiddenException, NotFoundException, MethodNotAllowedException, TooManyRequestsException,
            AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetAppsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetAppsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getAppsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAppsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetApps");

            return clientHandler.execute(new ClientExecutionParams<GetAppsRequest, GetAppsResponse>()
                    .withOperationName("GetApps").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getAppsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetAppsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about the status and settings of the Baidu channel for an application.
     * </p>
     *
     * @param getBaiduChannelRequest
     * @return Result of the GetBaiduChannel operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetBaiduChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetBaiduChannel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetBaiduChannelResponse getBaiduChannel(GetBaiduChannelRequest getBaiduChannelRequest) throws BadRequestException,
            InternalServerErrorException, PayloadTooLargeException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetBaiduChannelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetBaiduChannelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getBaiduChannelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getBaiduChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBaiduChannel");

            return clientHandler.execute(new ClientExecutionParams<GetBaiduChannelRequest, GetBaiduChannelResponse>()
                    .withOperationName("GetBaiduChannel").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getBaiduChannelRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetBaiduChannelRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about the status, configuration, and other settings for a campaign.
     * </p>
     *
     * @param getCampaignRequest
     * @return Result of the GetCampaign operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetCampaign" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetCampaignResponse getCampaign(GetCampaignRequest getCampaignRequest) throws BadRequestException,
            InternalServerErrorException, PayloadTooLargeException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetCampaignResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetCampaignResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getCampaignRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getCampaignRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCampaign");

            return clientHandler.execute(new ClientExecutionParams<GetCampaignRequest, GetCampaignResponse>()
                    .withOperationName("GetCampaign").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getCampaignRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetCampaignRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about all the activities for a campaign.
     * </p>
     *
     * @param getCampaignActivitiesRequest
     * @return Result of the GetCampaignActivities operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetCampaignActivities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetCampaignActivities"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetCampaignActivitiesResponse getCampaignActivities(GetCampaignActivitiesRequest getCampaignActivitiesRequest)
            throws BadRequestException, InternalServerErrorException, PayloadTooLargeException, ForbiddenException,
            NotFoundException, MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException,
            PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetCampaignActivitiesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetCampaignActivitiesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getCampaignActivitiesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getCampaignActivitiesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCampaignActivities");

            return clientHandler.execute(new ClientExecutionParams<GetCampaignActivitiesRequest, GetCampaignActivitiesResponse>()
                    .withOperationName("GetCampaignActivities").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getCampaignActivitiesRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetCampaignActivitiesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves (queries) pre-aggregated data for a standard metric that applies to a campaign.
     * </p>
     *
     * @param getCampaignDateRangeKpiRequest
     * @return Result of the GetCampaignDateRangeKpi operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetCampaignDateRangeKpi
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetCampaignDateRangeKpi"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetCampaignDateRangeKpiResponse getCampaignDateRangeKpi(GetCampaignDateRangeKpiRequest getCampaignDateRangeKpiRequest)
            throws BadRequestException, InternalServerErrorException, PayloadTooLargeException, ForbiddenException,
            NotFoundException, MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException,
            PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetCampaignDateRangeKpiResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetCampaignDateRangeKpiResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getCampaignDateRangeKpiRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getCampaignDateRangeKpiRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCampaignDateRangeKpi");

            return clientHandler
                    .execute(new ClientExecutionParams<GetCampaignDateRangeKpiRequest, GetCampaignDateRangeKpiResponse>()
                            .withOperationName("GetCampaignDateRangeKpi").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withInput(getCampaignDateRangeKpiRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetCampaignDateRangeKpiRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about the status, configuration, and other settings for a specific version of a campaign.
     * </p>
     *
     * @param getCampaignVersionRequest
     * @return Result of the GetCampaignVersion operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetCampaignVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetCampaignVersion" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetCampaignVersionResponse getCampaignVersion(GetCampaignVersionRequest getCampaignVersionRequest)
            throws BadRequestException, InternalServerErrorException, PayloadTooLargeException, ForbiddenException,
            NotFoundException, MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException,
            PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetCampaignVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetCampaignVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getCampaignVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getCampaignVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCampaignVersion");

            return clientHandler.execute(new ClientExecutionParams<GetCampaignVersionRequest, GetCampaignVersionResponse>()
                    .withOperationName("GetCampaignVersion").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getCampaignVersionRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetCampaignVersionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about the status, configuration, and other settings for all versions of a campaign.
     * </p>
     *
     * @param getCampaignVersionsRequest
     * @return Result of the GetCampaignVersions operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetCampaignVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetCampaignVersions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetCampaignVersionsResponse getCampaignVersions(GetCampaignVersionsRequest getCampaignVersionsRequest)
            throws BadRequestException, InternalServerErrorException, PayloadTooLargeException, ForbiddenException,
            NotFoundException, MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException,
            PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetCampaignVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetCampaignVersionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getCampaignVersionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getCampaignVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCampaignVersions");

            return clientHandler.execute(new ClientExecutionParams<GetCampaignVersionsRequest, GetCampaignVersionsResponse>()
                    .withOperationName("GetCampaignVersions").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getCampaignVersionsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetCampaignVersionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about the status, configuration, and other settings for all the campaigns that are
     * associated with an application.
     * </p>
     *
     * @param getCampaignsRequest
     * @return Result of the GetCampaigns operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetCampaigns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetCampaigns" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetCampaignsResponse getCampaigns(GetCampaignsRequest getCampaignsRequest) throws BadRequestException,
            InternalServerErrorException, PayloadTooLargeException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetCampaignsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetCampaignsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getCampaignsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getCampaignsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCampaigns");

            return clientHandler.execute(new ClientExecutionParams<GetCampaignsRequest, GetCampaignsResponse>()
                    .withOperationName("GetCampaigns").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getCampaignsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetCampaignsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about the history and status of each channel for an application.
     * </p>
     *
     * @param getChannelsRequest
     * @return Result of the GetChannels operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetChannels" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetChannelsResponse getChannels(GetChannelsRequest getChannelsRequest) throws BadRequestException,
            InternalServerErrorException, PayloadTooLargeException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetChannelsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetChannelsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getChannelsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getChannelsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetChannels");

            return clientHandler.execute(new ClientExecutionParams<GetChannelsRequest, GetChannelsResponse>()
                    .withOperationName("GetChannels").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getChannelsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetChannelsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about the status and settings of the email channel for an application.
     * </p>
     *
     * @param getEmailChannelRequest
     * @return Result of the GetEmailChannel operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetEmailChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetEmailChannel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetEmailChannelResponse getEmailChannel(GetEmailChannelRequest getEmailChannelRequest) throws BadRequestException,
            InternalServerErrorException, PayloadTooLargeException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetEmailChannelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetEmailChannelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getEmailChannelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getEmailChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetEmailChannel");

            return clientHandler.execute(new ClientExecutionParams<GetEmailChannelRequest, GetEmailChannelResponse>()
                    .withOperationName("GetEmailChannel").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getEmailChannelRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetEmailChannelRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the content and settings of a message template for messages that are sent through the email channel.
     * </p>
     *
     * @param getEmailTemplateRequest
     * @return Result of the GetEmailTemplate operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetEmailTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetEmailTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetEmailTemplateResponse getEmailTemplate(GetEmailTemplateRequest getEmailTemplateRequest) throws BadRequestException,
            InternalServerErrorException, PayloadTooLargeException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetEmailTemplateResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetEmailTemplateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getEmailTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getEmailTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetEmailTemplate");

            return clientHandler.execute(new ClientExecutionParams<GetEmailTemplateRequest, GetEmailTemplateResponse>()
                    .withOperationName("GetEmailTemplate").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getEmailTemplateRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetEmailTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about the settings and attributes of a specific endpoint for an application.
     * </p>
     *
     * @param getEndpointRequest
     * @return Result of the GetEndpoint operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetEndpointResponse getEndpoint(GetEndpointRequest getEndpointRequest) throws BadRequestException,
            InternalServerErrorException, PayloadTooLargeException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetEndpointResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetEndpointResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getEndpointRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetEndpoint");

            return clientHandler.execute(new ClientExecutionParams<GetEndpointRequest, GetEndpointResponse>()
                    .withOperationName("GetEndpoint").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getEndpointRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetEndpointRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about the event stream settings for an application.
     * </p>
     *
     * @param getEventStreamRequest
     * @return Result of the GetEventStream operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetEventStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetEventStream" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetEventStreamResponse getEventStream(GetEventStreamRequest getEventStreamRequest) throws BadRequestException,
            InternalServerErrorException, PayloadTooLargeException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetEventStreamResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetEventStreamResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getEventStreamRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getEventStreamRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetEventStream");

            return clientHandler.execute(new ClientExecutionParams<GetEventStreamRequest, GetEventStreamResponse>()
                    .withOperationName("GetEventStream").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getEventStreamRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetEventStreamRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about the status and settings of a specific export job for an application.
     * </p>
     *
     * @param getExportJobRequest
     * @return Result of the GetExportJob operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetExportJob" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetExportJobResponse getExportJob(GetExportJobRequest getExportJobRequest) throws BadRequestException,
            InternalServerErrorException, PayloadTooLargeException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetExportJobResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetExportJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getExportJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getExportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetExportJob");

            return clientHandler.execute(new ClientExecutionParams<GetExportJobRequest, GetExportJobResponse>()
                    .withOperationName("GetExportJob").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getExportJobRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetExportJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about the status and settings of all the export jobs for an application.
     * </p>
     *
     * @param getExportJobsRequest
     * @return Result of the GetExportJobs operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetExportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetExportJobs" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetExportJobsResponse getExportJobs(GetExportJobsRequest getExportJobsRequest) throws BadRequestException,
            InternalServerErrorException, PayloadTooLargeException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetExportJobsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetExportJobsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getExportJobsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getExportJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetExportJobs");

            return clientHandler.execute(new ClientExecutionParams<GetExportJobsRequest, GetExportJobsResponse>()
                    .withOperationName("GetExportJobs").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getExportJobsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetExportJobsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about the status and settings of the GCM channel for an application.
     * </p>
     *
     * @param getGcmChannelRequest
     * @return Result of the GetGcmChannel operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetGcmChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetGcmChannel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetGcmChannelResponse getGcmChannel(GetGcmChannelRequest getGcmChannelRequest) throws BadRequestException,
            InternalServerErrorException, PayloadTooLargeException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetGcmChannelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetGcmChannelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getGcmChannelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getGcmChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetGcmChannel");

            return clientHandler.execute(new ClientExecutionParams<GetGcmChannelRequest, GetGcmChannelResponse>()
                    .withOperationName("GetGcmChannel").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getGcmChannelRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetGcmChannelRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about the status and settings of a specific import job for an application.
     * </p>
     *
     * @param getImportJobRequest
     * @return Result of the GetImportJob operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetImportJob" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetImportJobResponse getImportJob(GetImportJobRequest getImportJobRequest) throws BadRequestException,
            InternalServerErrorException, PayloadTooLargeException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetImportJobResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetImportJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getImportJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getImportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetImportJob");

            return clientHandler.execute(new ClientExecutionParams<GetImportJobRequest, GetImportJobResponse>()
                    .withOperationName("GetImportJob").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getImportJobRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetImportJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about the status and settings of all the import jobs for an application.
     * </p>
     *
     * @param getImportJobsRequest
     * @return Result of the GetImportJobs operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetImportJobs" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetImportJobsResponse getImportJobs(GetImportJobsRequest getImportJobsRequest) throws BadRequestException,
            InternalServerErrorException, PayloadTooLargeException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetImportJobsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetImportJobsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getImportJobsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getImportJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetImportJobs");

            return clientHandler.execute(new ClientExecutionParams<GetImportJobsRequest, GetImportJobsResponse>()
                    .withOperationName("GetImportJobs").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getImportJobsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetImportJobsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the in-app messages targeted for the provided endpoint ID.
     * </p>
     *
     * @param getInAppMessagesRequest
     * @return Result of the GetInAppMessages operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetInAppMessages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetInAppMessages" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetInAppMessagesResponse getInAppMessages(GetInAppMessagesRequest getInAppMessagesRequest) throws BadRequestException,
            InternalServerErrorException, PayloadTooLargeException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetInAppMessagesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetInAppMessagesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getInAppMessagesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getInAppMessagesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetInAppMessages");

            return clientHandler.execute(new ClientExecutionParams<GetInAppMessagesRequest, GetInAppMessagesResponse>()
                    .withOperationName("GetInAppMessages").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getInAppMessagesRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetInAppMessagesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the content and settings of a message template for messages sent through the in-app channel.
     * </p>
     *
     * @param getInAppTemplateRequest
     * @return Result of the GetInAppTemplate operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetInAppTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetInAppTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetInAppTemplateResponse getInAppTemplate(GetInAppTemplateRequest getInAppTemplateRequest) throws BadRequestException,
            InternalServerErrorException, PayloadTooLargeException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetInAppTemplateResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetInAppTemplateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getInAppTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getInAppTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetInAppTemplate");

            return clientHandler.execute(new ClientExecutionParams<GetInAppTemplateRequest, GetInAppTemplateResponse>()
                    .withOperationName("GetInAppTemplate").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getInAppTemplateRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetInAppTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about the status, configuration, and other settings for a journey.
     * </p>
     *
     * @param getJourneyRequest
     * @return Result of the GetJourney operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetJourney
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetJourney" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetJourneyResponse getJourney(GetJourneyRequest getJourneyRequest) throws BadRequestException,
            InternalServerErrorException, PayloadTooLargeException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetJourneyResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetJourneyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getJourneyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getJourneyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetJourney");

            return clientHandler.execute(new ClientExecutionParams<GetJourneyRequest, GetJourneyResponse>()
                    .withOperationName("GetJourney").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getJourneyRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetJourneyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves (queries) pre-aggregated data for a standard engagement metric that applies to a journey.
     * </p>
     *
     * @param getJourneyDateRangeKpiRequest
     * @return Result of the GetJourneyDateRangeKpi operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetJourneyDateRangeKpi
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetJourneyDateRangeKpi"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetJourneyDateRangeKpiResponse getJourneyDateRangeKpi(GetJourneyDateRangeKpiRequest getJourneyDateRangeKpiRequest)
            throws BadRequestException, InternalServerErrorException, PayloadTooLargeException, ForbiddenException,
            NotFoundException, MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException,
            PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetJourneyDateRangeKpiResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetJourneyDateRangeKpiResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getJourneyDateRangeKpiRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getJourneyDateRangeKpiRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetJourneyDateRangeKpi");

            return clientHandler
                    .execute(new ClientExecutionParams<GetJourneyDateRangeKpiRequest, GetJourneyDateRangeKpiResponse>()
                            .withOperationName("GetJourneyDateRangeKpi").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withInput(getJourneyDateRangeKpiRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetJourneyDateRangeKpiRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves (queries) pre-aggregated data for a standard execution metric that applies to a journey activity.
     * </p>
     *
     * @param getJourneyExecutionActivityMetricsRequest
     * @return Result of the GetJourneyExecutionActivityMetrics operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetJourneyExecutionActivityMetrics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetJourneyExecutionActivityMetrics"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetJourneyExecutionActivityMetricsResponse getJourneyExecutionActivityMetrics(
            GetJourneyExecutionActivityMetricsRequest getJourneyExecutionActivityMetricsRequest) throws BadRequestException,
            InternalServerErrorException, PayloadTooLargeException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetJourneyExecutionActivityMetricsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetJourneyExecutionActivityMetricsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getJourneyExecutionActivityMetricsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getJourneyExecutionActivityMetricsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetJourneyExecutionActivityMetrics");

            return clientHandler
                    .execute(new ClientExecutionParams<GetJourneyExecutionActivityMetricsRequest, GetJourneyExecutionActivityMetricsResponse>()
                            .withOperationName("GetJourneyExecutionActivityMetrics").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withInput(getJourneyExecutionActivityMetricsRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetJourneyExecutionActivityMetricsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves (queries) pre-aggregated data for a standard execution metric that applies to a journey.
     * </p>
     *
     * @param getJourneyExecutionMetricsRequest
     * @return Result of the GetJourneyExecutionMetrics operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetJourneyExecutionMetrics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetJourneyExecutionMetrics"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetJourneyExecutionMetricsResponse getJourneyExecutionMetrics(
            GetJourneyExecutionMetricsRequest getJourneyExecutionMetricsRequest) throws BadRequestException,
            InternalServerErrorException, PayloadTooLargeException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetJourneyExecutionMetricsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetJourneyExecutionMetricsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getJourneyExecutionMetricsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getJourneyExecutionMetricsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetJourneyExecutionMetrics");

            return clientHandler
                    .execute(new ClientExecutionParams<GetJourneyExecutionMetricsRequest, GetJourneyExecutionMetricsResponse>()
                            .withOperationName("GetJourneyExecutionMetrics").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withInput(getJourneyExecutionMetricsRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetJourneyExecutionMetricsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves (queries) pre-aggregated data for a standard run execution metric that applies to a journey activity.
     * </p>
     *
     * @param getJourneyRunExecutionActivityMetricsRequest
     * @return Result of the GetJourneyRunExecutionActivityMetrics operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetJourneyRunExecutionActivityMetrics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetJourneyRunExecutionActivityMetrics"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetJourneyRunExecutionActivityMetricsResponse getJourneyRunExecutionActivityMetrics(
            GetJourneyRunExecutionActivityMetricsRequest getJourneyRunExecutionActivityMetricsRequest)
            throws BadRequestException, InternalServerErrorException, PayloadTooLargeException, ForbiddenException,
            NotFoundException, MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException,
            PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetJourneyRunExecutionActivityMetricsResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, GetJourneyRunExecutionActivityMetricsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getJourneyRunExecutionActivityMetricsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getJourneyRunExecutionActivityMetricsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetJourneyRunExecutionActivityMetrics");

            return clientHandler
                    .execute(new ClientExecutionParams<GetJourneyRunExecutionActivityMetricsRequest, GetJourneyRunExecutionActivityMetricsResponse>()
                            .withOperationName("GetJourneyRunExecutionActivityMetrics").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withInput(getJourneyRunExecutionActivityMetricsRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetJourneyRunExecutionActivityMetricsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves (queries) pre-aggregated data for a standard run execution metric that applies to a journey.
     * </p>
     *
     * @param getJourneyRunExecutionMetricsRequest
     * @return Result of the GetJourneyRunExecutionMetrics operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetJourneyRunExecutionMetrics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetJourneyRunExecutionMetrics"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetJourneyRunExecutionMetricsResponse getJourneyRunExecutionMetrics(
            GetJourneyRunExecutionMetricsRequest getJourneyRunExecutionMetricsRequest) throws BadRequestException,
            InternalServerErrorException, PayloadTooLargeException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetJourneyRunExecutionMetricsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetJourneyRunExecutionMetricsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getJourneyRunExecutionMetricsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getJourneyRunExecutionMetricsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetJourneyRunExecutionMetrics");

            return clientHandler
                    .execute(new ClientExecutionParams<GetJourneyRunExecutionMetricsRequest, GetJourneyRunExecutionMetricsResponse>()
                            .withOperationName("GetJourneyRunExecutionMetrics").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withInput(getJourneyRunExecutionMetricsRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetJourneyRunExecutionMetricsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Provides information about the runs of a journey.
     * </p>
     *
     * @param getJourneyRunsRequest
     * @return Result of the GetJourneyRuns operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetJourneyRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetJourneyRuns" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetJourneyRunsResponse getJourneyRuns(GetJourneyRunsRequest getJourneyRunsRequest) throws BadRequestException,
            InternalServerErrorException, PayloadTooLargeException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetJourneyRunsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetJourneyRunsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getJourneyRunsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getJourneyRunsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetJourneyRuns");

            return clientHandler.execute(new ClientExecutionParams<GetJourneyRunsRequest, GetJourneyRunsResponse>()
                    .withOperationName("GetJourneyRuns").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getJourneyRunsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetJourneyRunsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the content and settings of a message template for messages that are sent through a push notification
     * channel.
     * </p>
     *
     * @param getPushTemplateRequest
     * @return Result of the GetPushTemplate operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetPushTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetPushTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetPushTemplateResponse getPushTemplate(GetPushTemplateRequest getPushTemplateRequest) throws BadRequestException,
            InternalServerErrorException, PayloadTooLargeException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetPushTemplateResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetPushTemplateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getPushTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getPushTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetPushTemplate");

            return clientHandler.execute(new ClientExecutionParams<GetPushTemplateRequest, GetPushTemplateResponse>()
                    .withOperationName("GetPushTemplate").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getPushTemplateRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetPushTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about an Amazon Pinpoint configuration for a recommender model.
     * </p>
     *
     * @param getRecommenderConfigurationRequest
     * @return Result of the GetRecommenderConfiguration operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetRecommenderConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetRecommenderConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetRecommenderConfigurationResponse getRecommenderConfiguration(
            GetRecommenderConfigurationRequest getRecommenderConfigurationRequest) throws BadRequestException,
            InternalServerErrorException, PayloadTooLargeException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetRecommenderConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetRecommenderConfigurationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getRecommenderConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getRecommenderConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRecommenderConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<GetRecommenderConfigurationRequest, GetRecommenderConfigurationResponse>()
                            .withOperationName("GetRecommenderConfiguration").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withInput(getRecommenderConfigurationRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetRecommenderConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about all the recommender model configurations that are associated with your Amazon
     * Pinpoint account.
     * </p>
     *
     * @param getRecommenderConfigurationsRequest
     * @return Result of the GetRecommenderConfigurations operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetRecommenderConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetRecommenderConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetRecommenderConfigurationsResponse getRecommenderConfigurations(
            GetRecommenderConfigurationsRequest getRecommenderConfigurationsRequest) throws BadRequestException,
            InternalServerErrorException, PayloadTooLargeException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetRecommenderConfigurationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetRecommenderConfigurationsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getRecommenderConfigurationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getRecommenderConfigurationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRecommenderConfigurations");

            return clientHandler
                    .execute(new ClientExecutionParams<GetRecommenderConfigurationsRequest, GetRecommenderConfigurationsResponse>()
                            .withOperationName("GetRecommenderConfigurations").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withInput(getRecommenderConfigurationsRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetRecommenderConfigurationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about the configuration, dimension, and other settings for a specific segment that's
     * associated with an application.
     * </p>
     *
     * @param getSegmentRequest
     * @return Result of the GetSegment operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetSegment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSegment" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetSegmentResponse getSegment(GetSegmentRequest getSegmentRequest) throws BadRequestException,
            InternalServerErrorException, PayloadTooLargeException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetSegmentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetSegmentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getSegmentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSegmentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSegment");

            return clientHandler.execute(new ClientExecutionParams<GetSegmentRequest, GetSegmentResponse>()
                    .withOperationName("GetSegment").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getSegmentRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetSegmentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about the status and settings of the export jobs for a segment.
     * </p>
     *
     * @param getSegmentExportJobsRequest
     * @return Result of the GetSegmentExportJobs operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetSegmentExportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSegmentExportJobs" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetSegmentExportJobsResponse getSegmentExportJobs(GetSegmentExportJobsRequest getSegmentExportJobsRequest)
            throws BadRequestException, InternalServerErrorException, PayloadTooLargeException, ForbiddenException,
            NotFoundException, MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException,
            PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetSegmentExportJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetSegmentExportJobsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getSegmentExportJobsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSegmentExportJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSegmentExportJobs");

            return clientHandler.execute(new ClientExecutionParams<GetSegmentExportJobsRequest, GetSegmentExportJobsResponse>()
                    .withOperationName("GetSegmentExportJobs").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getSegmentExportJobsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetSegmentExportJobsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about the status and settings of the import jobs for a segment.
     * </p>
     *
     * @param getSegmentImportJobsRequest
     * @return Result of the GetSegmentImportJobs operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetSegmentImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSegmentImportJobs" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetSegmentImportJobsResponse getSegmentImportJobs(GetSegmentImportJobsRequest getSegmentImportJobsRequest)
            throws BadRequestException, InternalServerErrorException, PayloadTooLargeException, ForbiddenException,
            NotFoundException, MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException,
            PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetSegmentImportJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetSegmentImportJobsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getSegmentImportJobsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSegmentImportJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSegmentImportJobs");

            return clientHandler.execute(new ClientExecutionParams<GetSegmentImportJobsRequest, GetSegmentImportJobsResponse>()
                    .withOperationName("GetSegmentImportJobs").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getSegmentImportJobsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetSegmentImportJobsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about the configuration, dimension, and other settings for a specific version of a segment
     * that's associated with an application.
     * </p>
     *
     * @param getSegmentVersionRequest
     * @return Result of the GetSegmentVersion operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetSegmentVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSegmentVersion" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetSegmentVersionResponse getSegmentVersion(GetSegmentVersionRequest getSegmentVersionRequest)
            throws BadRequestException, InternalServerErrorException, PayloadTooLargeException, ForbiddenException,
            NotFoundException, MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException,
            PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetSegmentVersionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetSegmentVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getSegmentVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSegmentVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSegmentVersion");

            return clientHandler.execute(new ClientExecutionParams<GetSegmentVersionRequest, GetSegmentVersionResponse>()
                    .withOperationName("GetSegmentVersion").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getSegmentVersionRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetSegmentVersionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about the configuration, dimension, and other settings for all the versions of a specific
     * segment that's associated with an application.
     * </p>
     *
     * @param getSegmentVersionsRequest
     * @return Result of the GetSegmentVersions operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetSegmentVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSegmentVersions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetSegmentVersionsResponse getSegmentVersions(GetSegmentVersionsRequest getSegmentVersionsRequest)
            throws BadRequestException, InternalServerErrorException, PayloadTooLargeException, ForbiddenException,
            NotFoundException, MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException,
            PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetSegmentVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetSegmentVersionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getSegmentVersionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSegmentVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSegmentVersions");

            return clientHandler.execute(new ClientExecutionParams<GetSegmentVersionsRequest, GetSegmentVersionsResponse>()
                    .withOperationName("GetSegmentVersions").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getSegmentVersionsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetSegmentVersionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about the configuration, dimension, and other settings for all the segments that are
     * associated with an application.
     * </p>
     *
     * @param getSegmentsRequest
     * @return Result of the GetSegments operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetSegments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSegments" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetSegmentsResponse getSegments(GetSegmentsRequest getSegmentsRequest) throws BadRequestException,
            InternalServerErrorException, PayloadTooLargeException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetSegmentsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetSegmentsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getSegmentsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSegmentsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSegments");

            return clientHandler.execute(new ClientExecutionParams<GetSegmentsRequest, GetSegmentsResponse>()
                    .withOperationName("GetSegments").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getSegmentsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetSegmentsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about the status and settings of the SMS channel for an application.
     * </p>
     *
     * @param getSmsChannelRequest
     * @return Result of the GetSmsChannel operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetSmsChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSmsChannel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetSmsChannelResponse getSmsChannel(GetSmsChannelRequest getSmsChannelRequest) throws BadRequestException,
            InternalServerErrorException, PayloadTooLargeException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetSmsChannelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetSmsChannelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getSmsChannelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSmsChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSmsChannel");

            return clientHandler.execute(new ClientExecutionParams<GetSmsChannelRequest, GetSmsChannelResponse>()
                    .withOperationName("GetSmsChannel").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getSmsChannelRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetSmsChannelRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the content and settings of a message template for messages that are sent through the SMS channel.
     * </p>
     *
     * @param getSmsTemplateRequest
     * @return Result of the GetSmsTemplate operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetSmsTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSmsTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetSmsTemplateResponse getSmsTemplate(GetSmsTemplateRequest getSmsTemplateRequest) throws BadRequestException,
            InternalServerErrorException, PayloadTooLargeException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetSmsTemplateResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetSmsTemplateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getSmsTemplateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSmsTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSmsTemplate");

            return clientHandler.execute(new ClientExecutionParams<GetSmsTemplateRequest, GetSmsTemplateResponse>()
                    .withOperationName("GetSmsTemplate").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getSmsTemplateRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetSmsTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about all the endpoints that are associated with a specific user ID.
     * </p>
     *
     * @param getUserEndpointsRequest
     * @return Result of the GetUserEndpoints operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetUserEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetUserEndpoints" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetUserEndpointsResponse getUserEndpoints(GetUserEndpointsRequest getUserEndpointsRequest) throws BadRequestException,
            InternalServerErrorException, PayloadTooLargeException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetUserEndpointsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetUserEndpointsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getUserEndpointsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getUserEndpointsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetUserEndpoints");

            return clientHandler.execute(new ClientExecutionParams<GetUserEndpointsRequest, GetUserEndpointsResponse>()
                    .withOperationName("GetUserEndpoints").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getUserEndpointsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetUserEndpointsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about the status and settings of the voice channel for an application.
     * </p>
     *
     * @param getVoiceChannelRequest
     * @return Result of the GetVoiceChannel operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetVoiceChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetVoiceChannel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetVoiceChannelResponse getVoiceChannel(GetVoiceChannelRequest getVoiceChannelRequest) throws BadRequestException,
            InternalServerErrorException, PayloadTooLargeException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetVoiceChannelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetVoiceChannelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getVoiceChannelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getVoiceChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetVoiceChannel");

            return clientHandler.execute(new ClientExecutionParams<GetVoiceChannelRequest, GetVoiceChannelResponse>()
                    .withOperationName("GetVoiceChannel").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getVoiceChannelRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetVoiceChannelRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the content and settings of a message template for messages that are sent through the voice channel.
     * </p>
     *
     * @param getVoiceTemplateRequest
     * @return Result of the GetVoiceTemplate operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetVoiceTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetVoiceTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetVoiceTemplateResponse getVoiceTemplate(GetVoiceTemplateRequest getVoiceTemplateRequest) throws BadRequestException,
            InternalServerErrorException, PayloadTooLargeException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetVoiceTemplateResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetVoiceTemplateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getVoiceTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getVoiceTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetVoiceTemplate");

            return clientHandler.execute(new ClientExecutionParams<GetVoiceTemplateRequest, GetVoiceTemplateResponse>()
                    .withOperationName("GetVoiceTemplate").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getVoiceTemplateRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetVoiceTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about the status, configuration, and other settings for all the journeys that are
     * associated with an application.
     * </p>
     *
     * @param listJourneysRequest
     * @return Result of the ListJourneys operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.ListJourneys
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/ListJourneys" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListJourneysResponse listJourneys(ListJourneysRequest listJourneysRequest) throws BadRequestException,
            InternalServerErrorException, PayloadTooLargeException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListJourneysResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListJourneysResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listJourneysRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listJourneysRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListJourneys");

            return clientHandler.execute(new ClientExecutionParams<ListJourneysRequest, ListJourneysResponse>()
                    .withOperationName("ListJourneys").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(listJourneysRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListJourneysRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves all the tags (keys and values) that are associated with an application, campaign, message template, or
     * segment.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTagsForResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");

            return clientHandler.execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                    .withOperationName("ListTagsForResource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(listTagsForResourceRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about all the versions of a specific message template.
     * </p>
     *
     * @param listTemplateVersionsRequest
     * @return Result of the ListTemplateVersions operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.ListTemplateVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/ListTemplateVersions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListTemplateVersionsResponse listTemplateVersions(ListTemplateVersionsRequest listTemplateVersionsRequest)
            throws BadRequestException, InternalServerErrorException, PayloadTooLargeException, ForbiddenException,
            NotFoundException, MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException,
            PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTemplateVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTemplateVersionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTemplateVersionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTemplateVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTemplateVersions");

            return clientHandler.execute(new ClientExecutionParams<ListTemplateVersionsRequest, ListTemplateVersionsResponse>()
                    .withOperationName("ListTemplateVersions").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(listTemplateVersionsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTemplateVersionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about all the message templates that are associated with your Amazon Pinpoint account.
     * </p>
     *
     * @param listTemplatesRequest
     * @return Result of the ListTemplates operation returned by the service.
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.ListTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/ListTemplates" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListTemplatesResponse listTemplates(ListTemplatesRequest listTemplatesRequest) throws MethodNotAllowedException,
            TooManyRequestsException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException,
            SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTemplatesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListTemplatesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTemplatesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTemplatesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTemplates");

            return clientHandler.execute(new ClientExecutionParams<ListTemplatesRequest, ListTemplatesResponse>()
                    .withOperationName("ListTemplates").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(listTemplatesRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTemplatesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about a phone number.
     * </p>
     *
     * @param phoneNumberValidateRequest
     * @return Result of the PhoneNumberValidate operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.PhoneNumberValidate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/PhoneNumberValidate" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public PhoneNumberValidateResponse phoneNumberValidate(PhoneNumberValidateRequest phoneNumberValidateRequest)
            throws BadRequestException, InternalServerErrorException, PayloadTooLargeException, ForbiddenException,
            NotFoundException, MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException,
            PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PhoneNumberValidateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, PhoneNumberValidateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(phoneNumberValidateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, phoneNumberValidateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PhoneNumberValidate");

            return clientHandler.execute(new ClientExecutionParams<PhoneNumberValidateRequest, PhoneNumberValidateResponse>()
                    .withOperationName("PhoneNumberValidate").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(phoneNumberValidateRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new PhoneNumberValidateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new event stream for an application or updates the settings of an existing event stream for an
     * application.
     * </p>
     *
     * @param putEventStreamRequest
     * @return Result of the PutEventStream operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.PutEventStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/PutEventStream" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public PutEventStreamResponse putEventStream(PutEventStreamRequest putEventStreamRequest) throws BadRequestException,
            InternalServerErrorException, PayloadTooLargeException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutEventStreamResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                PutEventStreamResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putEventStreamRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putEventStreamRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutEventStream");

            return clientHandler.execute(new ClientExecutionParams<PutEventStreamRequest, PutEventStreamResponse>()
                    .withOperationName("PutEventStream").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(putEventStreamRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new PutEventStreamRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new event to record for endpoints, or creates or updates endpoint data that existing events are
     * associated with.
     * </p>
     *
     * @param putEventsRequest
     * @return Result of the PutEvents operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.PutEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/PutEvents" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public PutEventsResponse putEvents(PutEventsRequest putEventsRequest) throws BadRequestException,
            InternalServerErrorException, PayloadTooLargeException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutEventsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                PutEventsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putEventsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putEventsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutEvents");

            return clientHandler.execute(new ClientExecutionParams<PutEventsRequest, PutEventsResponse>()
                    .withOperationName("PutEvents").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(putEventsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new PutEventsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes one or more custom attributes, of the same attribute type, from the application. Existing endpoints still
     * have the attributes but Amazon Pinpoint will stop capturing new or changed values for these attributes.
     * </p>
     *
     * @param removeAttributesRequest
     * @return Result of the RemoveAttributes operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.RemoveAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/RemoveAttributes" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public RemoveAttributesResponse removeAttributes(RemoveAttributesRequest removeAttributesRequest) throws BadRequestException,
            InternalServerErrorException, PayloadTooLargeException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<RemoveAttributesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                RemoveAttributesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(removeAttributesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, removeAttributesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RemoveAttributes");

            return clientHandler.execute(new ClientExecutionParams<RemoveAttributesRequest, RemoveAttributesResponse>()
                    .withOperationName("RemoveAttributes").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(removeAttributesRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new RemoveAttributesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates and sends a direct message.
     * </p>
     *
     * @param sendMessagesRequest
     * @return Result of the SendMessages operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.SendMessages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/SendMessages" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public SendMessagesResponse sendMessages(SendMessagesRequest sendMessagesRequest) throws BadRequestException,
            InternalServerErrorException, PayloadTooLargeException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<SendMessagesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                SendMessagesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(sendMessagesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, sendMessagesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SendMessages");

            return clientHandler.execute(new ClientExecutionParams<SendMessagesRequest, SendMessagesResponse>()
                    .withOperationName("SendMessages").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(sendMessagesRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new SendMessagesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Send an OTP message
     * </p>
     *
     * @param sendOtpMessageRequest
     * @return Result of the SendOTPMessage operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws PayloadTooLargeException
     *         413 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.SendOTPMessage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/SendOTPMessage" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public SendOtpMessageResponse sendOTPMessage(SendOtpMessageRequest sendOtpMessageRequest) throws BadRequestException,
            InternalServerErrorException, PayloadTooLargeException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<SendOtpMessageResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                SendOtpMessageResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(sendOtpMessageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, sendOtpMessageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SendOTPMessage");

            return clientHandler.execute(new ClientExecutionParams<SendOtpMessageRequest, SendOtpMessageResponse>()
                    .withOperationName("SendOTPMessage").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(sendOtpMessageRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new SendOtpMessageRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates and sends a message to a list of users.
     * </p>
     *
     * @param sendUsersMessagesRequest
     * @return Result of the SendUsersMessages operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.SendUsersMessages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/SendUsersMessages" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public SendUsersMessagesResponse sendUsersMessages(SendUsersMessagesRequest sendUsersMessagesRequest)
            throws BadRequestException, InternalServerErrorException, PayloadTooLargeException, ForbiddenException,
            NotFoundException, MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException,
            PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<SendUsersMessagesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                SendUsersMessagesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(sendUsersMessagesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, sendUsersMessagesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SendUsersMessages");

            return clientHandler.execute(new ClientExecutionParams<SendUsersMessagesRequest, SendUsersMessagesResponse>()
                    .withOperationName("SendUsersMessages").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(sendUsersMessagesRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new SendUsersMessagesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds one or more tags (keys and values) to an application, campaign, message template, or segment.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws AwsServiceException, SdkClientException,
            PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                TagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");

            return clientHandler.execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                    .withOperationName("TagResource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(tagResourceRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new TagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes one or more tags (keys and values) from an application, campaign, message template, or segment.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws AwsServiceException,
            SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UntagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");

            return clientHandler.execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                    .withOperationName("UntagResource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(untagResourceRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Enables the ADM channel for an application or updates the status and settings of the ADM channel for an
     * application.
     * </p>
     *
     * @param updateAdmChannelRequest
     * @return Result of the UpdateAdmChannel operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.UpdateAdmChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateAdmChannel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateAdmChannelResponse updateAdmChannel(UpdateAdmChannelRequest updateAdmChannelRequest) throws BadRequestException,
            InternalServerErrorException, PayloadTooLargeException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateAdmChannelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateAdmChannelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateAdmChannelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAdmChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAdmChannel");

            return clientHandler.execute(new ClientExecutionParams<UpdateAdmChannelRequest, UpdateAdmChannelResponse>()
                    .withOperationName("UpdateAdmChannel").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(updateAdmChannelRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateAdmChannelRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Enables the APNs channel for an application or updates the status and settings of the APNs channel for an
     * application.
     * </p>
     *
     * @param updateApnsChannelRequest
     * @return Result of the UpdateApnsChannel operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.UpdateApnsChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateApnsChannel" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateApnsChannelResponse updateApnsChannel(UpdateApnsChannelRequest updateApnsChannelRequest)
            throws BadRequestException, InternalServerErrorException, PayloadTooLargeException, ForbiddenException,
            NotFoundException, MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException,
            PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateApnsChannelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateApnsChannelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateApnsChannelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateApnsChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateApnsChannel");

            return clientHandler.execute(new ClientExecutionParams<UpdateApnsChannelRequest, UpdateApnsChannelResponse>()
                    .withOperationName("UpdateApnsChannel").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(updateApnsChannelRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateApnsChannelRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Enables the APNs sandbox channel for an application or updates the status and settings of the APNs sandbox
     * channel for an application.
     * </p>
     *
     * @param updateApnsSandboxChannelRequest
     * @return Result of the UpdateApnsSandboxChannel operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.UpdateApnsSandboxChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateApnsSandboxChannel"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateApnsSandboxChannelResponse updateApnsSandboxChannel(
            UpdateApnsSandboxChannelRequest updateApnsSandboxChannelRequest) throws BadRequestException,
            InternalServerErrorException, PayloadTooLargeException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateApnsSandboxChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateApnsSandboxChannelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateApnsSandboxChannelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateApnsSandboxChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateApnsSandboxChannel");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateApnsSandboxChannelRequest, UpdateApnsSandboxChannelResponse>()
                            .withOperationName("UpdateApnsSandboxChannel").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withInput(updateApnsSandboxChannelRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateApnsSandboxChannelRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Enables the APNs VoIP channel for an application or updates the status and settings of the APNs VoIP channel for
     * an application.
     * </p>
     *
     * @param updateApnsVoipChannelRequest
     * @return Result of the UpdateApnsVoipChannel operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.UpdateApnsVoipChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateApnsVoipChannel"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateApnsVoipChannelResponse updateApnsVoipChannel(UpdateApnsVoipChannelRequest updateApnsVoipChannelRequest)
            throws BadRequestException, InternalServerErrorException, PayloadTooLargeException, ForbiddenException,
            NotFoundException, MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException,
            PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateApnsVoipChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateApnsVoipChannelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateApnsVoipChannelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateApnsVoipChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateApnsVoipChannel");

            return clientHandler.execute(new ClientExecutionParams<UpdateApnsVoipChannelRequest, UpdateApnsVoipChannelResponse>()
                    .withOperationName("UpdateApnsVoipChannel").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(updateApnsVoipChannelRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateApnsVoipChannelRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Enables the APNs VoIP sandbox channel for an application or updates the status and settings of the APNs VoIP
     * sandbox channel for an application.
     * </p>
     *
     * @param updateApnsVoipSandboxChannelRequest
     * @return Result of the UpdateApnsVoipSandboxChannel operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.UpdateApnsVoipSandboxChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateApnsVoipSandboxChannel"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateApnsVoipSandboxChannelResponse updateApnsVoipSandboxChannel(
            UpdateApnsVoipSandboxChannelRequest updateApnsVoipSandboxChannelRequest) throws BadRequestException,
            InternalServerErrorException, PayloadTooLargeException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateApnsVoipSandboxChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateApnsVoipSandboxChannelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateApnsVoipSandboxChannelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateApnsVoipSandboxChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateApnsVoipSandboxChannel");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateApnsVoipSandboxChannelRequest, UpdateApnsVoipSandboxChannelResponse>()
                            .withOperationName("UpdateApnsVoipSandboxChannel").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withInput(updateApnsVoipSandboxChannelRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateApnsVoipSandboxChannelRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the settings for an application.
     * </p>
     *
     * @param updateApplicationSettingsRequest
     * @return Result of the UpdateApplicationSettings operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.UpdateApplicationSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateApplicationSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateApplicationSettingsResponse updateApplicationSettings(
            UpdateApplicationSettingsRequest updateApplicationSettingsRequest) throws BadRequestException,
            InternalServerErrorException, PayloadTooLargeException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateApplicationSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateApplicationSettingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateApplicationSettingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateApplicationSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateApplicationSettings");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateApplicationSettingsRequest, UpdateApplicationSettingsResponse>()
                            .withOperationName("UpdateApplicationSettings").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withInput(updateApplicationSettingsRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateApplicationSettingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Enables the Baidu channel for an application or updates the status and settings of the Baidu channel for an
     * application.
     * </p>
     *
     * @param updateBaiduChannelRequest
     * @return Result of the UpdateBaiduChannel operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.UpdateBaiduChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateBaiduChannel" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateBaiduChannelResponse updateBaiduChannel(UpdateBaiduChannelRequest updateBaiduChannelRequest)
            throws BadRequestException, InternalServerErrorException, PayloadTooLargeException, ForbiddenException,
            NotFoundException, MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException,
            PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateBaiduChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateBaiduChannelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateBaiduChannelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateBaiduChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateBaiduChannel");

            return clientHandler.execute(new ClientExecutionParams<UpdateBaiduChannelRequest, UpdateBaiduChannelResponse>()
                    .withOperationName("UpdateBaiduChannel").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(updateBaiduChannelRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateBaiduChannelRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the configuration and other settings for a campaign.
     * </p>
     *
     * @param updateCampaignRequest
     * @return Result of the UpdateCampaign operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.UpdateCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateCampaign" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateCampaignResponse updateCampaign(UpdateCampaignRequest updateCampaignRequest) throws BadRequestException,
            InternalServerErrorException, PayloadTooLargeException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateCampaignResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateCampaignResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateCampaignRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateCampaignRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateCampaign");

            return clientHandler.execute(new ClientExecutionParams<UpdateCampaignRequest, UpdateCampaignResponse>()
                    .withOperationName("UpdateCampaign").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(updateCampaignRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateCampaignRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Enables the email channel for an application or updates the status and settings of the email channel for an
     * application.
     * </p>
     *
     * @param updateEmailChannelRequest
     * @return Result of the UpdateEmailChannel operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.UpdateEmailChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateEmailChannel" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateEmailChannelResponse updateEmailChannel(UpdateEmailChannelRequest updateEmailChannelRequest)
            throws BadRequestException, InternalServerErrorException, PayloadTooLargeException, ForbiddenException,
            NotFoundException, MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException,
            PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateEmailChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateEmailChannelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateEmailChannelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateEmailChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateEmailChannel");

            return clientHandler.execute(new ClientExecutionParams<UpdateEmailChannelRequest, UpdateEmailChannelResponse>()
                    .withOperationName("UpdateEmailChannel").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(updateEmailChannelRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateEmailChannelRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an existing message template for messages that are sent through the email channel.
     * </p>
     *
     * @param updateEmailTemplateRequest
     * @return Result of the UpdateEmailTemplate operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.UpdateEmailTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateEmailTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateEmailTemplateResponse updateEmailTemplate(UpdateEmailTemplateRequest updateEmailTemplateRequest)
            throws BadRequestException, InternalServerErrorException, PayloadTooLargeException, ForbiddenException,
            NotFoundException, MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException,
            PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateEmailTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateEmailTemplateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateEmailTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateEmailTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateEmailTemplate");

            return clientHandler.execute(new ClientExecutionParams<UpdateEmailTemplateRequest, UpdateEmailTemplateResponse>()
                    .withOperationName("UpdateEmailTemplate").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(updateEmailTemplateRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateEmailTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new endpoint for an application or updates the settings and attributes of an existing endpoint for an
     * application. You can also use this operation to define custom attributes for an endpoint. If an update includes
     * one or more values for a custom attribute, Amazon Pinpoint replaces (overwrites) any existing values with the new
     * values.
     * </p>
     *
     * @param updateEndpointRequest
     * @return Result of the UpdateEndpoint operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.UpdateEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateEndpointResponse updateEndpoint(UpdateEndpointRequest updateEndpointRequest) throws BadRequestException,
            InternalServerErrorException, PayloadTooLargeException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateEndpointResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateEndpointResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateEndpointRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateEndpoint");

            return clientHandler.execute(new ClientExecutionParams<UpdateEndpointRequest, UpdateEndpointResponse>()
                    .withOperationName("UpdateEndpoint").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(updateEndpointRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateEndpointRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new batch of endpoints for an application or updates the settings and attributes of a batch of existing
     * endpoints for an application. You can also use this operation to define custom attributes for a batch of
     * endpoints. If an update includes one or more values for a custom attribute, Amazon Pinpoint replaces (overwrites)
     * any existing values with the new values.
     * </p>
     *
     * @param updateEndpointsBatchRequest
     * @return Result of the UpdateEndpointsBatch operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.UpdateEndpointsBatch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateEndpointsBatch" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateEndpointsBatchResponse updateEndpointsBatch(UpdateEndpointsBatchRequest updateEndpointsBatchRequest)
            throws BadRequestException, InternalServerErrorException, PayloadTooLargeException, ForbiddenException,
            NotFoundException, MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException,
            PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateEndpointsBatchResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateEndpointsBatchResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateEndpointsBatchRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateEndpointsBatchRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateEndpointsBatch");

            return clientHandler.execute(new ClientExecutionParams<UpdateEndpointsBatchRequest, UpdateEndpointsBatchResponse>()
                    .withOperationName("UpdateEndpointsBatch").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(updateEndpointsBatchRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateEndpointsBatchRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Enables the GCM channel for an application or updates the status and settings of the GCM channel for an
     * application.
     * </p>
     *
     * @param updateGcmChannelRequest
     * @return Result of the UpdateGcmChannel operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.UpdateGcmChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateGcmChannel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateGcmChannelResponse updateGcmChannel(UpdateGcmChannelRequest updateGcmChannelRequest) throws BadRequestException,
            InternalServerErrorException, PayloadTooLargeException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateGcmChannelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateGcmChannelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateGcmChannelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateGcmChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateGcmChannel");

            return clientHandler.execute(new ClientExecutionParams<UpdateGcmChannelRequest, UpdateGcmChannelResponse>()
                    .withOperationName("UpdateGcmChannel").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(updateGcmChannelRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateGcmChannelRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an existing message template for messages sent through the in-app message channel.
     * </p>
     *
     * @param updateInAppTemplateRequest
     * @return Result of the UpdateInAppTemplate operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.UpdateInAppTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateInAppTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateInAppTemplateResponse updateInAppTemplate(UpdateInAppTemplateRequest updateInAppTemplateRequest)
            throws BadRequestException, InternalServerErrorException, PayloadTooLargeException, ForbiddenException,
            NotFoundException, MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException,
            PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateInAppTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateInAppTemplateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateInAppTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateInAppTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateInAppTemplate");

            return clientHandler.execute(new ClientExecutionParams<UpdateInAppTemplateRequest, UpdateInAppTemplateResponse>()
                    .withOperationName("UpdateInAppTemplate").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(updateInAppTemplateRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateInAppTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the configuration and other settings for a journey.
     * </p>
     *
     * @param updateJourneyRequest
     * @return Result of the UpdateJourney operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws ConflictException
     *         The request failed due to a conflict with the current state of the specified resource
     *         (ConflictException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.UpdateJourney
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateJourney" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateJourneyResponse updateJourney(UpdateJourneyRequest updateJourneyRequest) throws BadRequestException,
            InternalServerErrorException, PayloadTooLargeException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException,
            PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateJourneyResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateJourneyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateJourneyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateJourneyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateJourney");

            return clientHandler.execute(new ClientExecutionParams<UpdateJourneyRequest, UpdateJourneyResponse>()
                    .withOperationName("UpdateJourney").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(updateJourneyRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateJourneyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Cancels (stops) an active journey.
     * </p>
     *
     * @param updateJourneyStateRequest
     * @return Result of the UpdateJourneyState operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.UpdateJourneyState
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateJourneyState" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateJourneyStateResponse updateJourneyState(UpdateJourneyStateRequest updateJourneyStateRequest)
            throws BadRequestException, InternalServerErrorException, PayloadTooLargeException, ForbiddenException,
            NotFoundException, MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException,
            PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateJourneyStateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateJourneyStateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateJourneyStateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateJourneyStateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateJourneyState");

            return clientHandler.execute(new ClientExecutionParams<UpdateJourneyStateRequest, UpdateJourneyStateResponse>()
                    .withOperationName("UpdateJourneyState").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(updateJourneyStateRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateJourneyStateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an existing message template for messages that are sent through a push notification channel.
     * </p>
     *
     * @param updatePushTemplateRequest
     * @return Result of the UpdatePushTemplate operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.UpdatePushTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdatePushTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdatePushTemplateResponse updatePushTemplate(UpdatePushTemplateRequest updatePushTemplateRequest)
            throws BadRequestException, InternalServerErrorException, PayloadTooLargeException, ForbiddenException,
            NotFoundException, MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException,
            PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdatePushTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdatePushTemplateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updatePushTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updatePushTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdatePushTemplate");

            return clientHandler.execute(new ClientExecutionParams<UpdatePushTemplateRequest, UpdatePushTemplateResponse>()
                    .withOperationName("UpdatePushTemplate").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(updatePushTemplateRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdatePushTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an Amazon Pinpoint configuration for a recommender model.
     * </p>
     *
     * @param updateRecommenderConfigurationRequest
     * @return Result of the UpdateRecommenderConfiguration operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.UpdateRecommenderConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateRecommenderConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateRecommenderConfigurationResponse updateRecommenderConfiguration(
            UpdateRecommenderConfigurationRequest updateRecommenderConfigurationRequest) throws BadRequestException,
            InternalServerErrorException, PayloadTooLargeException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateRecommenderConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateRecommenderConfigurationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateRecommenderConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateRecommenderConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateRecommenderConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateRecommenderConfigurationRequest, UpdateRecommenderConfigurationResponse>()
                            .withOperationName("UpdateRecommenderConfiguration").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withInput(updateRecommenderConfigurationRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateRecommenderConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new segment for an application or updates the configuration, dimension, and other settings for an
     * existing segment that's associated with an application.
     * </p>
     *
     * @param updateSegmentRequest
     * @return Result of the UpdateSegment operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.UpdateSegment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateSegment" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateSegmentResponse updateSegment(UpdateSegmentRequest updateSegmentRequest) throws BadRequestException,
            InternalServerErrorException, PayloadTooLargeException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateSegmentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateSegmentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateSegmentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateSegmentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateSegment");

            return clientHandler.execute(new ClientExecutionParams<UpdateSegmentRequest, UpdateSegmentResponse>()
                    .withOperationName("UpdateSegment").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(updateSegmentRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateSegmentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Enables the SMS channel for an application or updates the status and settings of the SMS channel for an
     * application.
     * </p>
     *
     * @param updateSmsChannelRequest
     * @return Result of the UpdateSmsChannel operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.UpdateSmsChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateSmsChannel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateSmsChannelResponse updateSmsChannel(UpdateSmsChannelRequest updateSmsChannelRequest) throws BadRequestException,
            InternalServerErrorException, PayloadTooLargeException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateSmsChannelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateSmsChannelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateSmsChannelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateSmsChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateSmsChannel");

            return clientHandler.execute(new ClientExecutionParams<UpdateSmsChannelRequest, UpdateSmsChannelResponse>()
                    .withOperationName("UpdateSmsChannel").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(updateSmsChannelRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateSmsChannelRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an existing message template for messages that are sent through the SMS channel.
     * </p>
     *
     * @param updateSmsTemplateRequest
     * @return Result of the UpdateSmsTemplate operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.UpdateSmsTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateSmsTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateSmsTemplateResponse updateSmsTemplate(UpdateSmsTemplateRequest updateSmsTemplateRequest)
            throws BadRequestException, InternalServerErrorException, PayloadTooLargeException, ForbiddenException,
            NotFoundException, MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException,
            PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateSmsTemplateResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateSmsTemplateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateSmsTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateSmsTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateSmsTemplate");

            return clientHandler.execute(new ClientExecutionParams<UpdateSmsTemplateRequest, UpdateSmsTemplateResponse>()
                    .withOperationName("UpdateSmsTemplate").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(updateSmsTemplateRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateSmsTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Changes the status of a specific version of a message template to <i>active</i>.
     * </p>
     *
     * @param updateTemplateActiveVersionRequest
     * @return Result of the UpdateTemplateActiveVersion operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.UpdateTemplateActiveVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateTemplateActiveVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateTemplateActiveVersionResponse updateTemplateActiveVersion(
            UpdateTemplateActiveVersionRequest updateTemplateActiveVersionRequest) throws BadRequestException,
            InternalServerErrorException, PayloadTooLargeException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateTemplateActiveVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateTemplateActiveVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateTemplateActiveVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateTemplateActiveVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateTemplateActiveVersion");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateTemplateActiveVersionRequest, UpdateTemplateActiveVersionResponse>()
                            .withOperationName("UpdateTemplateActiveVersion").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withInput(updateTemplateActiveVersionRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateTemplateActiveVersionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Enables the voice channel for an application or updates the status and settings of the voice channel for an
     * application.
     * </p>
     *
     * @param updateVoiceChannelRequest
     * @return Result of the UpdateVoiceChannel operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.UpdateVoiceChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateVoiceChannel" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateVoiceChannelResponse updateVoiceChannel(UpdateVoiceChannelRequest updateVoiceChannelRequest)
            throws BadRequestException, InternalServerErrorException, PayloadTooLargeException, ForbiddenException,
            NotFoundException, MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException,
            PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateVoiceChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateVoiceChannelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateVoiceChannelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateVoiceChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateVoiceChannel");

            return clientHandler.execute(new ClientExecutionParams<UpdateVoiceChannelRequest, UpdateVoiceChannelResponse>()
                    .withOperationName("UpdateVoiceChannel").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(updateVoiceChannelRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateVoiceChannelRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an existing message template for messages that are sent through the voice channel.
     * </p>
     *
     * @param updateVoiceTemplateRequest
     * @return Result of the UpdateVoiceTemplate operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws PayloadTooLargeException
     *         The request failed because the payload for the body of the request is too large
     *         (RequestEntityTooLargeException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.UpdateVoiceTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateVoiceTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateVoiceTemplateResponse updateVoiceTemplate(UpdateVoiceTemplateRequest updateVoiceTemplateRequest)
            throws BadRequestException, InternalServerErrorException, PayloadTooLargeException, ForbiddenException,
            NotFoundException, MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException,
            PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateVoiceTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateVoiceTemplateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateVoiceTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateVoiceTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateVoiceTemplate");

            return clientHandler.execute(new ClientExecutionParams<UpdateVoiceTemplateRequest, UpdateVoiceTemplateResponse>()
                    .withOperationName("UpdateVoiceTemplate").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(updateVoiceTemplateRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateVoiceTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Verify an OTP
     * </p>
     *
     * @param verifyOtpMessageRequest
     * @return Result of the VerifyOTPMessage operation returned by the service.
     * @throws BadRequestException
     *         400 response
     * @throws InternalServerErrorException
     *         500 response
     * @throws PayloadTooLargeException
     *         413 response
     * @throws ForbiddenException
     *         403 response
     * @throws NotFoundException
     *         404 response
     * @throws MethodNotAllowedException
     *         405 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.VerifyOTPMessage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/VerifyOTPMessage" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public VerifyOtpMessageResponse verifyOTPMessage(VerifyOtpMessageRequest verifyOtpMessageRequest) throws BadRequestException,
            InternalServerErrorException, PayloadTooLargeException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<VerifyOtpMessageResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                VerifyOtpMessageResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(verifyOtpMessageRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, verifyOtpMessageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "VerifyOTPMessage");

            return clientHandler.execute(new ClientExecutionParams<VerifyOtpMessageRequest, VerifyOtpMessageResponse>()
                    .withOperationName("VerifyOTPMessage").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(verifyOtpMessageRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new VerifyOtpMessageRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        PinpointServiceClientConfigurationBuilder.BuilderInternal serviceConfigBuilder = PinpointServiceClientConfigurationBuilder
                .builder(clientConfiguration.toBuilder());
        serviceConfigBuilder.overrideConfiguration(serviceClientConfiguration.overrideConfiguration());
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        return serviceConfigBuilder.buildSdkClientConfiguration();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(PinpointException::builder)
                .protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ForbiddenException")
                                .exceptionBuilderSupplier(ForbiddenException::builder).httpStatusCode(403).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NotFoundException")
                                .exceptionBuilderSupplier(NotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("MethodNotAllowedException")
                                .exceptionBuilderSupplier(MethodNotAllowedException::builder).httpStatusCode(405).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConflictException")
                                .exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("PayloadTooLargeException")
                                .exceptionBuilderSupplier(PayloadTooLargeException::builder).httpStatusCode(413).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyRequestsException")
                                .exceptionBuilderSupplier(TooManyRequestsException::builder).httpStatusCode(429).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("BadRequestException")
                                .exceptionBuilderSupplier(BadRequestException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalServerErrorException")
                                .exceptionBuilderSupplier(InternalServerErrorException::builder).httpStatusCode(500).build());
    }

    @Override
    public final PinpointServiceClientConfiguration serviceClientConfiguration() {
        return this.serviceClientConfiguration;
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
