/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * For a campaign, specifies limits on the messages that the campaign can send. For an application, specifies the
 * default limits for messages that campaigns in the application can send.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CampaignLimits implements SdkPojo, Serializable, ToCopyableBuilder<CampaignLimits.Builder, CampaignLimits> {
    private static final SdkField<Integer> DAILY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Daily")
            .getter(getter(CampaignLimits::daily)).setter(setter(Builder::daily))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Daily").build()).build();

    private static final SdkField<Integer> MAXIMUM_DURATION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaximumDuration").getter(getter(CampaignLimits::maximumDuration))
            .setter(setter(Builder::maximumDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumDuration").build()).build();

    private static final SdkField<Integer> MESSAGES_PER_SECOND_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MessagesPerSecond").getter(getter(CampaignLimits::messagesPerSecond))
            .setter(setter(Builder::messagesPerSecond))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessagesPerSecond").build()).build();

    private static final SdkField<Integer> TOTAL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Total")
            .getter(getter(CampaignLimits::total)).setter(setter(Builder::total))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Total").build()).build();

    private static final SdkField<Integer> SESSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Session").getter(getter(CampaignLimits::session)).setter(setter(Builder::session))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Session").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DAILY_FIELD,
            MAXIMUM_DURATION_FIELD, MESSAGES_PER_SECOND_FIELD, TOTAL_FIELD, SESSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer daily;

    private final Integer maximumDuration;

    private final Integer messagesPerSecond;

    private final Integer total;

    private final Integer session;

    private CampaignLimits(BuilderImpl builder) {
        this.daily = builder.daily;
        this.maximumDuration = builder.maximumDuration;
        this.messagesPerSecond = builder.messagesPerSecond;
        this.total = builder.total;
        this.session = builder.session;
    }

    /**
     * <p>
     * The maximum number of messages that a campaign can send to a single endpoint during a 24-hour period. For an
     * application, this value specifies the default limit for the number of messages that campaigns and journeys can
     * send to a single endpoint during a 24-hour period. The maximum value is 100.
     * </p>
     * 
     * @return The maximum number of messages that a campaign can send to a single endpoint during a 24-hour period. For
     *         an application, this value specifies the default limit for the number of messages that campaigns and
     *         journeys can send to a single endpoint during a 24-hour period. The maximum value is 100.
     */
    public final Integer daily() {
        return daily;
    }

    /**
     * <p>
     * The maximum amount of time, in seconds, that a campaign can attempt to deliver a message after the scheduled
     * start time for the campaign. The minimum value is 60 seconds.
     * </p>
     * 
     * @return The maximum amount of time, in seconds, that a campaign can attempt to deliver a message after the
     *         scheduled start time for the campaign. The minimum value is 60 seconds.
     */
    public final Integer maximumDuration() {
        return maximumDuration;
    }

    /**
     * <p>
     * The maximum number of messages that a campaign can send each second. For an application, this value specifies the
     * default limit for the number of messages that campaigns can send each second. The minimum value is 50. The
     * maximum value is 20,000.
     * </p>
     * 
     * @return The maximum number of messages that a campaign can send each second. For an application, this value
     *         specifies the default limit for the number of messages that campaigns can send each second. The minimum
     *         value is 50. The maximum value is 20,000.
     */
    public final Integer messagesPerSecond() {
        return messagesPerSecond;
    }

    /**
     * <p>
     * The maximum number of messages that a campaign can send to a single endpoint during the course of the campaign.
     * If a campaign recurs, this setting applies to all runs of the campaign. The maximum value is 100.
     * </p>
     * 
     * @return The maximum number of messages that a campaign can send to a single endpoint during the course of the
     *         campaign. If a campaign recurs, this setting applies to all runs of the campaign. The maximum value is
     *         100.
     */
    public final Integer total() {
        return total;
    }

    /**
     * <p>
     * The maximum total number of messages that the campaign can send per user session.
     * </p>
     * 
     * @return The maximum total number of messages that the campaign can send per user session.
     */
    public final Integer session() {
        return session;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(daily());
        hashCode = 31 * hashCode + Objects.hashCode(maximumDuration());
        hashCode = 31 * hashCode + Objects.hashCode(messagesPerSecond());
        hashCode = 31 * hashCode + Objects.hashCode(total());
        hashCode = 31 * hashCode + Objects.hashCode(session());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CampaignLimits)) {
            return false;
        }
        CampaignLimits other = (CampaignLimits) obj;
        return Objects.equals(daily(), other.daily()) && Objects.equals(maximumDuration(), other.maximumDuration())
                && Objects.equals(messagesPerSecond(), other.messagesPerSecond()) && Objects.equals(total(), other.total())
                && Objects.equals(session(), other.session());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CampaignLimits").add("Daily", daily()).add("MaximumDuration", maximumDuration())
                .add("MessagesPerSecond", messagesPerSecond()).add("Total", total()).add("Session", session()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Daily":
            return Optional.ofNullable(clazz.cast(daily()));
        case "MaximumDuration":
            return Optional.ofNullable(clazz.cast(maximumDuration()));
        case "MessagesPerSecond":
            return Optional.ofNullable(clazz.cast(messagesPerSecond()));
        case "Total":
            return Optional.ofNullable(clazz.cast(total()));
        case "Session":
            return Optional.ofNullable(clazz.cast(session()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CampaignLimits, T> g) {
        return obj -> g.apply((CampaignLimits) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CampaignLimits> {
        /**
         * <p>
         * The maximum number of messages that a campaign can send to a single endpoint during a 24-hour period. For an
         * application, this value specifies the default limit for the number of messages that campaigns and journeys
         * can send to a single endpoint during a 24-hour period. The maximum value is 100.
         * </p>
         * 
         * @param daily
         *        The maximum number of messages that a campaign can send to a single endpoint during a 24-hour period.
         *        For an application, this value specifies the default limit for the number of messages that campaigns
         *        and journeys can send to a single endpoint during a 24-hour period. The maximum value is 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder daily(Integer daily);

        /**
         * <p>
         * The maximum amount of time, in seconds, that a campaign can attempt to deliver a message after the scheduled
         * start time for the campaign. The minimum value is 60 seconds.
         * </p>
         * 
         * @param maximumDuration
         *        The maximum amount of time, in seconds, that a campaign can attempt to deliver a message after the
         *        scheduled start time for the campaign. The minimum value is 60 seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumDuration(Integer maximumDuration);

        /**
         * <p>
         * The maximum number of messages that a campaign can send each second. For an application, this value specifies
         * the default limit for the number of messages that campaigns can send each second. The minimum value is 50.
         * The maximum value is 20,000.
         * </p>
         * 
         * @param messagesPerSecond
         *        The maximum number of messages that a campaign can send each second. For an application, this value
         *        specifies the default limit for the number of messages that campaigns can send each second. The
         *        minimum value is 50. The maximum value is 20,000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messagesPerSecond(Integer messagesPerSecond);

        /**
         * <p>
         * The maximum number of messages that a campaign can send to a single endpoint during the course of the
         * campaign. If a campaign recurs, this setting applies to all runs of the campaign. The maximum value is 100.
         * </p>
         * 
         * @param total
         *        The maximum number of messages that a campaign can send to a single endpoint during the course of the
         *        campaign. If a campaign recurs, this setting applies to all runs of the campaign. The maximum value is
         *        100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder total(Integer total);

        /**
         * <p>
         * The maximum total number of messages that the campaign can send per user session.
         * </p>
         * 
         * @param session
         *        The maximum total number of messages that the campaign can send per user session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder session(Integer session);
    }

    static final class BuilderImpl implements Builder {
        private Integer daily;

        private Integer maximumDuration;

        private Integer messagesPerSecond;

        private Integer total;

        private Integer session;

        private BuilderImpl() {
        }

        private BuilderImpl(CampaignLimits model) {
            daily(model.daily);
            maximumDuration(model.maximumDuration);
            messagesPerSecond(model.messagesPerSecond);
            total(model.total);
            session(model.session);
        }

        public final Integer getDaily() {
            return daily;
        }

        public final void setDaily(Integer daily) {
            this.daily = daily;
        }

        @Override
        public final Builder daily(Integer daily) {
            this.daily = daily;
            return this;
        }

        public final Integer getMaximumDuration() {
            return maximumDuration;
        }

        public final void setMaximumDuration(Integer maximumDuration) {
            this.maximumDuration = maximumDuration;
        }

        @Override
        public final Builder maximumDuration(Integer maximumDuration) {
            this.maximumDuration = maximumDuration;
            return this;
        }

        public final Integer getMessagesPerSecond() {
            return messagesPerSecond;
        }

        public final void setMessagesPerSecond(Integer messagesPerSecond) {
            this.messagesPerSecond = messagesPerSecond;
        }

        @Override
        public final Builder messagesPerSecond(Integer messagesPerSecond) {
            this.messagesPerSecond = messagesPerSecond;
            return this;
        }

        public final Integer getTotal() {
            return total;
        }

        public final void setTotal(Integer total) {
            this.total = total;
        }

        @Override
        public final Builder total(Integer total) {
            this.total = total;
            return this;
        }

        public final Integer getSession() {
            return session;
        }

        public final void setSession(Integer session) {
            this.session = session;
        }

        @Override
        public final Builder session(Integer session) {
            this.session = session;
            return this;
        }

        @Override
        public CampaignLimits build() {
            return new CampaignLimits(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
