/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about Amazon Pinpoint configuration settings for retrieving and processing data from a
 * recommender model.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecommenderConfigurationResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<RecommenderConfigurationResponse.Builder, RecommenderConfigurationResponse> {
    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Attributes")
            .getter(getter(RecommenderConfigurationResponse::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> CREATION_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreationDate").getter(getter(RecommenderConfigurationResponse::creationDate))
            .setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(RecommenderConfigurationResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(RecommenderConfigurationResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> LAST_MODIFIED_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastModifiedDate").getter(getter(RecommenderConfigurationResponse::lastModifiedDate))
            .setter(setter(Builder::lastModifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(RecommenderConfigurationResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> RECOMMENDATION_PROVIDER_ID_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RecommendationProviderIdType")
            .getter(getter(RecommenderConfigurationResponse::recommendationProviderIdType))
            .setter(setter(Builder::recommendationProviderIdType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendationProviderIdType")
                    .build()).build();

    private static final SdkField<String> RECOMMENDATION_PROVIDER_ROLE_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RecommendationProviderRoleArn")
            .getter(getter(RecommenderConfigurationResponse::recommendationProviderRoleArn))
            .setter(setter(Builder::recommendationProviderRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendationProviderRoleArn")
                    .build()).build();

    private static final SdkField<String> RECOMMENDATION_PROVIDER_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecommendationProviderUri").getter(getter(RecommenderConfigurationResponse::recommendationProviderUri))
            .setter(setter(Builder::recommendationProviderUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendationProviderUri").build())
            .build();

    private static final SdkField<String> RECOMMENDATION_TRANSFORMER_URI_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RecommendationTransformerUri")
            .getter(getter(RecommenderConfigurationResponse::recommendationTransformerUri))
            .setter(setter(Builder::recommendationTransformerUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendationTransformerUri")
                    .build()).build();

    private static final SdkField<String> RECOMMENDATIONS_DISPLAY_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RecommendationsDisplayName")
            .getter(getter(RecommenderConfigurationResponse::recommendationsDisplayName))
            .setter(setter(Builder::recommendationsDisplayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendationsDisplayName").build())
            .build();

    private static final SdkField<Integer> RECOMMENDATIONS_PER_MESSAGE_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("RecommendationsPerMessage")
            .getter(getter(RecommenderConfigurationResponse::recommendationsPerMessage))
            .setter(setter(Builder::recommendationsPerMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendationsPerMessage").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTES_FIELD,
            CREATION_DATE_FIELD, DESCRIPTION_FIELD, ID_FIELD, LAST_MODIFIED_DATE_FIELD, NAME_FIELD,
            RECOMMENDATION_PROVIDER_ID_TYPE_FIELD, RECOMMENDATION_PROVIDER_ROLE_ARN_FIELD, RECOMMENDATION_PROVIDER_URI_FIELD,
            RECOMMENDATION_TRANSFORMER_URI_FIELD, RECOMMENDATIONS_DISPLAY_NAME_FIELD, RECOMMENDATIONS_PER_MESSAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Map<String, String> attributes;

    private final String creationDate;

    private final String description;

    private final String id;

    private final String lastModifiedDate;

    private final String name;

    private final String recommendationProviderIdType;

    private final String recommendationProviderRoleArn;

    private final String recommendationProviderUri;

    private final String recommendationTransformerUri;

    private final String recommendationsDisplayName;

    private final Integer recommendationsPerMessage;

    private RecommenderConfigurationResponse(BuilderImpl builder) {
        this.attributes = builder.attributes;
        this.creationDate = builder.creationDate;
        this.description = builder.description;
        this.id = builder.id;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.name = builder.name;
        this.recommendationProviderIdType = builder.recommendationProviderIdType;
        this.recommendationProviderRoleArn = builder.recommendationProviderRoleArn;
        this.recommendationProviderUri = builder.recommendationProviderUri;
        this.recommendationTransformerUri = builder.recommendationTransformerUri;
        this.recommendationsDisplayName = builder.recommendationsDisplayName;
        this.recommendationsPerMessage = builder.recommendationsPerMessage;
    }

    /**
     * For responses, this returns true if the service returned a value for the Attributes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAttributes() {
        return attributes != null && !(attributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map that defines 1-10 custom endpoint or user attributes, depending on the value for the
     * RecommendationProviderIdType property. Each of these attributes temporarily stores a recommended item that's
     * retrieved from the recommender model and sent to an AWS Lambda function for additional processing. Each attribute
     * can be used as a message variable in a message template.
     * </p>
     * <p>
     * This value is null if the configuration doesn't invoke an AWS Lambda function (RecommendationTransformerUri) to
     * perform additional processing of recommendation data.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributes} method.
     * </p>
     * 
     * @return A map that defines 1-10 custom endpoint or user attributes, depending on the value for the
     *         RecommendationProviderIdType property. Each of these attributes temporarily stores a recommended item
     *         that's retrieved from the recommender model and sent to an AWS Lambda function for additional processing.
     *         Each attribute can be used as a message variable in a message template.</p>
     *         <p>
     *         This value is null if the configuration doesn't invoke an AWS Lambda function
     *         (RecommendationTransformerUri) to perform additional processing of recommendation data.
     */
    public final Map<String, String> attributes() {
        return attributes;
    }

    /**
     * <p>
     * The date, in extended ISO 8601 format, when the configuration was created for the recommender model.
     * </p>
     * 
     * @return The date, in extended ISO 8601 format, when the configuration was created for the recommender model.
     */
    public final String creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The custom description of the configuration for the recommender model.
     * </p>
     * 
     * @return The custom description of the configuration for the recommender model.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The unique identifier for the recommender model configuration.
     * </p>
     * 
     * @return The unique identifier for the recommender model configuration.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The date, in extended ISO 8601 format, when the configuration for the recommender model was last modified.
     * </p>
     * 
     * @return The date, in extended ISO 8601 format, when the configuration for the recommender model was last
     *         modified.
     */
    public final String lastModifiedDate() {
        return lastModifiedDate;
    }

    /**
     * <p>
     * The custom name of the configuration for the recommender model.
     * </p>
     * 
     * @return The custom name of the configuration for the recommender model.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The type of Amazon Pinpoint ID that's associated with unique user IDs in the recommender model. This value
     * enables the model to use attribute and event data that’s specific to a particular endpoint or user in an Amazon
     * Pinpoint application. Possible values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * PINPOINT_ENDPOINT_ID - Each user in the model is associated with a particular endpoint in Amazon Pinpoint. The
     * data is correlated based on endpoint IDs in Amazon Pinpoint. This is the default value.
     * </p>
     * </li>
     * <li>
     * <p>
     * PINPOINT_USER_ID - Each user in the model is associated with a particular user and endpoint in Amazon Pinpoint.
     * The data is correlated based on user IDs in Amazon Pinpoint. If this value is specified, an endpoint definition
     * in Amazon Pinpoint has to specify both a user ID (UserId) and an endpoint ID. Otherwise, messages won’t be sent
     * to the user's endpoint.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The type of Amazon Pinpoint ID that's associated with unique user IDs in the recommender model. This
     *         value enables the model to use attribute and event data that’s specific to a particular endpoint or user
     *         in an Amazon Pinpoint application. Possible values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         PINPOINT_ENDPOINT_ID - Each user in the model is associated with a particular endpoint in Amazon
     *         Pinpoint. The data is correlated based on endpoint IDs in Amazon Pinpoint. This is the default value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PINPOINT_USER_ID - Each user in the model is associated with a particular user and endpoint in Amazon
     *         Pinpoint. The data is correlated based on user IDs in Amazon Pinpoint. If this value is specified, an
     *         endpoint definition in Amazon Pinpoint has to specify both a user ID (UserId) and an endpoint ID.
     *         Otherwise, messages won’t be sent to the user's endpoint.
     *         </p>
     *         </li>
     */
    public final String recommendationProviderIdType() {
        return recommendationProviderIdType;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that authorizes Amazon
     * Pinpoint to retrieve recommendation data from the recommender model.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that authorizes
     *         Amazon Pinpoint to retrieve recommendation data from the recommender model.
     */
    public final String recommendationProviderRoleArn() {
        return recommendationProviderRoleArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the recommender model that Amazon Pinpoint retrieves the recommendation data
     * from. This value is the ARN of an Amazon Personalize campaign.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the recommender model that Amazon Pinpoint retrieves the recommendation
     *         data from. This value is the ARN of an Amazon Personalize campaign.
     */
    public final String recommendationProviderUri() {
        return recommendationProviderUri;
    }

    /**
     * <p>
     * The name or Amazon Resource Name (ARN) of the AWS Lambda function that Amazon Pinpoint invokes to perform
     * additional processing of recommendation data that it retrieves from the recommender model.
     * </p>
     * 
     * @return The name or Amazon Resource Name (ARN) of the AWS Lambda function that Amazon Pinpoint invokes to perform
     *         additional processing of recommendation data that it retrieves from the recommender model.
     */
    public final String recommendationTransformerUri() {
        return recommendationTransformerUri;
    }

    /**
     * <p>
     * The custom display name for the standard endpoint or user attribute (RecommendationItems) that temporarily stores
     * recommended items for each endpoint or user, depending on the value for the RecommendationProviderIdType
     * property. This name appears in the <b>Attribute finder</b> of the template editor on the Amazon Pinpoint console.
     * </p>
     * <p>
     * This value is null if the configuration doesn't invoke an AWS Lambda function (RecommendationTransformerUri) to
     * perform additional processing of recommendation data.
     * </p>
     * 
     * @return The custom display name for the standard endpoint or user attribute (RecommendationItems) that
     *         temporarily stores recommended items for each endpoint or user, depending on the value for the
     *         RecommendationProviderIdType property. This name appears in the <b>Attribute finder</b> of the template
     *         editor on the Amazon Pinpoint console.</p>
     *         <p>
     *         This value is null if the configuration doesn't invoke an AWS Lambda function
     *         (RecommendationTransformerUri) to perform additional processing of recommendation data.
     */
    public final String recommendationsDisplayName() {
        return recommendationsDisplayName;
    }

    /**
     * <p>
     * The number of recommended items that are retrieved from the model for each endpoint or user, depending on the
     * value for the RecommendationProviderIdType property. This number determines how many recommended items are
     * available for use in message variables.
     * </p>
     * 
     * @return The number of recommended items that are retrieved from the model for each endpoint or user, depending on
     *         the value for the RecommendationProviderIdType property. This number determines how many recommended
     *         items are available for use in message variables.
     */
    public final Integer recommendationsPerMessage() {
        return recommendationsPerMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributes() ? attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(recommendationProviderIdType());
        hashCode = 31 * hashCode + Objects.hashCode(recommendationProviderRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(recommendationProviderUri());
        hashCode = 31 * hashCode + Objects.hashCode(recommendationTransformerUri());
        hashCode = 31 * hashCode + Objects.hashCode(recommendationsDisplayName());
        hashCode = 31 * hashCode + Objects.hashCode(recommendationsPerMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecommenderConfigurationResponse)) {
            return false;
        }
        RecommenderConfigurationResponse other = (RecommenderConfigurationResponse) obj;
        return hasAttributes() == other.hasAttributes() && Objects.equals(attributes(), other.attributes())
                && Objects.equals(creationDate(), other.creationDate()) && Objects.equals(description(), other.description())
                && Objects.equals(id(), other.id()) && Objects.equals(lastModifiedDate(), other.lastModifiedDate())
                && Objects.equals(name(), other.name())
                && Objects.equals(recommendationProviderIdType(), other.recommendationProviderIdType())
                && Objects.equals(recommendationProviderRoleArn(), other.recommendationProviderRoleArn())
                && Objects.equals(recommendationProviderUri(), other.recommendationProviderUri())
                && Objects.equals(recommendationTransformerUri(), other.recommendationTransformerUri())
                && Objects.equals(recommendationsDisplayName(), other.recommendationsDisplayName())
                && Objects.equals(recommendationsPerMessage(), other.recommendationsPerMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RecommenderConfigurationResponse").add("Attributes", hasAttributes() ? attributes() : null)
                .add("CreationDate", creationDate()).add("Description", description()).add("Id", id())
                .add("LastModifiedDate", lastModifiedDate()).add("Name", name())
                .add("RecommendationProviderIdType", recommendationProviderIdType())
                .add("RecommendationProviderRoleArn", recommendationProviderRoleArn())
                .add("RecommendationProviderUri", recommendationProviderUri())
                .add("RecommendationTransformerUri", recommendationTransformerUri())
                .add("RecommendationsDisplayName", recommendationsDisplayName())
                .add("RecommendationsPerMessage", recommendationsPerMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        case "CreationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "LastModifiedDate":
            return Optional.ofNullable(clazz.cast(lastModifiedDate()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "RecommendationProviderIdType":
            return Optional.ofNullable(clazz.cast(recommendationProviderIdType()));
        case "RecommendationProviderRoleArn":
            return Optional.ofNullable(clazz.cast(recommendationProviderRoleArn()));
        case "RecommendationProviderUri":
            return Optional.ofNullable(clazz.cast(recommendationProviderUri()));
        case "RecommendationTransformerUri":
            return Optional.ofNullable(clazz.cast(recommendationTransformerUri()));
        case "RecommendationsDisplayName":
            return Optional.ofNullable(clazz.cast(recommendationsDisplayName()));
        case "RecommendationsPerMessage":
            return Optional.ofNullable(clazz.cast(recommendationsPerMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecommenderConfigurationResponse, T> g) {
        return obj -> g.apply((RecommenderConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecommenderConfigurationResponse> {
        /**
         * <p>
         * A map that defines 1-10 custom endpoint or user attributes, depending on the value for the
         * RecommendationProviderIdType property. Each of these attributes temporarily stores a recommended item that's
         * retrieved from the recommender model and sent to an AWS Lambda function for additional processing. Each
         * attribute can be used as a message variable in a message template.
         * </p>
         * <p>
         * This value is null if the configuration doesn't invoke an AWS Lambda function (RecommendationTransformerUri)
         * to perform additional processing of recommendation data.
         * </p>
         * 
         * @param attributes
         *        A map that defines 1-10 custom endpoint or user attributes, depending on the value for the
         *        RecommendationProviderIdType property. Each of these attributes temporarily stores a recommended item
         *        that's retrieved from the recommender model and sent to an AWS Lambda function for additional
         *        processing. Each attribute can be used as a message variable in a message template.</p>
         *        <p>
         *        This value is null if the configuration doesn't invoke an AWS Lambda function
         *        (RecommendationTransformerUri) to perform additional processing of recommendation data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<String, String> attributes);

        /**
         * <p>
         * The date, in extended ISO 8601 format, when the configuration was created for the recommender model.
         * </p>
         * 
         * @param creationDate
         *        The date, in extended ISO 8601 format, when the configuration was created for the recommender model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(String creationDate);

        /**
         * <p>
         * The custom description of the configuration for the recommender model.
         * </p>
         * 
         * @param description
         *        The custom description of the configuration for the recommender model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The unique identifier for the recommender model configuration.
         * </p>
         * 
         * @param id
         *        The unique identifier for the recommender model configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The date, in extended ISO 8601 format, when the configuration for the recommender model was last modified.
         * </p>
         * 
         * @param lastModifiedDate
         *        The date, in extended ISO 8601 format, when the configuration for the recommender model was last
         *        modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(String lastModifiedDate);

        /**
         * <p>
         * The custom name of the configuration for the recommender model.
         * </p>
         * 
         * @param name
         *        The custom name of the configuration for the recommender model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The type of Amazon Pinpoint ID that's associated with unique user IDs in the recommender model. This value
         * enables the model to use attribute and event data that’s specific to a particular endpoint or user in an
         * Amazon Pinpoint application. Possible values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * PINPOINT_ENDPOINT_ID - Each user in the model is associated with a particular endpoint in Amazon Pinpoint.
         * The data is correlated based on endpoint IDs in Amazon Pinpoint. This is the default value.
         * </p>
         * </li>
         * <li>
         * <p>
         * PINPOINT_USER_ID - Each user in the model is associated with a particular user and endpoint in Amazon
         * Pinpoint. The data is correlated based on user IDs in Amazon Pinpoint. If this value is specified, an
         * endpoint definition in Amazon Pinpoint has to specify both a user ID (UserId) and an endpoint ID. Otherwise,
         * messages won’t be sent to the user's endpoint.
         * </p>
         * </li>
         * </ul>
         * 
         * @param recommendationProviderIdType
         *        The type of Amazon Pinpoint ID that's associated with unique user IDs in the recommender model. This
         *        value enables the model to use attribute and event data that’s specific to a particular endpoint or
         *        user in an Amazon Pinpoint application. Possible values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        PINPOINT_ENDPOINT_ID - Each user in the model is associated with a particular endpoint in Amazon
         *        Pinpoint. The data is correlated based on endpoint IDs in Amazon Pinpoint. This is the default value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PINPOINT_USER_ID - Each user in the model is associated with a particular user and endpoint in Amazon
         *        Pinpoint. The data is correlated based on user IDs in Amazon Pinpoint. If this value is specified, an
         *        endpoint definition in Amazon Pinpoint has to specify both a user ID (UserId) and an endpoint ID.
         *        Otherwise, messages won’t be sent to the user's endpoint.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationProviderIdType(String recommendationProviderIdType);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that authorizes Amazon
         * Pinpoint to retrieve recommendation data from the recommender model.
         * </p>
         * 
         * @param recommendationProviderRoleArn
         *        The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that authorizes
         *        Amazon Pinpoint to retrieve recommendation data from the recommender model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationProviderRoleArn(String recommendationProviderRoleArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the recommender model that Amazon Pinpoint retrieves the recommendation
         * data from. This value is the ARN of an Amazon Personalize campaign.
         * </p>
         * 
         * @param recommendationProviderUri
         *        The Amazon Resource Name (ARN) of the recommender model that Amazon Pinpoint retrieves the
         *        recommendation data from. This value is the ARN of an Amazon Personalize campaign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationProviderUri(String recommendationProviderUri);

        /**
         * <p>
         * The name or Amazon Resource Name (ARN) of the AWS Lambda function that Amazon Pinpoint invokes to perform
         * additional processing of recommendation data that it retrieves from the recommender model.
         * </p>
         * 
         * @param recommendationTransformerUri
         *        The name or Amazon Resource Name (ARN) of the AWS Lambda function that Amazon Pinpoint invokes to
         *        perform additional processing of recommendation data that it retrieves from the recommender model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationTransformerUri(String recommendationTransformerUri);

        /**
         * <p>
         * The custom display name for the standard endpoint or user attribute (RecommendationItems) that temporarily
         * stores recommended items for each endpoint or user, depending on the value for the
         * RecommendationProviderIdType property. This name appears in the <b>Attribute finder</b> of the template
         * editor on the Amazon Pinpoint console.
         * </p>
         * <p>
         * This value is null if the configuration doesn't invoke an AWS Lambda function (RecommendationTransformerUri)
         * to perform additional processing of recommendation data.
         * </p>
         * 
         * @param recommendationsDisplayName
         *        The custom display name for the standard endpoint or user attribute (RecommendationItems) that
         *        temporarily stores recommended items for each endpoint or user, depending on the value for the
         *        RecommendationProviderIdType property. This name appears in the <b>Attribute finder</b> of the
         *        template editor on the Amazon Pinpoint console.</p>
         *        <p>
         *        This value is null if the configuration doesn't invoke an AWS Lambda function
         *        (RecommendationTransformerUri) to perform additional processing of recommendation data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationsDisplayName(String recommendationsDisplayName);

        /**
         * <p>
         * The number of recommended items that are retrieved from the model for each endpoint or user, depending on the
         * value for the RecommendationProviderIdType property. This number determines how many recommended items are
         * available for use in message variables.
         * </p>
         * 
         * @param recommendationsPerMessage
         *        The number of recommended items that are retrieved from the model for each endpoint or user, depending
         *        on the value for the RecommendationProviderIdType property. This number determines how many
         *        recommended items are available for use in message variables.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationsPerMessage(Integer recommendationsPerMessage);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();

        private String creationDate;

        private String description;

        private String id;

        private String lastModifiedDate;

        private String name;

        private String recommendationProviderIdType;

        private String recommendationProviderRoleArn;

        private String recommendationProviderUri;

        private String recommendationTransformerUri;

        private String recommendationsDisplayName;

        private Integer recommendationsPerMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(RecommenderConfigurationResponse model) {
            attributes(model.attributes);
            creationDate(model.creationDate);
            description(model.description);
            id(model.id);
            lastModifiedDate(model.lastModifiedDate);
            name(model.name);
            recommendationProviderIdType(model.recommendationProviderIdType);
            recommendationProviderRoleArn(model.recommendationProviderRoleArn);
            recommendationProviderUri(model.recommendationProviderUri);
            recommendationTransformerUri(model.recommendationTransformerUri);
            recommendationsDisplayName(model.recommendationsDisplayName);
            recommendationsPerMessage(model.recommendationsPerMessage);
        }

        public final Map<String, String> getAttributes() {
            if (attributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return attributes;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = MapOf__stringCopier.copy(attributes);
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = MapOf__stringCopier.copy(attributes);
            return this;
        }

        public final String getCreationDate() {
            return creationDate;
        }

        public final void setCreationDate(String creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(String creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getLastModifiedDate() {
            return lastModifiedDate;
        }

        public final void setLastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRecommendationProviderIdType() {
            return recommendationProviderIdType;
        }

        public final void setRecommendationProviderIdType(String recommendationProviderIdType) {
            this.recommendationProviderIdType = recommendationProviderIdType;
        }

        @Override
        public final Builder recommendationProviderIdType(String recommendationProviderIdType) {
            this.recommendationProviderIdType = recommendationProviderIdType;
            return this;
        }

        public final String getRecommendationProviderRoleArn() {
            return recommendationProviderRoleArn;
        }

        public final void setRecommendationProviderRoleArn(String recommendationProviderRoleArn) {
            this.recommendationProviderRoleArn = recommendationProviderRoleArn;
        }

        @Override
        public final Builder recommendationProviderRoleArn(String recommendationProviderRoleArn) {
            this.recommendationProviderRoleArn = recommendationProviderRoleArn;
            return this;
        }

        public final String getRecommendationProviderUri() {
            return recommendationProviderUri;
        }

        public final void setRecommendationProviderUri(String recommendationProviderUri) {
            this.recommendationProviderUri = recommendationProviderUri;
        }

        @Override
        public final Builder recommendationProviderUri(String recommendationProviderUri) {
            this.recommendationProviderUri = recommendationProviderUri;
            return this;
        }

        public final String getRecommendationTransformerUri() {
            return recommendationTransformerUri;
        }

        public final void setRecommendationTransformerUri(String recommendationTransformerUri) {
            this.recommendationTransformerUri = recommendationTransformerUri;
        }

        @Override
        public final Builder recommendationTransformerUri(String recommendationTransformerUri) {
            this.recommendationTransformerUri = recommendationTransformerUri;
            return this;
        }

        public final String getRecommendationsDisplayName() {
            return recommendationsDisplayName;
        }

        public final void setRecommendationsDisplayName(String recommendationsDisplayName) {
            this.recommendationsDisplayName = recommendationsDisplayName;
        }

        @Override
        public final Builder recommendationsDisplayName(String recommendationsDisplayName) {
            this.recommendationsDisplayName = recommendationsDisplayName;
            return this;
        }

        public final Integer getRecommendationsPerMessage() {
            return recommendationsPerMessage;
        }

        public final void setRecommendationsPerMessage(Integer recommendationsPerMessage) {
            this.recommendationsPerMessage = recommendationsPerMessage;
        }

        @Override
        public final Builder recommendationsPerMessage(Integer recommendationsPerMessage) {
            this.recommendationsPerMessage = recommendationsPerMessage;
            return this;
        }

        @Override
        public RecommenderConfigurationResponse build() {
            return new RecommenderConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
