/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSegmentResponse extends PinpointResponse implements
        ToCopyableBuilder<GetSegmentResponse.Builder, GetSegmentResponse> {
    private static final SdkField<SegmentResponse> SEGMENT_RESPONSE_FIELD = SdkField
            .<SegmentResponse> builder(MarshallingType.SDK_POJO)
            .memberName("SegmentResponse")
            .getter(getter(GetSegmentResponse::segmentResponse))
            .setter(setter(Builder::segmentResponse))
            .constructor(SegmentResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentResponse").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEGMENT_RESPONSE_FIELD));

    private final SegmentResponse segmentResponse;

    private GetSegmentResponse(BuilderImpl builder) {
        super(builder);
        this.segmentResponse = builder.segmentResponse;
    }

    /**
     * Returns the value of the SegmentResponse property for this object.
     * 
     * @return The value of the SegmentResponse property for this object.
     */
    public final SegmentResponse segmentResponse() {
        return segmentResponse;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(segmentResponse());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSegmentResponse)) {
            return false;
        }
        GetSegmentResponse other = (GetSegmentResponse) obj;
        return Objects.equals(segmentResponse(), other.segmentResponse());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSegmentResponse").add("SegmentResponse", segmentResponse()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SegmentResponse":
            return Optional.ofNullable(clazz.cast(segmentResponse()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSegmentResponse, T> g) {
        return obj -> g.apply((GetSegmentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetSegmentResponse> {
        /**
         * Sets the value of the SegmentResponse property for this object.
         *
         * @param segmentResponse
         *        The new value for the SegmentResponse property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentResponse(SegmentResponse segmentResponse);

        /**
         * Sets the value of the SegmentResponse property for this object.
         *
         * This is a convenience method that creates an instance of the {@link SegmentResponse.Builder} avoiding the
         * need to create one manually via {@link SegmentResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SegmentResponse.Builder#build()} is called immediately and its
         * result is passed to {@link #segmentResponse(SegmentResponse)}.
         * 
         * @param segmentResponse
         *        a consumer that will call methods on {@link SegmentResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #segmentResponse(SegmentResponse)
         */
        default Builder segmentResponse(Consumer<SegmentResponse.Builder> segmentResponse) {
            return segmentResponse(SegmentResponse.builder().applyMutation(segmentResponse).build());
        }
    }

    static final class BuilderImpl extends PinpointResponse.BuilderImpl implements Builder {
        private SegmentResponse segmentResponse;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSegmentResponse model) {
            super(model);
            segmentResponse(model.segmentResponse);
        }

        public final SegmentResponse.Builder getSegmentResponse() {
            return segmentResponse != null ? segmentResponse.toBuilder() : null;
        }

        public final void setSegmentResponse(SegmentResponse.BuilderImpl segmentResponse) {
            this.segmentResponse = segmentResponse != null ? segmentResponse.build() : null;
        }

        @Override
        public final Builder segmentResponse(SegmentResponse segmentResponse) {
            this.segmentResponse = segmentResponse;
            return this;
        }

        @Override
        public GetSegmentResponse build() {
            return new GetSegmentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
