/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Text config for Message Header.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InAppMessageHeaderConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<InAppMessageHeaderConfig.Builder, InAppMessageHeaderConfig> {
    private static final SdkField<String> ALIGNMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Alignment").getter(getter(InAppMessageHeaderConfig::alignmentAsString))
            .setter(setter(Builder::alignment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Alignment").build()).build();

    private static final SdkField<String> HEADER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Header")
            .getter(getter(InAppMessageHeaderConfig::header)).setter(setter(Builder::header))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Header").build()).build();

    private static final SdkField<String> TEXT_COLOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TextColor").getter(getter(InAppMessageHeaderConfig::textColor)).setter(setter(Builder::textColor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextColor").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALIGNMENT_FIELD, HEADER_FIELD,
            TEXT_COLOR_FIELD));

    private static final long serialVersionUID = 1L;

    private final String alignment;

    private final String header;

    private final String textColor;

    private InAppMessageHeaderConfig(BuilderImpl builder) {
        this.alignment = builder.alignment;
        this.header = builder.header;
        this.textColor = builder.textColor;
    }

    /**
     * <p>
     * The alignment of the text. Valid values: LEFT, CENTER, RIGHT.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #alignment} will
     * return {@link Alignment#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #alignmentAsString}.
     * </p>
     * 
     * @return The alignment of the text. Valid values: LEFT, CENTER, RIGHT.
     * @see Alignment
     */
    public final Alignment alignment() {
        return Alignment.fromValue(alignment);
    }

    /**
     * <p>
     * The alignment of the text. Valid values: LEFT, CENTER, RIGHT.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #alignment} will
     * return {@link Alignment#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #alignmentAsString}.
     * </p>
     * 
     * @return The alignment of the text. Valid values: LEFT, CENTER, RIGHT.
     * @see Alignment
     */
    public final String alignmentAsString() {
        return alignment;
    }

    /**
     * <p>
     * Message Header.
     * </p>
     * 
     * @return Message Header.
     */
    public final String header() {
        return header;
    }

    /**
     * <p>
     * The text color.
     * </p>
     * 
     * @return The text color.
     */
    public final String textColor() {
        return textColor;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(alignmentAsString());
        hashCode = 31 * hashCode + Objects.hashCode(header());
        hashCode = 31 * hashCode + Objects.hashCode(textColor());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InAppMessageHeaderConfig)) {
            return false;
        }
        InAppMessageHeaderConfig other = (InAppMessageHeaderConfig) obj;
        return Objects.equals(alignmentAsString(), other.alignmentAsString()) && Objects.equals(header(), other.header())
                && Objects.equals(textColor(), other.textColor());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InAppMessageHeaderConfig").add("Alignment", alignmentAsString()).add("Header", header())
                .add("TextColor", textColor()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Alignment":
            return Optional.ofNullable(clazz.cast(alignmentAsString()));
        case "Header":
            return Optional.ofNullable(clazz.cast(header()));
        case "TextColor":
            return Optional.ofNullable(clazz.cast(textColor()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InAppMessageHeaderConfig, T> g) {
        return obj -> g.apply((InAppMessageHeaderConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InAppMessageHeaderConfig> {
        /**
         * <p>
         * The alignment of the text. Valid values: LEFT, CENTER, RIGHT.
         * </p>
         * 
         * @param alignment
         *        The alignment of the text. Valid values: LEFT, CENTER, RIGHT.
         * @see Alignment
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Alignment
         */
        Builder alignment(String alignment);

        /**
         * <p>
         * The alignment of the text. Valid values: LEFT, CENTER, RIGHT.
         * </p>
         * 
         * @param alignment
         *        The alignment of the text. Valid values: LEFT, CENTER, RIGHT.
         * @see Alignment
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Alignment
         */
        Builder alignment(Alignment alignment);

        /**
         * <p>
         * Message Header.
         * </p>
         * 
         * @param header
         *        Message Header.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder header(String header);

        /**
         * <p>
         * The text color.
         * </p>
         * 
         * @param textColor
         *        The text color.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textColor(String textColor);
    }

    static final class BuilderImpl implements Builder {
        private String alignment;

        private String header;

        private String textColor;

        private BuilderImpl() {
        }

        private BuilderImpl(InAppMessageHeaderConfig model) {
            alignment(model.alignment);
            header(model.header);
            textColor(model.textColor);
        }

        public final String getAlignment() {
            return alignment;
        }

        public final void setAlignment(String alignment) {
            this.alignment = alignment;
        }

        @Override
        public final Builder alignment(String alignment) {
            this.alignment = alignment;
            return this;
        }

        @Override
        public final Builder alignment(Alignment alignment) {
            this.alignment(alignment == null ? null : alignment.toString());
            return this;
        }

        public final String getHeader() {
            return header;
        }

        public final void setHeader(String header) {
            this.header = header;
        }

        @Override
        public final Builder header(String header) {
            this.header = header;
            return this;
        }

        public final String getTextColor() {
            return textColor;
        }

        public final void setTextColor(String textColor) {
            this.textColor = textColor;
        }

        @Override
        public final Builder textColor(String textColor) {
            this.textColor = textColor;
            return this;
        }

        @Override
        public InAppMessageHeaderConfig build() {
            return new InAppMessageHeaderConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
