/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pinpoint.model.ListOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateAttributesRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UpdateAttributesRequest> {
    private static final SdkField<List<String>> BLACKLIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Blacklist").getter(UpdateAttributesRequest.getter(UpdateAttributesRequest::blacklist)).setter(UpdateAttributesRequest.setter(Builder::blacklist)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Blacklist").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLACKLIST_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> blacklist;

    private UpdateAttributesRequest(BuilderImpl builder) {
        this.blacklist = builder.blacklist;
    }

    public final boolean hasBlacklist() {
        return this.blacklist != null && !(this.blacklist instanceof SdkAutoConstructList);
    }

    public final List<String> blacklist() {
        return this.blacklist;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBlacklist() ? this.blacklist() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAttributesRequest)) {
            return false;
        }
        UpdateAttributesRequest other = (UpdateAttributesRequest)obj;
        return this.hasBlacklist() == other.hasBlacklist() && Objects.equals(this.blacklist(), other.blacklist());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateAttributesRequest").add("Blacklist", this.hasBlacklist() ? this.blacklist() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Blacklist": {
                return Optional.ofNullable(clazz.cast(this.blacklist()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAttributesRequest, T> g) {
        return obj -> g.apply((UpdateAttributesRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> blacklist = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAttributesRequest model) {
            this.blacklist(model.blacklist);
        }

        public final Collection<String> getBlacklist() {
            if (this.blacklist instanceof SdkAutoConstructList) {
                return null;
            }
            return this.blacklist;
        }

        public final void setBlacklist(Collection<String> blacklist) {
            this.blacklist = ListOf__stringCopier.copy(blacklist);
        }

        @Override
        @Transient
        public final Builder blacklist(Collection<String> blacklist) {
            this.blacklist = ListOf__stringCopier.copy(blacklist);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder blacklist(String ... blacklist) {
            this.blacklist(Arrays.asList(blacklist));
            return this;
        }

        public UpdateAttributesRequest build() {
            return new UpdateAttributesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UpdateAttributesRequest> {
        public Builder blacklist(Collection<String> var1);

        public Builder blacklist(String ... var1);
    }
}

