/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListJourneysResponse extends PinpointResponse implements
        ToCopyableBuilder<ListJourneysResponse.Builder, ListJourneysResponse> {
    private static final SdkField<JourneysResponse> JOURNEYS_RESPONSE_FIELD = SdkField
            .<JourneysResponse> builder(MarshallingType.SDK_POJO)
            .memberName("JourneysResponse")
            .getter(getter(ListJourneysResponse::journeysResponse))
            .setter(setter(Builder::journeysResponse))
            .constructor(JourneysResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JourneysResponse").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOURNEYS_RESPONSE_FIELD));

    private final JourneysResponse journeysResponse;

    private ListJourneysResponse(BuilderImpl builder) {
        super(builder);
        this.journeysResponse = builder.journeysResponse;
    }

    /**
     * Returns the value of the JourneysResponse property for this object.
     * 
     * @return The value of the JourneysResponse property for this object.
     */
    public final JourneysResponse journeysResponse() {
        return journeysResponse;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(journeysResponse());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListJourneysResponse)) {
            return false;
        }
        ListJourneysResponse other = (ListJourneysResponse) obj;
        return Objects.equals(journeysResponse(), other.journeysResponse());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListJourneysResponse").add("JourneysResponse", journeysResponse()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JourneysResponse":
            return Optional.ofNullable(clazz.cast(journeysResponse()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListJourneysResponse, T> g) {
        return obj -> g.apply((ListJourneysResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListJourneysResponse> {
        /**
         * Sets the value of the JourneysResponse property for this object.
         *
         * @param journeysResponse
         *        The new value for the JourneysResponse property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder journeysResponse(JourneysResponse journeysResponse);

        /**
         * Sets the value of the JourneysResponse property for this object.
         *
         * This is a convenience that creates an instance of the {@link JourneysResponse.Builder} avoiding the need to
         * create one manually via {@link JourneysResponse#builder()}.
         *
         * When the {@link Consumer} completes, {@link JourneysResponse.Builder#build()} is called immediately and its
         * result is passed to {@link #journeysResponse(JourneysResponse)}.
         * 
         * @param journeysResponse
         *        a consumer that will call methods on {@link JourneysResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #journeysResponse(JourneysResponse)
         */
        default Builder journeysResponse(Consumer<JourneysResponse.Builder> journeysResponse) {
            return journeysResponse(JourneysResponse.builder().applyMutation(journeysResponse).build());
        }
    }

    static final class BuilderImpl extends PinpointResponse.BuilderImpl implements Builder {
        private JourneysResponse journeysResponse;

        private BuilderImpl() {
        }

        private BuilderImpl(ListJourneysResponse model) {
            super(model);
            journeysResponse(model.journeysResponse);
        }

        public final JourneysResponse.Builder getJourneysResponse() {
            return journeysResponse != null ? journeysResponse.toBuilder() : null;
        }

        public final void setJourneysResponse(JourneysResponse.BuilderImpl journeysResponse) {
            this.journeysResponse = journeysResponse != null ? journeysResponse.build() : null;
        }

        @Override
        @Transient
        public final Builder journeysResponse(JourneysResponse journeysResponse) {
            this.journeysResponse = journeysResponse;
            return this;
        }

        @Override
        public ListJourneysResponse build() {
            return new ListJourneysResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
