/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the content and settings for a message template that can be used in messages that are sent through a push
 * notification channel.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PushNotificationTemplateRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<PushNotificationTemplateRequest.Builder, PushNotificationTemplateRequest> {
    private static final SdkField<AndroidPushNotificationTemplate> ADM_FIELD = SdkField
            .<AndroidPushNotificationTemplate> builder(MarshallingType.SDK_POJO).memberName("ADM")
            .getter(getter(PushNotificationTemplateRequest::adm)).setter(setter(Builder::adm))
            .constructor(AndroidPushNotificationTemplate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ADM").build()).build();

    private static final SdkField<APNSPushNotificationTemplate> APNS_FIELD = SdkField
            .<APNSPushNotificationTemplate> builder(MarshallingType.SDK_POJO).memberName("APNS")
            .getter(getter(PushNotificationTemplateRequest::apns)).setter(setter(Builder::apns))
            .constructor(APNSPushNotificationTemplate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("APNS").build()).build();

    private static final SdkField<AndroidPushNotificationTemplate> BAIDU_FIELD = SdkField
            .<AndroidPushNotificationTemplate> builder(MarshallingType.SDK_POJO).memberName("Baidu")
            .getter(getter(PushNotificationTemplateRequest::baidu)).setter(setter(Builder::baidu))
            .constructor(AndroidPushNotificationTemplate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Baidu").build()).build();

    private static final SdkField<DefaultPushNotificationTemplate> DEFAULT_FIELD = SdkField
            .<DefaultPushNotificationTemplate> builder(MarshallingType.SDK_POJO).memberName("Default")
            .getter(getter(PushNotificationTemplateRequest::defaultValue)).setter(setter(Builder::defaultValue))
            .constructor(DefaultPushNotificationTemplate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Default").build()).build();

    private static final SdkField<String> DEFAULT_SUBSTITUTIONS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefaultSubstitutions").getter(getter(PushNotificationTemplateRequest::defaultSubstitutions))
            .setter(setter(Builder::defaultSubstitutions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultSubstitutions").build())
            .build();

    private static final SdkField<AndroidPushNotificationTemplate> GCM_FIELD = SdkField
            .<AndroidPushNotificationTemplate> builder(MarshallingType.SDK_POJO).memberName("GCM")
            .getter(getter(PushNotificationTemplateRequest::gcm)).setter(setter(Builder::gcm))
            .constructor(AndroidPushNotificationTemplate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GCM").build()).build();

    private static final SdkField<String> RECOMMENDER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecommenderId").getter(getter(PushNotificationTemplateRequest::recommenderId))
            .setter(setter(Builder::recommenderId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommenderId").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(PushNotificationTemplateRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> TEMPLATE_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateDescription").getter(getter(PushNotificationTemplateRequest::templateDescription))
            .setter(setter(Builder::templateDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateDescription").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADM_FIELD, APNS_FIELD,
            BAIDU_FIELD, DEFAULT_FIELD, DEFAULT_SUBSTITUTIONS_FIELD, GCM_FIELD, RECOMMENDER_ID_FIELD, TAGS_FIELD,
            TEMPLATE_DESCRIPTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final AndroidPushNotificationTemplate adm;

    private final APNSPushNotificationTemplate apns;

    private final AndroidPushNotificationTemplate baidu;

    private final DefaultPushNotificationTemplate defaultValue;

    private final String defaultSubstitutions;

    private final AndroidPushNotificationTemplate gcm;

    private final String recommenderId;

    private final Map<String, String> tags;

    private final String templateDescription;

    private PushNotificationTemplateRequest(BuilderImpl builder) {
        this.adm = builder.adm;
        this.apns = builder.apns;
        this.baidu = builder.baidu;
        this.defaultValue = builder.defaultValue;
        this.defaultSubstitutions = builder.defaultSubstitutions;
        this.gcm = builder.gcm;
        this.recommenderId = builder.recommenderId;
        this.tags = builder.tags;
        this.templateDescription = builder.templateDescription;
    }

    /**
     * <p>
     * The message template to use for the ADM (Amazon Device Messaging) channel. This message template overrides the
     * default template for push notification channels (DefaultPushNotificationTemplate).
     * </p>
     * 
     * @return The message template to use for the ADM (Amazon Device Messaging) channel. This message template
     *         overrides the default template for push notification channels (DefaultPushNotificationTemplate).
     */
    public final AndroidPushNotificationTemplate adm() {
        return adm;
    }

    /**
     * <p>
     * The message template to use for the APNs (Apple Push Notification service) channel. This message template
     * overrides the default template for push notification channels (DefaultPushNotificationTemplate).
     * </p>
     * 
     * @return The message template to use for the APNs (Apple Push Notification service) channel. This message template
     *         overrides the default template for push notification channels (DefaultPushNotificationTemplate).
     */
    public final APNSPushNotificationTemplate apns() {
        return apns;
    }

    /**
     * <p>
     * The message template to use for the Baidu (Baidu Cloud Push) channel. This message template overrides the default
     * template for push notification channels (DefaultPushNotificationTemplate).
     * </p>
     * 
     * @return The message template to use for the Baidu (Baidu Cloud Push) channel. This message template overrides the
     *         default template for push notification channels (DefaultPushNotificationTemplate).
     */
    public final AndroidPushNotificationTemplate baidu() {
        return baidu;
    }

    /**
     * <p>
     * The default message template to use for push notification channels.
     * </p>
     * 
     * @return The default message template to use for push notification channels.
     */
    public final DefaultPushNotificationTemplate defaultValue() {
        return defaultValue;
    }

    /**
     * <p>
     * A JSON object that specifies the default values to use for message variables in the message template. This object
     * is a set of key-value pairs. Each key defines a message variable in the template. The corresponding value defines
     * the default value for that variable. When you create a message that's based on the template, you can override
     * these defaults with message-specific and address-specific variables and values.
     * </p>
     * 
     * @return A JSON object that specifies the default values to use for message variables in the message template.
     *         This object is a set of key-value pairs. Each key defines a message variable in the template. The
     *         corresponding value defines the default value for that variable. When you create a message that's based
     *         on the template, you can override these defaults with message-specific and address-specific variables and
     *         values.
     */
    public final String defaultSubstitutions() {
        return defaultSubstitutions;
    }

    /**
     * <p>
     * The message template to use for the GCM channel, which is used to send notifications through the Firebase Cloud
     * Messaging (FCM), formerly Google Cloud Messaging (GCM), service. This message template overrides the default
     * template for push notification channels (DefaultPushNotificationTemplate).
     * </p>
     * 
     * @return The message template to use for the GCM channel, which is used to send notifications through the Firebase
     *         Cloud Messaging (FCM), formerly Google Cloud Messaging (GCM), service. This message template overrides
     *         the default template for push notification channels (DefaultPushNotificationTemplate).
     */
    public final AndroidPushNotificationTemplate gcm() {
        return gcm;
    }

    /**
     * <p>
     * The unique identifier for the recommender model to use for the message template. Amazon Pinpoint uses this value
     * to determine how to retrieve and process data from a recommender model when it sends messages that use the
     * template, if the template contains message variables for recommendation data.
     * </p>
     * 
     * @return The unique identifier for the recommender model to use for the message template. Amazon Pinpoint uses
     *         this value to determine how to retrieve and process data from a recommender model when it sends messages
     *         that use the template, if the template contains message variables for recommendation data.
     */
    public final String recommenderId() {
        return recommenderId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A string-to-string map of key-value pairs that defines the tags to associate with the message template. Each tag
     * consists of a required tag key and an associated tag value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A string-to-string map of key-value pairs that defines the tags to associate with the message template.
     *         Each tag consists of a required tag key and an associated tag value.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * A custom description of the message template.
     * </p>
     * 
     * @return A custom description of the message template.
     */
    public final String templateDescription() {
        return templateDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(adm());
        hashCode = 31 * hashCode + Objects.hashCode(apns());
        hashCode = 31 * hashCode + Objects.hashCode(baidu());
        hashCode = 31 * hashCode + Objects.hashCode(defaultValue());
        hashCode = 31 * hashCode + Objects.hashCode(defaultSubstitutions());
        hashCode = 31 * hashCode + Objects.hashCode(gcm());
        hashCode = 31 * hashCode + Objects.hashCode(recommenderId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(templateDescription());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PushNotificationTemplateRequest)) {
            return false;
        }
        PushNotificationTemplateRequest other = (PushNotificationTemplateRequest) obj;
        return Objects.equals(adm(), other.adm()) && Objects.equals(apns(), other.apns())
                && Objects.equals(baidu(), other.baidu()) && Objects.equals(defaultValue(), other.defaultValue())
                && Objects.equals(defaultSubstitutions(), other.defaultSubstitutions()) && Objects.equals(gcm(), other.gcm())
                && Objects.equals(recommenderId(), other.recommenderId()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(templateDescription(), other.templateDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PushNotificationTemplateRequest").add("ADM", adm()).add("APNS", apns()).add("Baidu", baidu())
                .add("Default", defaultValue()).add("DefaultSubstitutions", defaultSubstitutions()).add("GCM", gcm())
                .add("RecommenderId", recommenderId()).add("Tags", hasTags() ? tags() : null)
                .add("TemplateDescription", templateDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ADM":
            return Optional.ofNullable(clazz.cast(adm()));
        case "APNS":
            return Optional.ofNullable(clazz.cast(apns()));
        case "Baidu":
            return Optional.ofNullable(clazz.cast(baidu()));
        case "Default":
            return Optional.ofNullable(clazz.cast(defaultValue()));
        case "DefaultSubstitutions":
            return Optional.ofNullable(clazz.cast(defaultSubstitutions()));
        case "GCM":
            return Optional.ofNullable(clazz.cast(gcm()));
        case "RecommenderId":
            return Optional.ofNullable(clazz.cast(recommenderId()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "TemplateDescription":
            return Optional.ofNullable(clazz.cast(templateDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PushNotificationTemplateRequest, T> g) {
        return obj -> g.apply((PushNotificationTemplateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PushNotificationTemplateRequest> {
        /**
         * <p>
         * The message template to use for the ADM (Amazon Device Messaging) channel. This message template overrides
         * the default template for push notification channels (DefaultPushNotificationTemplate).
         * </p>
         * 
         * @param adm
         *        The message template to use for the ADM (Amazon Device Messaging) channel. This message template
         *        overrides the default template for push notification channels (DefaultPushNotificationTemplate).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adm(AndroidPushNotificationTemplate adm);

        /**
         * <p>
         * The message template to use for the ADM (Amazon Device Messaging) channel. This message template overrides
         * the default template for push notification channels (DefaultPushNotificationTemplate).
         * </p>
         * This is a convenience method that creates an instance of the {@link AndroidPushNotificationTemplate.Builder}
         * avoiding the need to create one manually via {@link AndroidPushNotificationTemplate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AndroidPushNotificationTemplate.Builder#build()} is called
         * immediately and its result is passed to {@link #adm(AndroidPushNotificationTemplate)}.
         * 
         * @param adm
         *        a consumer that will call methods on {@link AndroidPushNotificationTemplate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #adm(AndroidPushNotificationTemplate)
         */
        default Builder adm(Consumer<AndroidPushNotificationTemplate.Builder> adm) {
            return adm(AndroidPushNotificationTemplate.builder().applyMutation(adm).build());
        }

        /**
         * <p>
         * The message template to use for the APNs (Apple Push Notification service) channel. This message template
         * overrides the default template for push notification channels (DefaultPushNotificationTemplate).
         * </p>
         * 
         * @param apns
         *        The message template to use for the APNs (Apple Push Notification service) channel. This message
         *        template overrides the default template for push notification channels
         *        (DefaultPushNotificationTemplate).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apns(APNSPushNotificationTemplate apns);

        /**
         * <p>
         * The message template to use for the APNs (Apple Push Notification service) channel. This message template
         * overrides the default template for push notification channels (DefaultPushNotificationTemplate).
         * </p>
         * This is a convenience method that creates an instance of the {@link APNSPushNotificationTemplate.Builder}
         * avoiding the need to create one manually via {@link APNSPushNotificationTemplate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link APNSPushNotificationTemplate.Builder#build()} is called
         * immediately and its result is passed to {@link #apns(APNSPushNotificationTemplate)}.
         * 
         * @param apns
         *        a consumer that will call methods on {@link APNSPushNotificationTemplate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #apns(APNSPushNotificationTemplate)
         */
        default Builder apns(Consumer<APNSPushNotificationTemplate.Builder> apns) {
            return apns(APNSPushNotificationTemplate.builder().applyMutation(apns).build());
        }

        /**
         * <p>
         * The message template to use for the Baidu (Baidu Cloud Push) channel. This message template overrides the
         * default template for push notification channels (DefaultPushNotificationTemplate).
         * </p>
         * 
         * @param baidu
         *        The message template to use for the Baidu (Baidu Cloud Push) channel. This message template overrides
         *        the default template for push notification channels (DefaultPushNotificationTemplate).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baidu(AndroidPushNotificationTemplate baidu);

        /**
         * <p>
         * The message template to use for the Baidu (Baidu Cloud Push) channel. This message template overrides the
         * default template for push notification channels (DefaultPushNotificationTemplate).
         * </p>
         * This is a convenience method that creates an instance of the {@link AndroidPushNotificationTemplate.Builder}
         * avoiding the need to create one manually via {@link AndroidPushNotificationTemplate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AndroidPushNotificationTemplate.Builder#build()} is called
         * immediately and its result is passed to {@link #baidu(AndroidPushNotificationTemplate)}.
         * 
         * @param baidu
         *        a consumer that will call methods on {@link AndroidPushNotificationTemplate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #baidu(AndroidPushNotificationTemplate)
         */
        default Builder baidu(Consumer<AndroidPushNotificationTemplate.Builder> baidu) {
            return baidu(AndroidPushNotificationTemplate.builder().applyMutation(baidu).build());
        }

        /**
         * <p>
         * The default message template to use for push notification channels.
         * </p>
         * 
         * @param defaultValue
         *        The default message template to use for push notification channels.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultValue(DefaultPushNotificationTemplate defaultValue);

        /**
         * <p>
         * The default message template to use for push notification channels.
         * </p>
         * This is a convenience method that creates an instance of the {@link DefaultPushNotificationTemplate.Builder}
         * avoiding the need to create one manually via {@link DefaultPushNotificationTemplate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DefaultPushNotificationTemplate.Builder#build()} is called
         * immediately and its result is passed to {@link #defaultValue(DefaultPushNotificationTemplate)}.
         * 
         * @param defaultValue
         *        a consumer that will call methods on {@link DefaultPushNotificationTemplate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultValue(DefaultPushNotificationTemplate)
         */
        default Builder defaultValue(Consumer<DefaultPushNotificationTemplate.Builder> defaultValue) {
            return defaultValue(DefaultPushNotificationTemplate.builder().applyMutation(defaultValue).build());
        }

        /**
         * <p>
         * A JSON object that specifies the default values to use for message variables in the message template. This
         * object is a set of key-value pairs. Each key defines a message variable in the template. The corresponding
         * value defines the default value for that variable. When you create a message that's based on the template,
         * you can override these defaults with message-specific and address-specific variables and values.
         * </p>
         * 
         * @param defaultSubstitutions
         *        A JSON object that specifies the default values to use for message variables in the message template.
         *        This object is a set of key-value pairs. Each key defines a message variable in the template. The
         *        corresponding value defines the default value for that variable. When you create a message that's
         *        based on the template, you can override these defaults with message-specific and address-specific
         *        variables and values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultSubstitutions(String defaultSubstitutions);

        /**
         * <p>
         * The message template to use for the GCM channel, which is used to send notifications through the Firebase
         * Cloud Messaging (FCM), formerly Google Cloud Messaging (GCM), service. This message template overrides the
         * default template for push notification channels (DefaultPushNotificationTemplate).
         * </p>
         * 
         * @param gcm
         *        The message template to use for the GCM channel, which is used to send notifications through the
         *        Firebase Cloud Messaging (FCM), formerly Google Cloud Messaging (GCM), service. This message template
         *        overrides the default template for push notification channels (DefaultPushNotificationTemplate).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gcm(AndroidPushNotificationTemplate gcm);

        /**
         * <p>
         * The message template to use for the GCM channel, which is used to send notifications through the Firebase
         * Cloud Messaging (FCM), formerly Google Cloud Messaging (GCM), service. This message template overrides the
         * default template for push notification channels (DefaultPushNotificationTemplate).
         * </p>
         * This is a convenience method that creates an instance of the {@link AndroidPushNotificationTemplate.Builder}
         * avoiding the need to create one manually via {@link AndroidPushNotificationTemplate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AndroidPushNotificationTemplate.Builder#build()} is called
         * immediately and its result is passed to {@link #gcm(AndroidPushNotificationTemplate)}.
         * 
         * @param gcm
         *        a consumer that will call methods on {@link AndroidPushNotificationTemplate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #gcm(AndroidPushNotificationTemplate)
         */
        default Builder gcm(Consumer<AndroidPushNotificationTemplate.Builder> gcm) {
            return gcm(AndroidPushNotificationTemplate.builder().applyMutation(gcm).build());
        }

        /**
         * <p>
         * The unique identifier for the recommender model to use for the message template. Amazon Pinpoint uses this
         * value to determine how to retrieve and process data from a recommender model when it sends messages that use
         * the template, if the template contains message variables for recommendation data.
         * </p>
         * 
         * @param recommenderId
         *        The unique identifier for the recommender model to use for the message template. Amazon Pinpoint uses
         *        this value to determine how to retrieve and process data from a recommender model when it sends
         *        messages that use the template, if the template contains message variables for recommendation data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommenderId(String recommenderId);

        /**
         * <p>
         * A string-to-string map of key-value pairs that defines the tags to associate with the message template. Each
         * tag consists of a required tag key and an associated tag value.
         * </p>
         * 
         * @param tags
         *        A string-to-string map of key-value pairs that defines the tags to associate with the message
         *        template. Each tag consists of a required tag key and an associated tag value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * A custom description of the message template.
         * </p>
         * 
         * @param templateDescription
         *        A custom description of the message template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateDescription(String templateDescription);
    }

    static final class BuilderImpl implements Builder {
        private AndroidPushNotificationTemplate adm;

        private APNSPushNotificationTemplate apns;

        private AndroidPushNotificationTemplate baidu;

        private DefaultPushNotificationTemplate defaultValue;

        private String defaultSubstitutions;

        private AndroidPushNotificationTemplate gcm;

        private String recommenderId;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String templateDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(PushNotificationTemplateRequest model) {
            adm(model.adm);
            apns(model.apns);
            baidu(model.baidu);
            defaultValue(model.defaultValue);
            defaultSubstitutions(model.defaultSubstitutions);
            gcm(model.gcm);
            recommenderId(model.recommenderId);
            tags(model.tags);
            templateDescription(model.templateDescription);
        }

        public final AndroidPushNotificationTemplate.Builder getAdm() {
            return adm != null ? adm.toBuilder() : null;
        }

        public final void setAdm(AndroidPushNotificationTemplate.BuilderImpl adm) {
            this.adm = adm != null ? adm.build() : null;
        }

        @Override
        public final Builder adm(AndroidPushNotificationTemplate adm) {
            this.adm = adm;
            return this;
        }

        public final APNSPushNotificationTemplate.Builder getApns() {
            return apns != null ? apns.toBuilder() : null;
        }

        public final void setApns(APNSPushNotificationTemplate.BuilderImpl apns) {
            this.apns = apns != null ? apns.build() : null;
        }

        @Override
        public final Builder apns(APNSPushNotificationTemplate apns) {
            this.apns = apns;
            return this;
        }

        public final AndroidPushNotificationTemplate.Builder getBaidu() {
            return baidu != null ? baidu.toBuilder() : null;
        }

        public final void setBaidu(AndroidPushNotificationTemplate.BuilderImpl baidu) {
            this.baidu = baidu != null ? baidu.build() : null;
        }

        @Override
        public final Builder baidu(AndroidPushNotificationTemplate baidu) {
            this.baidu = baidu;
            return this;
        }

        public final DefaultPushNotificationTemplate.Builder getDefaultValue() {
            return defaultValue != null ? defaultValue.toBuilder() : null;
        }

        public final void setDefaultValue(DefaultPushNotificationTemplate.BuilderImpl defaultValue) {
            this.defaultValue = defaultValue != null ? defaultValue.build() : null;
        }

        @Override
        public final Builder defaultValue(DefaultPushNotificationTemplate defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final String getDefaultSubstitutions() {
            return defaultSubstitutions;
        }

        public final void setDefaultSubstitutions(String defaultSubstitutions) {
            this.defaultSubstitutions = defaultSubstitutions;
        }

        @Override
        public final Builder defaultSubstitutions(String defaultSubstitutions) {
            this.defaultSubstitutions = defaultSubstitutions;
            return this;
        }

        public final AndroidPushNotificationTemplate.Builder getGcm() {
            return gcm != null ? gcm.toBuilder() : null;
        }

        public final void setGcm(AndroidPushNotificationTemplate.BuilderImpl gcm) {
            this.gcm = gcm != null ? gcm.build() : null;
        }

        @Override
        public final Builder gcm(AndroidPushNotificationTemplate gcm) {
            this.gcm = gcm;
            return this;
        }

        public final String getRecommenderId() {
            return recommenderId;
        }

        public final void setRecommenderId(String recommenderId) {
            this.recommenderId = recommenderId;
        }

        @Override
        public final Builder recommenderId(String recommenderId) {
            this.recommenderId = recommenderId;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = MapOf__stringCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = MapOf__stringCopier.copy(tags);
            return this;
        }

        public final String getTemplateDescription() {
            return templateDescription;
        }

        public final void setTemplateDescription(String templateDescription) {
            this.templateDescription = templateDescription;
        }

        @Override
        public final Builder templateDescription(String templateDescription) {
            this.templateDescription = templateDescription;
            return this;
        }

        @Override
        public PushNotificationTemplateRequest build() {
            return new PushNotificationTemplateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
