/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies data for one or more attributes that describe the user who's associated with an endpoint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EndpointUser implements SdkPojo, Serializable, ToCopyableBuilder<EndpointUser.Builder, EndpointUser> {
    private static final SdkField<Map<String, List<String>>> USER_ATTRIBUTES_FIELD = SdkField
            .<Map<String, List<String>>> builder(MarshallingType.MAP)
            .memberName("UserAttributes")
            .getter(getter(EndpointUser::userAttributes))
            .setter(setter(Builder::userAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserAttributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<String> USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("UserId")
            .getter(getter(EndpointUser::userId)).setter(setter(Builder::userId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_ATTRIBUTES_FIELD,
            USER_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final Map<String, List<String>> userAttributes;

    private final String userId;

    private EndpointUser(BuilderImpl builder) {
        this.userAttributes = builder.userAttributes;
        this.userId = builder.userId;
    }

    /**
     * For responses, this returns true if the service returned a value for the UserAttributes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUserAttributes() {
        return userAttributes != null && !(userAttributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * One or more custom attributes that describe the user by associating a name with an array of values. For example,
     * the value of an attribute named Interests might be: ["Science", "Music", "Travel"]. You can use these attributes
     * as filter criteria when you create segments. Attribute names are case sensitive.
     * </p>
     * <p>
     * An attribute name can contain up to 50 characters. An attribute value can contain up to 100 characters. When you
     * define the name of a custom attribute, avoid using the following characters: number sign (#), colon (:), question
     * mark (?), backslash (\), and slash (/). The Amazon Pinpoint console can't display attribute names that contain
     * these characters. This restriction doesn't apply to attribute values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUserAttributes} method.
     * </p>
     * 
     * @return One or more custom attributes that describe the user by associating a name with an array of values. For
     *         example, the value of an attribute named Interests might be: ["Science", "Music", "Travel"]. You can use
     *         these attributes as filter criteria when you create segments. Attribute names are case sensitive.</p>
     *         <p>
     *         An attribute name can contain up to 50 characters. An attribute value can contain up to 100 characters.
     *         When you define the name of a custom attribute, avoid using the following characters: number sign (#),
     *         colon (:), question mark (?), backslash (\), and slash (/). The Amazon Pinpoint console can't display
     *         attribute names that contain these characters. This restriction doesn't apply to attribute values.
     */
    public final Map<String, List<String>> userAttributes() {
        return userAttributes;
    }

    /**
     * <p>
     * The unique identifier for the user.
     * </p>
     * 
     * @return The unique identifier for the user.
     */
    public final String userId() {
        return userId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasUserAttributes() ? userAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EndpointUser)) {
            return false;
        }
        EndpointUser other = (EndpointUser) obj;
        return hasUserAttributes() == other.hasUserAttributes() && Objects.equals(userAttributes(), other.userAttributes())
                && Objects.equals(userId(), other.userId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EndpointUser").add("UserAttributes", hasUserAttributes() ? userAttributes() : null)
                .add("UserId", userId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserAttributes":
            return Optional.ofNullable(clazz.cast(userAttributes()));
        case "UserId":
            return Optional.ofNullable(clazz.cast(userId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EndpointUser, T> g) {
        return obj -> g.apply((EndpointUser) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EndpointUser> {
        /**
         * <p>
         * One or more custom attributes that describe the user by associating a name with an array of values. For
         * example, the value of an attribute named Interests might be: ["Science", "Music", "Travel"]. You can use
         * these attributes as filter criteria when you create segments. Attribute names are case sensitive.
         * </p>
         * <p>
         * An attribute name can contain up to 50 characters. An attribute value can contain up to 100 characters. When
         * you define the name of a custom attribute, avoid using the following characters: number sign (#), colon (:),
         * question mark (?), backslash (\), and slash (/). The Amazon Pinpoint console can't display attribute names
         * that contain these characters. This restriction doesn't apply to attribute values.
         * </p>
         * 
         * @param userAttributes
         *        One or more custom attributes that describe the user by associating a name with an array of values.
         *        For example, the value of an attribute named Interests might be: ["Science", "Music", "Travel"]. You
         *        can use these attributes as filter criteria when you create segments. Attribute names are case
         *        sensitive.</p>
         *        <p>
         *        An attribute name can contain up to 50 characters. An attribute value can contain up to 100
         *        characters. When you define the name of a custom attribute, avoid using the following characters:
         *        number sign (#), colon (:), question mark (?), backslash (\), and slash (/). The Amazon Pinpoint
         *        console can't display attribute names that contain these characters. This restriction doesn't apply to
         *        attribute values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userAttributes(Map<String, ? extends Collection<String>> userAttributes);

        /**
         * <p>
         * The unique identifier for the user.
         * </p>
         * 
         * @param userId
         *        The unique identifier for the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, List<String>> userAttributes = DefaultSdkAutoConstructMap.getInstance();

        private String userId;

        private BuilderImpl() {
        }

        private BuilderImpl(EndpointUser model) {
            userAttributes(model.userAttributes);
            userId(model.userId);
        }

        public final Map<String, ? extends Collection<String>> getUserAttributes() {
            if (userAttributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return userAttributes;
        }

        public final void setUserAttributes(Map<String, ? extends Collection<String>> userAttributes) {
            this.userAttributes = MapOfListOf__stringCopier.copy(userAttributes);
        }

        @Override
        public final Builder userAttributes(Map<String, ? extends Collection<String>> userAttributes) {
            this.userAttributes = MapOfListOf__stringCopier.copy(userAttributes);
            return this;
        }

        public final String getUserId() {
            return userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        @Override
        public EndpointUser build() {
            return new EndpointUser(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
