/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pinpoint.model.ListOfRandomSplitEntryCopier;
import software.amazon.awssdk.services.pinpoint.model.RandomSplitEntry;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RandomSplitActivity
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RandomSplitActivity> {
    private static final SdkField<List<RandomSplitEntry>> BRANCHES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Branches").getter(RandomSplitActivity.getter(RandomSplitActivity::branches)).setter(RandomSplitActivity.setter(Builder::branches)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Branches").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RandomSplitEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BRANCHES_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<RandomSplitEntry> branches;

    private RandomSplitActivity(BuilderImpl builder) {
        this.branches = builder.branches;
    }

    public final boolean hasBranches() {
        return this.branches != null && !(this.branches instanceof SdkAutoConstructList);
    }

    public final List<RandomSplitEntry> branches() {
        return this.branches;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBranches() ? this.branches() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RandomSplitActivity)) {
            return false;
        }
        RandomSplitActivity other = (RandomSplitActivity)obj;
        return this.hasBranches() == other.hasBranches() && Objects.equals(this.branches(), other.branches());
    }

    public final String toString() {
        return ToString.builder((String)"RandomSplitActivity").add("Branches", this.hasBranches() ? this.branches() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Branches": {
                return Optional.ofNullable(clazz.cast(this.branches()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RandomSplitActivity, T> g) {
        return obj -> g.apply((RandomSplitActivity)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<RandomSplitEntry> branches = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RandomSplitActivity model) {
            this.branches(model.branches);
        }

        public final List<RandomSplitEntry.Builder> getBranches() {
            List<RandomSplitEntry.Builder> result = ListOfRandomSplitEntryCopier.copyToBuilder(this.branches);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder branches(Collection<RandomSplitEntry> branches) {
            this.branches = ListOfRandomSplitEntryCopier.copy(branches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder branches(RandomSplitEntry ... branches) {
            this.branches(Arrays.asList(branches));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder branches(Consumer<RandomSplitEntry.Builder> ... branches) {
            this.branches(Stream.of(branches).map(c -> (RandomSplitEntry)((RandomSplitEntry.Builder)RandomSplitEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBranches(Collection<RandomSplitEntry.BuilderImpl> branches) {
            this.branches = ListOfRandomSplitEntryCopier.copyFromBuilder(branches);
        }

        public RandomSplitActivity build() {
            return new RandomSplitActivity(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RandomSplitActivity> {
        public Builder branches(Collection<RandomSplitEntry> var1);

        public Builder branches(RandomSplitEntry ... var1);

        public Builder branches(Consumer<RandomSplitEntry.Builder> ... var1);
    }
}

