/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pinpoint.model.CampaignHook;
import software.amazon.awssdk.services.pinpoint.model.CampaignLimits;
import software.amazon.awssdk.services.pinpoint.model.QuietTime;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WriteApplicationSettingsRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WriteApplicationSettingsRequest> {
    private static final SdkField<CampaignHook> CAMPAIGN_HOOK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CampaignHook").getter(WriteApplicationSettingsRequest.getter(WriteApplicationSettingsRequest::campaignHook)).setter(WriteApplicationSettingsRequest.setter(Builder::campaignHook)).constructor(CampaignHook::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CampaignHook").build()}).build();
    private static final SdkField<Boolean> CLOUD_WATCH_METRICS_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CloudWatchMetricsEnabled").getter(WriteApplicationSettingsRequest.getter(WriteApplicationSettingsRequest::cloudWatchMetricsEnabled)).setter(WriteApplicationSettingsRequest.setter(Builder::cloudWatchMetricsEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchMetricsEnabled").build()}).build();
    private static final SdkField<Boolean> EVENT_TAGGING_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EventTaggingEnabled").getter(WriteApplicationSettingsRequest.getter(WriteApplicationSettingsRequest::eventTaggingEnabled)).setter(WriteApplicationSettingsRequest.setter(Builder::eventTaggingEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventTaggingEnabled").build()}).build();
    private static final SdkField<CampaignLimits> LIMITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Limits").getter(WriteApplicationSettingsRequest.getter(WriteApplicationSettingsRequest::limits)).setter(WriteApplicationSettingsRequest.setter(Builder::limits)).constructor(CampaignLimits::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limits").build()}).build();
    private static final SdkField<QuietTime> QUIET_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("QuietTime").getter(WriteApplicationSettingsRequest.getter(WriteApplicationSettingsRequest::quietTime)).setter(WriteApplicationSettingsRequest.setter(Builder::quietTime)).constructor(QuietTime::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuietTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAMPAIGN_HOOK_FIELD, CLOUD_WATCH_METRICS_ENABLED_FIELD, EVENT_TAGGING_ENABLED_FIELD, LIMITS_FIELD, QUIET_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final CampaignHook campaignHook;
    private final Boolean cloudWatchMetricsEnabled;
    private final Boolean eventTaggingEnabled;
    private final CampaignLimits limits;
    private final QuietTime quietTime;

    private WriteApplicationSettingsRequest(BuilderImpl builder) {
        this.campaignHook = builder.campaignHook;
        this.cloudWatchMetricsEnabled = builder.cloudWatchMetricsEnabled;
        this.eventTaggingEnabled = builder.eventTaggingEnabled;
        this.limits = builder.limits;
        this.quietTime = builder.quietTime;
    }

    public final CampaignHook campaignHook() {
        return this.campaignHook;
    }

    public final Boolean cloudWatchMetricsEnabled() {
        return this.cloudWatchMetricsEnabled;
    }

    public final Boolean eventTaggingEnabled() {
        return this.eventTaggingEnabled;
    }

    public final CampaignLimits limits() {
        return this.limits;
    }

    public final QuietTime quietTime() {
        return this.quietTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.campaignHook());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchMetricsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTaggingEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.limits());
        hashCode = 31 * hashCode + Objects.hashCode(this.quietTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WriteApplicationSettingsRequest)) {
            return false;
        }
        WriteApplicationSettingsRequest other = (WriteApplicationSettingsRequest)obj;
        return Objects.equals(this.campaignHook(), other.campaignHook()) && Objects.equals(this.cloudWatchMetricsEnabled(), other.cloudWatchMetricsEnabled()) && Objects.equals(this.eventTaggingEnabled(), other.eventTaggingEnabled()) && Objects.equals(this.limits(), other.limits()) && Objects.equals(this.quietTime(), other.quietTime());
    }

    public final String toString() {
        return ToString.builder((String)"WriteApplicationSettingsRequest").add("CampaignHook", (Object)this.campaignHook()).add("CloudWatchMetricsEnabled", (Object)this.cloudWatchMetricsEnabled()).add("EventTaggingEnabled", (Object)this.eventTaggingEnabled()).add("Limits", (Object)this.limits()).add("QuietTime", (Object)this.quietTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CampaignHook": {
                return Optional.ofNullable(clazz.cast(this.campaignHook()));
            }
            case "CloudWatchMetricsEnabled": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchMetricsEnabled()));
            }
            case "EventTaggingEnabled": {
                return Optional.ofNullable(clazz.cast(this.eventTaggingEnabled()));
            }
            case "Limits": {
                return Optional.ofNullable(clazz.cast(this.limits()));
            }
            case "QuietTime": {
                return Optional.ofNullable(clazz.cast(this.quietTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WriteApplicationSettingsRequest, T> g) {
        return obj -> g.apply((WriteApplicationSettingsRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private CampaignHook campaignHook;
        private Boolean cloudWatchMetricsEnabled;
        private Boolean eventTaggingEnabled;
        private CampaignLimits limits;
        private QuietTime quietTime;

        private BuilderImpl() {
        }

        private BuilderImpl(WriteApplicationSettingsRequest model) {
            this.campaignHook(model.campaignHook);
            this.cloudWatchMetricsEnabled(model.cloudWatchMetricsEnabled);
            this.eventTaggingEnabled(model.eventTaggingEnabled);
            this.limits(model.limits);
            this.quietTime(model.quietTime);
        }

        public final CampaignHook.Builder getCampaignHook() {
            return this.campaignHook != null ? this.campaignHook.toBuilder() : null;
        }

        @Override
        public final Builder campaignHook(CampaignHook campaignHook) {
            this.campaignHook = campaignHook;
            return this;
        }

        public final void setCampaignHook(CampaignHook.BuilderImpl campaignHook) {
            this.campaignHook = campaignHook != null ? campaignHook.build() : null;
        }

        public final Boolean getCloudWatchMetricsEnabled() {
            return this.cloudWatchMetricsEnabled;
        }

        @Override
        public final Builder cloudWatchMetricsEnabled(Boolean cloudWatchMetricsEnabled) {
            this.cloudWatchMetricsEnabled = cloudWatchMetricsEnabled;
            return this;
        }

        public final void setCloudWatchMetricsEnabled(Boolean cloudWatchMetricsEnabled) {
            this.cloudWatchMetricsEnabled = cloudWatchMetricsEnabled;
        }

        public final Boolean getEventTaggingEnabled() {
            return this.eventTaggingEnabled;
        }

        @Override
        public final Builder eventTaggingEnabled(Boolean eventTaggingEnabled) {
            this.eventTaggingEnabled = eventTaggingEnabled;
            return this;
        }

        public final void setEventTaggingEnabled(Boolean eventTaggingEnabled) {
            this.eventTaggingEnabled = eventTaggingEnabled;
        }

        public final CampaignLimits.Builder getLimits() {
            return this.limits != null ? this.limits.toBuilder() : null;
        }

        @Override
        public final Builder limits(CampaignLimits limits) {
            this.limits = limits;
            return this;
        }

        public final void setLimits(CampaignLimits.BuilderImpl limits) {
            this.limits = limits != null ? limits.build() : null;
        }

        public final QuietTime.Builder getQuietTime() {
            return this.quietTime != null ? this.quietTime.toBuilder() : null;
        }

        @Override
        public final Builder quietTime(QuietTime quietTime) {
            this.quietTime = quietTime;
            return this;
        }

        public final void setQuietTime(QuietTime.BuilderImpl quietTime) {
            this.quietTime = quietTime != null ? quietTime.build() : null;
        }

        public WriteApplicationSettingsRequest build() {
            return new WriteApplicationSettingsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WriteApplicationSettingsRequest> {
        public Builder campaignHook(CampaignHook var1);

        default public Builder campaignHook(Consumer<CampaignHook.Builder> campaignHook) {
            return this.campaignHook((CampaignHook)((CampaignHook.Builder)CampaignHook.builder().applyMutation(campaignHook)).build());
        }

        public Builder cloudWatchMetricsEnabled(Boolean var1);

        public Builder eventTaggingEnabled(Boolean var1);

        public Builder limits(CampaignLimits var1);

        default public Builder limits(Consumer<CampaignLimits.Builder> limits) {
            return this.limits((CampaignLimits)((CampaignLimits.Builder)CampaignLimits.builder().applyMutation(limits)).build());
        }

        public Builder quietTime(QuietTime var1);

        default public Builder quietTime(Consumer<QuietTime.Builder> quietTime) {
            return this.quietTime((QuietTime)((QuietTime.Builder)QuietTime.builder().applyMutation(quietTime)).build());
        }
    }
}

