/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pinpoint.model.ListOfSegmentDimensionsCopier;
import software.amazon.awssdk.services.pinpoint.model.ListOfSegmentReferenceCopier;
import software.amazon.awssdk.services.pinpoint.model.SegmentDimensions;
import software.amazon.awssdk.services.pinpoint.model.SegmentReference;
import software.amazon.awssdk.services.pinpoint.model.SourceType;
import software.amazon.awssdk.services.pinpoint.model.Type;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SegmentGroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SegmentGroup> {
    private static final SdkField<List<SegmentDimensions>> DIMENSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Dimensions").getter(SegmentGroup.getter(SegmentGroup::dimensions)).setter(SegmentGroup.setter(Builder::dimensions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dimensions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SegmentDimensions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<SegmentReference>> SOURCE_SEGMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SourceSegments").getter(SegmentGroup.getter(SegmentGroup::sourceSegments)).setter(SegmentGroup.setter(Builder::sourceSegments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceSegments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SegmentReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceType").getter(SegmentGroup.getter(SegmentGroup::sourceTypeAsString)).setter(SegmentGroup.setter(Builder::sourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceType").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(SegmentGroup.getter(SegmentGroup::typeAsString)).setter(SegmentGroup.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIMENSIONS_FIELD, SOURCE_SEGMENTS_FIELD, SOURCE_TYPE_FIELD, TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<SegmentDimensions> dimensions;
    private final List<SegmentReference> sourceSegments;
    private final String sourceType;
    private final String type;

    private SegmentGroup(BuilderImpl builder) {
        this.dimensions = builder.dimensions;
        this.sourceSegments = builder.sourceSegments;
        this.sourceType = builder.sourceType;
        this.type = builder.type;
    }

    public final boolean hasDimensions() {
        return this.dimensions != null && !(this.dimensions instanceof SdkAutoConstructList);
    }

    public final List<SegmentDimensions> dimensions() {
        return this.dimensions;
    }

    public final boolean hasSourceSegments() {
        return this.sourceSegments != null && !(this.sourceSegments instanceof SdkAutoConstructList);
    }

    public final List<SegmentReference> sourceSegments() {
        return this.sourceSegments;
    }

    public final SourceType sourceType() {
        return SourceType.fromValue(this.sourceType);
    }

    public final String sourceTypeAsString() {
        return this.sourceType;
    }

    public final Type type() {
        return Type.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDimensions() ? this.dimensions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSourceSegments() ? this.sourceSegments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SegmentGroup)) {
            return false;
        }
        SegmentGroup other = (SegmentGroup)obj;
        return this.hasDimensions() == other.hasDimensions() && Objects.equals(this.dimensions(), other.dimensions()) && this.hasSourceSegments() == other.hasSourceSegments() && Objects.equals(this.sourceSegments(), other.sourceSegments()) && Objects.equals(this.sourceTypeAsString(), other.sourceTypeAsString()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SegmentGroup").add("Dimensions", this.hasDimensions() ? this.dimensions() : null).add("SourceSegments", this.hasSourceSegments() ? this.sourceSegments() : null).add("SourceType", (Object)this.sourceTypeAsString()).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Dimensions": {
                return Optional.ofNullable(clazz.cast(this.dimensions()));
            }
            case "SourceSegments": {
                return Optional.ofNullable(clazz.cast(this.sourceSegments()));
            }
            case "SourceType": {
                return Optional.ofNullable(clazz.cast(this.sourceTypeAsString()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SegmentGroup, T> g) {
        return obj -> g.apply((SegmentGroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<SegmentDimensions> dimensions = DefaultSdkAutoConstructList.getInstance();
        private List<SegmentReference> sourceSegments = DefaultSdkAutoConstructList.getInstance();
        private String sourceType;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(SegmentGroup model) {
            this.dimensions(model.dimensions);
            this.sourceSegments(model.sourceSegments);
            this.sourceType(model.sourceType);
            this.type(model.type);
        }

        public final Collection<SegmentDimensions.Builder> getDimensions() {
            if (this.dimensions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dimensions != null ? (Collection)this.dimensions.stream().map(SegmentDimensions::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dimensions(Collection<SegmentDimensions> dimensions) {
            this.dimensions = ListOfSegmentDimensionsCopier.copy(dimensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensions(SegmentDimensions ... dimensions) {
            this.dimensions(Arrays.asList(dimensions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensions(Consumer<SegmentDimensions.Builder> ... dimensions) {
            this.dimensions(Stream.of(dimensions).map(c -> (SegmentDimensions)((SegmentDimensions.Builder)SegmentDimensions.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDimensions(Collection<SegmentDimensions.BuilderImpl> dimensions) {
            this.dimensions = ListOfSegmentDimensionsCopier.copyFromBuilder(dimensions);
        }

        public final Collection<SegmentReference.Builder> getSourceSegments() {
            if (this.sourceSegments instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sourceSegments != null ? (Collection)this.sourceSegments.stream().map(SegmentReference::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder sourceSegments(Collection<SegmentReference> sourceSegments) {
            this.sourceSegments = ListOfSegmentReferenceCopier.copy(sourceSegments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceSegments(SegmentReference ... sourceSegments) {
            this.sourceSegments(Arrays.asList(sourceSegments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceSegments(Consumer<SegmentReference.Builder> ... sourceSegments) {
            this.sourceSegments(Stream.of(sourceSegments).map(c -> (SegmentReference)((SegmentReference.Builder)SegmentReference.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSourceSegments(Collection<SegmentReference.BuilderImpl> sourceSegments) {
            this.sourceSegments = ListOfSegmentReferenceCopier.copyFromBuilder(sourceSegments);
        }

        public final String getSourceType() {
            return this.sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        @Override
        public final Builder sourceType(SourceType sourceType) {
            this.sourceType(sourceType == null ? null : sourceType.toString());
            return this;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(Type type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public SegmentGroup build() {
            return new SegmentGroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SegmentGroup> {
        public Builder dimensions(Collection<SegmentDimensions> var1);

        public Builder dimensions(SegmentDimensions ... var1);

        public Builder dimensions(Consumer<SegmentDimensions.Builder> ... var1);

        public Builder sourceSegments(Collection<SegmentReference> var1);

        public Builder sourceSegments(SegmentReference ... var1);

        public Builder sourceSegments(Consumer<SegmentReference.Builder> ... var1);

        public Builder sourceType(String var1);

        public Builder sourceType(SourceType var1);

        public Builder type(String var1);

        public Builder type(Type var1);
    }
}

