/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies settings for publishing event data to an Amazon Kinesis data stream or an Amazon Kinesis Data Firehose
 * delivery stream.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EventStream implements SdkPojo, Serializable, ToCopyableBuilder<EventStream.Builder, EventStream> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationId").getter(getter(EventStream::applicationId)).setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationId").build()).build();

    private static final SdkField<String> DESTINATION_STREAM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationStreamArn").getter(getter(EventStream::destinationStreamArn))
            .setter(setter(Builder::destinationStreamArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationStreamArn").build())
            .build();

    private static final SdkField<String> EXTERNAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExternalId").getter(getter(EventStream::externalId)).setter(setter(Builder::externalId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExternalId").build()).build();

    private static final SdkField<String> LAST_MODIFIED_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastModifiedDate").getter(getter(EventStream::lastModifiedDate))
            .setter(setter(Builder::lastModifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()).build();

    private static final SdkField<String> LAST_UPDATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastUpdatedBy").getter(getter(EventStream::lastUpdatedBy)).setter(setter(Builder::lastUpdatedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedBy").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(EventStream::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            DESTINATION_STREAM_ARN_FIELD, EXTERNAL_ID_FIELD, LAST_MODIFIED_DATE_FIELD, LAST_UPDATED_BY_FIELD, ROLE_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String applicationId;

    private final String destinationStreamArn;

    private final String externalId;

    private final String lastModifiedDate;

    private final String lastUpdatedBy;

    private final String roleArn;

    private EventStream(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.destinationStreamArn = builder.destinationStreamArn;
        this.externalId = builder.externalId;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.lastUpdatedBy = builder.lastUpdatedBy;
        this.roleArn = builder.roleArn;
    }

    /**
     * <p>
     * The unique identifier for the application to publish event data for.
     * </p>
     * 
     * @return The unique identifier for the application to publish event data for.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon Kinesis data stream or Amazon Kinesis Data Firehose delivery stream
     * to publish event data to.
     * </p>
     * <p>
     * For a Kinesis data stream, the ARN format is:
     * arn:aws:kinesis:<replaceable>region</replaceable>:<replaceable>account
     * -id</replaceable>:stream/<replaceable>stream_name</replaceable>
     * </p>
     * <p>
     * For a Kinesis Data Firehose delivery stream, the ARN format is:
     * arn:aws:firehose:<replaceable>region</replaceable>
     * :<replaceable>account-id</replaceable>:deliverystream/<replaceable>stream_name</replaceable>
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon Kinesis data stream or Amazon Kinesis Data Firehose delivery
     *         stream to publish event data to.</p>
     *         <p>
     *         For a Kinesis data stream, the ARN format is:
     *         arn:aws:kinesis:<replaceable>region</replaceable>:<replaceable
     *         >account-id</replaceable>:stream/<replaceable>stream_name</replaceable>
     *         </p>
     *         <p>
     *         For a Kinesis Data Firehose delivery stream, the ARN format is:
     *         arn:aws:firehose:<replaceable>region</replaceable
     *         >:<replaceable>account-id</replaceable>:deliverystream/<replaceable>stream_name</replaceable>
     */
    public final String destinationStreamArn() {
        return destinationStreamArn;
    }

    /**
     * <p>
     * (Deprecated) Your AWS account ID, which you assigned to an external ID key in an IAM trust policy. Amazon
     * Pinpoint previously used this value to assume an IAM role when publishing event data, but we removed this
     * requirement. We don't recommend use of external IDs for IAM roles that are assumed by Amazon Pinpoint.
     * </p>
     * 
     * @return (Deprecated) Your AWS account ID, which you assigned to an external ID key in an IAM trust policy. Amazon
     *         Pinpoint previously used this value to assume an IAM role when publishing event data, but we removed this
     *         requirement. We don't recommend use of external IDs for IAM roles that are assumed by Amazon Pinpoint.
     */
    public final String externalId() {
        return externalId;
    }

    /**
     * <p>
     * The date, in ISO 8601 format, when the event stream was last modified.
     * </p>
     * 
     * @return The date, in ISO 8601 format, when the event stream was last modified.
     */
    public final String lastModifiedDate() {
        return lastModifiedDate;
    }

    /**
     * <p>
     * The IAM user who last modified the event stream.
     * </p>
     * 
     * @return The IAM user who last modified the event stream.
     */
    public final String lastUpdatedBy() {
        return lastUpdatedBy;
    }

    /**
     * <p>
     * The AWS Identity and Access Management (IAM) role that authorizes Amazon Pinpoint to publish event data to the
     * stream in your AWS account.
     * </p>
     * 
     * @return The AWS Identity and Access Management (IAM) role that authorizes Amazon Pinpoint to publish event data
     *         to the stream in your AWS account.
     */
    public final String roleArn() {
        return roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(destinationStreamArn());
        hashCode = 31 * hashCode + Objects.hashCode(externalId());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedBy());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventStream)) {
            return false;
        }
        EventStream other = (EventStream) obj;
        return Objects.equals(applicationId(), other.applicationId())
                && Objects.equals(destinationStreamArn(), other.destinationStreamArn())
                && Objects.equals(externalId(), other.externalId())
                && Objects.equals(lastModifiedDate(), other.lastModifiedDate())
                && Objects.equals(lastUpdatedBy(), other.lastUpdatedBy()) && Objects.equals(roleArn(), other.roleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EventStream").add("ApplicationId", applicationId())
                .add("DestinationStreamArn", destinationStreamArn()).add("ExternalId", externalId())
                .add("LastModifiedDate", lastModifiedDate()).add("LastUpdatedBy", lastUpdatedBy()).add("RoleArn", roleArn())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "DestinationStreamArn":
            return Optional.ofNullable(clazz.cast(destinationStreamArn()));
        case "ExternalId":
            return Optional.ofNullable(clazz.cast(externalId()));
        case "LastModifiedDate":
            return Optional.ofNullable(clazz.cast(lastModifiedDate()));
        case "LastUpdatedBy":
            return Optional.ofNullable(clazz.cast(lastUpdatedBy()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EventStream, T> g) {
        return obj -> g.apply((EventStream) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EventStream> {
        /**
         * <p>
         * The unique identifier for the application to publish event data for.
         * </p>
         * 
         * @param applicationId
         *        The unique identifier for the application to publish event data for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon Kinesis data stream or Amazon Kinesis Data Firehose delivery
         * stream to publish event data to.
         * </p>
         * <p>
         * For a Kinesis data stream, the ARN format is:
         * arn:aws:kinesis:<replaceable>region</replaceable>:<replaceable>account
         * -id</replaceable>:stream/<replaceable>stream_name</replaceable>
         * </p>
         * <p>
         * For a Kinesis Data Firehose delivery stream, the ARN format is:
         * arn:aws:firehose:<replaceable>region</replaceable
         * >:<replaceable>account-id</replaceable>:deliverystream/<replaceable>stream_name</replaceable>
         * </p>
         * 
         * @param destinationStreamArn
         *        The Amazon Resource Name (ARN) of the Amazon Kinesis data stream or Amazon Kinesis Data Firehose
         *        delivery stream to publish event data to.</p>
         *        <p>
         *        For a Kinesis data stream, the ARN format is:
         *        arn:aws:kinesis:<replaceable>region</replaceable>:<replaceable
         *        >account-id</replaceable>:stream/<replaceable>stream_name</replaceable>
         *        </p>
         *        <p>
         *        For a Kinesis Data Firehose delivery stream, the ARN format is:
         *        arn:aws:firehose:<replaceable>region</replaceable
         *        >:<replaceable>account-id</replaceable>:deliverystream/<replaceable>stream_name</replaceable>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationStreamArn(String destinationStreamArn);

        /**
         * <p>
         * (Deprecated) Your AWS account ID, which you assigned to an external ID key in an IAM trust policy. Amazon
         * Pinpoint previously used this value to assume an IAM role when publishing event data, but we removed this
         * requirement. We don't recommend use of external IDs for IAM roles that are assumed by Amazon Pinpoint.
         * </p>
         * 
         * @param externalId
         *        (Deprecated) Your AWS account ID, which you assigned to an external ID key in an IAM trust policy.
         *        Amazon Pinpoint previously used this value to assume an IAM role when publishing event data, but we
         *        removed this requirement. We don't recommend use of external IDs for IAM roles that are assumed by
         *        Amazon Pinpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalId(String externalId);

        /**
         * <p>
         * The date, in ISO 8601 format, when the event stream was last modified.
         * </p>
         * 
         * @param lastModifiedDate
         *        The date, in ISO 8601 format, when the event stream was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(String lastModifiedDate);

        /**
         * <p>
         * The IAM user who last modified the event stream.
         * </p>
         * 
         * @param lastUpdatedBy
         *        The IAM user who last modified the event stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedBy(String lastUpdatedBy);

        /**
         * <p>
         * The AWS Identity and Access Management (IAM) role that authorizes Amazon Pinpoint to publish event data to
         * the stream in your AWS account.
         * </p>
         * 
         * @param roleArn
         *        The AWS Identity and Access Management (IAM) role that authorizes Amazon Pinpoint to publish event
         *        data to the stream in your AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);
    }

    static final class BuilderImpl implements Builder {
        private String applicationId;

        private String destinationStreamArn;

        private String externalId;

        private String lastModifiedDate;

        private String lastUpdatedBy;

        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(EventStream model) {
            applicationId(model.applicationId);
            destinationStreamArn(model.destinationStreamArn);
            externalId(model.externalId);
            lastModifiedDate(model.lastModifiedDate);
            lastUpdatedBy(model.lastUpdatedBy);
            roleArn(model.roleArn);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final String getDestinationStreamArn() {
            return destinationStreamArn;
        }

        @Override
        public final Builder destinationStreamArn(String destinationStreamArn) {
            this.destinationStreamArn = destinationStreamArn;
            return this;
        }

        public final void setDestinationStreamArn(String destinationStreamArn) {
            this.destinationStreamArn = destinationStreamArn;
        }

        public final String getExternalId() {
            return externalId;
        }

        @Override
        public final Builder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public final void setExternalId(String externalId) {
            this.externalId = externalId;
        }

        public final String getLastModifiedDate() {
            return lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final void setLastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        public final String getLastUpdatedBy() {
            return lastUpdatedBy;
        }

        @Override
        public final Builder lastUpdatedBy(String lastUpdatedBy) {
            this.lastUpdatedBy = lastUpdatedBy;
            return this;
        }

        public final void setLastUpdatedBy(String lastUpdatedBy) {
            this.lastUpdatedBy = lastUpdatedBy;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public EventStream build() {
            return new EventStream(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
