/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the default settings for an application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WriteApplicationSettingsRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<WriteApplicationSettingsRequest.Builder, WriteApplicationSettingsRequest> {
    private static final SdkField<CampaignHook> CAMPAIGN_HOOK_FIELD = SdkField.<CampaignHook> builder(MarshallingType.SDK_POJO)
            .memberName("CampaignHook").getter(getter(WriteApplicationSettingsRequest::campaignHook))
            .setter(setter(Builder::campaignHook)).constructor(CampaignHook::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CampaignHook").build()).build();

    private static final SdkField<Boolean> CLOUD_WATCH_METRICS_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("CloudWatchMetricsEnabled")
            .getter(getter(WriteApplicationSettingsRequest::cloudWatchMetricsEnabled))
            .setter(setter(Builder::cloudWatchMetricsEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchMetricsEnabled").build())
            .build();

    private static final SdkField<Boolean> EVENT_TAGGING_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EventTaggingEnabled").getter(getter(WriteApplicationSettingsRequest::eventTaggingEnabled))
            .setter(setter(Builder::eventTaggingEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventTaggingEnabled").build())
            .build();

    private static final SdkField<CampaignLimits> LIMITS_FIELD = SdkField.<CampaignLimits> builder(MarshallingType.SDK_POJO)
            .memberName("Limits").getter(getter(WriteApplicationSettingsRequest::limits)).setter(setter(Builder::limits))
            .constructor(CampaignLimits::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limits").build()).build();

    private static final SdkField<QuietTime> QUIET_TIME_FIELD = SdkField.<QuietTime> builder(MarshallingType.SDK_POJO)
            .memberName("QuietTime").getter(getter(WriteApplicationSettingsRequest::quietTime))
            .setter(setter(Builder::quietTime)).constructor(QuietTime::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuietTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAMPAIGN_HOOK_FIELD,
            CLOUD_WATCH_METRICS_ENABLED_FIELD, EVENT_TAGGING_ENABLED_FIELD, LIMITS_FIELD, QUIET_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final CampaignHook campaignHook;

    private final Boolean cloudWatchMetricsEnabled;

    private final Boolean eventTaggingEnabled;

    private final CampaignLimits limits;

    private final QuietTime quietTime;

    private WriteApplicationSettingsRequest(BuilderImpl builder) {
        this.campaignHook = builder.campaignHook;
        this.cloudWatchMetricsEnabled = builder.cloudWatchMetricsEnabled;
        this.eventTaggingEnabled = builder.eventTaggingEnabled;
        this.limits = builder.limits;
        this.quietTime = builder.quietTime;
    }

    /**
     * <p>
     * The settings for the AWS Lambda function to invoke by default as a code hook for campaigns in the application.
     * You can use this hook to customize segments that are used by campaigns in the application.
     * </p>
     * <p>
     * To override these settings and define custom settings for a specific campaign, use the CampaignHook object of the
     * <link linkend="apps-application-id-campaigns-campaign-id">Campaign</link> resource.
     * </p>
     * 
     * @return The settings for the AWS Lambda function to invoke by default as a code hook for campaigns in the
     *         application. You can use this hook to customize segments that are used by campaigns in the
     *         application.</p>
     *         <p>
     *         To override these settings and define custom settings for a specific campaign, use the CampaignHook
     *         object of the <link linkend="apps-application-id-campaigns-campaign-id">Campaign</link> resource.
     */
    public CampaignHook campaignHook() {
        return campaignHook;
    }

    /**
     * <p>
     * Specifies whether to enable application-related alarms in Amazon CloudWatch.
     * </p>
     * 
     * @return Specifies whether to enable application-related alarms in Amazon CloudWatch.
     */
    public Boolean cloudWatchMetricsEnabled() {
        return cloudWatchMetricsEnabled;
    }

    /**
     * Returns the value of the EventTaggingEnabled property for this object.
     * 
     * @return The value of the EventTaggingEnabled property for this object.
     */
    public Boolean eventTaggingEnabled() {
        return eventTaggingEnabled;
    }

    /**
     * <p>
     * The default sending limits for campaigns in the application. To override these limits and define custom limits
     * for a specific campaign or journey, use the <link
     * linkend="apps-application-id-campaigns-campaign-id">Campaign</link> resource or the <link
     * linkend="apps-application-id-journeys-journey-id">Journey</link> resource, respectively.
     * </p>
     * 
     * @return The default sending limits for campaigns in the application. To override these limits and define custom
     *         limits for a specific campaign or journey, use the <link
     *         linkend="apps-application-id-campaigns-campaign-id">Campaign</link> resource or the <link
     *         linkend="apps-application-id-journeys-journey-id">Journey</link> resource, respectively.
     */
    public CampaignLimits limits() {
        return limits;
    }

    /**
     * <p>
     * The default quiet time for campaigns in the application. Quiet time is a specific time range when messages aren't
     * sent to endpoints, if all the following conditions are met:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The EndpointDemographic.Timezone property of the endpoint is set to a valid value.
     * </p>
     * </li>
     * <li>
     * <p>
     * The current time in the endpoint's time zone is later than or equal to the time specified by the QuietTime.Start
     * property for the application (or a campaign or journey that has custom quiet time settings).
     * </p>
     * </li>
     * <li>
     * <p>
     * The current time in the endpoint's time zone is earlier than or equal to the time specified by the QuietTime.End
     * property for the application (or a campaign or journey that has custom quiet time settings).
     * </p>
     * </li>
     * </ul>
     * <p>
     * If any of the preceding conditions isn't met, the endpoint will receive messages from a campaign or journey, even
     * if quiet time is enabled.
     * </p>
     * <p>
     * To override the default quiet time settings for a specific campaign or journey, use the <link
     * linkend="apps-application-id-campaigns-campaign-id">Campaign</link> resource or the <link
     * linkend="apps-application-id-journeys-journey-id">Journey</link> resource to define a custom quiet time for the
     * campaign or journey.
     * </p>
     * 
     * @return The default quiet time for campaigns in the application. Quiet time is a specific time range when
     *         messages aren't sent to endpoints, if all the following conditions are met:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         The EndpointDemographic.Timezone property of the endpoint is set to a valid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The current time in the endpoint's time zone is later than or equal to the time specified by the
     *         QuietTime.Start property for the application (or a campaign or journey that has custom quiet time
     *         settings).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The current time in the endpoint's time zone is earlier than or equal to the time specified by the
     *         QuietTime.End property for the application (or a campaign or journey that has custom quiet time
     *         settings).
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If any of the preceding conditions isn't met, the endpoint will receive messages from a campaign or
     *         journey, even if quiet time is enabled.
     *         </p>
     *         <p>
     *         To override the default quiet time settings for a specific campaign or journey, use the <link
     *         linkend="apps-application-id-campaigns-campaign-id">Campaign</link> resource or the <link
     *         linkend="apps-application-id-journeys-journey-id">Journey</link> resource to define a custom quiet time
     *         for the campaign or journey.
     */
    public QuietTime quietTime() {
        return quietTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(campaignHook());
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchMetricsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(eventTaggingEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(limits());
        hashCode = 31 * hashCode + Objects.hashCode(quietTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WriteApplicationSettingsRequest)) {
            return false;
        }
        WriteApplicationSettingsRequest other = (WriteApplicationSettingsRequest) obj;
        return Objects.equals(campaignHook(), other.campaignHook())
                && Objects.equals(cloudWatchMetricsEnabled(), other.cloudWatchMetricsEnabled())
                && Objects.equals(eventTaggingEnabled(), other.eventTaggingEnabled()) && Objects.equals(limits(), other.limits())
                && Objects.equals(quietTime(), other.quietTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("WriteApplicationSettingsRequest").add("CampaignHook", campaignHook())
                .add("CloudWatchMetricsEnabled", cloudWatchMetricsEnabled()).add("EventTaggingEnabled", eventTaggingEnabled())
                .add("Limits", limits()).add("QuietTime", quietTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CampaignHook":
            return Optional.ofNullable(clazz.cast(campaignHook()));
        case "CloudWatchMetricsEnabled":
            return Optional.ofNullable(clazz.cast(cloudWatchMetricsEnabled()));
        case "EventTaggingEnabled":
            return Optional.ofNullable(clazz.cast(eventTaggingEnabled()));
        case "Limits":
            return Optional.ofNullable(clazz.cast(limits()));
        case "QuietTime":
            return Optional.ofNullable(clazz.cast(quietTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WriteApplicationSettingsRequest, T> g) {
        return obj -> g.apply((WriteApplicationSettingsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WriteApplicationSettingsRequest> {
        /**
         * <p>
         * The settings for the AWS Lambda function to invoke by default as a code hook for campaigns in the
         * application. You can use this hook to customize segments that are used by campaigns in the application.
         * </p>
         * <p>
         * To override these settings and define custom settings for a specific campaign, use the CampaignHook object of
         * the <link linkend="apps-application-id-campaigns-campaign-id">Campaign</link> resource.
         * </p>
         * 
         * @param campaignHook
         *        The settings for the AWS Lambda function to invoke by default as a code hook for campaigns in the
         *        application. You can use this hook to customize segments that are used by campaigns in the
         *        application.</p>
         *        <p>
         *        To override these settings and define custom settings for a specific campaign, use the CampaignHook
         *        object of the <link linkend="apps-application-id-campaigns-campaign-id">Campaign</link> resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder campaignHook(CampaignHook campaignHook);

        /**
         * <p>
         * The settings for the AWS Lambda function to invoke by default as a code hook for campaigns in the
         * application. You can use this hook to customize segments that are used by campaigns in the application.
         * </p>
         * <p>
         * To override these settings and define custom settings for a specific campaign, use the CampaignHook object of
         * the <link linkend="apps-application-id-campaigns-campaign-id">Campaign</link> resource.
         * </p>
         * This is a convenience that creates an instance of the {@link CampaignHook.Builder} avoiding the need to
         * create one manually via {@link CampaignHook#builder()}.
         *
         * When the {@link Consumer} completes, {@link CampaignHook.Builder#build()} is called immediately and its
         * result is passed to {@link #campaignHook(CampaignHook)}.
         * 
         * @param campaignHook
         *        a consumer that will call methods on {@link CampaignHook.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #campaignHook(CampaignHook)
         */
        default Builder campaignHook(Consumer<CampaignHook.Builder> campaignHook) {
            return campaignHook(CampaignHook.builder().applyMutation(campaignHook).build());
        }

        /**
         * <p>
         * Specifies whether to enable application-related alarms in Amazon CloudWatch.
         * </p>
         * 
         * @param cloudWatchMetricsEnabled
         *        Specifies whether to enable application-related alarms in Amazon CloudWatch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchMetricsEnabled(Boolean cloudWatchMetricsEnabled);

        /**
         * Sets the value of the EventTaggingEnabled property for this object.
         *
         * @param eventTaggingEnabled
         *        The new value for the EventTaggingEnabled property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTaggingEnabled(Boolean eventTaggingEnabled);

        /**
         * <p>
         * The default sending limits for campaigns in the application. To override these limits and define custom
         * limits for a specific campaign or journey, use the <link
         * linkend="apps-application-id-campaigns-campaign-id">Campaign</link> resource or the <link
         * linkend="apps-application-id-journeys-journey-id">Journey</link> resource, respectively.
         * </p>
         * 
         * @param limits
         *        The default sending limits for campaigns in the application. To override these limits and define
         *        custom limits for a specific campaign or journey, use the <link
         *        linkend="apps-application-id-campaigns-campaign-id">Campaign</link> resource or the <link
         *        linkend="apps-application-id-journeys-journey-id">Journey</link> resource, respectively.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limits(CampaignLimits limits);

        /**
         * <p>
         * The default sending limits for campaigns in the application. To override these limits and define custom
         * limits for a specific campaign or journey, use the <link
         * linkend="apps-application-id-campaigns-campaign-id">Campaign</link> resource or the <link
         * linkend="apps-application-id-journeys-journey-id">Journey</link> resource, respectively.
         * </p>
         * This is a convenience that creates an instance of the {@link CampaignLimits.Builder} avoiding the need to
         * create one manually via {@link CampaignLimits#builder()}.
         *
         * When the {@link Consumer} completes, {@link CampaignLimits.Builder#build()} is called immediately and its
         * result is passed to {@link #limits(CampaignLimits)}.
         * 
         * @param limits
         *        a consumer that will call methods on {@link CampaignLimits.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #limits(CampaignLimits)
         */
        default Builder limits(Consumer<CampaignLimits.Builder> limits) {
            return limits(CampaignLimits.builder().applyMutation(limits).build());
        }

        /**
         * <p>
         * The default quiet time for campaigns in the application. Quiet time is a specific time range when messages
         * aren't sent to endpoints, if all the following conditions are met:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The EndpointDemographic.Timezone property of the endpoint is set to a valid value.
         * </p>
         * </li>
         * <li>
         * <p>
         * The current time in the endpoint's time zone is later than or equal to the time specified by the
         * QuietTime.Start property for the application (or a campaign or journey that has custom quiet time settings).
         * </p>
         * </li>
         * <li>
         * <p>
         * The current time in the endpoint's time zone is earlier than or equal to the time specified by the
         * QuietTime.End property for the application (or a campaign or journey that has custom quiet time settings).
         * </p>
         * </li>
         * </ul>
         * <p>
         * If any of the preceding conditions isn't met, the endpoint will receive messages from a campaign or journey,
         * even if quiet time is enabled.
         * </p>
         * <p>
         * To override the default quiet time settings for a specific campaign or journey, use the <link
         * linkend="apps-application-id-campaigns-campaign-id">Campaign</link> resource or the <link
         * linkend="apps-application-id-journeys-journey-id">Journey</link> resource to define a custom quiet time for
         * the campaign or journey.
         * </p>
         * 
         * @param quietTime
         *        The default quiet time for campaigns in the application. Quiet time is a specific time range when
         *        messages aren't sent to endpoints, if all the following conditions are met:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        The EndpointDemographic.Timezone property of the endpoint is set to a valid value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The current time in the endpoint's time zone is later than or equal to the time specified by the
         *        QuietTime.Start property for the application (or a campaign or journey that has custom quiet time
         *        settings).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The current time in the endpoint's time zone is earlier than or equal to the time specified by the
         *        QuietTime.End property for the application (or a campaign or journey that has custom quiet time
         *        settings).
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If any of the preceding conditions isn't met, the endpoint will receive messages from a campaign or
         *        journey, even if quiet time is enabled.
         *        </p>
         *        <p>
         *        To override the default quiet time settings for a specific campaign or journey, use the <link
         *        linkend="apps-application-id-campaigns-campaign-id">Campaign</link> resource or the <link
         *        linkend="apps-application-id-journeys-journey-id">Journey</link> resource to define a custom quiet
         *        time for the campaign or journey.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quietTime(QuietTime quietTime);

        /**
         * <p>
         * The default quiet time for campaigns in the application. Quiet time is a specific time range when messages
         * aren't sent to endpoints, if all the following conditions are met:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The EndpointDemographic.Timezone property of the endpoint is set to a valid value.
         * </p>
         * </li>
         * <li>
         * <p>
         * The current time in the endpoint's time zone is later than or equal to the time specified by the
         * QuietTime.Start property for the application (or a campaign or journey that has custom quiet time settings).
         * </p>
         * </li>
         * <li>
         * <p>
         * The current time in the endpoint's time zone is earlier than or equal to the time specified by the
         * QuietTime.End property for the application (or a campaign or journey that has custom quiet time settings).
         * </p>
         * </li>
         * </ul>
         * <p>
         * If any of the preceding conditions isn't met, the endpoint will receive messages from a campaign or journey,
         * even if quiet time is enabled.
         * </p>
         * <p>
         * To override the default quiet time settings for a specific campaign or journey, use the <link
         * linkend="apps-application-id-campaigns-campaign-id">Campaign</link> resource or the <link
         * linkend="apps-application-id-journeys-journey-id">Journey</link> resource to define a custom quiet time for
         * the campaign or journey.
         * </p>
         * This is a convenience that creates an instance of the {@link QuietTime.Builder} avoiding the need to create
         * one manually via {@link QuietTime#builder()}.
         *
         * When the {@link Consumer} completes, {@link QuietTime.Builder#build()} is called immediately and its result
         * is passed to {@link #quietTime(QuietTime)}.
         * 
         * @param quietTime
         *        a consumer that will call methods on {@link QuietTime.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #quietTime(QuietTime)
         */
        default Builder quietTime(Consumer<QuietTime.Builder> quietTime) {
            return quietTime(QuietTime.builder().applyMutation(quietTime).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CampaignHook campaignHook;

        private Boolean cloudWatchMetricsEnabled;

        private Boolean eventTaggingEnabled;

        private CampaignLimits limits;

        private QuietTime quietTime;

        private BuilderImpl() {
        }

        private BuilderImpl(WriteApplicationSettingsRequest model) {
            campaignHook(model.campaignHook);
            cloudWatchMetricsEnabled(model.cloudWatchMetricsEnabled);
            eventTaggingEnabled(model.eventTaggingEnabled);
            limits(model.limits);
            quietTime(model.quietTime);
        }

        public final CampaignHook.Builder getCampaignHook() {
            return campaignHook != null ? campaignHook.toBuilder() : null;
        }

        @Override
        public final Builder campaignHook(CampaignHook campaignHook) {
            this.campaignHook = campaignHook;
            return this;
        }

        public final void setCampaignHook(CampaignHook.BuilderImpl campaignHook) {
            this.campaignHook = campaignHook != null ? campaignHook.build() : null;
        }

        public final Boolean getCloudWatchMetricsEnabled() {
            return cloudWatchMetricsEnabled;
        }

        @Override
        public final Builder cloudWatchMetricsEnabled(Boolean cloudWatchMetricsEnabled) {
            this.cloudWatchMetricsEnabled = cloudWatchMetricsEnabled;
            return this;
        }

        public final void setCloudWatchMetricsEnabled(Boolean cloudWatchMetricsEnabled) {
            this.cloudWatchMetricsEnabled = cloudWatchMetricsEnabled;
        }

        public final Boolean getEventTaggingEnabled() {
            return eventTaggingEnabled;
        }

        @Override
        public final Builder eventTaggingEnabled(Boolean eventTaggingEnabled) {
            this.eventTaggingEnabled = eventTaggingEnabled;
            return this;
        }

        public final void setEventTaggingEnabled(Boolean eventTaggingEnabled) {
            this.eventTaggingEnabled = eventTaggingEnabled;
        }

        public final CampaignLimits.Builder getLimits() {
            return limits != null ? limits.toBuilder() : null;
        }

        @Override
        public final Builder limits(CampaignLimits limits) {
            this.limits = limits;
            return this;
        }

        public final void setLimits(CampaignLimits.BuilderImpl limits) {
            this.limits = limits != null ? limits.build() : null;
        }

        public final QuietTime.Builder getQuietTime() {
            return quietTime != null ? quietTime.toBuilder() : null;
        }

        @Override
        public final Builder quietTime(QuietTime quietTime) {
            this.quietTime = quietTime;
            return this;
        }

        public final void setQuietTime(QuietTime.BuilderImpl quietTime) {
            this.quietTime = quietTime != null ? quietTime.build() : null;
        }

        @Override
        public WriteApplicationSettingsRequest build() {
            return new WriteApplicationSettingsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
