/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateApnsSandboxChannelRequest extends PinpointRequest implements
        ToCopyableBuilder<UpdateApnsSandboxChannelRequest.Builder, UpdateApnsSandboxChannelRequest> {
    private static final SdkField<APNSSandboxChannelRequest> APNS_SANDBOX_CHANNEL_REQUEST_FIELD = SdkField
            .<APNSSandboxChannelRequest> builder(MarshallingType.SDK_POJO)
            .memberName("APNSSandboxChannelRequest")
            .getter(getter(UpdateApnsSandboxChannelRequest::apnsSandboxChannelRequest))
            .setter(setter(Builder::apnsSandboxChannelRequest))
            .constructor(APNSSandboxChannelRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("APNSSandboxChannelRequest").build(),
                    PayloadTrait.create()).build();

    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationId").getter(getter(UpdateApnsSandboxChannelRequest::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("application-id").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            APNS_SANDBOX_CHANNEL_REQUEST_FIELD, APPLICATION_ID_FIELD));

    private final APNSSandboxChannelRequest apnsSandboxChannelRequest;

    private final String applicationId;

    private UpdateApnsSandboxChannelRequest(BuilderImpl builder) {
        super(builder);
        this.apnsSandboxChannelRequest = builder.apnsSandboxChannelRequest;
        this.applicationId = builder.applicationId;
    }

    /**
     * Returns the value of the APNSSandboxChannelRequest property for this object.
     * 
     * @return The value of the APNSSandboxChannelRequest property for this object.
     */
    public APNSSandboxChannelRequest apnsSandboxChannelRequest() {
        return apnsSandboxChannelRequest;
    }

    /**
     * <p>
     * The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon
     * Pinpoint console.
     * </p>
     * 
     * @return The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the
     *         Amazon Pinpoint console.
     */
    public String applicationId() {
        return applicationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(apnsSandboxChannelRequest());
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateApnsSandboxChannelRequest)) {
            return false;
        }
        UpdateApnsSandboxChannelRequest other = (UpdateApnsSandboxChannelRequest) obj;
        return Objects.equals(apnsSandboxChannelRequest(), other.apnsSandboxChannelRequest())
                && Objects.equals(applicationId(), other.applicationId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateApnsSandboxChannelRequest").add("APNSSandboxChannelRequest", apnsSandboxChannelRequest())
                .add("ApplicationId", applicationId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "APNSSandboxChannelRequest":
            return Optional.ofNullable(clazz.cast(apnsSandboxChannelRequest()));
        case "ApplicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateApnsSandboxChannelRequest, T> g) {
        return obj -> g.apply((UpdateApnsSandboxChannelRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateApnsSandboxChannelRequest> {
        /**
         * Sets the value of the APNSSandboxChannelRequest property for this object.
         *
         * @param apnsSandboxChannelRequest
         *        The new value for the APNSSandboxChannelRequest property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apnsSandboxChannelRequest(APNSSandboxChannelRequest apnsSandboxChannelRequest);

        /**
         * Sets the value of the APNSSandboxChannelRequest property for this object.
         *
         * This is a convenience that creates an instance of the {@link APNSSandboxChannelRequest.Builder} avoiding the
         * need to create one manually via {@link APNSSandboxChannelRequest#builder()}.
         *
         * When the {@link Consumer} completes, {@link APNSSandboxChannelRequest.Builder#build()} is called immediately
         * and its result is passed to {@link #apnsSandboxChannelRequest(APNSSandboxChannelRequest)}.
         * 
         * @param apnsSandboxChannelRequest
         *        a consumer that will call methods on {@link APNSSandboxChannelRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #apnsSandboxChannelRequest(APNSSandboxChannelRequest)
         */
        default Builder apnsSandboxChannelRequest(Consumer<APNSSandboxChannelRequest.Builder> apnsSandboxChannelRequest) {
            return apnsSandboxChannelRequest(APNSSandboxChannelRequest.builder().applyMutation(apnsSandboxChannelRequest).build());
        }

        /**
         * <p>
         * The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the
         * Amazon Pinpoint console.
         * </p>
         * 
         * @param applicationId
         *        The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on
         *        the Amazon Pinpoint console.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PinpointRequest.BuilderImpl implements Builder {
        private APNSSandboxChannelRequest apnsSandboxChannelRequest;

        private String applicationId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateApnsSandboxChannelRequest model) {
            super(model);
            apnsSandboxChannelRequest(model.apnsSandboxChannelRequest);
            applicationId(model.applicationId);
        }

        public final APNSSandboxChannelRequest.Builder getApnsSandboxChannelRequest() {
            return apnsSandboxChannelRequest != null ? apnsSandboxChannelRequest.toBuilder() : null;
        }

        @Override
        public final Builder apnsSandboxChannelRequest(APNSSandboxChannelRequest apnsSandboxChannelRequest) {
            this.apnsSandboxChannelRequest = apnsSandboxChannelRequest;
            return this;
        }

        public final void setApnsSandboxChannelRequest(APNSSandboxChannelRequest.BuilderImpl apnsSandboxChannelRequest) {
            this.apnsSandboxChannelRequest = apnsSandboxChannelRequest != null ? apnsSandboxChannelRequest.build() : null;
        }

        public final String getApplicationId() {
            return applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateApnsSandboxChannelRequest build() {
            return new UpdateApnsSandboxChannelRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
