/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the results of a query that retrieved the data for a standard metric that applies to an application,
 * campaign, or journey.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResultRow implements SdkPojo, Serializable, ToCopyableBuilder<ResultRow.Builder, ResultRow> {
    private static final SdkField<List<ResultRowValue>> GROUPED_BYS_FIELD = SdkField
            .<List<ResultRowValue>> builder(MarshallingType.LIST)
            .memberName("GroupedBys")
            .getter(getter(ResultRow::groupedBys))
            .setter(setter(Builder::groupedBys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupedBys").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResultRowValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResultRowValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ResultRowValue>> VALUES_FIELD = SdkField
            .<List<ResultRowValue>> builder(MarshallingType.LIST)
            .memberName("Values")
            .getter(getter(ResultRow::values))
            .setter(setter(Builder::values))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Values").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResultRowValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResultRowValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUPED_BYS_FIELD,
            VALUES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<ResultRowValue> groupedBys;

    private final List<ResultRowValue> values;

    private ResultRow(BuilderImpl builder) {
        this.groupedBys = builder.groupedBys;
        this.values = builder.values;
    }

    /**
     * Returns true if the GroupedBys property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasGroupedBys() {
        return groupedBys != null && !(groupedBys instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects that defines the field and field values that were used to group data in a result set that
     * contains multiple results. This value is null if the data in a result set isn’t grouped.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasGroupedBys()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of objects that defines the field and field values that were used to group data in a result set
     *         that contains multiple results. This value is null if the data in a result set isn’t grouped.
     */
    public List<ResultRowValue> groupedBys() {
        return groupedBys;
    }

    /**
     * Returns true if the Values property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasValues() {
        return values != null && !(values instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects that provides pre-aggregated values for a standard metric that applies to an application,
     * campaign, or journey.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasValues()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of objects that provides pre-aggregated values for a standard metric that applies to an
     *         application, campaign, or journey.
     */
    public List<ResultRowValue> values() {
        return values;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(groupedBys());
        hashCode = 31 * hashCode + Objects.hashCode(values());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResultRow)) {
            return false;
        }
        ResultRow other = (ResultRow) obj;
        return Objects.equals(groupedBys(), other.groupedBys()) && Objects.equals(values(), other.values());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ResultRow").add("GroupedBys", groupedBys()).add("Values", values()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupedBys":
            return Optional.ofNullable(clazz.cast(groupedBys()));
        case "Values":
            return Optional.ofNullable(clazz.cast(values()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResultRow, T> g) {
        return obj -> g.apply((ResultRow) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResultRow> {
        /**
         * <p>
         * An array of objects that defines the field and field values that were used to group data in a result set that
         * contains multiple results. This value is null if the data in a result set isn’t grouped.
         * </p>
         * 
         * @param groupedBys
         *        An array of objects that defines the field and field values that were used to group data in a result
         *        set that contains multiple results. This value is null if the data in a result set isn’t grouped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupedBys(Collection<ResultRowValue> groupedBys);

        /**
         * <p>
         * An array of objects that defines the field and field values that were used to group data in a result set that
         * contains multiple results. This value is null if the data in a result set isn’t grouped.
         * </p>
         * 
         * @param groupedBys
         *        An array of objects that defines the field and field values that were used to group data in a result
         *        set that contains multiple results. This value is null if the data in a result set isn’t grouped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupedBys(ResultRowValue... groupedBys);

        /**
         * <p>
         * An array of objects that defines the field and field values that were used to group data in a result set that
         * contains multiple results. This value is null if the data in a result set isn’t grouped.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ResultRowValue>.Builder} avoiding the need
         * to create one manually via {@link List<ResultRowValue>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ResultRowValue>.Builder#build()} is called immediately and
         * its result is passed to {@link #groupedBys(List<ResultRowValue>)}.
         * 
         * @param groupedBys
         *        a consumer that will call methods on {@link List<ResultRowValue>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #groupedBys(List<ResultRowValue>)
         */
        Builder groupedBys(Consumer<ResultRowValue.Builder>... groupedBys);

        /**
         * <p>
         * An array of objects that provides pre-aggregated values for a standard metric that applies to an application,
         * campaign, or journey.
         * </p>
         * 
         * @param values
         *        An array of objects that provides pre-aggregated values for a standard metric that applies to an
         *        application, campaign, or journey.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(Collection<ResultRowValue> values);

        /**
         * <p>
         * An array of objects that provides pre-aggregated values for a standard metric that applies to an application,
         * campaign, or journey.
         * </p>
         * 
         * @param values
         *        An array of objects that provides pre-aggregated values for a standard metric that applies to an
         *        application, campaign, or journey.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(ResultRowValue... values);

        /**
         * <p>
         * An array of objects that provides pre-aggregated values for a standard metric that applies to an application,
         * campaign, or journey.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ResultRowValue>.Builder} avoiding the need
         * to create one manually via {@link List<ResultRowValue>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ResultRowValue>.Builder#build()} is called immediately and
         * its result is passed to {@link #values(List<ResultRowValue>)}.
         * 
         * @param values
         *        a consumer that will call methods on {@link List<ResultRowValue>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #values(List<ResultRowValue>)
         */
        Builder values(Consumer<ResultRowValue.Builder>... values);
    }

    static final class BuilderImpl implements Builder {
        private List<ResultRowValue> groupedBys = DefaultSdkAutoConstructList.getInstance();

        private List<ResultRowValue> values = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ResultRow model) {
            groupedBys(model.groupedBys);
            values(model.values);
        }

        public final Collection<ResultRowValue.Builder> getGroupedBys() {
            return groupedBys != null ? groupedBys.stream().map(ResultRowValue::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder groupedBys(Collection<ResultRowValue> groupedBys) {
            this.groupedBys = ListOfResultRowValueCopier.copy(groupedBys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupedBys(ResultRowValue... groupedBys) {
            groupedBys(Arrays.asList(groupedBys));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupedBys(Consumer<ResultRowValue.Builder>... groupedBys) {
            groupedBys(Stream.of(groupedBys).map(c -> ResultRowValue.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setGroupedBys(Collection<ResultRowValue.BuilderImpl> groupedBys) {
            this.groupedBys = ListOfResultRowValueCopier.copyFromBuilder(groupedBys);
        }

        public final Collection<ResultRowValue.Builder> getValues() {
            return values != null ? values.stream().map(ResultRowValue::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder values(Collection<ResultRowValue> values) {
            this.values = ListOfResultRowValueCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(ResultRowValue... values) {
            values(Arrays.asList(values));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(Consumer<ResultRowValue.Builder>... values) {
            values(Stream.of(values).map(c -> ResultRowValue.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setValues(Collection<ResultRowValue.BuilderImpl> values) {
            this.values = ListOfResultRowValueCopier.copyFromBuilder(values);
        }

        @Override
        public ResultRow build() {
            return new ResultRow(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
