/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the status and settings of the APNs (Apple Push Notification service) VoIP sandbox channel
 * for an application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class APNSVoipSandboxChannelResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<APNSVoipSandboxChannelResponse.Builder, APNSVoipSandboxChannelResponse> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationId").getter(getter(APNSVoipSandboxChannelResponse::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationId").build()).build();

    private static final SdkField<String> CREATION_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreationDate").getter(getter(APNSVoipSandboxChannelResponse::creationDate))
            .setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()).build();

    private static final SdkField<String> DEFAULT_AUTHENTICATION_METHOD_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DefaultAuthenticationMethod")
            .getter(getter(APNSVoipSandboxChannelResponse::defaultAuthenticationMethod))
            .setter(setter(Builder::defaultAuthenticationMethod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultAuthenticationMethod")
                    .build()).build();

    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Enabled").getter(getter(APNSVoipSandboxChannelResponse::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()).build();

    private static final SdkField<Boolean> HAS_CREDENTIAL_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("HasCredential").getter(getter(APNSVoipSandboxChannelResponse::hasCredential))
            .setter(setter(Builder::hasCredential))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HasCredential").build()).build();

    private static final SdkField<Boolean> HAS_TOKEN_KEY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("HasTokenKey").getter(getter(APNSVoipSandboxChannelResponse::hasTokenKey))
            .setter(setter(Builder::hasTokenKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HasTokenKey").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(APNSVoipSandboxChannelResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<Boolean> IS_ARCHIVED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsArchived").getter(getter(APNSVoipSandboxChannelResponse::isArchived))
            .setter(setter(Builder::isArchived))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsArchived").build()).build();

    private static final SdkField<String> LAST_MODIFIED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastModifiedBy").getter(getter(APNSVoipSandboxChannelResponse::lastModifiedBy))
            .setter(setter(Builder::lastModifiedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedBy").build()).build();

    private static final SdkField<String> LAST_MODIFIED_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastModifiedDate").getter(getter(APNSVoipSandboxChannelResponse::lastModifiedDate))
            .setter(setter(Builder::lastModifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()).build();

    private static final SdkField<String> PLATFORM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Platform").getter(getter(APNSVoipSandboxChannelResponse::platform)).setter(setter(Builder::platform))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Platform").build()).build();

    private static final SdkField<Integer> VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Version").getter(getter(APNSVoipSandboxChannelResponse::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            CREATION_DATE_FIELD, DEFAULT_AUTHENTICATION_METHOD_FIELD, ENABLED_FIELD, HAS_CREDENTIAL_FIELD, HAS_TOKEN_KEY_FIELD,
            ID_FIELD, IS_ARCHIVED_FIELD, LAST_MODIFIED_BY_FIELD, LAST_MODIFIED_DATE_FIELD, PLATFORM_FIELD, VERSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String applicationId;

    private final String creationDate;

    private final String defaultAuthenticationMethod;

    private final Boolean enabled;

    private final Boolean hasCredential;

    private final Boolean hasTokenKey;

    private final String id;

    private final Boolean isArchived;

    private final String lastModifiedBy;

    private final String lastModifiedDate;

    private final String platform;

    private final Integer version;

    private APNSVoipSandboxChannelResponse(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.creationDate = builder.creationDate;
        this.defaultAuthenticationMethod = builder.defaultAuthenticationMethod;
        this.enabled = builder.enabled;
        this.hasCredential = builder.hasCredential;
        this.hasTokenKey = builder.hasTokenKey;
        this.id = builder.id;
        this.isArchived = builder.isArchived;
        this.lastModifiedBy = builder.lastModifiedBy;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.platform = builder.platform;
        this.version = builder.version;
    }

    /**
     * <p>
     * The unique identifier for the application that the APNs VoIP sandbox channel applies to.
     * </p>
     * 
     * @return The unique identifier for the application that the APNs VoIP sandbox channel applies to.
     */
    public String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The date and time when the APNs VoIP sandbox channel was enabled.
     * </p>
     * 
     * @return The date and time when the APNs VoIP sandbox channel was enabled.
     */
    public String creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The default authentication method that Amazon Pinpoint uses to authenticate with the APNs sandbox environment for
     * this channel, key or certificate.
     * </p>
     * 
     * @return The default authentication method that Amazon Pinpoint uses to authenticate with the APNs sandbox
     *         environment for this channel, key or certificate.
     */
    public String defaultAuthenticationMethod() {
        return defaultAuthenticationMethod;
    }

    /**
     * <p>
     * Specifies whether the APNs VoIP sandbox channel is enabled for the application.
     * </p>
     * 
     * @return Specifies whether the APNs VoIP sandbox channel is enabled for the application.
     */
    public Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * (Not used) This property is retained only for backward compatibility.
     * </p>
     * 
     * @return (Not used) This property is retained only for backward compatibility.
     */
    public Boolean hasCredential() {
        return hasCredential;
    }

    /**
     * <p>
     * Specifies whether the APNs VoIP sandbox channel is configured to communicate with APNs by using APNs tokens. To
     * provide an authentication key for APNs tokens, set the TokenKey property of the channel.
     * </p>
     * 
     * @return Specifies whether the APNs VoIP sandbox channel is configured to communicate with APNs by using APNs
     *         tokens. To provide an authentication key for APNs tokens, set the TokenKey property of the channel.
     */
    public Boolean hasTokenKey() {
        return hasTokenKey;
    }

    /**
     * <p>
     * (Deprecated) An identifier for the APNs VoIP sandbox channel. This property is retained only for backward
     * compatibility.
     * </p>
     * 
     * @return (Deprecated) An identifier for the APNs VoIP sandbox channel. This property is retained only for backward
     *         compatibility.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * Specifies whether the APNs VoIP sandbox channel is archived.
     * </p>
     * 
     * @return Specifies whether the APNs VoIP sandbox channel is archived.
     */
    public Boolean isArchived() {
        return isArchived;
    }

    /**
     * <p>
     * The user who last modified the APNs VoIP sandbox channel.
     * </p>
     * 
     * @return The user who last modified the APNs VoIP sandbox channel.
     */
    public String lastModifiedBy() {
        return lastModifiedBy;
    }

    /**
     * <p>
     * The date and time when the APNs VoIP sandbox channel was last modified.
     * </p>
     * 
     * @return The date and time when the APNs VoIP sandbox channel was last modified.
     */
    public String lastModifiedDate() {
        return lastModifiedDate;
    }

    /**
     * <p>
     * The type of messaging or notification platform for the channel. For the APNs VoIP sandbox channel, this value is
     * APNS_VOIP_SANDBOX.
     * </p>
     * 
     * @return The type of messaging or notification platform for the channel. For the APNs VoIP sandbox channel, this
     *         value is APNS_VOIP_SANDBOX.
     */
    public String platform() {
        return platform;
    }

    /**
     * <p>
     * The current version of the APNs VoIP sandbox channel.
     * </p>
     * 
     * @return The current version of the APNs VoIP sandbox channel.
     */
    public Integer version() {
        return version;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(defaultAuthenticationMethod());
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(hasCredential());
        hashCode = 31 * hashCode + Objects.hashCode(hasTokenKey());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(isArchived());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedBy());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(platform());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof APNSVoipSandboxChannelResponse)) {
            return false;
        }
        APNSVoipSandboxChannelResponse other = (APNSVoipSandboxChannelResponse) obj;
        return Objects.equals(applicationId(), other.applicationId()) && Objects.equals(creationDate(), other.creationDate())
                && Objects.equals(defaultAuthenticationMethod(), other.defaultAuthenticationMethod())
                && Objects.equals(enabled(), other.enabled()) && Objects.equals(hasCredential(), other.hasCredential())
                && Objects.equals(hasTokenKey(), other.hasTokenKey()) && Objects.equals(id(), other.id())
                && Objects.equals(isArchived(), other.isArchived()) && Objects.equals(lastModifiedBy(), other.lastModifiedBy())
                && Objects.equals(lastModifiedDate(), other.lastModifiedDate()) && Objects.equals(platform(), other.platform())
                && Objects.equals(version(), other.version());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("APNSVoipSandboxChannelResponse").add("ApplicationId", applicationId())
                .add("CreationDate", creationDate()).add("DefaultAuthenticationMethod", defaultAuthenticationMethod())
                .add("Enabled", enabled()).add("HasCredential", hasCredential()).add("HasTokenKey", hasTokenKey())
                .add("Id", id()).add("IsArchived", isArchived()).add("LastModifiedBy", lastModifiedBy())
                .add("LastModifiedDate", lastModifiedDate()).add("Platform", platform()).add("Version", version()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "CreationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "DefaultAuthenticationMethod":
            return Optional.ofNullable(clazz.cast(defaultAuthenticationMethod()));
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "HasCredential":
            return Optional.ofNullable(clazz.cast(hasCredential()));
        case "HasTokenKey":
            return Optional.ofNullable(clazz.cast(hasTokenKey()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "IsArchived":
            return Optional.ofNullable(clazz.cast(isArchived()));
        case "LastModifiedBy":
            return Optional.ofNullable(clazz.cast(lastModifiedBy()));
        case "LastModifiedDate":
            return Optional.ofNullable(clazz.cast(lastModifiedDate()));
        case "Platform":
            return Optional.ofNullable(clazz.cast(platform()));
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<APNSVoipSandboxChannelResponse, T> g) {
        return obj -> g.apply((APNSVoipSandboxChannelResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, APNSVoipSandboxChannelResponse> {
        /**
         * <p>
         * The unique identifier for the application that the APNs VoIP sandbox channel applies to.
         * </p>
         * 
         * @param applicationId
         *        The unique identifier for the application that the APNs VoIP sandbox channel applies to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The date and time when the APNs VoIP sandbox channel was enabled.
         * </p>
         * 
         * @param creationDate
         *        The date and time when the APNs VoIP sandbox channel was enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(String creationDate);

        /**
         * <p>
         * The default authentication method that Amazon Pinpoint uses to authenticate with the APNs sandbox environment
         * for this channel, key or certificate.
         * </p>
         * 
         * @param defaultAuthenticationMethod
         *        The default authentication method that Amazon Pinpoint uses to authenticate with the APNs sandbox
         *        environment for this channel, key or certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultAuthenticationMethod(String defaultAuthenticationMethod);

        /**
         * <p>
         * Specifies whether the APNs VoIP sandbox channel is enabled for the application.
         * </p>
         * 
         * @param enabled
         *        Specifies whether the APNs VoIP sandbox channel is enabled for the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * (Not used) This property is retained only for backward compatibility.
         * </p>
         * 
         * @param hasCredential
         *        (Not used) This property is retained only for backward compatibility.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hasCredential(Boolean hasCredential);

        /**
         * <p>
         * Specifies whether the APNs VoIP sandbox channel is configured to communicate with APNs by using APNs tokens.
         * To provide an authentication key for APNs tokens, set the TokenKey property of the channel.
         * </p>
         * 
         * @param hasTokenKey
         *        Specifies whether the APNs VoIP sandbox channel is configured to communicate with APNs by using APNs
         *        tokens. To provide an authentication key for APNs tokens, set the TokenKey property of the channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hasTokenKey(Boolean hasTokenKey);

        /**
         * <p>
         * (Deprecated) An identifier for the APNs VoIP sandbox channel. This property is retained only for backward
         * compatibility.
         * </p>
         * 
         * @param id
         *        (Deprecated) An identifier for the APNs VoIP sandbox channel. This property is retained only for
         *        backward compatibility.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * Specifies whether the APNs VoIP sandbox channel is archived.
         * </p>
         * 
         * @param isArchived
         *        Specifies whether the APNs VoIP sandbox channel is archived.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isArchived(Boolean isArchived);

        /**
         * <p>
         * The user who last modified the APNs VoIP sandbox channel.
         * </p>
         * 
         * @param lastModifiedBy
         *        The user who last modified the APNs VoIP sandbox channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedBy(String lastModifiedBy);

        /**
         * <p>
         * The date and time when the APNs VoIP sandbox channel was last modified.
         * </p>
         * 
         * @param lastModifiedDate
         *        The date and time when the APNs VoIP sandbox channel was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(String lastModifiedDate);

        /**
         * <p>
         * The type of messaging or notification platform for the channel. For the APNs VoIP sandbox channel, this value
         * is APNS_VOIP_SANDBOX.
         * </p>
         * 
         * @param platform
         *        The type of messaging or notification platform for the channel. For the APNs VoIP sandbox channel,
         *        this value is APNS_VOIP_SANDBOX.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platform(String platform);

        /**
         * <p>
         * The current version of the APNs VoIP sandbox channel.
         * </p>
         * 
         * @param version
         *        The current version of the APNs VoIP sandbox channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(Integer version);
    }

    static final class BuilderImpl implements Builder {
        private String applicationId;

        private String creationDate;

        private String defaultAuthenticationMethod;

        private Boolean enabled;

        private Boolean hasCredential;

        private Boolean hasTokenKey;

        private String id;

        private Boolean isArchived;

        private String lastModifiedBy;

        private String lastModifiedDate;

        private String platform;

        private Integer version;

        private BuilderImpl() {
        }

        private BuilderImpl(APNSVoipSandboxChannelResponse model) {
            applicationId(model.applicationId);
            creationDate(model.creationDate);
            defaultAuthenticationMethod(model.defaultAuthenticationMethod);
            enabled(model.enabled);
            hasCredential(model.hasCredential);
            hasTokenKey(model.hasTokenKey);
            id(model.id);
            isArchived(model.isArchived);
            lastModifiedBy(model.lastModifiedBy);
            lastModifiedDate(model.lastModifiedDate);
            platform(model.platform);
            version(model.version);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final String getCreationDate() {
            return creationDate;
        }

        @Override
        public final Builder creationDate(String creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(String creationDate) {
            this.creationDate = creationDate;
        }

        public final String getDefaultAuthenticationMethod() {
            return defaultAuthenticationMethod;
        }

        @Override
        public final Builder defaultAuthenticationMethod(String defaultAuthenticationMethod) {
            this.defaultAuthenticationMethod = defaultAuthenticationMethod;
            return this;
        }

        public final void setDefaultAuthenticationMethod(String defaultAuthenticationMethod) {
            this.defaultAuthenticationMethod = defaultAuthenticationMethod;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final Boolean getHasCredential() {
            return hasCredential;
        }

        @Override
        public final Builder hasCredential(Boolean hasCredential) {
            this.hasCredential = hasCredential;
            return this;
        }

        public final void setHasCredential(Boolean hasCredential) {
            this.hasCredential = hasCredential;
        }

        public final Boolean getHasTokenKey() {
            return hasTokenKey;
        }

        @Override
        public final Builder hasTokenKey(Boolean hasTokenKey) {
            this.hasTokenKey = hasTokenKey;
            return this;
        }

        public final void setHasTokenKey(Boolean hasTokenKey) {
            this.hasTokenKey = hasTokenKey;
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final Boolean getIsArchived() {
            return isArchived;
        }

        @Override
        public final Builder isArchived(Boolean isArchived) {
            this.isArchived = isArchived;
            return this;
        }

        public final void setIsArchived(Boolean isArchived) {
            this.isArchived = isArchived;
        }

        public final String getLastModifiedBy() {
            return lastModifiedBy;
        }

        @Override
        public final Builder lastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        public final void setLastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
        }

        public final String getLastModifiedDate() {
            return lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final void setLastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        public final String getPlatform() {
            return platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public final Integer getVersion() {
            return version;
        }

        @Override
        public final Builder version(Integer version) {
            this.version = version;
            return this;
        }

        public final void setVersion(Integer version) {
            this.version = version;
        }

        @Override
        public APNSVoipSandboxChannelResponse build() {
            return new APNSVoipSandboxChannelResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
