/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ImportMode {
    FULL("FULL"),
    INCREMENTAL("INCREMENTAL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ImportMode> VALUE_MAP;
    private final String value;

    private ImportMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ImportMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ImportMode> knownValues() {
        EnumSet<ImportMode> knownValues = EnumSet.allOf(ImportMode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ImportMode.class, ImportMode::toString);
    }
}

