/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pcs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pcs.model.PcsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteComputeNodeGroupRequest
extends PcsRequest
implements ToCopyableBuilder<Builder, DeleteComputeNodeGroupRequest> {
    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clusterIdentifier").getter(DeleteComputeNodeGroupRequest.getter(DeleteComputeNodeGroupRequest::clusterIdentifier)).setter(DeleteComputeNodeGroupRequest.setter(Builder::clusterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterIdentifier").build()}).build();
    private static final SdkField<String> COMPUTE_NODE_GROUP_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("computeNodeGroupIdentifier").getter(DeleteComputeNodeGroupRequest.getter(DeleteComputeNodeGroupRequest::computeNodeGroupIdentifier)).setter(DeleteComputeNodeGroupRequest.setter(Builder::computeNodeGroupIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeNodeGroupIdentifier").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(DeleteComputeNodeGroupRequest.getter(DeleteComputeNodeGroupRequest::clientToken)).setter(DeleteComputeNodeGroupRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_IDENTIFIER_FIELD, COMPUTE_NODE_GROUP_IDENTIFIER_FIELD, CLIENT_TOKEN_FIELD));
    private final String clusterIdentifier;
    private final String computeNodeGroupIdentifier;
    private final String clientToken;

    private DeleteComputeNodeGroupRequest(BuilderImpl builder) {
        super(builder);
        this.clusterIdentifier = builder.clusterIdentifier;
        this.computeNodeGroupIdentifier = builder.computeNodeGroupIdentifier;
        this.clientToken = builder.clientToken;
    }

    public final String clusterIdentifier() {
        return this.clusterIdentifier;
    }

    public final String computeNodeGroupIdentifier() {
        return this.computeNodeGroupIdentifier;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeNodeGroupIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteComputeNodeGroupRequest)) {
            return false;
        }
        DeleteComputeNodeGroupRequest other = (DeleteComputeNodeGroupRequest)((Object)obj);
        return Objects.equals(this.clusterIdentifier(), other.clusterIdentifier()) && Objects.equals(this.computeNodeGroupIdentifier(), other.computeNodeGroupIdentifier()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteComputeNodeGroupRequest").add("ClusterIdentifier", (Object)this.clusterIdentifier()).add("ComputeNodeGroupIdentifier", (Object)this.computeNodeGroupIdentifier()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.clusterIdentifier()));
            }
            case "computeNodeGroupIdentifier": {
                return Optional.ofNullable(clazz.cast(this.computeNodeGroupIdentifier()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteComputeNodeGroupRequest, T> g) {
        return obj -> g.apply((DeleteComputeNodeGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PcsRequest.BuilderImpl
    implements Builder {
        private String clusterIdentifier;
        private String computeNodeGroupIdentifier;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteComputeNodeGroupRequest model) {
            super(model);
            this.clusterIdentifier(model.clusterIdentifier);
            this.computeNodeGroupIdentifier(model.computeNodeGroupIdentifier);
            this.clientToken(model.clientToken);
        }

        public final String getClusterIdentifier() {
            return this.clusterIdentifier;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final String getComputeNodeGroupIdentifier() {
            return this.computeNodeGroupIdentifier;
        }

        public final void setComputeNodeGroupIdentifier(String computeNodeGroupIdentifier) {
            this.computeNodeGroupIdentifier = computeNodeGroupIdentifier;
        }

        @Override
        public final Builder computeNodeGroupIdentifier(String computeNodeGroupIdentifier) {
            this.computeNodeGroupIdentifier = computeNodeGroupIdentifier;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteComputeNodeGroupRequest build() {
            return new DeleteComputeNodeGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PcsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteComputeNodeGroupRequest> {
        public Builder clusterIdentifier(String var1);

        public Builder computeNodeGroupIdentifier(String var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

