/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pcs;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.pcs.model.CreateClusterRequest;
import software.amazon.awssdk.services.pcs.model.CreateClusterResponse;
import software.amazon.awssdk.services.pcs.model.CreateComputeNodeGroupRequest;
import software.amazon.awssdk.services.pcs.model.CreateComputeNodeGroupResponse;
import software.amazon.awssdk.services.pcs.model.CreateQueueRequest;
import software.amazon.awssdk.services.pcs.model.CreateQueueResponse;
import software.amazon.awssdk.services.pcs.model.DeleteClusterRequest;
import software.amazon.awssdk.services.pcs.model.DeleteClusterResponse;
import software.amazon.awssdk.services.pcs.model.DeleteComputeNodeGroupRequest;
import software.amazon.awssdk.services.pcs.model.DeleteComputeNodeGroupResponse;
import software.amazon.awssdk.services.pcs.model.DeleteQueueRequest;
import software.amazon.awssdk.services.pcs.model.DeleteQueueResponse;
import software.amazon.awssdk.services.pcs.model.GetClusterRequest;
import software.amazon.awssdk.services.pcs.model.GetClusterResponse;
import software.amazon.awssdk.services.pcs.model.GetComputeNodeGroupRequest;
import software.amazon.awssdk.services.pcs.model.GetComputeNodeGroupResponse;
import software.amazon.awssdk.services.pcs.model.GetQueueRequest;
import software.amazon.awssdk.services.pcs.model.GetQueueResponse;
import software.amazon.awssdk.services.pcs.model.ListClustersRequest;
import software.amazon.awssdk.services.pcs.model.ListClustersResponse;
import software.amazon.awssdk.services.pcs.model.ListComputeNodeGroupsRequest;
import software.amazon.awssdk.services.pcs.model.ListComputeNodeGroupsResponse;
import software.amazon.awssdk.services.pcs.model.ListQueuesRequest;
import software.amazon.awssdk.services.pcs.model.ListQueuesResponse;
import software.amazon.awssdk.services.pcs.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.pcs.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.pcs.model.RegisterComputeNodeGroupInstanceRequest;
import software.amazon.awssdk.services.pcs.model.RegisterComputeNodeGroupInstanceResponse;
import software.amazon.awssdk.services.pcs.model.TagResourceRequest;
import software.amazon.awssdk.services.pcs.model.TagResourceResponse;
import software.amazon.awssdk.services.pcs.model.UntagResourceRequest;
import software.amazon.awssdk.services.pcs.model.UntagResourceResponse;
import software.amazon.awssdk.services.pcs.model.UpdateComputeNodeGroupRequest;
import software.amazon.awssdk.services.pcs.model.UpdateComputeNodeGroupResponse;
import software.amazon.awssdk.services.pcs.model.UpdateQueueRequest;
import software.amazon.awssdk.services.pcs.model.UpdateQueueResponse;
import software.amazon.awssdk.services.pcs.paginators.ListClustersPublisher;
import software.amazon.awssdk.services.pcs.paginators.ListComputeNodeGroupsPublisher;
import software.amazon.awssdk.services.pcs.paginators.ListQueuesPublisher;

/**
 * Service client for accessing AWS Parallel Computing Service asynchronously. This can be created using the static
 * {@link #builder()} method.The asynchronous client performs non-blocking I/O when configured with any
 * {@code SdkAsyncHttpClient} supported in the SDK. However, full non-blocking is not guaranteed as the async client may
 * perform blocking calls in some cases such as credentials retrieval and endpoint discovery as part of the async API
 * call.
 *
 * <p>
 * Amazon Web Services Parallel Computing Service (Amazon Web Services PCS) is a managed service that makes it easier
 * for you to run and scale your high performance computing (HPC) workloads, and build scientific and engineering models
 * on Amazon Web Services using Slurm. For more information, see the <a
 * href="https://docs.aws.amazon.com/pcs/latest/userguide">Amazon Web Services Parallel Computing Service User
 * Guide</a>.
 * </p>
 * <p>
 * This reference describes the actions and data types of the service management API. You can use the Amazon Web
 * Services SDKs to call the API actions in software, or use the Command Line Interface (CLI) to call the API actions
 * manually. These API actions manage the service through an Amazon Web Services account.
 * </p>
 * <p>
 * The API actions operate on Amazon Web Services PCS resources. A <i>resource</i> is an entity in Amazon Web Services
 * that you can work with. Amazon Web Services services create resources when you use the features of the service.
 * Examples of Amazon Web Services PCS resources include clusters, compute node groups, and queues. For more information
 * about resources in Amazon Web Services, see <a href=
 * "https://docs.aws.amazon.com/resource-explorer/latest/userguide/getting-started-terms-and-concepts.html#term-resource"
 * >Resource</a> in the <i>Resource Explorer User Guide</i>.
 * </p>
 * <p>
 * An Amazon Web Services PCS <i>compute node</i> is an Amazon EC2 instance. You don't launch compute nodes directly.
 * Amazon Web Services PCS uses configuration information that you provide to launch compute nodes in your Amazon Web
 * Services account. You receive billing charges for your running compute nodes. Amazon Web Services PCS automatically
 * terminates your compute nodes when you delete the Amazon Web Services PCS resources related to those compute nodes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface PcsAsyncClient extends AwsClient {
    String SERVICE_NAME = "pcs";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "pcs";

    /**
     * <p>
     * Creates a cluster in your account. Amazon Web Services PCS creates the cluster controller in a service-owned
     * account. The cluster controller communicates with the cluster resources in your account. The subnets and security
     * groups for the cluster must already exist before you use this API action.
     * </p>
     * <note>
     * <p>
     * It takes time for Amazon Web Services PCS to create the cluster. The cluster is in a <code>Creating</code> state
     * until it is ready to use. There can only be 1 cluster in a <code>Creating</code> state per Amazon Web Services
     * Region per Amazon Web Services account. <code>CreateCluster</code> fails with a
     * <code>ServiceQuotaExceededException</code> if there is already a cluster in a <code>Creating</code> state.
     * </p>
     * </note>
     *
     * @param createClusterRequest
     * @return A Java Future containing the result of the CreateCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException You exceeded your service quota. Service quotas, also referred to as
     *         limits, are the maximum number of service resources or operations for your Amazon Web Services account.
     *         To learn how to increase your service quota, see <a
     *         href="https://docs.aws.amazon.com/servicequotas/latest/userguide/request-quota-increase.html">Requesting
     *         a quota increase</a> in the <i>Service Quotas User Guide</i> </p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The max number of clusters or queues has been reached for the account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The max number of compute node groups has been reached for the associated cluster.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The total of <code>maxInstances</code> across all compute node groups has been reached for associated
     *         cluster.
     *         </p>
     *         </li></li>
     *         <li>ThrottlingException Your request exceeded a request rate quota. Check the resource's request rate
     *         quota and try again.</li>
     *         <li>ValidationException The request isn't valid.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your request contains malformed JSON or unsupported characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The scheduler version isn't supported.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There are networking related errors, such as network validation failure.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         AMI type is <code>CUSTOM</code> and the launch template doesn't define the AMI ID, or the AMI type is AL2
     *         and the launch template defines the AMI.
     *         </p>
     *         </li></li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than 1 operation on the same resource at the same time.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A cluster with the same name already exists.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A cluster isn't in <code>ACTIVE</code> status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A cluster to delete is in an unstable state. For example, because it still has <code>ACTIVE</code> node
     *         groups or queues.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A queue already exists in a cluster.
     *         </p>
     *         </li></li>
     *         <li>InternalServerException Amazon Web Services PCS can't process your request right now. Try again
     *         later.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The launch template instance profile doesn't pass <code>iam:PassRole</code> verification.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There is a mismatch between the account ID and cluster ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The cluster ID doesn't exist.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The EC2 instance isn't present.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample PcsAsyncClient.CreateCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pcs-2023-02-10/CreateCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateClusterResponse> createCluster(CreateClusterRequest createClusterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a cluster in your account. Amazon Web Services PCS creates the cluster controller in a service-owned
     * account. The cluster controller communicates with the cluster resources in your account. The subnets and security
     * groups for the cluster must already exist before you use this API action.
     * </p>
     * <note>
     * <p>
     * It takes time for Amazon Web Services PCS to create the cluster. The cluster is in a <code>Creating</code> state
     * until it is ready to use. There can only be 1 cluster in a <code>Creating</code> state per Amazon Web Services
     * Region per Amazon Web Services account. <code>CreateCluster</code> fails with a
     * <code>ServiceQuotaExceededException</code> if there is already a cluster in a <code>Creating</code> state.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateClusterRequest.Builder} avoiding the need to
     * create one manually via {@link CreateClusterRequest#builder()}
     * </p>
     *
     * @param createClusterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pcs.model.CreateClusterRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException You exceeded your service quota. Service quotas, also referred to as
     *         limits, are the maximum number of service resources or operations for your Amazon Web Services account.
     *         To learn how to increase your service quota, see <a
     *         href="https://docs.aws.amazon.com/servicequotas/latest/userguide/request-quota-increase.html">Requesting
     *         a quota increase</a> in the <i>Service Quotas User Guide</i> </p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The max number of clusters or queues has been reached for the account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The max number of compute node groups has been reached for the associated cluster.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The total of <code>maxInstances</code> across all compute node groups has been reached for associated
     *         cluster.
     *         </p>
     *         </li></li>
     *         <li>ThrottlingException Your request exceeded a request rate quota. Check the resource's request rate
     *         quota and try again.</li>
     *         <li>ValidationException The request isn't valid.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your request contains malformed JSON or unsupported characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The scheduler version isn't supported.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There are networking related errors, such as network validation failure.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         AMI type is <code>CUSTOM</code> and the launch template doesn't define the AMI ID, or the AMI type is AL2
     *         and the launch template defines the AMI.
     *         </p>
     *         </li></li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than 1 operation on the same resource at the same time.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A cluster with the same name already exists.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A cluster isn't in <code>ACTIVE</code> status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A cluster to delete is in an unstable state. For example, because it still has <code>ACTIVE</code> node
     *         groups or queues.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A queue already exists in a cluster.
     *         </p>
     *         </li></li>
     *         <li>InternalServerException Amazon Web Services PCS can't process your request right now. Try again
     *         later.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The launch template instance profile doesn't pass <code>iam:PassRole</code> verification.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There is a mismatch between the account ID and cluster ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The cluster ID doesn't exist.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The EC2 instance isn't present.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample PcsAsyncClient.CreateCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pcs-2023-02-10/CreateCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateClusterResponse> createCluster(Consumer<CreateClusterRequest.Builder> createClusterRequest) {
        return createCluster(CreateClusterRequest.builder().applyMutation(createClusterRequest).build());
    }

    /**
     * <p>
     * Creates a managed set of compute nodes. You associate a compute node group with a cluster through 1 or more
     * Amazon Web Services PCS queues or as part of the login fleet. A compute node group includes the definition of the
     * compute properties and lifecycle management. Amazon Web Services PCS uses the information you provide to this API
     * action to launch compute nodes in your account. You can only specify subnets in the same Amazon VPC as your
     * cluster. You receive billing charges for the compute nodes that Amazon Web Services PCS launches in your account.
     * You must already have a launch template before you call this API. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html">Launch an instance from a
     * launch template</a> in the <i>Amazon Elastic Compute Cloud User Guide for Linux Instances</i>.
     * </p>
     *
     * @param createComputeNodeGroupRequest
     * @return A Java Future containing the result of the CreateComputeNodeGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException You exceeded your service quota. Service quotas, also referred to as
     *         limits, are the maximum number of service resources or operations for your Amazon Web Services account.
     *         To learn how to increase your service quota, see <a
     *         href="https://docs.aws.amazon.com/servicequotas/latest/userguide/request-quota-increase.html">Requesting
     *         a quota increase</a> in the <i>Service Quotas User Guide</i> </p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The max number of clusters or queues has been reached for the account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The max number of compute node groups has been reached for the associated cluster.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The total of <code>maxInstances</code> across all compute node groups has been reached for associated
     *         cluster.
     *         </p>
     *         </li></li>
     *         <li>ThrottlingException Your request exceeded a request rate quota. Check the resource's request rate
     *         quota and try again.</li>
     *         <li>ValidationException The request isn't valid.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your request contains malformed JSON or unsupported characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The scheduler version isn't supported.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There are networking related errors, such as network validation failure.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         AMI type is <code>CUSTOM</code> and the launch template doesn't define the AMI ID, or the AMI type is AL2
     *         and the launch template defines the AMI.
     *         </p>
     *         </li></li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than 1 operation on the same resource at the same time.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A cluster with the same name already exists.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A cluster isn't in <code>ACTIVE</code> status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A cluster to delete is in an unstable state. For example, because it still has <code>ACTIVE</code> node
     *         groups or queues.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A queue already exists in a cluster.
     *         </p>
     *         </li></li>
     *         <li>ResourceNotFoundException The requested resource can't be found. The cluster, node group, or queue
     *         you're attempting to get, update, list, or delete doesn't exist.</p>
     *         <p>
     *         <u>Examples</u></li>
     *         <li>InternalServerException Amazon Web Services PCS can't process your request right now. Try again
     *         later.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The launch template instance profile doesn't pass <code>iam:PassRole</code> verification.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There is a mismatch between the account ID and cluster ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The cluster ID doesn't exist.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The EC2 instance isn't present.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample PcsAsyncClient.CreateComputeNodeGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pcs-2023-02-10/CreateComputeNodeGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateComputeNodeGroupResponse> createComputeNodeGroup(
            CreateComputeNodeGroupRequest createComputeNodeGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a managed set of compute nodes. You associate a compute node group with a cluster through 1 or more
     * Amazon Web Services PCS queues or as part of the login fleet. A compute node group includes the definition of the
     * compute properties and lifecycle management. Amazon Web Services PCS uses the information you provide to this API
     * action to launch compute nodes in your account. You can only specify subnets in the same Amazon VPC as your
     * cluster. You receive billing charges for the compute nodes that Amazon Web Services PCS launches in your account.
     * You must already have a launch template before you call this API. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html">Launch an instance from a
     * launch template</a> in the <i>Amazon Elastic Compute Cloud User Guide for Linux Instances</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateComputeNodeGroupRequest.Builder} avoiding the
     * need to create one manually via {@link CreateComputeNodeGroupRequest#builder()}
     * </p>
     *
     * @param createComputeNodeGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pcs.model.CreateComputeNodeGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateComputeNodeGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException You exceeded your service quota. Service quotas, also referred to as
     *         limits, are the maximum number of service resources or operations for your Amazon Web Services account.
     *         To learn how to increase your service quota, see <a
     *         href="https://docs.aws.amazon.com/servicequotas/latest/userguide/request-quota-increase.html">Requesting
     *         a quota increase</a> in the <i>Service Quotas User Guide</i> </p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The max number of clusters or queues has been reached for the account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The max number of compute node groups has been reached for the associated cluster.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The total of <code>maxInstances</code> across all compute node groups has been reached for associated
     *         cluster.
     *         </p>
     *         </li></li>
     *         <li>ThrottlingException Your request exceeded a request rate quota. Check the resource's request rate
     *         quota and try again.</li>
     *         <li>ValidationException The request isn't valid.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your request contains malformed JSON or unsupported characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The scheduler version isn't supported.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There are networking related errors, such as network validation failure.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         AMI type is <code>CUSTOM</code> and the launch template doesn't define the AMI ID, or the AMI type is AL2
     *         and the launch template defines the AMI.
     *         </p>
     *         </li></li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than 1 operation on the same resource at the same time.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A cluster with the same name already exists.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A cluster isn't in <code>ACTIVE</code> status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A cluster to delete is in an unstable state. For example, because it still has <code>ACTIVE</code> node
     *         groups or queues.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A queue already exists in a cluster.
     *         </p>
     *         </li></li>
     *         <li>ResourceNotFoundException The requested resource can't be found. The cluster, node group, or queue
     *         you're attempting to get, update, list, or delete doesn't exist.</p>
     *         <p>
     *         <u>Examples</u></li>
     *         <li>InternalServerException Amazon Web Services PCS can't process your request right now. Try again
     *         later.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The launch template instance profile doesn't pass <code>iam:PassRole</code> verification.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There is a mismatch between the account ID and cluster ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The cluster ID doesn't exist.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The EC2 instance isn't present.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample PcsAsyncClient.CreateComputeNodeGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pcs-2023-02-10/CreateComputeNodeGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateComputeNodeGroupResponse> createComputeNodeGroup(
            Consumer<CreateComputeNodeGroupRequest.Builder> createComputeNodeGroupRequest) {
        return createComputeNodeGroup(CreateComputeNodeGroupRequest.builder().applyMutation(createComputeNodeGroupRequest)
                .build());
    }

    /**
     * <p>
     * Creates a job queue. You must associate 1 or more compute node groups with the queue. You can associate 1 compute
     * node group with multiple queues.
     * </p>
     *
     * @param createQueueRequest
     * @return A Java Future containing the result of the CreateQueue operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException You exceeded your service quota. Service quotas, also referred to as
     *         limits, are the maximum number of service resources or operations for your Amazon Web Services account.
     *         To learn how to increase your service quota, see <a
     *         href="https://docs.aws.amazon.com/servicequotas/latest/userguide/request-quota-increase.html">Requesting
     *         a quota increase</a> in the <i>Service Quotas User Guide</i> </p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The max number of clusters or queues has been reached for the account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The max number of compute node groups has been reached for the associated cluster.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The total of <code>maxInstances</code> across all compute node groups has been reached for associated
     *         cluster.
     *         </p>
     *         </li></li>
     *         <li>ThrottlingException Your request exceeded a request rate quota. Check the resource's request rate
     *         quota and try again.</li>
     *         <li>ValidationException The request isn't valid.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your request contains malformed JSON or unsupported characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The scheduler version isn't supported.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There are networking related errors, such as network validation failure.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         AMI type is <code>CUSTOM</code> and the launch template doesn't define the AMI ID, or the AMI type is AL2
     *         and the launch template defines the AMI.
     *         </p>
     *         </li></li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than 1 operation on the same resource at the same time.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A cluster with the same name already exists.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A cluster isn't in <code>ACTIVE</code> status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A cluster to delete is in an unstable state. For example, because it still has <code>ACTIVE</code> node
     *         groups or queues.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A queue already exists in a cluster.
     *         </p>
     *         </li></li>
     *         <li>ResourceNotFoundException The requested resource can't be found. The cluster, node group, or queue
     *         you're attempting to get, update, list, or delete doesn't exist.</p>
     *         <p>
     *         <u>Examples</u></li>
     *         <li>InternalServerException Amazon Web Services PCS can't process your request right now. Try again
     *         later.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The launch template instance profile doesn't pass <code>iam:PassRole</code> verification.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There is a mismatch between the account ID and cluster ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The cluster ID doesn't exist.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The EC2 instance isn't present.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample PcsAsyncClient.CreateQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pcs-2023-02-10/CreateQueue" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateQueueResponse> createQueue(CreateQueueRequest createQueueRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a job queue. You must associate 1 or more compute node groups with the queue. You can associate 1 compute
     * node group with multiple queues.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateQueueRequest.Builder} avoiding the need to
     * create one manually via {@link CreateQueueRequest#builder()}
     * </p>
     *
     * @param createQueueRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pcs.model.CreateQueueRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateQueue operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException You exceeded your service quota. Service quotas, also referred to as
     *         limits, are the maximum number of service resources or operations for your Amazon Web Services account.
     *         To learn how to increase your service quota, see <a
     *         href="https://docs.aws.amazon.com/servicequotas/latest/userguide/request-quota-increase.html">Requesting
     *         a quota increase</a> in the <i>Service Quotas User Guide</i> </p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The max number of clusters or queues has been reached for the account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The max number of compute node groups has been reached for the associated cluster.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The total of <code>maxInstances</code> across all compute node groups has been reached for associated
     *         cluster.
     *         </p>
     *         </li></li>
     *         <li>ThrottlingException Your request exceeded a request rate quota. Check the resource's request rate
     *         quota and try again.</li>
     *         <li>ValidationException The request isn't valid.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your request contains malformed JSON or unsupported characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The scheduler version isn't supported.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There are networking related errors, such as network validation failure.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         AMI type is <code>CUSTOM</code> and the launch template doesn't define the AMI ID, or the AMI type is AL2
     *         and the launch template defines the AMI.
     *         </p>
     *         </li></li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than 1 operation on the same resource at the same time.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A cluster with the same name already exists.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A cluster isn't in <code>ACTIVE</code> status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A cluster to delete is in an unstable state. For example, because it still has <code>ACTIVE</code> node
     *         groups or queues.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A queue already exists in a cluster.
     *         </p>
     *         </li></li>
     *         <li>ResourceNotFoundException The requested resource can't be found. The cluster, node group, or queue
     *         you're attempting to get, update, list, or delete doesn't exist.</p>
     *         <p>
     *         <u>Examples</u></li>
     *         <li>InternalServerException Amazon Web Services PCS can't process your request right now. Try again
     *         later.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The launch template instance profile doesn't pass <code>iam:PassRole</code> verification.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There is a mismatch between the account ID and cluster ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The cluster ID doesn't exist.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The EC2 instance isn't present.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample PcsAsyncClient.CreateQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pcs-2023-02-10/CreateQueue" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateQueueResponse> createQueue(Consumer<CreateQueueRequest.Builder> createQueueRequest) {
        return createQueue(CreateQueueRequest.builder().applyMutation(createQueueRequest).build());
    }

    /**
     * <p>
     * Deletes a cluster and all its linked resources. You must delete all queues and compute node groups associated
     * with the cluster before you can delete the cluster.
     * </p>
     *
     * @param deleteClusterRequest
     * @return A Java Future containing the result of the DeleteCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Your request exceeded a request rate quota. Check the resource's request rate
     *         quota and try again.</li>
     *         <li>ValidationException The request isn't valid.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your request contains malformed JSON or unsupported characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The scheduler version isn't supported.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There are networking related errors, such as network validation failure.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         AMI type is <code>CUSTOM</code> and the launch template doesn't define the AMI ID, or the AMI type is AL2
     *         and the launch template defines the AMI.
     *         </p>
     *         </li></li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than 1 operation on the same resource at the same time.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A cluster with the same name already exists.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A cluster isn't in <code>ACTIVE</code> status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A cluster to delete is in an unstable state. For example, because it still has <code>ACTIVE</code> node
     *         groups or queues.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A queue already exists in a cluster.
     *         </p>
     *         </li></li>
     *         <li>ResourceNotFoundException The requested resource can't be found. The cluster, node group, or queue
     *         you're attempting to get, update, list, or delete doesn't exist.</p>
     *         <p>
     *         <u>Examples</u></li>
     *         <li>InternalServerException Amazon Web Services PCS can't process your request right now. Try again
     *         later.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The launch template instance profile doesn't pass <code>iam:PassRole</code> verification.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There is a mismatch between the account ID and cluster ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The cluster ID doesn't exist.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The EC2 instance isn't present.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample PcsAsyncClient.DeleteCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pcs-2023-02-10/DeleteCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteClusterResponse> deleteCluster(DeleteClusterRequest deleteClusterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a cluster and all its linked resources. You must delete all queues and compute node groups associated
     * with the cluster before you can delete the cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteClusterRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteClusterRequest#builder()}
     * </p>
     *
     * @param deleteClusterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pcs.model.DeleteClusterRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Your request exceeded a request rate quota. Check the resource's request rate
     *         quota and try again.</li>
     *         <li>ValidationException The request isn't valid.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your request contains malformed JSON or unsupported characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The scheduler version isn't supported.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There are networking related errors, such as network validation failure.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         AMI type is <code>CUSTOM</code> and the launch template doesn't define the AMI ID, or the AMI type is AL2
     *         and the launch template defines the AMI.
     *         </p>
     *         </li></li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than 1 operation on the same resource at the same time.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A cluster with the same name already exists.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A cluster isn't in <code>ACTIVE</code> status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A cluster to delete is in an unstable state. For example, because it still has <code>ACTIVE</code> node
     *         groups or queues.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A queue already exists in a cluster.
     *         </p>
     *         </li></li>
     *         <li>ResourceNotFoundException The requested resource can't be found. The cluster, node group, or queue
     *         you're attempting to get, update, list, or delete doesn't exist.</p>
     *         <p>
     *         <u>Examples</u></li>
     *         <li>InternalServerException Amazon Web Services PCS can't process your request right now. Try again
     *         later.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The launch template instance profile doesn't pass <code>iam:PassRole</code> verification.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There is a mismatch between the account ID and cluster ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The cluster ID doesn't exist.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The EC2 instance isn't present.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample PcsAsyncClient.DeleteCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pcs-2023-02-10/DeleteCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteClusterResponse> deleteCluster(Consumer<DeleteClusterRequest.Builder> deleteClusterRequest) {
        return deleteCluster(DeleteClusterRequest.builder().applyMutation(deleteClusterRequest).build());
    }

    /**
     * <p>
     * Deletes a compute node group. You must delete all queues associated with the compute node group first.
     * </p>
     *
     * @param deleteComputeNodeGroupRequest
     * @return A Java Future containing the result of the DeleteComputeNodeGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Your request exceeded a request rate quota. Check the resource's request rate
     *         quota and try again.</li>
     *         <li>ValidationException The request isn't valid.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your request contains malformed JSON or unsupported characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The scheduler version isn't supported.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There are networking related errors, such as network validation failure.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         AMI type is <code>CUSTOM</code> and the launch template doesn't define the AMI ID, or the AMI type is AL2
     *         and the launch template defines the AMI.
     *         </p>
     *         </li></li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than 1 operation on the same resource at the same time.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A cluster with the same name already exists.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A cluster isn't in <code>ACTIVE</code> status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A cluster to delete is in an unstable state. For example, because it still has <code>ACTIVE</code> node
     *         groups or queues.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A queue already exists in a cluster.
     *         </p>
     *         </li></li>
     *         <li>ResourceNotFoundException The requested resource can't be found. The cluster, node group, or queue
     *         you're attempting to get, update, list, or delete doesn't exist.</p>
     *         <p>
     *         <u>Examples</u></li>
     *         <li>InternalServerException Amazon Web Services PCS can't process your request right now. Try again
     *         later.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The launch template instance profile doesn't pass <code>iam:PassRole</code> verification.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There is a mismatch between the account ID and cluster ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The cluster ID doesn't exist.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The EC2 instance isn't present.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample PcsAsyncClient.DeleteComputeNodeGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pcs-2023-02-10/DeleteComputeNodeGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteComputeNodeGroupResponse> deleteComputeNodeGroup(
            DeleteComputeNodeGroupRequest deleteComputeNodeGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a compute node group. You must delete all queues associated with the compute node group first.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteComputeNodeGroupRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteComputeNodeGroupRequest#builder()}
     * </p>
     *
     * @param deleteComputeNodeGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pcs.model.DeleteComputeNodeGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteComputeNodeGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Your request exceeded a request rate quota. Check the resource's request rate
     *         quota and try again.</li>
     *         <li>ValidationException The request isn't valid.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your request contains malformed JSON or unsupported characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The scheduler version isn't supported.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There are networking related errors, such as network validation failure.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         AMI type is <code>CUSTOM</code> and the launch template doesn't define the AMI ID, or the AMI type is AL2
     *         and the launch template defines the AMI.
     *         </p>
     *         </li></li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than 1 operation on the same resource at the same time.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A cluster with the same name already exists.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A cluster isn't in <code>ACTIVE</code> status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A cluster to delete is in an unstable state. For example, because it still has <code>ACTIVE</code> node
     *         groups or queues.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A queue already exists in a cluster.
     *         </p>
     *         </li></li>
     *         <li>ResourceNotFoundException The requested resource can't be found. The cluster, node group, or queue
     *         you're attempting to get, update, list, or delete doesn't exist.</p>
     *         <p>
     *         <u>Examples</u></li>
     *         <li>InternalServerException Amazon Web Services PCS can't process your request right now. Try again
     *         later.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The launch template instance profile doesn't pass <code>iam:PassRole</code> verification.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There is a mismatch between the account ID and cluster ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The cluster ID doesn't exist.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The EC2 instance isn't present.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample PcsAsyncClient.DeleteComputeNodeGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pcs-2023-02-10/DeleteComputeNodeGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteComputeNodeGroupResponse> deleteComputeNodeGroup(
            Consumer<DeleteComputeNodeGroupRequest.Builder> deleteComputeNodeGroupRequest) {
        return deleteComputeNodeGroup(DeleteComputeNodeGroupRequest.builder().applyMutation(deleteComputeNodeGroupRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a job queue. If the compute node group associated with this queue isn't associated with any other queues,
     * Amazon Web Services PCS terminates all the compute nodes for this queue.
     * </p>
     *
     * @param deleteQueueRequest
     * @return A Java Future containing the result of the DeleteQueue operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Your request exceeded a request rate quota. Check the resource's request rate
     *         quota and try again.</li>
     *         <li>ValidationException The request isn't valid.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your request contains malformed JSON or unsupported characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The scheduler version isn't supported.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There are networking related errors, such as network validation failure.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         AMI type is <code>CUSTOM</code> and the launch template doesn't define the AMI ID, or the AMI type is AL2
     *         and the launch template defines the AMI.
     *         </p>
     *         </li></li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than 1 operation on the same resource at the same time.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A cluster with the same name already exists.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A cluster isn't in <code>ACTIVE</code> status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A cluster to delete is in an unstable state. For example, because it still has <code>ACTIVE</code> node
     *         groups or queues.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A queue already exists in a cluster.
     *         </p>
     *         </li></li>
     *         <li>ResourceNotFoundException The requested resource can't be found. The cluster, node group, or queue
     *         you're attempting to get, update, list, or delete doesn't exist.</p>
     *         <p>
     *         <u>Examples</u></li>
     *         <li>InternalServerException Amazon Web Services PCS can't process your request right now. Try again
     *         later.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The launch template instance profile doesn't pass <code>iam:PassRole</code> verification.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There is a mismatch between the account ID and cluster ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The cluster ID doesn't exist.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The EC2 instance isn't present.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample PcsAsyncClient.DeleteQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pcs-2023-02-10/DeleteQueue" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteQueueResponse> deleteQueue(DeleteQueueRequest deleteQueueRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a job queue. If the compute node group associated with this queue isn't associated with any other queues,
     * Amazon Web Services PCS terminates all the compute nodes for this queue.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteQueueRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteQueueRequest#builder()}
     * </p>
     *
     * @param deleteQueueRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pcs.model.DeleteQueueRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteQueue operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Your request exceeded a request rate quota. Check the resource's request rate
     *         quota and try again.</li>
     *         <li>ValidationException The request isn't valid.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your request contains malformed JSON or unsupported characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The scheduler version isn't supported.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There are networking related errors, such as network validation failure.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         AMI type is <code>CUSTOM</code> and the launch template doesn't define the AMI ID, or the AMI type is AL2
     *         and the launch template defines the AMI.
     *         </p>
     *         </li></li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than 1 operation on the same resource at the same time.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A cluster with the same name already exists.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A cluster isn't in <code>ACTIVE</code> status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A cluster to delete is in an unstable state. For example, because it still has <code>ACTIVE</code> node
     *         groups or queues.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A queue already exists in a cluster.
     *         </p>
     *         </li></li>
     *         <li>ResourceNotFoundException The requested resource can't be found. The cluster, node group, or queue
     *         you're attempting to get, update, list, or delete doesn't exist.</p>
     *         <p>
     *         <u>Examples</u></li>
     *         <li>InternalServerException Amazon Web Services PCS can't process your request right now. Try again
     *         later.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The launch template instance profile doesn't pass <code>iam:PassRole</code> verification.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There is a mismatch between the account ID and cluster ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The cluster ID doesn't exist.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The EC2 instance isn't present.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample PcsAsyncClient.DeleteQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pcs-2023-02-10/DeleteQueue" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteQueueResponse> deleteQueue(Consumer<DeleteQueueRequest.Builder> deleteQueueRequest) {
        return deleteQueue(DeleteQueueRequest.builder().applyMutation(deleteQueueRequest).build());
    }

    /**
     * <p>
     * Returns detailed information about a running cluster in your account. This API action provides networking
     * information, endpoint information for communication with the scheduler, and provisioning status.
     * </p>
     *
     * @param getClusterRequest
     * @return A Java Future containing the result of the GetCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Your request exceeded a request rate quota. Check the resource's request rate
     *         quota and try again.</li>
     *         <li>ValidationException The request isn't valid.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your request contains malformed JSON or unsupported characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The scheduler version isn't supported.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There are networking related errors, such as network validation failure.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         AMI type is <code>CUSTOM</code> and the launch template doesn't define the AMI ID, or the AMI type is AL2
     *         and the launch template defines the AMI.
     *         </p>
     *         </li></li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than 1 operation on the same resource at the same time.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A cluster with the same name already exists.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A cluster isn't in <code>ACTIVE</code> status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A cluster to delete is in an unstable state. For example, because it still has <code>ACTIVE</code> node
     *         groups or queues.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A queue already exists in a cluster.
     *         </p>
     *         </li></li>
     *         <li>ResourceNotFoundException The requested resource can't be found. The cluster, node group, or queue
     *         you're attempting to get, update, list, or delete doesn't exist.</p>
     *         <p>
     *         <u>Examples</u></li>
     *         <li>InternalServerException Amazon Web Services PCS can't process your request right now. Try again
     *         later.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The launch template instance profile doesn't pass <code>iam:PassRole</code> verification.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There is a mismatch between the account ID and cluster ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The cluster ID doesn't exist.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The EC2 instance isn't present.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample PcsAsyncClient.GetCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pcs-2023-02-10/GetCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetClusterResponse> getCluster(GetClusterRequest getClusterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns detailed information about a running cluster in your account. This API action provides networking
     * information, endpoint information for communication with the scheduler, and provisioning status.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetClusterRequest.Builder} avoiding the need to
     * create one manually via {@link GetClusterRequest#builder()}
     * </p>
     *
     * @param getClusterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pcs.model.GetClusterRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Your request exceeded a request rate quota. Check the resource's request rate
     *         quota and try again.</li>
     *         <li>ValidationException The request isn't valid.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your request contains malformed JSON or unsupported characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The scheduler version isn't supported.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There are networking related errors, such as network validation failure.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         AMI type is <code>CUSTOM</code> and the launch template doesn't define the AMI ID, or the AMI type is AL2
     *         and the launch template defines the AMI.
     *         </p>
     *         </li></li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than 1 operation on the same resource at the same time.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A cluster with the same name already exists.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A cluster isn't in <code>ACTIVE</code> status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A cluster to delete is in an unstable state. For example, because it still has <code>ACTIVE</code> node
     *         groups or queues.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A queue already exists in a cluster.
     *         </p>
     *         </li></li>
     *         <li>ResourceNotFoundException The requested resource can't be found. The cluster, node group, or queue
     *         you're attempting to get, update, list, or delete doesn't exist.</p>
     *         <p>
     *         <u>Examples</u></li>
     *         <li>InternalServerException Amazon Web Services PCS can't process your request right now. Try again
     *         later.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The launch template instance profile doesn't pass <code>iam:PassRole</code> verification.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There is a mismatch between the account ID and cluster ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The cluster ID doesn't exist.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The EC2 instance isn't present.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample PcsAsyncClient.GetCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pcs-2023-02-10/GetCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetClusterResponse> getCluster(Consumer<GetClusterRequest.Builder> getClusterRequest) {
        return getCluster(GetClusterRequest.builder().applyMutation(getClusterRequest).build());
    }

    /**
     * <p>
     * Returns detailed information about a compute node group. This API action provides networking information, EC2
     * instance type, compute node group status, and scheduler (such as Slurm) configuration.
     * </p>
     *
     * @param getComputeNodeGroupRequest
     * @return A Java Future containing the result of the GetComputeNodeGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Your request exceeded a request rate quota. Check the resource's request rate
     *         quota and try again.</li>
     *         <li>ValidationException The request isn't valid.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your request contains malformed JSON or unsupported characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The scheduler version isn't supported.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There are networking related errors, such as network validation failure.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         AMI type is <code>CUSTOM</code> and the launch template doesn't define the AMI ID, or the AMI type is AL2
     *         and the launch template defines the AMI.
     *         </p>
     *         </li></li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than 1 operation on the same resource at the same time.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A cluster with the same name already exists.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A cluster isn't in <code>ACTIVE</code> status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A cluster to delete is in an unstable state. For example, because it still has <code>ACTIVE</code> node
     *         groups or queues.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A queue already exists in a cluster.
     *         </p>
     *         </li></li>
     *         <li>ResourceNotFoundException The requested resource can't be found. The cluster, node group, or queue
     *         you're attempting to get, update, list, or delete doesn't exist.</p>
     *         <p>
     *         <u>Examples</u></li>
     *         <li>InternalServerException Amazon Web Services PCS can't process your request right now. Try again
     *         later.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The launch template instance profile doesn't pass <code>iam:PassRole</code> verification.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There is a mismatch between the account ID and cluster ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The cluster ID doesn't exist.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The EC2 instance isn't present.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample PcsAsyncClient.GetComputeNodeGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pcs-2023-02-10/GetComputeNodeGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetComputeNodeGroupResponse> getComputeNodeGroup(
            GetComputeNodeGroupRequest getComputeNodeGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns detailed information about a compute node group. This API action provides networking information, EC2
     * instance type, compute node group status, and scheduler (such as Slurm) configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetComputeNodeGroupRequest.Builder} avoiding the
     * need to create one manually via {@link GetComputeNodeGroupRequest#builder()}
     * </p>
     *
     * @param getComputeNodeGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pcs.model.GetComputeNodeGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetComputeNodeGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Your request exceeded a request rate quota. Check the resource's request rate
     *         quota and try again.</li>
     *         <li>ValidationException The request isn't valid.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your request contains malformed JSON or unsupported characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The scheduler version isn't supported.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There are networking related errors, such as network validation failure.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         AMI type is <code>CUSTOM</code> and the launch template doesn't define the AMI ID, or the AMI type is AL2
     *         and the launch template defines the AMI.
     *         </p>
     *         </li></li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than 1 operation on the same resource at the same time.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A cluster with the same name already exists.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A cluster isn't in <code>ACTIVE</code> status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A cluster to delete is in an unstable state. For example, because it still has <code>ACTIVE</code> node
     *         groups or queues.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A queue already exists in a cluster.
     *         </p>
     *         </li></li>
     *         <li>ResourceNotFoundException The requested resource can't be found. The cluster, node group, or queue
     *         you're attempting to get, update, list, or delete doesn't exist.</p>
     *         <p>
     *         <u>Examples</u></li>
     *         <li>InternalServerException Amazon Web Services PCS can't process your request right now. Try again
     *         later.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The launch template instance profile doesn't pass <code>iam:PassRole</code> verification.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There is a mismatch between the account ID and cluster ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The cluster ID doesn't exist.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The EC2 instance isn't present.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample PcsAsyncClient.GetComputeNodeGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pcs-2023-02-10/GetComputeNodeGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetComputeNodeGroupResponse> getComputeNodeGroup(
            Consumer<GetComputeNodeGroupRequest.Builder> getComputeNodeGroupRequest) {
        return getComputeNodeGroup(GetComputeNodeGroupRequest.builder().applyMutation(getComputeNodeGroupRequest).build());
    }

    /**
     * <p>
     * Returns detailed information about a queue. The information includes the compute node groups that the queue uses
     * to schedule jobs.
     * </p>
     *
     * @param getQueueRequest
     * @return A Java Future containing the result of the GetQueue operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Your request exceeded a request rate quota. Check the resource's request rate
     *         quota and try again.</li>
     *         <li>ValidationException The request isn't valid.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your request contains malformed JSON or unsupported characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The scheduler version isn't supported.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There are networking related errors, such as network validation failure.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         AMI type is <code>CUSTOM</code> and the launch template doesn't define the AMI ID, or the AMI type is AL2
     *         and the launch template defines the AMI.
     *         </p>
     *         </li></li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than 1 operation on the same resource at the same time.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A cluster with the same name already exists.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A cluster isn't in <code>ACTIVE</code> status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A cluster to delete is in an unstable state. For example, because it still has <code>ACTIVE</code> node
     *         groups or queues.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A queue already exists in a cluster.
     *         </p>
     *         </li></li>
     *         <li>ResourceNotFoundException The requested resource can't be found. The cluster, node group, or queue
     *         you're attempting to get, update, list, or delete doesn't exist.</p>
     *         <p>
     *         <u>Examples</u></li>
     *         <li>InternalServerException Amazon Web Services PCS can't process your request right now. Try again
     *         later.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The launch template instance profile doesn't pass <code>iam:PassRole</code> verification.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There is a mismatch between the account ID and cluster ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The cluster ID doesn't exist.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The EC2 instance isn't present.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample PcsAsyncClient.GetQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pcs-2023-02-10/GetQueue" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetQueueResponse> getQueue(GetQueueRequest getQueueRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns detailed information about a queue. The information includes the compute node groups that the queue uses
     * to schedule jobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetQueueRequest.Builder} avoiding the need to
     * create one manually via {@link GetQueueRequest#builder()}
     * </p>
     *
     * @param getQueueRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pcs.model.GetQueueRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetQueue operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Your request exceeded a request rate quota. Check the resource's request rate
     *         quota and try again.</li>
     *         <li>ValidationException The request isn't valid.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your request contains malformed JSON or unsupported characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The scheduler version isn't supported.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There are networking related errors, such as network validation failure.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         AMI type is <code>CUSTOM</code> and the launch template doesn't define the AMI ID, or the AMI type is AL2
     *         and the launch template defines the AMI.
     *         </p>
     *         </li></li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than 1 operation on the same resource at the same time.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A cluster with the same name already exists.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A cluster isn't in <code>ACTIVE</code> status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A cluster to delete is in an unstable state. For example, because it still has <code>ACTIVE</code> node
     *         groups or queues.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A queue already exists in a cluster.
     *         </p>
     *         </li></li>
     *         <li>ResourceNotFoundException The requested resource can't be found. The cluster, node group, or queue
     *         you're attempting to get, update, list, or delete doesn't exist.</p>
     *         <p>
     *         <u>Examples</u></li>
     *         <li>InternalServerException Amazon Web Services PCS can't process your request right now. Try again
     *         later.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The launch template instance profile doesn't pass <code>iam:PassRole</code> verification.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There is a mismatch between the account ID and cluster ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The cluster ID doesn't exist.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The EC2 instance isn't present.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample PcsAsyncClient.GetQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pcs-2023-02-10/GetQueue" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetQueueResponse> getQueue(Consumer<GetQueueRequest.Builder> getQueueRequest) {
        return getQueue(GetQueueRequest.builder().applyMutation(getQueueRequest).build());
    }

    /**
     * <p>
     * Returns a list of running clusters in your account.
     * </p>
     *
     * @param listClustersRequest
     * @return A Java Future containing the result of the ListClusters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Your request exceeded a request rate quota. Check the resource's request rate
     *         quota and try again.</li>
     *         <li>ValidationException The request isn't valid.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your request contains malformed JSON or unsupported characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The scheduler version isn't supported.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There are networking related errors, such as network validation failure.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         AMI type is <code>CUSTOM</code> and the launch template doesn't define the AMI ID, or the AMI type is AL2
     *         and the launch template defines the AMI.
     *         </p>
     *         </li></li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than 1 operation on the same resource at the same time.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A cluster with the same name already exists.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A cluster isn't in <code>ACTIVE</code> status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A cluster to delete is in an unstable state. For example, because it still has <code>ACTIVE</code> node
     *         groups or queues.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A queue already exists in a cluster.
     *         </p>
     *         </li></li>
     *         <li>ResourceNotFoundException The requested resource can't be found. The cluster, node group, or queue
     *         you're attempting to get, update, list, or delete doesn't exist.</p>
     *         <p>
     *         <u>Examples</u></li>
     *         <li>InternalServerException Amazon Web Services PCS can't process your request right now. Try again
     *         later.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The launch template instance profile doesn't pass <code>iam:PassRole</code> verification.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There is a mismatch between the account ID and cluster ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The cluster ID doesn't exist.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The EC2 instance isn't present.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample PcsAsyncClient.ListClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pcs-2023-02-10/ListClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListClustersResponse> listClusters(ListClustersRequest listClustersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of running clusters in your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListClustersRequest.Builder} avoiding the need to
     * create one manually via {@link ListClustersRequest#builder()}
     * </p>
     *
     * @param listClustersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pcs.model.ListClustersRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListClusters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Your request exceeded a request rate quota. Check the resource's request rate
     *         quota and try again.</li>
     *         <li>ValidationException The request isn't valid.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your request contains malformed JSON or unsupported characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The scheduler version isn't supported.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There are networking related errors, such as network validation failure.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         AMI type is <code>CUSTOM</code> and the launch template doesn't define the AMI ID, or the AMI type is AL2
     *         and the launch template defines the AMI.
     *         </p>
     *         </li></li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than 1 operation on the same resource at the same time.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A cluster with the same name already exists.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A cluster isn't in <code>ACTIVE</code> status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A cluster to delete is in an unstable state. For example, because it still has <code>ACTIVE</code> node
     *         groups or queues.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A queue already exists in a cluster.
     *         </p>
     *         </li></li>
     *         <li>ResourceNotFoundException The requested resource can't be found. The cluster, node group, or queue
     *         you're attempting to get, update, list, or delete doesn't exist.</p>
     *         <p>
     *         <u>Examples</u></li>
     *         <li>InternalServerException Amazon Web Services PCS can't process your request right now. Try again
     *         later.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The launch template instance profile doesn't pass <code>iam:PassRole</code> verification.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There is a mismatch between the account ID and cluster ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The cluster ID doesn't exist.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The EC2 instance isn't present.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample PcsAsyncClient.ListClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pcs-2023-02-10/ListClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListClustersResponse> listClusters(Consumer<ListClustersRequest.Builder> listClustersRequest) {
        return listClusters(ListClustersRequest.builder().applyMutation(listClustersRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listClusters(software.amazon.awssdk.services.pcs.model.ListClustersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pcs.paginators.ListClustersPublisher publisher = client.listClustersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pcs.paginators.ListClustersPublisher publisher = client.listClustersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.pcs.model.ListClustersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.pcs.model.ListClustersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listClusters(software.amazon.awssdk.services.pcs.model.ListClustersRequest)} operation.</b>
     * </p>
     *
     * @param listClustersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Your request exceeded a request rate quota. Check the resource's request rate
     *         quota and try again.</li>
     *         <li>ValidationException The request isn't valid.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your request contains malformed JSON or unsupported characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The scheduler version isn't supported.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There are networking related errors, such as network validation failure.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         AMI type is <code>CUSTOM</code> and the launch template doesn't define the AMI ID, or the AMI type is AL2
     *         and the launch template defines the AMI.
     *         </p>
     *         </li></li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than 1 operation on the same resource at the same time.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A cluster with the same name already exists.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A cluster isn't in <code>ACTIVE</code> status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A cluster to delete is in an unstable state. For example, because it still has <code>ACTIVE</code> node
     *         groups or queues.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A queue already exists in a cluster.
     *         </p>
     *         </li></li>
     *         <li>ResourceNotFoundException The requested resource can't be found. The cluster, node group, or queue
     *         you're attempting to get, update, list, or delete doesn't exist.</p>
     *         <p>
     *         <u>Examples</u></li>
     *         <li>InternalServerException Amazon Web Services PCS can't process your request right now. Try again
     *         later.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The launch template instance profile doesn't pass <code>iam:PassRole</code> verification.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There is a mismatch between the account ID and cluster ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The cluster ID doesn't exist.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The EC2 instance isn't present.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample PcsAsyncClient.ListClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pcs-2023-02-10/ListClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default ListClustersPublisher listClustersPaginator(ListClustersRequest listClustersRequest) {
        return new ListClustersPublisher(this, listClustersRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listClusters(software.amazon.awssdk.services.pcs.model.ListClustersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pcs.paginators.ListClustersPublisher publisher = client.listClustersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pcs.paginators.ListClustersPublisher publisher = client.listClustersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.pcs.model.ListClustersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.pcs.model.ListClustersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listClusters(software.amazon.awssdk.services.pcs.model.ListClustersRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListClustersRequest.Builder} avoiding the need to
     * create one manually via {@link ListClustersRequest#builder()}
     * </p>
     *
     * @param listClustersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pcs.model.ListClustersRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Your request exceeded a request rate quota. Check the resource's request rate
     *         quota and try again.</li>
     *         <li>ValidationException The request isn't valid.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your request contains malformed JSON or unsupported characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The scheduler version isn't supported.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There are networking related errors, such as network validation failure.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         AMI type is <code>CUSTOM</code> and the launch template doesn't define the AMI ID, or the AMI type is AL2
     *         and the launch template defines the AMI.
     *         </p>
     *         </li></li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than 1 operation on the same resource at the same time.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A cluster with the same name already exists.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A cluster isn't in <code>ACTIVE</code> status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A cluster to delete is in an unstable state. For example, because it still has <code>ACTIVE</code> node
     *         groups or queues.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A queue already exists in a cluster.
     *         </p>
     *         </li></li>
     *         <li>ResourceNotFoundException The requested resource can't be found. The cluster, node group, or queue
     *         you're attempting to get, update, list, or delete doesn't exist.</p>
     *         <p>
     *         <u>Examples</u></li>
     *         <li>InternalServerException Amazon Web Services PCS can't process your request right now. Try again
     *         later.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The launch template instance profile doesn't pass <code>iam:PassRole</code> verification.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There is a mismatch between the account ID and cluster ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The cluster ID doesn't exist.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The EC2 instance isn't present.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample PcsAsyncClient.ListClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pcs-2023-02-10/ListClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default ListClustersPublisher listClustersPaginator(Consumer<ListClustersRequest.Builder> listClustersRequest) {
        return listClustersPaginator(ListClustersRequest.builder().applyMutation(listClustersRequest).build());
    }

    /**
     * <p>
     * Returns a list of all compute node groups associated with a cluster.
     * </p>
     *
     * @param listComputeNodeGroupsRequest
     * @return A Java Future containing the result of the ListComputeNodeGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Your request exceeded a request rate quota. Check the resource's request rate
     *         quota and try again.</li>
     *         <li>ValidationException The request isn't valid.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your request contains malformed JSON or unsupported characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The scheduler version isn't supported.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There are networking related errors, such as network validation failure.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         AMI type is <code>CUSTOM</code> and the launch template doesn't define the AMI ID, or the AMI type is AL2
     *         and the launch template defines the AMI.
     *         </p>
     *         </li></li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than 1 operation on the same resource at the same time.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A cluster with the same name already exists.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A cluster isn't in <code>ACTIVE</code> status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A cluster to delete is in an unstable state. For example, because it still has <code>ACTIVE</code> node
     *         groups or queues.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A queue already exists in a cluster.
     *         </p>
     *         </li></li>
     *         <li>ResourceNotFoundException The requested resource can't be found. The cluster, node group, or queue
     *         you're attempting to get, update, list, or delete doesn't exist.</p>
     *         <p>
     *         <u>Examples</u></li>
     *         <li>InternalServerException Amazon Web Services PCS can't process your request right now. Try again
     *         later.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The launch template instance profile doesn't pass <code>iam:PassRole</code> verification.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There is a mismatch between the account ID and cluster ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The cluster ID doesn't exist.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The EC2 instance isn't present.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample PcsAsyncClient.ListComputeNodeGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pcs-2023-02-10/ListComputeNodeGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListComputeNodeGroupsResponse> listComputeNodeGroups(
            ListComputeNodeGroupsRequest listComputeNodeGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all compute node groups associated with a cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListComputeNodeGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link ListComputeNodeGroupsRequest#builder()}
     * </p>
     *
     * @param listComputeNodeGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pcs.model.ListComputeNodeGroupsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListComputeNodeGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Your request exceeded a request rate quota. Check the resource's request rate
     *         quota and try again.</li>
     *         <li>ValidationException The request isn't valid.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your request contains malformed JSON or unsupported characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The scheduler version isn't supported.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There are networking related errors, such as network validation failure.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         AMI type is <code>CUSTOM</code> and the launch template doesn't define the AMI ID, or the AMI type is AL2
     *         and the launch template defines the AMI.
     *         </p>
     *         </li></li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than 1 operation on the same resource at the same time.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A cluster with the same name already exists.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A cluster isn't in <code>ACTIVE</code> status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A cluster to delete is in an unstable state. For example, because it still has <code>ACTIVE</code> node
     *         groups or queues.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A queue already exists in a cluster.
     *         </p>
     *         </li></li>
     *         <li>ResourceNotFoundException The requested resource can't be found. The cluster, node group, or queue
     *         you're attempting to get, update, list, or delete doesn't exist.</p>
     *         <p>
     *         <u>Examples</u></li>
     *         <li>InternalServerException Amazon Web Services PCS can't process your request right now. Try again
     *         later.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The launch template instance profile doesn't pass <code>iam:PassRole</code> verification.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There is a mismatch between the account ID and cluster ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The cluster ID doesn't exist.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The EC2 instance isn't present.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample PcsAsyncClient.ListComputeNodeGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pcs-2023-02-10/ListComputeNodeGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListComputeNodeGroupsResponse> listComputeNodeGroups(
            Consumer<ListComputeNodeGroupsRequest.Builder> listComputeNodeGroupsRequest) {
        return listComputeNodeGroups(ListComputeNodeGroupsRequest.builder().applyMutation(listComputeNodeGroupsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listComputeNodeGroups(software.amazon.awssdk.services.pcs.model.ListComputeNodeGroupsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pcs.paginators.ListComputeNodeGroupsPublisher publisher = client.listComputeNodeGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pcs.paginators.ListComputeNodeGroupsPublisher publisher = client.listComputeNodeGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.pcs.model.ListComputeNodeGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.pcs.model.ListComputeNodeGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listComputeNodeGroups(software.amazon.awssdk.services.pcs.model.ListComputeNodeGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listComputeNodeGroupsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Your request exceeded a request rate quota. Check the resource's request rate
     *         quota and try again.</li>
     *         <li>ValidationException The request isn't valid.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your request contains malformed JSON or unsupported characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The scheduler version isn't supported.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There are networking related errors, such as network validation failure.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         AMI type is <code>CUSTOM</code> and the launch template doesn't define the AMI ID, or the AMI type is AL2
     *         and the launch template defines the AMI.
     *         </p>
     *         </li></li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than 1 operation on the same resource at the same time.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A cluster with the same name already exists.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A cluster isn't in <code>ACTIVE</code> status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A cluster to delete is in an unstable state. For example, because it still has <code>ACTIVE</code> node
     *         groups or queues.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A queue already exists in a cluster.
     *         </p>
     *         </li></li>
     *         <li>ResourceNotFoundException The requested resource can't be found. The cluster, node group, or queue
     *         you're attempting to get, update, list, or delete doesn't exist.</p>
     *         <p>
     *         <u>Examples</u></li>
     *         <li>InternalServerException Amazon Web Services PCS can't process your request right now. Try again
     *         later.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The launch template instance profile doesn't pass <code>iam:PassRole</code> verification.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There is a mismatch between the account ID and cluster ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The cluster ID doesn't exist.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The EC2 instance isn't present.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample PcsAsyncClient.ListComputeNodeGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pcs-2023-02-10/ListComputeNodeGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default ListComputeNodeGroupsPublisher listComputeNodeGroupsPaginator(
            ListComputeNodeGroupsRequest listComputeNodeGroupsRequest) {
        return new ListComputeNodeGroupsPublisher(this, listComputeNodeGroupsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listComputeNodeGroups(software.amazon.awssdk.services.pcs.model.ListComputeNodeGroupsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pcs.paginators.ListComputeNodeGroupsPublisher publisher = client.listComputeNodeGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pcs.paginators.ListComputeNodeGroupsPublisher publisher = client.listComputeNodeGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.pcs.model.ListComputeNodeGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.pcs.model.ListComputeNodeGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listComputeNodeGroups(software.amazon.awssdk.services.pcs.model.ListComputeNodeGroupsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListComputeNodeGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link ListComputeNodeGroupsRequest#builder()}
     * </p>
     *
     * @param listComputeNodeGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pcs.model.ListComputeNodeGroupsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Your request exceeded a request rate quota. Check the resource's request rate
     *         quota and try again.</li>
     *         <li>ValidationException The request isn't valid.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your request contains malformed JSON or unsupported characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The scheduler version isn't supported.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There are networking related errors, such as network validation failure.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         AMI type is <code>CUSTOM</code> and the launch template doesn't define the AMI ID, or the AMI type is AL2
     *         and the launch template defines the AMI.
     *         </p>
     *         </li></li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than 1 operation on the same resource at the same time.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A cluster with the same name already exists.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A cluster isn't in <code>ACTIVE</code> status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A cluster to delete is in an unstable state. For example, because it still has <code>ACTIVE</code> node
     *         groups or queues.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A queue already exists in a cluster.
     *         </p>
     *         </li></li>
     *         <li>ResourceNotFoundException The requested resource can't be found. The cluster, node group, or queue
     *         you're attempting to get, update, list, or delete doesn't exist.</p>
     *         <p>
     *         <u>Examples</u></li>
     *         <li>InternalServerException Amazon Web Services PCS can't process your request right now. Try again
     *         later.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The launch template instance profile doesn't pass <code>iam:PassRole</code> verification.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There is a mismatch between the account ID and cluster ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The cluster ID doesn't exist.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The EC2 instance isn't present.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample PcsAsyncClient.ListComputeNodeGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pcs-2023-02-10/ListComputeNodeGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default ListComputeNodeGroupsPublisher listComputeNodeGroupsPaginator(
            Consumer<ListComputeNodeGroupsRequest.Builder> listComputeNodeGroupsRequest) {
        return listComputeNodeGroupsPaginator(ListComputeNodeGroupsRequest.builder().applyMutation(listComputeNodeGroupsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of all queues associated with a cluster.
     * </p>
     *
     * @param listQueuesRequest
     * @return A Java Future containing the result of the ListQueues operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Your request exceeded a request rate quota. Check the resource's request rate
     *         quota and try again.</li>
     *         <li>ValidationException The request isn't valid.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your request contains malformed JSON or unsupported characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The scheduler version isn't supported.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There are networking related errors, such as network validation failure.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         AMI type is <code>CUSTOM</code> and the launch template doesn't define the AMI ID, or the AMI type is AL2
     *         and the launch template defines the AMI.
     *         </p>
     *         </li></li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than 1 operation on the same resource at the same time.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A cluster with the same name already exists.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A cluster isn't in <code>ACTIVE</code> status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A cluster to delete is in an unstable state. For example, because it still has <code>ACTIVE</code> node
     *         groups or queues.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A queue already exists in a cluster.
     *         </p>
     *         </li></li>
     *         <li>ResourceNotFoundException The requested resource can't be found. The cluster, node group, or queue
     *         you're attempting to get, update, list, or delete doesn't exist.</p>
     *         <p>
     *         <u>Examples</u></li>
     *         <li>InternalServerException Amazon Web Services PCS can't process your request right now. Try again
     *         later.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The launch template instance profile doesn't pass <code>iam:PassRole</code> verification.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There is a mismatch between the account ID and cluster ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The cluster ID doesn't exist.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The EC2 instance isn't present.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample PcsAsyncClient.ListQueues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pcs-2023-02-10/ListQueues" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListQueuesResponse> listQueues(ListQueuesRequest listQueuesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all queues associated with a cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListQueuesRequest.Builder} avoiding the need to
     * create one manually via {@link ListQueuesRequest#builder()}
     * </p>
     *
     * @param listQueuesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pcs.model.ListQueuesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListQueues operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Your request exceeded a request rate quota. Check the resource's request rate
     *         quota and try again.</li>
     *         <li>ValidationException The request isn't valid.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your request contains malformed JSON or unsupported characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The scheduler version isn't supported.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There are networking related errors, such as network validation failure.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         AMI type is <code>CUSTOM</code> and the launch template doesn't define the AMI ID, or the AMI type is AL2
     *         and the launch template defines the AMI.
     *         </p>
     *         </li></li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than 1 operation on the same resource at the same time.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A cluster with the same name already exists.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A cluster isn't in <code>ACTIVE</code> status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A cluster to delete is in an unstable state. For example, because it still has <code>ACTIVE</code> node
     *         groups or queues.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A queue already exists in a cluster.
     *         </p>
     *         </li></li>
     *         <li>ResourceNotFoundException The requested resource can't be found. The cluster, node group, or queue
     *         you're attempting to get, update, list, or delete doesn't exist.</p>
     *         <p>
     *         <u>Examples</u></li>
     *         <li>InternalServerException Amazon Web Services PCS can't process your request right now. Try again
     *         later.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The launch template instance profile doesn't pass <code>iam:PassRole</code> verification.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There is a mismatch between the account ID and cluster ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The cluster ID doesn't exist.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The EC2 instance isn't present.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample PcsAsyncClient.ListQueues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pcs-2023-02-10/ListQueues" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListQueuesResponse> listQueues(Consumer<ListQueuesRequest.Builder> listQueuesRequest) {
        return listQueues(ListQueuesRequest.builder().applyMutation(listQueuesRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listQueues(software.amazon.awssdk.services.pcs.model.ListQueuesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pcs.paginators.ListQueuesPublisher publisher = client.listQueuesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pcs.paginators.ListQueuesPublisher publisher = client.listQueuesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.pcs.model.ListQueuesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.pcs.model.ListQueuesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listQueues(software.amazon.awssdk.services.pcs.model.ListQueuesRequest)} operation.</b>
     * </p>
     *
     * @param listQueuesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Your request exceeded a request rate quota. Check the resource's request rate
     *         quota and try again.</li>
     *         <li>ValidationException The request isn't valid.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your request contains malformed JSON or unsupported characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The scheduler version isn't supported.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There are networking related errors, such as network validation failure.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         AMI type is <code>CUSTOM</code> and the launch template doesn't define the AMI ID, or the AMI type is AL2
     *         and the launch template defines the AMI.
     *         </p>
     *         </li></li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than 1 operation on the same resource at the same time.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A cluster with the same name already exists.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A cluster isn't in <code>ACTIVE</code> status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A cluster to delete is in an unstable state. For example, because it still has <code>ACTIVE</code> node
     *         groups or queues.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A queue already exists in a cluster.
     *         </p>
     *         </li></li>
     *         <li>ResourceNotFoundException The requested resource can't be found. The cluster, node group, or queue
     *         you're attempting to get, update, list, or delete doesn't exist.</p>
     *         <p>
     *         <u>Examples</u></li>
     *         <li>InternalServerException Amazon Web Services PCS can't process your request right now. Try again
     *         later.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The launch template instance profile doesn't pass <code>iam:PassRole</code> verification.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There is a mismatch between the account ID and cluster ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The cluster ID doesn't exist.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The EC2 instance isn't present.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample PcsAsyncClient.ListQueues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pcs-2023-02-10/ListQueues" target="_top">AWS API
     *      Documentation</a>
     */
    default ListQueuesPublisher listQueuesPaginator(ListQueuesRequest listQueuesRequest) {
        return new ListQueuesPublisher(this, listQueuesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listQueues(software.amazon.awssdk.services.pcs.model.ListQueuesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pcs.paginators.ListQueuesPublisher publisher = client.listQueuesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pcs.paginators.ListQueuesPublisher publisher = client.listQueuesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.pcs.model.ListQueuesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.pcs.model.ListQueuesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listQueues(software.amazon.awssdk.services.pcs.model.ListQueuesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListQueuesRequest.Builder} avoiding the need to
     * create one manually via {@link ListQueuesRequest#builder()}
     * </p>
     *
     * @param listQueuesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pcs.model.ListQueuesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException Your request exceeded a request rate quota. Check the resource's request rate
     *         quota and try again.</li>
     *         <li>ValidationException The request isn't valid.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your request contains malformed JSON or unsupported characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The scheduler version isn't supported.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There are networking related errors, such as network validation failure.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         AMI type is <code>CUSTOM</code> and the launch template doesn't define the AMI ID, or the AMI type is AL2
     *         and the launch template defines the AMI.
     *         </p>
     *         </li></li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than 1 operation on the same resource at the same time.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A cluster with the same name already exists.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A cluster isn't in <code>ACTIVE</code> status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A cluster to delete is in an unstable state. For example, because it still has <code>ACTIVE</code> node
     *         groups or queues.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A queue already exists in a cluster.
     *         </p>
     *         </li></li>
     *         <li>ResourceNotFoundException The requested resource can't be found. The cluster, node group, or queue
     *         you're attempting to get, update, list, or delete doesn't exist.</p>
     *         <p>
     *         <u>Examples</u></li>
     *         <li>InternalServerException Amazon Web Services PCS can't process your request right now. Try again
     *         later.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The launch template instance profile doesn't pass <code>iam:PassRole</code> verification.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There is a mismatch between the account ID and cluster ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The cluster ID doesn't exist.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The EC2 instance isn't present.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample PcsAsyncClient.ListQueues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pcs-2023-02-10/ListQueues" target="_top">AWS API
     *      Documentation</a>
     */
    default ListQueuesPublisher listQueuesPaginator(Consumer<ListQueuesRequest.Builder> listQueuesRequest) {
        return listQueuesPaginator(ListQueuesRequest.builder().applyMutation(listQueuesRequest).build());
    }

    /**
     * <p>
     * Returns a list of all tags on an Amazon Web Services PCS resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource can't be found. The cluster, node group, or queue
     *         you're attempting to get, update, list, or delete doesn't exist.</p>
     *         <p>
     *         <u>Examples</u></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample PcsAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pcs-2023-02-10/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all tags on an Amazon Web Services PCS resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pcs.model.ListTagsForResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource can't be found. The cluster, node group, or queue
     *         you're attempting to get, update, list, or delete doesn't exist.</p>
     *         <p>
     *         <u>Examples</u></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample PcsAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pcs-2023-02-10/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <important>
     * <p>
     * This API action isn't intended for you to use.
     * </p>
     * </important>
     * <p>
     * Amazon Web Services PCS uses this API action to register the compute nodes it launches in your account.
     * </p>
     *
     * @param registerComputeNodeGroupInstanceRequest
     * @return A Java Future containing the result of the RegisterComputeNodeGroupInstance operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Amazon Web Services PCS can't process your request right now. Try again
     *         later.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The launch template instance profile doesn't pass <code>iam:PassRole</code> verification.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There is a mismatch between the account ID and cluster ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The cluster ID doesn't exist.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The EC2 instance isn't present.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample PcsAsyncClient.RegisterComputeNodeGroupInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pcs-2023-02-10/RegisterComputeNodeGroupInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RegisterComputeNodeGroupInstanceResponse> registerComputeNodeGroupInstance(
            RegisterComputeNodeGroupInstanceRequest registerComputeNodeGroupInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <important>
     * <p>
     * This API action isn't intended for you to use.
     * </p>
     * </important>
     * <p>
     * Amazon Web Services PCS uses this API action to register the compute nodes it launches in your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RegisterComputeNodeGroupInstanceRequest.Builder}
     * avoiding the need to create one manually via {@link RegisterComputeNodeGroupInstanceRequest#builder()}
     * </p>
     *
     * @param registerComputeNodeGroupInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pcs.model.RegisterComputeNodeGroupInstanceRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the RegisterComputeNodeGroupInstance operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Amazon Web Services PCS can't process your request right now. Try again
     *         later.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The launch template instance profile doesn't pass <code>iam:PassRole</code> verification.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There is a mismatch between the account ID and cluster ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The cluster ID doesn't exist.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The EC2 instance isn't present.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample PcsAsyncClient.RegisterComputeNodeGroupInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pcs-2023-02-10/RegisterComputeNodeGroupInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RegisterComputeNodeGroupInstanceResponse> registerComputeNodeGroupInstance(
            Consumer<RegisterComputeNodeGroupInstanceRequest.Builder> registerComputeNodeGroupInstanceRequest) {
        return registerComputeNodeGroupInstance(RegisterComputeNodeGroupInstanceRequest.builder()
                .applyMutation(registerComputeNodeGroupInstanceRequest).build());
    }

    /**
     * <p>
     * Adds or edits tags on an Amazon Web Services PCS resource. Each tag consists of a tag key and a tag value. The
     * tag key and tag value are case-sensitive strings. The tag value can be an empty (null) string. To add a tag,
     * specify a new tag key and a tag value. To edit a tag, specify an existing tag key and a new tag value.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource can't be found. The cluster, node group, or queue
     *         you're attempting to get, update, list, or delete doesn't exist.</p>
     *         <p>
     *         <u>Examples</u></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample PcsAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pcs-2023-02-10/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds or edits tags on an Amazon Web Services PCS resource. Each tag consists of a tag key and a tag value. The
     * tag key and tag value are case-sensitive strings. The tag value can be an empty (null) string. To add a tag,
     * specify a new tag key and a tag value. To edit a tag, specify an existing tag key and a new tag value.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pcs.model.TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource can't be found. The cluster, node group, or queue
     *         you're attempting to get, update, list, or delete doesn't exist.</p>
     *         <p>
     *         <u>Examples</u></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample PcsAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pcs-2023-02-10/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Deletes tags from an Amazon Web Services PCS resource. To delete a tag, specify the tag key and the Amazon
     * Resource Name (ARN) of the Amazon Web Services PCS resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource can't be found. The cluster, node group, or queue
     *         you're attempting to get, update, list, or delete doesn't exist.</p>
     *         <p>
     *         <u>Examples</u></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample PcsAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pcs-2023-02-10/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes tags from an Amazon Web Services PCS resource. To delete a tag, specify the tag key and the Amazon
     * Resource Name (ARN) of the Amazon Web Services PCS resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pcs.model.UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource can't be found. The cluster, node group, or queue
     *         you're attempting to get, update, list, or delete doesn't exist.</p>
     *         <p>
     *         <u>Examples</u></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample PcsAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pcs-2023-02-10/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates a compute node group. You can update many of the fields related to your compute node group including the
     * configurations for networking, compute nodes, and settings specific to your scheduler (such as Slurm).
     * </p>
     *
     * @param updateComputeNodeGroupRequest
     * @return A Java Future containing the result of the UpdateComputeNodeGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException You exceeded your service quota. Service quotas, also referred to as
     *         limits, are the maximum number of service resources or operations for your Amazon Web Services account.
     *         To learn how to increase your service quota, see <a
     *         href="https://docs.aws.amazon.com/servicequotas/latest/userguide/request-quota-increase.html">Requesting
     *         a quota increase</a> in the <i>Service Quotas User Guide</i> </p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The max number of clusters or queues has been reached for the account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The max number of compute node groups has been reached for the associated cluster.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The total of <code>maxInstances</code> across all compute node groups has been reached for associated
     *         cluster.
     *         </p>
     *         </li></li>
     *         <li>ThrottlingException Your request exceeded a request rate quota. Check the resource's request rate
     *         quota and try again.</li>
     *         <li>ValidationException The request isn't valid.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your request contains malformed JSON or unsupported characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The scheduler version isn't supported.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There are networking related errors, such as network validation failure.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         AMI type is <code>CUSTOM</code> and the launch template doesn't define the AMI ID, or the AMI type is AL2
     *         and the launch template defines the AMI.
     *         </p>
     *         </li></li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than 1 operation on the same resource at the same time.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A cluster with the same name already exists.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A cluster isn't in <code>ACTIVE</code> status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A cluster to delete is in an unstable state. For example, because it still has <code>ACTIVE</code> node
     *         groups or queues.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A queue already exists in a cluster.
     *         </p>
     *         </li></li>
     *         <li>ResourceNotFoundException The requested resource can't be found. The cluster, node group, or queue
     *         you're attempting to get, update, list, or delete doesn't exist.</p>
     *         <p>
     *         <u>Examples</u></li>
     *         <li>InternalServerException Amazon Web Services PCS can't process your request right now. Try again
     *         later.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The launch template instance profile doesn't pass <code>iam:PassRole</code> verification.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There is a mismatch between the account ID and cluster ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The cluster ID doesn't exist.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The EC2 instance isn't present.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample PcsAsyncClient.UpdateComputeNodeGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pcs-2023-02-10/UpdateComputeNodeGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateComputeNodeGroupResponse> updateComputeNodeGroup(
            UpdateComputeNodeGroupRequest updateComputeNodeGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a compute node group. You can update many of the fields related to your compute node group including the
     * configurations for networking, compute nodes, and settings specific to your scheduler (such as Slurm).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateComputeNodeGroupRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateComputeNodeGroupRequest#builder()}
     * </p>
     *
     * @param updateComputeNodeGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pcs.model.UpdateComputeNodeGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateComputeNodeGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException You exceeded your service quota. Service quotas, also referred to as
     *         limits, are the maximum number of service resources or operations for your Amazon Web Services account.
     *         To learn how to increase your service quota, see <a
     *         href="https://docs.aws.amazon.com/servicequotas/latest/userguide/request-quota-increase.html">Requesting
     *         a quota increase</a> in the <i>Service Quotas User Guide</i> </p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The max number of clusters or queues has been reached for the account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The max number of compute node groups has been reached for the associated cluster.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The total of <code>maxInstances</code> across all compute node groups has been reached for associated
     *         cluster.
     *         </p>
     *         </li></li>
     *         <li>ThrottlingException Your request exceeded a request rate quota. Check the resource's request rate
     *         quota and try again.</li>
     *         <li>ValidationException The request isn't valid.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your request contains malformed JSON or unsupported characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The scheduler version isn't supported.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There are networking related errors, such as network validation failure.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         AMI type is <code>CUSTOM</code> and the launch template doesn't define the AMI ID, or the AMI type is AL2
     *         and the launch template defines the AMI.
     *         </p>
     *         </li></li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than 1 operation on the same resource at the same time.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A cluster with the same name already exists.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A cluster isn't in <code>ACTIVE</code> status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A cluster to delete is in an unstable state. For example, because it still has <code>ACTIVE</code> node
     *         groups or queues.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A queue already exists in a cluster.
     *         </p>
     *         </li></li>
     *         <li>ResourceNotFoundException The requested resource can't be found. The cluster, node group, or queue
     *         you're attempting to get, update, list, or delete doesn't exist.</p>
     *         <p>
     *         <u>Examples</u></li>
     *         <li>InternalServerException Amazon Web Services PCS can't process your request right now. Try again
     *         later.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The launch template instance profile doesn't pass <code>iam:PassRole</code> verification.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There is a mismatch between the account ID and cluster ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The cluster ID doesn't exist.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The EC2 instance isn't present.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample PcsAsyncClient.UpdateComputeNodeGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pcs-2023-02-10/UpdateComputeNodeGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateComputeNodeGroupResponse> updateComputeNodeGroup(
            Consumer<UpdateComputeNodeGroupRequest.Builder> updateComputeNodeGroupRequest) {
        return updateComputeNodeGroup(UpdateComputeNodeGroupRequest.builder().applyMutation(updateComputeNodeGroupRequest)
                .build());
    }

    /**
     * <p>
     * Updates the compute node group configuration of a queue. Use this API to change the compute node groups that the
     * queue can send jobs to.
     * </p>
     *
     * @param updateQueueRequest
     * @return A Java Future containing the result of the UpdateQueue operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException You exceeded your service quota. Service quotas, also referred to as
     *         limits, are the maximum number of service resources or operations for your Amazon Web Services account.
     *         To learn how to increase your service quota, see <a
     *         href="https://docs.aws.amazon.com/servicequotas/latest/userguide/request-quota-increase.html">Requesting
     *         a quota increase</a> in the <i>Service Quotas User Guide</i> </p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The max number of clusters or queues has been reached for the account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The max number of compute node groups has been reached for the associated cluster.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The total of <code>maxInstances</code> across all compute node groups has been reached for associated
     *         cluster.
     *         </p>
     *         </li></li>
     *         <li>ThrottlingException Your request exceeded a request rate quota. Check the resource's request rate
     *         quota and try again.</li>
     *         <li>ValidationException The request isn't valid.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your request contains malformed JSON or unsupported characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The scheduler version isn't supported.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There are networking related errors, such as network validation failure.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         AMI type is <code>CUSTOM</code> and the launch template doesn't define the AMI ID, or the AMI type is AL2
     *         and the launch template defines the AMI.
     *         </p>
     *         </li></li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than 1 operation on the same resource at the same time.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A cluster with the same name already exists.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A cluster isn't in <code>ACTIVE</code> status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A cluster to delete is in an unstable state. For example, because it still has <code>ACTIVE</code> node
     *         groups or queues.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A queue already exists in a cluster.
     *         </p>
     *         </li></li>
     *         <li>ResourceNotFoundException The requested resource can't be found. The cluster, node group, or queue
     *         you're attempting to get, update, list, or delete doesn't exist.</p>
     *         <p>
     *         <u>Examples</u></li>
     *         <li>InternalServerException Amazon Web Services PCS can't process your request right now. Try again
     *         later.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The launch template instance profile doesn't pass <code>iam:PassRole</code> verification.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There is a mismatch between the account ID and cluster ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The cluster ID doesn't exist.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The EC2 instance isn't present.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample PcsAsyncClient.UpdateQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pcs-2023-02-10/UpdateQueue" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateQueueResponse> updateQueue(UpdateQueueRequest updateQueueRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the compute node group configuration of a queue. Use this API to change the compute node groups that the
     * queue can send jobs to.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateQueueRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateQueueRequest#builder()}
     * </p>
     *
     * @param updateQueueRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pcs.model.UpdateQueueRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateQueue operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException You exceeded your service quota. Service quotas, also referred to as
     *         limits, are the maximum number of service resources or operations for your Amazon Web Services account.
     *         To learn how to increase your service quota, see <a
     *         href="https://docs.aws.amazon.com/servicequotas/latest/userguide/request-quota-increase.html">Requesting
     *         a quota increase</a> in the <i>Service Quotas User Guide</i> </p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The max number of clusters or queues has been reached for the account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The max number of compute node groups has been reached for the associated cluster.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The total of <code>maxInstances</code> across all compute node groups has been reached for associated
     *         cluster.
     *         </p>
     *         </li></li>
     *         <li>ThrottlingException Your request exceeded a request rate quota. Check the resource's request rate
     *         quota and try again.</li>
     *         <li>ValidationException The request isn't valid.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your request contains malformed JSON or unsupported characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The scheduler version isn't supported.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There are networking related errors, such as network validation failure.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         AMI type is <code>CUSTOM</code> and the launch template doesn't define the AMI ID, or the AMI type is AL2
     *         and the launch template defines the AMI.
     *         </p>
     *         </li></li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than 1 operation on the same resource at the same time.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A cluster with the same name already exists.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A cluster isn't in <code>ACTIVE</code> status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A cluster to delete is in an unstable state. For example, because it still has <code>ACTIVE</code> node
     *         groups or queues.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A queue already exists in a cluster.
     *         </p>
     *         </li></li>
     *         <li>ResourceNotFoundException The requested resource can't be found. The cluster, node group, or queue
     *         you're attempting to get, update, list, or delete doesn't exist.</p>
     *         <p>
     *         <u>Examples</u></li>
     *         <li>InternalServerException Amazon Web Services PCS can't process your request right now. Try again
     *         later.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</p>
     *         <p>
     *         <u>Examples</u>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The launch template instance profile doesn't pass <code>iam:PassRole</code> verification.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There is a mismatch between the account ID and cluster ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The cluster ID doesn't exist.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The EC2 instance isn't present.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PcsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample PcsAsyncClient.UpdateQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pcs-2023-02-10/UpdateQueue" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateQueueResponse> updateQueue(Consumer<UpdateQueueRequest.Builder> updateQueueRequest) {
        return updateQueue(UpdateQueueRequest.builder().applyMutation(updateQueueRequest).build());
    }

    @Override
    default PcsServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link PcsAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static PcsAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link PcsAsyncClient}.
     */
    static PcsAsyncClientBuilder builder() {
        return new DefaultPcsAsyncClientBuilder();
    }
}
