/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pcs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * You exceeded your service quota. Service quotas, also referred to as limits, are the maximum number of service
 * resources or operations for your Amazon Web Services account. To learn how to increase your service quota, see <a
 * href="https://docs.aws.amazon.com/servicequotas/latest/userguide/request-quota-increase.html">Requesting a quota
 * increase</a> in the <i>Service Quotas User Guide</i>
 * </p>
 * <p>
 * <u>Examples</u>
 * </p>
 * <ul>
 * <li>
 * <p>
 * The max number of clusters or queues has been reached for the account.
 * </p>
 * </li>
 * <li>
 * <p>
 * The max number of compute node groups has been reached for the associated cluster.
 * </p>
 * </li>
 * <li>
 * <p>
 * The total of <code>maxInstances</code> across all compute node groups has been reached for associated cluster.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceQuotaExceededException extends PcsException implements
        ToCopyableBuilder<ServiceQuotaExceededException.Builder, ServiceQuotaExceededException> {
    private static final SdkField<String> SERVICE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceCode").getter(getter(ServiceQuotaExceededException::serviceCode))
            .setter(setter(Builder::serviceCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceCode").build()).build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceId").getter(getter(ServiceQuotaExceededException::resourceId))
            .setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceId").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceType").getter(getter(ServiceQuotaExceededException::resourceType))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()).build();

    private static final SdkField<String> QUOTA_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("quotaCode").getter(getter(ServiceQuotaExceededException::quotaCode)).setter(setter(Builder::quotaCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("quotaCode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_CODE_FIELD,
            RESOURCE_ID_FIELD, RESOURCE_TYPE_FIELD, QUOTA_CODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String serviceCode;

    private final String resourceId;

    private final String resourceType;

    private final String quotaCode;

    private ServiceQuotaExceededException(BuilderImpl builder) {
        super(builder);
        this.serviceCode = builder.serviceCode;
        this.resourceId = builder.resourceId;
        this.resourceType = builder.resourceType;
        this.quotaCode = builder.quotaCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * <p>
     * The service code associated with the quota that was exceeded.
     * </p>
     * 
     * @return The service code associated with the quota that was exceeded.
     */
    public String serviceCode() {
        return serviceCode;
    }

    /**
     * <p>
     * The unique identifier of the resource that caused the quota to be exceeded.
     * </p>
     * 
     * @return The unique identifier of the resource that caused the quota to be exceeded.
     */
    public String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The type or category of the resource that caused the quota to be exceeded.
     * </p>
     * 
     * @return The type or category of the resource that caused the quota to be exceeded.
     */
    public String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * The <b>quota code</b> of the service quota that was exceeded.
     * </p>
     * 
     * @return The <b>quota code</b> of the service quota that was exceeded.
     */
    public String quotaCode() {
        return quotaCode;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServiceQuotaExceededException, T> g) {
        return obj -> g.apply((ServiceQuotaExceededException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceQuotaExceededException>, PcsException.Builder {
        /**
         * <p>
         * The service code associated with the quota that was exceeded.
         * </p>
         * 
         * @param serviceCode
         *        The service code associated with the quota that was exceeded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceCode(String serviceCode);

        /**
         * <p>
         * The unique identifier of the resource that caused the quota to be exceeded.
         * </p>
         * 
         * @param resourceId
         *        The unique identifier of the resource that caused the quota to be exceeded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * The type or category of the resource that caused the quota to be exceeded.
         * </p>
         * 
         * @param resourceType
         *        The type or category of the resource that caused the quota to be exceeded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The <b>quota code</b> of the service quota that was exceeded.
         * </p>
         * 
         * @param quotaCode
         *        The <b>quota code</b> of the service quota that was exceeded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quotaCode(String quotaCode);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);

        @Override
        Builder writableStackTrace(Boolean writableStackTrace);
    }

    static final class BuilderImpl extends PcsException.BuilderImpl implements Builder {
        private String serviceCode;

        private String resourceId;

        private String resourceType;

        private String quotaCode;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceQuotaExceededException model) {
            super(model);
            serviceCode(model.serviceCode);
            resourceId(model.resourceId);
            resourceType(model.resourceType);
            quotaCode(model.quotaCode);
        }

        public final String getServiceCode() {
            return serviceCode;
        }

        public final void setServiceCode(String serviceCode) {
            this.serviceCode = serviceCode;
        }

        @Override
        public final Builder serviceCode(String serviceCode) {
            this.serviceCode = serviceCode;
            return this;
        }

        public final String getResourceId() {
            return resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final String getQuotaCode() {
            return quotaCode;
        }

        public final void setQuotaCode(String quotaCode) {
            this.quotaCode = quotaCode;
        }

        @Override
        public final Builder quotaCode(String quotaCode) {
            this.quotaCode = quotaCode;
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public BuilderImpl writableStackTrace(Boolean writableStackTrace) {
            this.writableStackTrace = writableStackTrace;
            return this;
        }

        @Override
        public ServiceQuotaExceededException build() {
            return new ServiceQuotaExceededException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
