/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pcs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An endpoint available for interaction with the scheduler.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Endpoint implements SdkPojo, Serializable, ToCopyableBuilder<Endpoint.Builder, Endpoint> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(Endpoint::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> PRIVATE_IP_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("privateIpAddress").getter(getter(Endpoint::privateIpAddress)).setter(setter(Builder::privateIpAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("privateIpAddress").build()).build();

    private static final SdkField<String> PUBLIC_IP_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("publicIpAddress").getter(getter(Endpoint::publicIpAddress)).setter(setter(Builder::publicIpAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publicIpAddress").build()).build();

    private static final SdkField<String> PORT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("port")
            .getter(getter(Endpoint::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("port").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD,
            PRIVATE_IP_ADDRESS_FIELD, PUBLIC_IP_ADDRESS_FIELD, PORT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String privateIpAddress;

    private final String publicIpAddress;

    private final String port;

    private Endpoint(BuilderImpl builder) {
        this.type = builder.type;
        this.privateIpAddress = builder.privateIpAddress;
        this.publicIpAddress = builder.publicIpAddress;
        this.port = builder.port;
    }

    /**
     * <p>
     * Indicates the type of endpoint running at the specific IP address.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link EndpointType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Indicates the type of endpoint running at the specific IP address.
     * @see EndpointType
     */
    public final EndpointType type() {
        return EndpointType.fromValue(type);
    }

    /**
     * <p>
     * Indicates the type of endpoint running at the specific IP address.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link EndpointType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Indicates the type of endpoint running at the specific IP address.
     * @see EndpointType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The endpoint's private IP address.
     * </p>
     * <p>
     * Example: <code>2.2.2.2</code>
     * </p>
     * 
     * @return The endpoint's private IP address.</p>
     *         <p>
     *         Example: <code>2.2.2.2</code>
     */
    public final String privateIpAddress() {
        return privateIpAddress;
    }

    /**
     * <p>
     * The endpoint's public IP address.
     * </p>
     * <p>
     * Example: <code>1.1.1.1</code>
     * </p>
     * 
     * @return The endpoint's public IP address.</p>
     *         <p>
     *         Example: <code>1.1.1.1</code>
     */
    public final String publicIpAddress() {
        return publicIpAddress;
    }

    /**
     * <p>
     * The endpoint's connection port number.
     * </p>
     * <p>
     * Example: <code>1234</code>
     * </p>
     * 
     * @return The endpoint's connection port number.</p>
     *         <p>
     *         Example: <code>1234</code>
     */
    public final String port() {
        return port;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(privateIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(publicIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Endpoint)) {
            return false;
        }
        Endpoint other = (Endpoint) obj;
        return Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(privateIpAddress(), other.privateIpAddress())
                && Objects.equals(publicIpAddress(), other.publicIpAddress()) && Objects.equals(port(), other.port());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Endpoint").add("Type", typeAsString()).add("PrivateIpAddress", privateIpAddress())
                .add("PublicIpAddress", publicIpAddress()).add("Port", port()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "privateIpAddress":
            return Optional.ofNullable(clazz.cast(privateIpAddress()));
        case "publicIpAddress":
            return Optional.ofNullable(clazz.cast(publicIpAddress()));
        case "port":
            return Optional.ofNullable(clazz.cast(port()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Endpoint, T> g) {
        return obj -> g.apply((Endpoint) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Endpoint> {
        /**
         * <p>
         * Indicates the type of endpoint running at the specific IP address.
         * </p>
         * 
         * @param type
         *        Indicates the type of endpoint running at the specific IP address.
         * @see EndpointType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EndpointType
         */
        Builder type(String type);

        /**
         * <p>
         * Indicates the type of endpoint running at the specific IP address.
         * </p>
         * 
         * @param type
         *        Indicates the type of endpoint running at the specific IP address.
         * @see EndpointType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EndpointType
         */
        Builder type(EndpointType type);

        /**
         * <p>
         * The endpoint's private IP address.
         * </p>
         * <p>
         * Example: <code>2.2.2.2</code>
         * </p>
         * 
         * @param privateIpAddress
         *        The endpoint's private IP address.</p>
         *        <p>
         *        Example: <code>2.2.2.2</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddress(String privateIpAddress);

        /**
         * <p>
         * The endpoint's public IP address.
         * </p>
         * <p>
         * Example: <code>1.1.1.1</code>
         * </p>
         * 
         * @param publicIpAddress
         *        The endpoint's public IP address.</p>
         *        <p>
         *        Example: <code>1.1.1.1</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicIpAddress(String publicIpAddress);

        /**
         * <p>
         * The endpoint's connection port number.
         * </p>
         * <p>
         * Example: <code>1234</code>
         * </p>
         * 
         * @param port
         *        The endpoint's connection port number.</p>
         *        <p>
         *        Example: <code>1234</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(String port);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String privateIpAddress;

        private String publicIpAddress;

        private String port;

        private BuilderImpl() {
        }

        private BuilderImpl(Endpoint model) {
            type(model.type);
            privateIpAddress(model.privateIpAddress);
            publicIpAddress(model.publicIpAddress);
            port(model.port);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(EndpointType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getPrivateIpAddress() {
            return privateIpAddress;
        }

        public final void setPrivateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
        }

        @Override
        public final Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        public final String getPublicIpAddress() {
            return publicIpAddress;
        }

        public final void setPublicIpAddress(String publicIpAddress) {
            this.publicIpAddress = publicIpAddress;
        }

        @Override
        public final Builder publicIpAddress(String publicIpAddress) {
            this.publicIpAddress = publicIpAddress;
            return this;
        }

        public final String getPort() {
            return port;
        }

        public final void setPort(String port) {
            this.port = port;
        }

        @Override
        public final Builder port(String port) {
            this.port = port;
            return this;
        }

        @Override
        public Endpoint build() {
            return new Endpoint(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
