/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pcaconnectorscep.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OpenIdConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OpenIdConfiguration> {
    private static final SdkField<String> ISSUER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Issuer").getter(OpenIdConfiguration.getter(OpenIdConfiguration::issuer)).setter(OpenIdConfiguration.setter(Builder::issuer)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Issuer").build()}).build();
    private static final SdkField<String> SUBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Subject").getter(OpenIdConfiguration.getter(OpenIdConfiguration::subject)).setter(OpenIdConfiguration.setter(Builder::subject)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subject").build()}).build();
    private static final SdkField<String> AUDIENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Audience").getter(OpenIdConfiguration.getter(OpenIdConfiguration::audience)).setter(OpenIdConfiguration.setter(Builder::audience)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Audience").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ISSUER_FIELD, SUBJECT_FIELD, AUDIENCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OpenIdConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String issuer;
    private final String subject;
    private final String audience;

    private OpenIdConfiguration(BuilderImpl builder) {
        this.issuer = builder.issuer;
        this.subject = builder.subject;
        this.audience = builder.audience;
    }

    public final String issuer() {
        return this.issuer;
    }

    public final String subject() {
        return this.subject;
    }

    public final String audience() {
        return this.audience;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.issuer());
        hashCode = 31 * hashCode + Objects.hashCode(this.subject());
        hashCode = 31 * hashCode + Objects.hashCode(this.audience());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpenIdConfiguration)) {
            return false;
        }
        OpenIdConfiguration other = (OpenIdConfiguration)obj;
        return Objects.equals(this.issuer(), other.issuer()) && Objects.equals(this.subject(), other.subject()) && Objects.equals(this.audience(), other.audience());
    }

    public final String toString() {
        return ToString.builder((String)"OpenIdConfiguration").add("Issuer", (Object)this.issuer()).add("Subject", (Object)this.subject()).add("Audience", (Object)this.audience()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Issuer": {
                return Optional.ofNullable(clazz.cast(this.issuer()));
            }
            case "Subject": {
                return Optional.ofNullable(clazz.cast(this.subject()));
            }
            case "Audience": {
                return Optional.ofNullable(clazz.cast(this.audience()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Issuer", ISSUER_FIELD);
        map.put("Subject", SUBJECT_FIELD);
        map.put("Audience", AUDIENCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OpenIdConfiguration, T> g) {
        return obj -> g.apply((OpenIdConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String issuer;
        private String subject;
        private String audience;

        private BuilderImpl() {
        }

        private BuilderImpl(OpenIdConfiguration model) {
            this.issuer(model.issuer);
            this.subject(model.subject);
            this.audience(model.audience);
        }

        public final String getIssuer() {
            return this.issuer;
        }

        public final void setIssuer(String issuer) {
            this.issuer = issuer;
        }

        @Override
        public final Builder issuer(String issuer) {
            this.issuer = issuer;
            return this;
        }

        public final String getSubject() {
            return this.subject;
        }

        public final void setSubject(String subject) {
            this.subject = subject;
        }

        @Override
        public final Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public final String getAudience() {
            return this.audience;
        }

        public final void setAudience(String audience) {
            this.audience = audience;
        }

        @Override
        public final Builder audience(String audience) {
            this.audience = audience;
            return this;
        }

        public OpenIdConfiguration build() {
            return new OpenIdConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OpenIdConfiguration> {
        public Builder issuer(String var1);

        public Builder subject(String var1);

        public Builder audience(String var1);
    }
}

