/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pcaconnectorscep.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pcaconnectorscep.model.ChallengeMetadataListCopier;
import software.amazon.awssdk.services.pcaconnectorscep.model.ChallengeMetadataSummary;
import software.amazon.awssdk.services.pcaconnectorscep.model.PcaConnectorScepResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListChallengeMetadataResponse
extends PcaConnectorScepResponse
implements ToCopyableBuilder<Builder, ListChallengeMetadataResponse> {
    private static final SdkField<List<ChallengeMetadataSummary>> CHALLENGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Challenges").getter(ListChallengeMetadataResponse.getter(ListChallengeMetadataResponse::challenges)).setter(ListChallengeMetadataResponse.setter(Builder::challenges)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Challenges").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ChallengeMetadataSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListChallengeMetadataResponse.getter(ListChallengeMetadataResponse::nextToken)).setter(ListChallengeMetadataResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHALLENGES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListChallengeMetadataResponse.memberNameToFieldInitializer();
    private final List<ChallengeMetadataSummary> challenges;
    private final String nextToken;

    private ListChallengeMetadataResponse(BuilderImpl builder) {
        super(builder);
        this.challenges = builder.challenges;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasChallenges() {
        return this.challenges != null && !(this.challenges instanceof SdkAutoConstructList);
    }

    public final List<ChallengeMetadataSummary> challenges() {
        return this.challenges;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasChallenges() ? this.challenges() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListChallengeMetadataResponse)) {
            return false;
        }
        ListChallengeMetadataResponse other = (ListChallengeMetadataResponse)((Object)obj);
        return this.hasChallenges() == other.hasChallenges() && Objects.equals(this.challenges(), other.challenges()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListChallengeMetadataResponse").add("Challenges", this.hasChallenges() ? this.challenges() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Challenges": {
                return Optional.ofNullable(clazz.cast(this.challenges()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Challenges", CHALLENGES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListChallengeMetadataResponse, T> g) {
        return obj -> g.apply((ListChallengeMetadataResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PcaConnectorScepResponse.BuilderImpl
    implements Builder {
        private List<ChallengeMetadataSummary> challenges = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListChallengeMetadataResponse model) {
            super(model);
            this.challenges(model.challenges);
            this.nextToken(model.nextToken);
        }

        public final List<ChallengeMetadataSummary.Builder> getChallenges() {
            List<ChallengeMetadataSummary.Builder> result = ChallengeMetadataListCopier.copyToBuilder(this.challenges);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChallenges(Collection<ChallengeMetadataSummary.BuilderImpl> challenges) {
            this.challenges = ChallengeMetadataListCopier.copyFromBuilder(challenges);
        }

        @Override
        public final Builder challenges(Collection<ChallengeMetadataSummary> challenges) {
            this.challenges = ChallengeMetadataListCopier.copy(challenges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder challenges(ChallengeMetadataSummary ... challenges) {
            this.challenges(Arrays.asList(challenges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder challenges(Consumer<ChallengeMetadataSummary.Builder> ... challenges) {
            this.challenges(Stream.of(challenges).map(c -> (ChallengeMetadataSummary)((ChallengeMetadataSummary.Builder)ChallengeMetadataSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListChallengeMetadataResponse build() {
            return new ListChallengeMetadataResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PcaConnectorScepResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListChallengeMetadataResponse> {
        public Builder challenges(Collection<ChallengeMetadataSummary> var1);

        public Builder challenges(ChallengeMetadataSummary ... var1);

        public Builder challenges(Consumer<ChallengeMetadataSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

