/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pcaconnectorscep.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListChallengeMetadataResponse extends PcaConnectorScepResponse implements
        ToCopyableBuilder<ListChallengeMetadataResponse.Builder, ListChallengeMetadataResponse> {
    private static final SdkField<List<ChallengeMetadataSummary>> CHALLENGES_FIELD = SdkField
            .<List<ChallengeMetadataSummary>> builder(MarshallingType.LIST)
            .memberName("Challenges")
            .getter(getter(ListChallengeMetadataResponse::challenges))
            .setter(setter(Builder::challenges))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Challenges").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ChallengeMetadataSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ChallengeMetadataSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListChallengeMetadataResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHALLENGES_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ChallengeMetadataSummary> challenges;

    private final String nextToken;

    private ListChallengeMetadataResponse(BuilderImpl builder) {
        super(builder);
        this.challenges = builder.challenges;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Challenges property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasChallenges() {
        return challenges != null && !(challenges instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The challenge metadata for the challenges belonging to your Amazon Web Services account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasChallenges} method.
     * </p>
     * 
     * @return The challenge metadata for the challenges belonging to your Amazon Web Services account.
     */
    public final List<ChallengeMetadataSummary> challenges() {
        return challenges;
    }

    /**
     * <p>
     * When you request a list of objects with a <code>MaxResults</code> setting, if the number of objects that are
     * still available for retrieval exceeds the maximum you requested, Connector for SCEP returns a
     * <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token returned from
     * the prior request in your next request.
     * </p>
     * 
     * @return When you request a list of objects with a <code>MaxResults</code> setting, if the number of objects that
     *         are still available for retrieval exceeds the maximum you requested, Connector for SCEP returns a
     *         <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token
     *         returned from the prior request in your next request.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasChallenges() ? challenges() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListChallengeMetadataResponse)) {
            return false;
        }
        ListChallengeMetadataResponse other = (ListChallengeMetadataResponse) obj;
        return hasChallenges() == other.hasChallenges() && Objects.equals(challenges(), other.challenges())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListChallengeMetadataResponse").add("Challenges", hasChallenges() ? challenges() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Challenges":
            return Optional.ofNullable(clazz.cast(challenges()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Challenges", CHALLENGES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListChallengeMetadataResponse, T> g) {
        return obj -> g.apply((ListChallengeMetadataResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PcaConnectorScepResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListChallengeMetadataResponse> {
        /**
         * <p>
         * The challenge metadata for the challenges belonging to your Amazon Web Services account.
         * </p>
         * 
         * @param challenges
         *        The challenge metadata for the challenges belonging to your Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder challenges(Collection<ChallengeMetadataSummary> challenges);

        /**
         * <p>
         * The challenge metadata for the challenges belonging to your Amazon Web Services account.
         * </p>
         * 
         * @param challenges
         *        The challenge metadata for the challenges belonging to your Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder challenges(ChallengeMetadataSummary... challenges);

        /**
         * <p>
         * The challenge metadata for the challenges belonging to your Amazon Web Services account.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.pcaconnectorscep.model.ChallengeMetadataSummary.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.pcaconnectorscep.model.ChallengeMetadataSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.pcaconnectorscep.model.ChallengeMetadataSummary.Builder#build()} is
         * called immediately and its result is passed to {@link #challenges(List<ChallengeMetadataSummary>)}.
         * 
         * @param challenges
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.pcaconnectorscep.model.ChallengeMetadataSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #challenges(java.util.Collection<ChallengeMetadataSummary>)
         */
        Builder challenges(Consumer<ChallengeMetadataSummary.Builder>... challenges);

        /**
         * <p>
         * When you request a list of objects with a <code>MaxResults</code> setting, if the number of objects that are
         * still available for retrieval exceeds the maximum you requested, Connector for SCEP returns a
         * <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token returned
         * from the prior request in your next request.
         * </p>
         * 
         * @param nextToken
         *        When you request a list of objects with a <code>MaxResults</code> setting, if the number of objects
         *        that are still available for retrieval exceeds the maximum you requested, Connector for SCEP returns a
         *        <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token
         *        returned from the prior request in your next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends PcaConnectorScepResponse.BuilderImpl implements Builder {
        private List<ChallengeMetadataSummary> challenges = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListChallengeMetadataResponse model) {
            super(model);
            challenges(model.challenges);
            nextToken(model.nextToken);
        }

        public final List<ChallengeMetadataSummary.Builder> getChallenges() {
            List<ChallengeMetadataSummary.Builder> result = ChallengeMetadataListCopier.copyToBuilder(this.challenges);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChallenges(Collection<ChallengeMetadataSummary.BuilderImpl> challenges) {
            this.challenges = ChallengeMetadataListCopier.copyFromBuilder(challenges);
        }

        @Override
        public final Builder challenges(Collection<ChallengeMetadataSummary> challenges) {
            this.challenges = ChallengeMetadataListCopier.copy(challenges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder challenges(ChallengeMetadataSummary... challenges) {
            challenges(Arrays.asList(challenges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder challenges(Consumer<ChallengeMetadataSummary.Builder>... challenges) {
            challenges(Stream.of(challenges).map(c -> ChallengeMetadataSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListChallengeMetadataResponse build() {
            return new ListChallengeMetadataResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
