/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class VerifyMacRequest extends PaymentCryptographyDataRequest implements
        ToCopyableBuilder<VerifyMacRequest.Builder, VerifyMacRequest> {
    private static final SdkField<String> KEY_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KeyIdentifier").getter(getter(VerifyMacRequest::keyIdentifier)).setter(setter(Builder::keyIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyIdentifier").build()).build();

    private static final SdkField<String> MAC_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Mac")
            .getter(getter(VerifyMacRequest::mac)).setter(setter(Builder::mac))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mac").build()).build();

    private static final SdkField<Integer> MAC_LENGTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MacLength").getter(getter(VerifyMacRequest::macLength)).setter(setter(Builder::macLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MacLength").build()).build();

    private static final SdkField<String> MESSAGE_DATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MessageData").getter(getter(VerifyMacRequest::messageData)).setter(setter(Builder::messageData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageData").build()).build();

    private static final SdkField<MacAttributes> VERIFICATION_ATTRIBUTES_FIELD = SdkField
            .<MacAttributes> builder(MarshallingType.SDK_POJO).memberName("VerificationAttributes")
            .getter(getter(VerifyMacRequest::verificationAttributes)).setter(setter(Builder::verificationAttributes))
            .constructor(MacAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerificationAttributes").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_IDENTIFIER_FIELD,
            MAC_FIELD, MAC_LENGTH_FIELD, MESSAGE_DATA_FIELD, VERIFICATION_ATTRIBUTES_FIELD));

    private final String keyIdentifier;

    private final String mac;

    private final Integer macLength;

    private final String messageData;

    private final MacAttributes verificationAttributes;

    private VerifyMacRequest(BuilderImpl builder) {
        super(builder);
        this.keyIdentifier = builder.keyIdentifier;
        this.mac = builder.mac;
        this.macLength = builder.macLength;
        this.messageData = builder.messageData;
        this.verificationAttributes = builder.verificationAttributes;
    }

    /**
     * <p>
     * The <code>keyARN</code> of the encryption key that Amazon Web Services Payment Cryptography uses to verify MAC
     * data.
     * </p>
     * 
     * @return The <code>keyARN</code> of the encryption key that Amazon Web Services Payment Cryptography uses to
     *         verify MAC data.
     */
    public final String keyIdentifier() {
        return keyIdentifier;
    }

    /**
     * <p>
     * The MAC being verified.
     * </p>
     * 
     * @return The MAC being verified.
     */
    public final String mac() {
        return mac;
    }

    /**
     * <p>
     * The length of the MAC.
     * </p>
     * 
     * @return The length of the MAC.
     */
    public final Integer macLength() {
        return macLength;
    }

    /**
     * <p>
     * The data on for which MAC is under verification. This value must be hexBinary.
     * </p>
     * 
     * @return The data on for which MAC is under verification. This value must be hexBinary.
     */
    public final String messageData() {
        return messageData;
    }

    /**
     * <p>
     * The attributes and data values to use for MAC verification within Amazon Web Services Payment Cryptography.
     * </p>
     * 
     * @return The attributes and data values to use for MAC verification within Amazon Web Services Payment
     *         Cryptography.
     */
    public final MacAttributes verificationAttributes() {
        return verificationAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(keyIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(mac());
        hashCode = 31 * hashCode + Objects.hashCode(macLength());
        hashCode = 31 * hashCode + Objects.hashCode(messageData());
        hashCode = 31 * hashCode + Objects.hashCode(verificationAttributes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VerifyMacRequest)) {
            return false;
        }
        VerifyMacRequest other = (VerifyMacRequest) obj;
        return Objects.equals(keyIdentifier(), other.keyIdentifier()) && Objects.equals(mac(), other.mac())
                && Objects.equals(macLength(), other.macLength()) && Objects.equals(messageData(), other.messageData())
                && Objects.equals(verificationAttributes(), other.verificationAttributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VerifyMacRequest").add("KeyIdentifier", keyIdentifier())
                .add("Mac", mac() == null ? null : "*** Sensitive Data Redacted ***").add("MacLength", macLength())
                .add("MessageData", messageData() == null ? null : "*** Sensitive Data Redacted ***")
                .add("VerificationAttributes", verificationAttributes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KeyIdentifier":
            return Optional.ofNullable(clazz.cast(keyIdentifier()));
        case "Mac":
            return Optional.ofNullable(clazz.cast(mac()));
        case "MacLength":
            return Optional.ofNullable(clazz.cast(macLength()));
        case "MessageData":
            return Optional.ofNullable(clazz.cast(messageData()));
        case "VerificationAttributes":
            return Optional.ofNullable(clazz.cast(verificationAttributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VerifyMacRequest, T> g) {
        return obj -> g.apply((VerifyMacRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PaymentCryptographyDataRequest.Builder, SdkPojo, CopyableBuilder<Builder, VerifyMacRequest> {
        /**
         * <p>
         * The <code>keyARN</code> of the encryption key that Amazon Web Services Payment Cryptography uses to verify
         * MAC data.
         * </p>
         * 
         * @param keyIdentifier
         *        The <code>keyARN</code> of the encryption key that Amazon Web Services Payment Cryptography uses to
         *        verify MAC data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyIdentifier(String keyIdentifier);

        /**
         * <p>
         * The MAC being verified.
         * </p>
         * 
         * @param mac
         *        The MAC being verified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mac(String mac);

        /**
         * <p>
         * The length of the MAC.
         * </p>
         * 
         * @param macLength
         *        The length of the MAC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder macLength(Integer macLength);

        /**
         * <p>
         * The data on for which MAC is under verification. This value must be hexBinary.
         * </p>
         * 
         * @param messageData
         *        The data on for which MAC is under verification. This value must be hexBinary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageData(String messageData);

        /**
         * <p>
         * The attributes and data values to use for MAC verification within Amazon Web Services Payment Cryptography.
         * </p>
         * 
         * @param verificationAttributes
         *        The attributes and data values to use for MAC verification within Amazon Web Services Payment
         *        Cryptography.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verificationAttributes(MacAttributes verificationAttributes);

        /**
         * <p>
         * The attributes and data values to use for MAC verification within Amazon Web Services Payment Cryptography.
         * </p>
         * This is a convenience method that creates an instance of the {@link MacAttributes.Builder} avoiding the need
         * to create one manually via {@link MacAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MacAttributes.Builder#build()} is called immediately and its
         * result is passed to {@link #verificationAttributes(MacAttributes)}.
         * 
         * @param verificationAttributes
         *        a consumer that will call methods on {@link MacAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #verificationAttributes(MacAttributes)
         */
        default Builder verificationAttributes(Consumer<MacAttributes.Builder> verificationAttributes) {
            return verificationAttributes(MacAttributes.builder().applyMutation(verificationAttributes).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PaymentCryptographyDataRequest.BuilderImpl implements Builder {
        private String keyIdentifier;

        private String mac;

        private Integer macLength;

        private String messageData;

        private MacAttributes verificationAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(VerifyMacRequest model) {
            super(model);
            keyIdentifier(model.keyIdentifier);
            mac(model.mac);
            macLength(model.macLength);
            messageData(model.messageData);
            verificationAttributes(model.verificationAttributes);
        }

        public final String getKeyIdentifier() {
            return keyIdentifier;
        }

        public final void setKeyIdentifier(String keyIdentifier) {
            this.keyIdentifier = keyIdentifier;
        }

        @Override
        public final Builder keyIdentifier(String keyIdentifier) {
            this.keyIdentifier = keyIdentifier;
            return this;
        }

        public final String getMac() {
            return mac;
        }

        public final void setMac(String mac) {
            this.mac = mac;
        }

        @Override
        public final Builder mac(String mac) {
            this.mac = mac;
            return this;
        }

        public final Integer getMacLength() {
            return macLength;
        }

        public final void setMacLength(Integer macLength) {
            this.macLength = macLength;
        }

        @Override
        public final Builder macLength(Integer macLength) {
            this.macLength = macLength;
            return this;
        }

        public final String getMessageData() {
            return messageData;
        }

        public final void setMessageData(String messageData) {
            this.messageData = messageData;
        }

        @Override
        public final Builder messageData(String messageData) {
            this.messageData = messageData;
            return this;
        }

        public final MacAttributes.Builder getVerificationAttributes() {
            return verificationAttributes != null ? verificationAttributes.toBuilder() : null;
        }

        public final void setVerificationAttributes(MacAttributes.BuilderImpl verificationAttributes) {
            this.verificationAttributes = verificationAttributes != null ? verificationAttributes.build() : null;
        }

        @Override
        public final Builder verificationAttributes(MacAttributes verificationAttributes) {
            this.verificationAttributes = verificationAttributes;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public VerifyMacRequest build() {
            return new VerifyMacRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
