/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class VerifyCardValidationDataResponse extends PaymentCryptographyDataResponse implements
        ToCopyableBuilder<VerifyCardValidationDataResponse.Builder, VerifyCardValidationDataResponse> {
    private static final SdkField<String> KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("KeyArn")
            .getter(getter(VerifyCardValidationDataResponse::keyArn)).setter(setter(Builder::keyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyArn").build()).build();

    private static final SdkField<String> KEY_CHECK_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KeyCheckValue").getter(getter(VerifyCardValidationDataResponse::keyCheckValue))
            .setter(setter(Builder::keyCheckValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyCheckValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_ARN_FIELD,
            KEY_CHECK_VALUE_FIELD));

    private final String keyArn;

    private final String keyCheckValue;

    private VerifyCardValidationDataResponse(BuilderImpl builder) {
        super(builder);
        this.keyArn = builder.keyArn;
        this.keyCheckValue = builder.keyCheckValue;
    }

    /**
     * <p>
     * The <code>keyARN</code> of the CVK encryption key that Amazon Web Services Payment Cryptography uses to verify
     * CVV or CSC.
     * </p>
     * 
     * @return The <code>keyARN</code> of the CVK encryption key that Amazon Web Services Payment Cryptography uses to
     *         verify CVV or CSC.
     */
    public final String keyArn() {
        return keyArn;
    }

    /**
     * <p>
     * The key check value (KCV) of the encryption key. The KCV is used to check if all parties holding a given key have
     * the same key or to detect that a key has changed.
     * </p>
     * <p>
     * Amazon Web Services Payment Cryptography computes the KCV according to the CMAC specification.
     * </p>
     * 
     * @return The key check value (KCV) of the encryption key. The KCV is used to check if all parties holding a given
     *         key have the same key or to detect that a key has changed.</p>
     *         <p>
     *         Amazon Web Services Payment Cryptography computes the KCV according to the CMAC specification.
     */
    public final String keyCheckValue() {
        return keyCheckValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(keyArn());
        hashCode = 31 * hashCode + Objects.hashCode(keyCheckValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VerifyCardValidationDataResponse)) {
            return false;
        }
        VerifyCardValidationDataResponse other = (VerifyCardValidationDataResponse) obj;
        return Objects.equals(keyArn(), other.keyArn()) && Objects.equals(keyCheckValue(), other.keyCheckValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VerifyCardValidationDataResponse").add("KeyArn", keyArn()).add("KeyCheckValue", keyCheckValue())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KeyArn":
            return Optional.ofNullable(clazz.cast(keyArn()));
        case "KeyCheckValue":
            return Optional.ofNullable(clazz.cast(keyCheckValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VerifyCardValidationDataResponse, T> g) {
        return obj -> g.apply((VerifyCardValidationDataResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PaymentCryptographyDataResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, VerifyCardValidationDataResponse> {
        /**
         * <p>
         * The <code>keyARN</code> of the CVK encryption key that Amazon Web Services Payment Cryptography uses to
         * verify CVV or CSC.
         * </p>
         * 
         * @param keyArn
         *        The <code>keyARN</code> of the CVK encryption key that Amazon Web Services Payment Cryptography uses
         *        to verify CVV or CSC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyArn(String keyArn);

        /**
         * <p>
         * The key check value (KCV) of the encryption key. The KCV is used to check if all parties holding a given key
         * have the same key or to detect that a key has changed.
         * </p>
         * <p>
         * Amazon Web Services Payment Cryptography computes the KCV according to the CMAC specification.
         * </p>
         * 
         * @param keyCheckValue
         *        The key check value (KCV) of the encryption key. The KCV is used to check if all parties holding a
         *        given key have the same key or to detect that a key has changed.</p>
         *        <p>
         *        Amazon Web Services Payment Cryptography computes the KCV according to the CMAC specification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyCheckValue(String keyCheckValue);
    }

    static final class BuilderImpl extends PaymentCryptographyDataResponse.BuilderImpl implements Builder {
        private String keyArn;

        private String keyCheckValue;

        private BuilderImpl() {
        }

        private BuilderImpl(VerifyCardValidationDataResponse model) {
            super(model);
            keyArn(model.keyArn);
            keyCheckValue(model.keyCheckValue);
        }

        public final String getKeyArn() {
            return keyArn;
        }

        public final void setKeyArn(String keyArn) {
            this.keyArn = keyArn;
        }

        @Override
        public final Builder keyArn(String keyArn) {
            this.keyArn = keyArn;
            return this;
        }

        public final String getKeyCheckValue() {
            return keyCheckValue;
        }

        public final void setKeyCheckValue(String keyCheckValue) {
            this.keyCheckValue = keyCheckValue;
        }

        @Override
        public final Builder keyCheckValue(String keyCheckValue) {
            this.keyCheckValue = keyCheckValue;
            return this;
        }

        @Override
        public VerifyCardValidationDataResponse build() {
            return new VerifyCardValidationDataResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
