/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Parameters that are required for DUKPT, HMAC, or EMV MAC generation or verification.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MacAttributes implements SdkPojo, Serializable, ToCopyableBuilder<MacAttributes.Builder, MacAttributes> {
    private static final SdkField<String> ALGORITHM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Algorithm").getter(getter(MacAttributes::algorithmAsString)).setter(setter(Builder::algorithm))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Algorithm").build()).build();

    private static final SdkField<MacAlgorithmDukpt> DUKPT_CMAC_FIELD = SdkField
            .<MacAlgorithmDukpt> builder(MarshallingType.SDK_POJO).memberName("DukptCmac")
            .getter(getter(MacAttributes::dukptCmac)).setter(setter(Builder::dukptCmac)).constructor(MacAlgorithmDukpt::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DukptCmac").build()).build();

    private static final SdkField<MacAlgorithmDukpt> DUKPT_ISO9797_ALGORITHM1_FIELD = SdkField
            .<MacAlgorithmDukpt> builder(MarshallingType.SDK_POJO).memberName("DukptIso9797Algorithm1")
            .getter(getter(MacAttributes::dukptIso9797Algorithm1)).setter(setter(Builder::dukptIso9797Algorithm1))
            .constructor(MacAlgorithmDukpt::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DukptIso9797Algorithm1").build())
            .build();

    private static final SdkField<MacAlgorithmDukpt> DUKPT_ISO9797_ALGORITHM3_FIELD = SdkField
            .<MacAlgorithmDukpt> builder(MarshallingType.SDK_POJO).memberName("DukptIso9797Algorithm3")
            .getter(getter(MacAttributes::dukptIso9797Algorithm3)).setter(setter(Builder::dukptIso9797Algorithm3))
            .constructor(MacAlgorithmDukpt::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DukptIso9797Algorithm3").build())
            .build();

    private static final SdkField<MacAlgorithmEmv> EMV_MAC_FIELD = SdkField.<MacAlgorithmEmv> builder(MarshallingType.SDK_POJO)
            .memberName("EmvMac").getter(getter(MacAttributes::emvMac)).setter(setter(Builder::emvMac))
            .constructor(MacAlgorithmEmv::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmvMac").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALGORITHM_FIELD,
            DUKPT_CMAC_FIELD, DUKPT_ISO9797_ALGORITHM1_FIELD, DUKPT_ISO9797_ALGORITHM3_FIELD, EMV_MAC_FIELD));

    private static final long serialVersionUID = 1L;

    private final String algorithm;

    private final MacAlgorithmDukpt dukptCmac;

    private final MacAlgorithmDukpt dukptIso9797Algorithm1;

    private final MacAlgorithmDukpt dukptIso9797Algorithm3;

    private final MacAlgorithmEmv emvMac;

    private final Type type;

    private MacAttributes(BuilderImpl builder) {
        this.algorithm = builder.algorithm;
        this.dukptCmac = builder.dukptCmac;
        this.dukptIso9797Algorithm1 = builder.dukptIso9797Algorithm1;
        this.dukptIso9797Algorithm3 = builder.dukptIso9797Algorithm3;
        this.emvMac = builder.emvMac;
        this.type = builder.type;
    }

    /**
     * <p>
     * The encryption algorithm for MAC generation or verification.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #algorithm} will
     * return {@link MacAlgorithm#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #algorithmAsString}.
     * </p>
     * 
     * @return The encryption algorithm for MAC generation or verification.
     * @see MacAlgorithm
     */
    public final MacAlgorithm algorithm() {
        return MacAlgorithm.fromValue(algorithm);
    }

    /**
     * <p>
     * The encryption algorithm for MAC generation or verification.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #algorithm} will
     * return {@link MacAlgorithm#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #algorithmAsString}.
     * </p>
     * 
     * @return The encryption algorithm for MAC generation or verification.
     * @see MacAlgorithm
     */
    public final String algorithmAsString() {
        return algorithm;
    }

    /**
     * <p>
     * Parameters that are required for MAC generation or verification using DUKPT CMAC algorithm.
     * </p>
     * 
     * @return Parameters that are required for MAC generation or verification using DUKPT CMAC algorithm.
     */
    public final MacAlgorithmDukpt dukptCmac() {
        return dukptCmac;
    }

    /**
     * <p>
     * Parameters that are required for MAC generation or verification using DUKPT ISO 9797 algorithm1.
     * </p>
     * 
     * @return Parameters that are required for MAC generation or verification using DUKPT ISO 9797 algorithm1.
     */
    public final MacAlgorithmDukpt dukptIso9797Algorithm1() {
        return dukptIso9797Algorithm1;
    }

    /**
     * <p>
     * Parameters that are required for MAC generation or verification using DUKPT ISO 9797 algorithm3.
     * </p>
     * 
     * @return Parameters that are required for MAC generation or verification using DUKPT ISO 9797 algorithm3.
     */
    public final MacAlgorithmDukpt dukptIso9797Algorithm3() {
        return dukptIso9797Algorithm3;
    }

    /**
     * <p>
     * Parameters that are required for MAC generation or verification using EMV MAC algorithm.
     * </p>
     * 
     * @return Parameters that are required for MAC generation or verification using EMV MAC algorithm.
     */
    public final MacAlgorithmEmv emvMac() {
        return emvMac;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(algorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dukptCmac());
        hashCode = 31 * hashCode + Objects.hashCode(dukptIso9797Algorithm1());
        hashCode = 31 * hashCode + Objects.hashCode(dukptIso9797Algorithm3());
        hashCode = 31 * hashCode + Objects.hashCode(emvMac());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MacAttributes)) {
            return false;
        }
        MacAttributes other = (MacAttributes) obj;
        return Objects.equals(algorithmAsString(), other.algorithmAsString()) && Objects.equals(dukptCmac(), other.dukptCmac())
                && Objects.equals(dukptIso9797Algorithm1(), other.dukptIso9797Algorithm1())
                && Objects.equals(dukptIso9797Algorithm3(), other.dukptIso9797Algorithm3())
                && Objects.equals(emvMac(), other.emvMac());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MacAttributes").add("Algorithm", algorithmAsString()).add("DukptCmac", dukptCmac())
                .add("DukptIso9797Algorithm1", dukptIso9797Algorithm1()).add("DukptIso9797Algorithm3", dukptIso9797Algorithm3())
                .add("EmvMac", emvMac()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Algorithm":
            return Optional.ofNullable(clazz.cast(algorithmAsString()));
        case "DukptCmac":
            return Optional.ofNullable(clazz.cast(dukptCmac()));
        case "DukptIso9797Algorithm1":
            return Optional.ofNullable(clazz.cast(dukptIso9797Algorithm1()));
        case "DukptIso9797Algorithm3":
            return Optional.ofNullable(clazz.cast(dukptIso9797Algorithm3()));
        case "EmvMac":
            return Optional.ofNullable(clazz.cast(emvMac()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #algorithmAsString()} initialized to the given value.
     *
     * <p>
     * The encryption algorithm for MAC generation or verification.
     * </p>
     * 
     * @param algorithm
     *        The encryption algorithm for MAC generation or verification.
     * @see MacAlgorithm
     */
    public static MacAttributes fromAlgorithm(String algorithm) {
        return builder().algorithm(algorithm).build();
    }

    /**
     * Create an instance of this class with {@link #algorithmAsString()} initialized to the given value.
     *
     * <p>
     * The encryption algorithm for MAC generation or verification.
     * </p>
     * 
     * @param algorithm
     *        The encryption algorithm for MAC generation or verification.
     * @see MacAlgorithm
     */
    public static MacAttributes fromAlgorithm(MacAlgorithm algorithm) {
        return builder().algorithm(algorithm).build();
    }

    /**
     * Create an instance of this class with {@link #dukptCmac()} initialized to the given value.
     *
     * <p>
     * Parameters that are required for MAC generation or verification using DUKPT CMAC algorithm.
     * </p>
     * 
     * @param dukptCmac
     *        Parameters that are required for MAC generation or verification using DUKPT CMAC algorithm.
     */
    public static MacAttributes fromDukptCmac(MacAlgorithmDukpt dukptCmac) {
        return builder().dukptCmac(dukptCmac).build();
    }

    /**
     * Create an instance of this class with {@link #dukptCmac()} initialized to the given value.
     *
     * <p>
     * Parameters that are required for MAC generation or verification using DUKPT CMAC algorithm.
     * </p>
     * 
     * @param dukptCmac
     *        Parameters that are required for MAC generation or verification using DUKPT CMAC algorithm.
     */
    public static MacAttributes fromDukptCmac(Consumer<MacAlgorithmDukpt.Builder> dukptCmac) {
        MacAlgorithmDukpt.Builder builder = MacAlgorithmDukpt.builder();
        dukptCmac.accept(builder);
        return fromDukptCmac(builder.build());
    }

    /**
     * Create an instance of this class with {@link #dukptIso9797Algorithm1()} initialized to the given value.
     *
     * <p>
     * Parameters that are required for MAC generation or verification using DUKPT ISO 9797 algorithm1.
     * </p>
     * 
     * @param dukptIso9797Algorithm1
     *        Parameters that are required for MAC generation or verification using DUKPT ISO 9797 algorithm1.
     */
    public static MacAttributes fromDukptIso9797Algorithm1(MacAlgorithmDukpt dukptIso9797Algorithm1) {
        return builder().dukptIso9797Algorithm1(dukptIso9797Algorithm1).build();
    }

    /**
     * Create an instance of this class with {@link #dukptIso9797Algorithm1()} initialized to the given value.
     *
     * <p>
     * Parameters that are required for MAC generation or verification using DUKPT ISO 9797 algorithm1.
     * </p>
     * 
     * @param dukptIso9797Algorithm1
     *        Parameters that are required for MAC generation or verification using DUKPT ISO 9797 algorithm1.
     */
    public static MacAttributes fromDukptIso9797Algorithm1(Consumer<MacAlgorithmDukpt.Builder> dukptIso9797Algorithm1) {
        MacAlgorithmDukpt.Builder builder = MacAlgorithmDukpt.builder();
        dukptIso9797Algorithm1.accept(builder);
        return fromDukptIso9797Algorithm1(builder.build());
    }

    /**
     * Create an instance of this class with {@link #dukptIso9797Algorithm3()} initialized to the given value.
     *
     * <p>
     * Parameters that are required for MAC generation or verification using DUKPT ISO 9797 algorithm3.
     * </p>
     * 
     * @param dukptIso9797Algorithm3
     *        Parameters that are required for MAC generation or verification using DUKPT ISO 9797 algorithm3.
     */
    public static MacAttributes fromDukptIso9797Algorithm3(MacAlgorithmDukpt dukptIso9797Algorithm3) {
        return builder().dukptIso9797Algorithm3(dukptIso9797Algorithm3).build();
    }

    /**
     * Create an instance of this class with {@link #dukptIso9797Algorithm3()} initialized to the given value.
     *
     * <p>
     * Parameters that are required for MAC generation or verification using DUKPT ISO 9797 algorithm3.
     * </p>
     * 
     * @param dukptIso9797Algorithm3
     *        Parameters that are required for MAC generation or verification using DUKPT ISO 9797 algorithm3.
     */
    public static MacAttributes fromDukptIso9797Algorithm3(Consumer<MacAlgorithmDukpt.Builder> dukptIso9797Algorithm3) {
        MacAlgorithmDukpt.Builder builder = MacAlgorithmDukpt.builder();
        dukptIso9797Algorithm3.accept(builder);
        return fromDukptIso9797Algorithm3(builder.build());
    }

    /**
     * Create an instance of this class with {@link #emvMac()} initialized to the given value.
     *
     * <p>
     * Parameters that are required for MAC generation or verification using EMV MAC algorithm.
     * </p>
     * 
     * @param emvMac
     *        Parameters that are required for MAC generation or verification using EMV MAC algorithm.
     */
    public static MacAttributes fromEmvMac(MacAlgorithmEmv emvMac) {
        return builder().emvMac(emvMac).build();
    }

    /**
     * Create an instance of this class with {@link #emvMac()} initialized to the given value.
     *
     * <p>
     * Parameters that are required for MAC generation or verification using EMV MAC algorithm.
     * </p>
     * 
     * @param emvMac
     *        Parameters that are required for MAC generation or verification using EMV MAC algorithm.
     */
    public static MacAttributes fromEmvMac(Consumer<MacAlgorithmEmv.Builder> emvMac) {
        MacAlgorithmEmv.Builder builder = MacAlgorithmEmv.builder();
        emvMac.accept(builder);
        return fromEmvMac(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MacAttributes, T> g) {
        return obj -> g.apply((MacAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MacAttributes> {
        /**
         * <p>
         * The encryption algorithm for MAC generation or verification.
         * </p>
         * 
         * @param algorithm
         *        The encryption algorithm for MAC generation or verification.
         * @see MacAlgorithm
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MacAlgorithm
         */
        Builder algorithm(String algorithm);

        /**
         * <p>
         * The encryption algorithm for MAC generation or verification.
         * </p>
         * 
         * @param algorithm
         *        The encryption algorithm for MAC generation or verification.
         * @see MacAlgorithm
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MacAlgorithm
         */
        Builder algorithm(MacAlgorithm algorithm);

        /**
         * <p>
         * Parameters that are required for MAC generation or verification using DUKPT CMAC algorithm.
         * </p>
         * 
         * @param dukptCmac
         *        Parameters that are required for MAC generation or verification using DUKPT CMAC algorithm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dukptCmac(MacAlgorithmDukpt dukptCmac);

        /**
         * <p>
         * Parameters that are required for MAC generation or verification using DUKPT CMAC algorithm.
         * </p>
         * This is a convenience method that creates an instance of the {@link MacAlgorithmDukpt.Builder} avoiding the
         * need to create one manually via {@link MacAlgorithmDukpt#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MacAlgorithmDukpt.Builder#build()} is called immediately and its
         * result is passed to {@link #dukptCmac(MacAlgorithmDukpt)}.
         * 
         * @param dukptCmac
         *        a consumer that will call methods on {@link MacAlgorithmDukpt.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dukptCmac(MacAlgorithmDukpt)
         */
        default Builder dukptCmac(Consumer<MacAlgorithmDukpt.Builder> dukptCmac) {
            return dukptCmac(MacAlgorithmDukpt.builder().applyMutation(dukptCmac).build());
        }

        /**
         * <p>
         * Parameters that are required for MAC generation or verification using DUKPT ISO 9797 algorithm1.
         * </p>
         * 
         * @param dukptIso9797Algorithm1
         *        Parameters that are required for MAC generation or verification using DUKPT ISO 9797 algorithm1.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dukptIso9797Algorithm1(MacAlgorithmDukpt dukptIso9797Algorithm1);

        /**
         * <p>
         * Parameters that are required for MAC generation or verification using DUKPT ISO 9797 algorithm1.
         * </p>
         * This is a convenience method that creates an instance of the {@link MacAlgorithmDukpt.Builder} avoiding the
         * need to create one manually via {@link MacAlgorithmDukpt#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MacAlgorithmDukpt.Builder#build()} is called immediately and its
         * result is passed to {@link #dukptIso9797Algorithm1(MacAlgorithmDukpt)}.
         * 
         * @param dukptIso9797Algorithm1
         *        a consumer that will call methods on {@link MacAlgorithmDukpt.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dukptIso9797Algorithm1(MacAlgorithmDukpt)
         */
        default Builder dukptIso9797Algorithm1(Consumer<MacAlgorithmDukpt.Builder> dukptIso9797Algorithm1) {
            return dukptIso9797Algorithm1(MacAlgorithmDukpt.builder().applyMutation(dukptIso9797Algorithm1).build());
        }

        /**
         * <p>
         * Parameters that are required for MAC generation or verification using DUKPT ISO 9797 algorithm3.
         * </p>
         * 
         * @param dukptIso9797Algorithm3
         *        Parameters that are required for MAC generation or verification using DUKPT ISO 9797 algorithm3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dukptIso9797Algorithm3(MacAlgorithmDukpt dukptIso9797Algorithm3);

        /**
         * <p>
         * Parameters that are required for MAC generation or verification using DUKPT ISO 9797 algorithm3.
         * </p>
         * This is a convenience method that creates an instance of the {@link MacAlgorithmDukpt.Builder} avoiding the
         * need to create one manually via {@link MacAlgorithmDukpt#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MacAlgorithmDukpt.Builder#build()} is called immediately and its
         * result is passed to {@link #dukptIso9797Algorithm3(MacAlgorithmDukpt)}.
         * 
         * @param dukptIso9797Algorithm3
         *        a consumer that will call methods on {@link MacAlgorithmDukpt.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dukptIso9797Algorithm3(MacAlgorithmDukpt)
         */
        default Builder dukptIso9797Algorithm3(Consumer<MacAlgorithmDukpt.Builder> dukptIso9797Algorithm3) {
            return dukptIso9797Algorithm3(MacAlgorithmDukpt.builder().applyMutation(dukptIso9797Algorithm3).build());
        }

        /**
         * <p>
         * Parameters that are required for MAC generation or verification using EMV MAC algorithm.
         * </p>
         * 
         * @param emvMac
         *        Parameters that are required for MAC generation or verification using EMV MAC algorithm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emvMac(MacAlgorithmEmv emvMac);

        /**
         * <p>
         * Parameters that are required for MAC generation or verification using EMV MAC algorithm.
         * </p>
         * This is a convenience method that creates an instance of the {@link MacAlgorithmEmv.Builder} avoiding the
         * need to create one manually via {@link MacAlgorithmEmv#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MacAlgorithmEmv.Builder#build()} is called immediately and its
         * result is passed to {@link #emvMac(MacAlgorithmEmv)}.
         * 
         * @param emvMac
         *        a consumer that will call methods on {@link MacAlgorithmEmv.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #emvMac(MacAlgorithmEmv)
         */
        default Builder emvMac(Consumer<MacAlgorithmEmv.Builder> emvMac) {
            return emvMac(MacAlgorithmEmv.builder().applyMutation(emvMac).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String algorithm;

        private MacAlgorithmDukpt dukptCmac;

        private MacAlgorithmDukpt dukptIso9797Algorithm1;

        private MacAlgorithmDukpt dukptIso9797Algorithm3;

        private MacAlgorithmEmv emvMac;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(MacAttributes model) {
            algorithm(model.algorithm);
            dukptCmac(model.dukptCmac);
            dukptIso9797Algorithm1(model.dukptIso9797Algorithm1);
            dukptIso9797Algorithm3(model.dukptIso9797Algorithm3);
            emvMac(model.emvMac);
        }

        public final String getAlgorithm() {
            return algorithm;
        }

        public final void setAlgorithm(String algorithm) {
            Object oldValue = this.algorithm;
            this.algorithm = algorithm;
            handleUnionValueChange(Type.ALGORITHM, oldValue, this.algorithm);
        }

        @Override
        public final Builder algorithm(String algorithm) {
            Object oldValue = this.algorithm;
            this.algorithm = algorithm;
            handleUnionValueChange(Type.ALGORITHM, oldValue, this.algorithm);
            return this;
        }

        @Override
        public final Builder algorithm(MacAlgorithm algorithm) {
            this.algorithm(algorithm == null ? null : algorithm.toString());
            return this;
        }

        public final MacAlgorithmDukpt.Builder getDukptCmac() {
            return dukptCmac != null ? dukptCmac.toBuilder() : null;
        }

        public final void setDukptCmac(MacAlgorithmDukpt.BuilderImpl dukptCmac) {
            Object oldValue = this.dukptCmac;
            this.dukptCmac = dukptCmac != null ? dukptCmac.build() : null;
            handleUnionValueChange(Type.DUKPT_CMAC, oldValue, this.dukptCmac);
        }

        @Override
        public final Builder dukptCmac(MacAlgorithmDukpt dukptCmac) {
            Object oldValue = this.dukptCmac;
            this.dukptCmac = dukptCmac;
            handleUnionValueChange(Type.DUKPT_CMAC, oldValue, this.dukptCmac);
            return this;
        }

        public final MacAlgorithmDukpt.Builder getDukptIso9797Algorithm1() {
            return dukptIso9797Algorithm1 != null ? dukptIso9797Algorithm1.toBuilder() : null;
        }

        public final void setDukptIso9797Algorithm1(MacAlgorithmDukpt.BuilderImpl dukptIso9797Algorithm1) {
            Object oldValue = this.dukptIso9797Algorithm1;
            this.dukptIso9797Algorithm1 = dukptIso9797Algorithm1 != null ? dukptIso9797Algorithm1.build() : null;
            handleUnionValueChange(Type.DUKPT_ISO9797_ALGORITHM1, oldValue, this.dukptIso9797Algorithm1);
        }

        @Override
        public final Builder dukptIso9797Algorithm1(MacAlgorithmDukpt dukptIso9797Algorithm1) {
            Object oldValue = this.dukptIso9797Algorithm1;
            this.dukptIso9797Algorithm1 = dukptIso9797Algorithm1;
            handleUnionValueChange(Type.DUKPT_ISO9797_ALGORITHM1, oldValue, this.dukptIso9797Algorithm1);
            return this;
        }

        public final MacAlgorithmDukpt.Builder getDukptIso9797Algorithm3() {
            return dukptIso9797Algorithm3 != null ? dukptIso9797Algorithm3.toBuilder() : null;
        }

        public final void setDukptIso9797Algorithm3(MacAlgorithmDukpt.BuilderImpl dukptIso9797Algorithm3) {
            Object oldValue = this.dukptIso9797Algorithm3;
            this.dukptIso9797Algorithm3 = dukptIso9797Algorithm3 != null ? dukptIso9797Algorithm3.build() : null;
            handleUnionValueChange(Type.DUKPT_ISO9797_ALGORITHM3, oldValue, this.dukptIso9797Algorithm3);
        }

        @Override
        public final Builder dukptIso9797Algorithm3(MacAlgorithmDukpt dukptIso9797Algorithm3) {
            Object oldValue = this.dukptIso9797Algorithm3;
            this.dukptIso9797Algorithm3 = dukptIso9797Algorithm3;
            handleUnionValueChange(Type.DUKPT_ISO9797_ALGORITHM3, oldValue, this.dukptIso9797Algorithm3);
            return this;
        }

        public final MacAlgorithmEmv.Builder getEmvMac() {
            return emvMac != null ? emvMac.toBuilder() : null;
        }

        public final void setEmvMac(MacAlgorithmEmv.BuilderImpl emvMac) {
            Object oldValue = this.emvMac;
            this.emvMac = emvMac != null ? emvMac.build() : null;
            handleUnionValueChange(Type.EMV_MAC, oldValue, this.emvMac);
        }

        @Override
        public final Builder emvMac(MacAlgorithmEmv emvMac) {
            Object oldValue = this.emvMac;
            this.emvMac = emvMac;
            handleUnionValueChange(Type.EMV_MAC, oldValue, this.emvMac);
            return this;
        }

        @Override
        public MacAttributes build() {
            return new MacAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see MacAttributes#type()
     */
    public enum Type {
        ALGORITHM,

        DUKPT_CMAC,

        DUKPT_ISO9797_ALGORITHM1,

        DUKPT_ISO9797_ALGORITHM3,

        EMV_MAC,

        UNKNOWN_TO_SDK_VERSION
    }
}
