/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Parameters for plaintext encryption using EMV keys.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EmvEncryptionAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<EmvEncryptionAttributes.Builder, EmvEncryptionAttributes> {
    private static final SdkField<String> INITIALIZATION_VECTOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InitializationVector").getter(getter(EmvEncryptionAttributes::initializationVector))
            .setter(setter(Builder::initializationVector))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitializationVector").build())
            .build();

    private static final SdkField<String> MAJOR_KEY_DERIVATION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MajorKeyDerivationMode").getter(getter(EmvEncryptionAttributes::majorKeyDerivationModeAsString))
            .setter(setter(Builder::majorKeyDerivationMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MajorKeyDerivationMode").build())
            .build();

    private static final SdkField<String> MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Mode")
            .getter(getter(EmvEncryptionAttributes::modeAsString)).setter(setter(Builder::mode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mode").build()).build();

    private static final SdkField<String> PAN_SEQUENCE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PanSequenceNumber").getter(getter(EmvEncryptionAttributes::panSequenceNumber))
            .setter(setter(Builder::panSequenceNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PanSequenceNumber").build()).build();

    private static final SdkField<String> PRIMARY_ACCOUNT_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrimaryAccountNumber").getter(getter(EmvEncryptionAttributes::primaryAccountNumber))
            .setter(setter(Builder::primaryAccountNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryAccountNumber").build())
            .build();

    private static final SdkField<String> SESSION_DERIVATION_DATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SessionDerivationData").getter(getter(EmvEncryptionAttributes::sessionDerivationData))
            .setter(setter(Builder::sessionDerivationData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionDerivationData").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INITIALIZATION_VECTOR_FIELD,
            MAJOR_KEY_DERIVATION_MODE_FIELD, MODE_FIELD, PAN_SEQUENCE_NUMBER_FIELD, PRIMARY_ACCOUNT_NUMBER_FIELD,
            SESSION_DERIVATION_DATA_FIELD));

    private static final long serialVersionUID = 1L;

    private final String initializationVector;

    private final String majorKeyDerivationMode;

    private final String mode;

    private final String panSequenceNumber;

    private final String primaryAccountNumber;

    private final String sessionDerivationData;

    private EmvEncryptionAttributes(BuilderImpl builder) {
        this.initializationVector = builder.initializationVector;
        this.majorKeyDerivationMode = builder.majorKeyDerivationMode;
        this.mode = builder.mode;
        this.panSequenceNumber = builder.panSequenceNumber;
        this.primaryAccountNumber = builder.primaryAccountNumber;
        this.sessionDerivationData = builder.sessionDerivationData;
    }

    /**
     * <p>
     * An input used to provide the intial state. If no value is provided, Amazon Web Services Payment Cryptography
     * defaults it to zero.
     * </p>
     * 
     * @return An input used to provide the intial state. If no value is provided, Amazon Web Services Payment
     *         Cryptography defaults it to zero.
     */
    public final String initializationVector() {
        return initializationVector;
    }

    /**
     * <p>
     * The EMV derivation mode to use for ICC master key derivation as per EMV version 4.3 book 2.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #majorKeyDerivationMode} will return {@link EmvMajorKeyDerivationMode#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #majorKeyDerivationModeAsString}.
     * </p>
     * 
     * @return The EMV derivation mode to use for ICC master key derivation as per EMV version 4.3 book 2.
     * @see EmvMajorKeyDerivationMode
     */
    public final EmvMajorKeyDerivationMode majorKeyDerivationMode() {
        return EmvMajorKeyDerivationMode.fromValue(majorKeyDerivationMode);
    }

    /**
     * <p>
     * The EMV derivation mode to use for ICC master key derivation as per EMV version 4.3 book 2.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #majorKeyDerivationMode} will return {@link EmvMajorKeyDerivationMode#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #majorKeyDerivationModeAsString}.
     * </p>
     * 
     * @return The EMV derivation mode to use for ICC master key derivation as per EMV version 4.3 book 2.
     * @see EmvMajorKeyDerivationMode
     */
    public final String majorKeyDerivationModeAsString() {
        return majorKeyDerivationMode;
    }

    /**
     * <p>
     * The block cipher method to use for encryption.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link EmvEncryptionMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return The block cipher method to use for encryption.
     * @see EmvEncryptionMode
     */
    public final EmvEncryptionMode mode() {
        return EmvEncryptionMode.fromValue(mode);
    }

    /**
     * <p>
     * The block cipher method to use for encryption.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link EmvEncryptionMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return The block cipher method to use for encryption.
     * @see EmvEncryptionMode
     */
    public final String modeAsString() {
        return mode;
    }

    /**
     * <p>
     * A number that identifies and differentiates payment cards with the same Primary Account Number (PAN).
     * </p>
     * 
     * @return A number that identifies and differentiates payment cards with the same Primary Account Number (PAN).
     */
    public final String panSequenceNumber() {
        return panSequenceNumber;
    }

    /**
     * <p>
     * The Primary Account Number (PAN), a unique identifier for a payment credit or debit card and associates the card
     * to a specific account holder.
     * </p>
     * 
     * @return The Primary Account Number (PAN), a unique identifier for a payment credit or debit card and associates
     *         the card to a specific account holder.
     */
    public final String primaryAccountNumber() {
        return primaryAccountNumber;
    }

    /**
     * <p>
     * The derivation value used to derive the ICC session key. It is typically the application transaction counter
     * value padded with zeros or previous ARQC value padded with zeros as per EMV version 4.3 book 2.
     * </p>
     * 
     * @return The derivation value used to derive the ICC session key. It is typically the application transaction
     *         counter value padded with zeros or previous ARQC value padded with zeros as per EMV version 4.3 book 2.
     */
    public final String sessionDerivationData() {
        return sessionDerivationData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(initializationVector());
        hashCode = 31 * hashCode + Objects.hashCode(majorKeyDerivationModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(panSequenceNumber());
        hashCode = 31 * hashCode + Objects.hashCode(primaryAccountNumber());
        hashCode = 31 * hashCode + Objects.hashCode(sessionDerivationData());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EmvEncryptionAttributes)) {
            return false;
        }
        EmvEncryptionAttributes other = (EmvEncryptionAttributes) obj;
        return Objects.equals(initializationVector(), other.initializationVector())
                && Objects.equals(majorKeyDerivationModeAsString(), other.majorKeyDerivationModeAsString())
                && Objects.equals(modeAsString(), other.modeAsString())
                && Objects.equals(panSequenceNumber(), other.panSequenceNumber())
                && Objects.equals(primaryAccountNumber(), other.primaryAccountNumber())
                && Objects.equals(sessionDerivationData(), other.sessionDerivationData());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EmvEncryptionAttributes")
                .add("InitializationVector", initializationVector() == null ? null : "*** Sensitive Data Redacted ***")
                .add("MajorKeyDerivationMode", majorKeyDerivationModeAsString()).add("Mode", modeAsString())
                .add("PanSequenceNumber", panSequenceNumber())
                .add("PrimaryAccountNumber", primaryAccountNumber() == null ? null : "*** Sensitive Data Redacted ***")
                .add("SessionDerivationData", sessionDerivationData()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InitializationVector":
            return Optional.ofNullable(clazz.cast(initializationVector()));
        case "MajorKeyDerivationMode":
            return Optional.ofNullable(clazz.cast(majorKeyDerivationModeAsString()));
        case "Mode":
            return Optional.ofNullable(clazz.cast(modeAsString()));
        case "PanSequenceNumber":
            return Optional.ofNullable(clazz.cast(panSequenceNumber()));
        case "PrimaryAccountNumber":
            return Optional.ofNullable(clazz.cast(primaryAccountNumber()));
        case "SessionDerivationData":
            return Optional.ofNullable(clazz.cast(sessionDerivationData()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EmvEncryptionAttributes, T> g) {
        return obj -> g.apply((EmvEncryptionAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EmvEncryptionAttributes> {
        /**
         * <p>
         * An input used to provide the intial state. If no value is provided, Amazon Web Services Payment Cryptography
         * defaults it to zero.
         * </p>
         * 
         * @param initializationVector
         *        An input used to provide the intial state. If no value is provided, Amazon Web Services Payment
         *        Cryptography defaults it to zero.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initializationVector(String initializationVector);

        /**
         * <p>
         * The EMV derivation mode to use for ICC master key derivation as per EMV version 4.3 book 2.
         * </p>
         * 
         * @param majorKeyDerivationMode
         *        The EMV derivation mode to use for ICC master key derivation as per EMV version 4.3 book 2.
         * @see EmvMajorKeyDerivationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EmvMajorKeyDerivationMode
         */
        Builder majorKeyDerivationMode(String majorKeyDerivationMode);

        /**
         * <p>
         * The EMV derivation mode to use for ICC master key derivation as per EMV version 4.3 book 2.
         * </p>
         * 
         * @param majorKeyDerivationMode
         *        The EMV derivation mode to use for ICC master key derivation as per EMV version 4.3 book 2.
         * @see EmvMajorKeyDerivationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EmvMajorKeyDerivationMode
         */
        Builder majorKeyDerivationMode(EmvMajorKeyDerivationMode majorKeyDerivationMode);

        /**
         * <p>
         * The block cipher method to use for encryption.
         * </p>
         * 
         * @param mode
         *        The block cipher method to use for encryption.
         * @see EmvEncryptionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EmvEncryptionMode
         */
        Builder mode(String mode);

        /**
         * <p>
         * The block cipher method to use for encryption.
         * </p>
         * 
         * @param mode
         *        The block cipher method to use for encryption.
         * @see EmvEncryptionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EmvEncryptionMode
         */
        Builder mode(EmvEncryptionMode mode);

        /**
         * <p>
         * A number that identifies and differentiates payment cards with the same Primary Account Number (PAN).
         * </p>
         * 
         * @param panSequenceNumber
         *        A number that identifies and differentiates payment cards with the same Primary Account Number (PAN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder panSequenceNumber(String panSequenceNumber);

        /**
         * <p>
         * The Primary Account Number (PAN), a unique identifier for a payment credit or debit card and associates the
         * card to a specific account holder.
         * </p>
         * 
         * @param primaryAccountNumber
         *        The Primary Account Number (PAN), a unique identifier for a payment credit or debit card and
         *        associates the card to a specific account holder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryAccountNumber(String primaryAccountNumber);

        /**
         * <p>
         * The derivation value used to derive the ICC session key. It is typically the application transaction counter
         * value padded with zeros or previous ARQC value padded with zeros as per EMV version 4.3 book 2.
         * </p>
         * 
         * @param sessionDerivationData
         *        The derivation value used to derive the ICC session key. It is typically the application transaction
         *        counter value padded with zeros or previous ARQC value padded with zeros as per EMV version 4.3 book
         *        2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionDerivationData(String sessionDerivationData);
    }

    static final class BuilderImpl implements Builder {
        private String initializationVector;

        private String majorKeyDerivationMode;

        private String mode;

        private String panSequenceNumber;

        private String primaryAccountNumber;

        private String sessionDerivationData;

        private BuilderImpl() {
        }

        private BuilderImpl(EmvEncryptionAttributes model) {
            initializationVector(model.initializationVector);
            majorKeyDerivationMode(model.majorKeyDerivationMode);
            mode(model.mode);
            panSequenceNumber(model.panSequenceNumber);
            primaryAccountNumber(model.primaryAccountNumber);
            sessionDerivationData(model.sessionDerivationData);
        }

        public final String getInitializationVector() {
            return initializationVector;
        }

        public final void setInitializationVector(String initializationVector) {
            this.initializationVector = initializationVector;
        }

        @Override
        public final Builder initializationVector(String initializationVector) {
            this.initializationVector = initializationVector;
            return this;
        }

        public final String getMajorKeyDerivationMode() {
            return majorKeyDerivationMode;
        }

        public final void setMajorKeyDerivationMode(String majorKeyDerivationMode) {
            this.majorKeyDerivationMode = majorKeyDerivationMode;
        }

        @Override
        public final Builder majorKeyDerivationMode(String majorKeyDerivationMode) {
            this.majorKeyDerivationMode = majorKeyDerivationMode;
            return this;
        }

        @Override
        public final Builder majorKeyDerivationMode(EmvMajorKeyDerivationMode majorKeyDerivationMode) {
            this.majorKeyDerivationMode(majorKeyDerivationMode == null ? null : majorKeyDerivationMode.toString());
            return this;
        }

        public final String getMode() {
            return mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(EmvEncryptionMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final String getPanSequenceNumber() {
            return panSequenceNumber;
        }

        public final void setPanSequenceNumber(String panSequenceNumber) {
            this.panSequenceNumber = panSequenceNumber;
        }

        @Override
        public final Builder panSequenceNumber(String panSequenceNumber) {
            this.panSequenceNumber = panSequenceNumber;
            return this;
        }

        public final String getPrimaryAccountNumber() {
            return primaryAccountNumber;
        }

        public final void setPrimaryAccountNumber(String primaryAccountNumber) {
            this.primaryAccountNumber = primaryAccountNumber;
        }

        @Override
        public final Builder primaryAccountNumber(String primaryAccountNumber) {
            this.primaryAccountNumber = primaryAccountNumber;
            return this;
        }

        public final String getSessionDerivationData() {
            return sessionDerivationData;
        }

        public final void setSessionDerivationData(String sessionDerivationData) {
            this.sessionDerivationData = sessionDerivationData;
        }

        @Override
        public final Builder sessionDerivationData(String sessionDerivationData) {
            this.sessionDerivationData = sessionDerivationData;
            return this;
        }

        @Override
        public EmvEncryptionAttributes build() {
            return new EmvEncryptionAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
