/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Parameters that are required to generate or verify Visa PIN.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VisaPin implements SdkPojo, Serializable, ToCopyableBuilder<VisaPin.Builder, VisaPin> {
    private static final SdkField<Integer> PIN_VERIFICATION_KEY_INDEX_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PinVerificationKeyIndex").getter(getter(VisaPin::pinVerificationKeyIndex))
            .setter(setter(Builder::pinVerificationKeyIndex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PinVerificationKeyIndex").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(PIN_VERIFICATION_KEY_INDEX_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer pinVerificationKeyIndex;

    private VisaPin(BuilderImpl builder) {
        this.pinVerificationKeyIndex = builder.pinVerificationKeyIndex;
    }

    /**
     * <p>
     * The value for PIN verification index. It is used in the Visa PIN algorithm to calculate the PVV (PIN Verification
     * Value).
     * </p>
     * 
     * @return The value for PIN verification index. It is used in the Visa PIN algorithm to calculate the PVV (PIN
     *         Verification Value).
     */
    public final Integer pinVerificationKeyIndex() {
        return pinVerificationKeyIndex;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(pinVerificationKeyIndex());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VisaPin)) {
            return false;
        }
        VisaPin other = (VisaPin) obj;
        return Objects.equals(pinVerificationKeyIndex(), other.pinVerificationKeyIndex());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VisaPin").add("PinVerificationKeyIndex", pinVerificationKeyIndex()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PinVerificationKeyIndex":
            return Optional.ofNullable(clazz.cast(pinVerificationKeyIndex()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VisaPin, T> g) {
        return obj -> g.apply((VisaPin) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VisaPin> {
        /**
         * <p>
         * The value for PIN verification index. It is used in the Visa PIN algorithm to calculate the PVV (PIN
         * Verification Value).
         * </p>
         * 
         * @param pinVerificationKeyIndex
         *        The value for PIN verification index. It is used in the Visa PIN algorithm to calculate the PVV (PIN
         *        Verification Value).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pinVerificationKeyIndex(Integer pinVerificationKeyIndex);
    }

    static final class BuilderImpl implements Builder {
        private Integer pinVerificationKeyIndex;

        private BuilderImpl() {
        }

        private BuilderImpl(VisaPin model) {
            pinVerificationKeyIndex(model.pinVerificationKeyIndex);
        }

        public final Integer getPinVerificationKeyIndex() {
            return pinVerificationKeyIndex;
        }

        public final void setPinVerificationKeyIndex(Integer pinVerificationKeyIndex) {
            this.pinVerificationKeyIndex = pinVerificationKeyIndex;
        }

        @Override
        public final Builder pinVerificationKeyIndex(Integer pinVerificationKeyIndex) {
            this.pinVerificationKeyIndex = pinVerificationKeyIndex;
            return this;
        }

        @Override
        public VisaPin build() {
            return new VisaPin(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
