/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SalesActivity {
    INITIALIZED_DISCUSSIONS_WITH_CUSTOMER("Initialized discussions with customer"),
    CUSTOMER_HAS_SHOWN_INTEREST_IN_SOLUTION("Customer has shown interest in solution"),
    CONDUCTED_POC_DEMO("Conducted POC / Demo"),
    IN_EVALUATION_PLANNING_STAGE("In evaluation / planning stage"),
    AGREED_ON_SOLUTION_TO_BUSINESS_PROBLEM("Agreed on solution to Business Problem"),
    COMPLETED_ACTION_PLAN("Completed Action Plan"),
    FINALIZED_DEPLOYMENT_NEED("Finalized Deployment Need"),
    SOW_SIGNED("SOW Signed"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SalesActivity> VALUE_MAP;
    private final String value;

    private SalesActivity(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SalesActivity fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SalesActivity> knownValues() {
        EnumSet<SalesActivity> knownValues = EnumSet.allOf(SalesActivity.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SalesActivity.class, SalesActivity::toString);
    }
}

