/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.partnercentralselling.PartnerCentralSellingClient;
import software.amazon.awssdk.services.partnercentralselling.internal.UserAgentUtils;
import software.amazon.awssdk.services.partnercentralselling.model.EngagementMember;
import software.amazon.awssdk.services.partnercentralselling.model.ListEngagementMembersRequest;
import software.amazon.awssdk.services.partnercentralselling.model.ListEngagementMembersResponse;

public class ListEngagementMembersIterable
implements SdkIterable<ListEngagementMembersResponse> {
    private final PartnerCentralSellingClient client;
    private final ListEngagementMembersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListEngagementMembersIterable(PartnerCentralSellingClient client, ListEngagementMembersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListEngagementMembersResponseFetcher();
    }

    public Iterator<ListEngagementMembersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<EngagementMember> engagementMemberList() {
        Function<ListEngagementMembersResponse, Iterator> getIterator = response -> {
            if (response != null && response.engagementMemberList() != null) {
                return response.engagementMemberList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListEngagementMembersResponseFetcher
    implements SyncPageFetcher<ListEngagementMembersResponse> {
        private ListEngagementMembersResponseFetcher() {
        }

        public boolean hasNextPage(ListEngagementMembersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListEngagementMembersResponse nextPage(ListEngagementMembersResponse previousPage) {
            if (previousPage == null) {
                return ListEngagementMembersIterable.this.client.listEngagementMembers(ListEngagementMembersIterable.this.firstRequest);
            }
            return ListEngagementMembersIterable.this.client.listEngagementMembers((ListEngagementMembersRequest)((Object)ListEngagementMembersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

