/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.outposts.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about EC2 capacity.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EC2Capacity implements SdkPojo, Serializable, ToCopyableBuilder<EC2Capacity.Builder, EC2Capacity> {
    private static final SdkField<String> FAMILY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Family")
            .getter(getter(EC2Capacity::family)).setter(setter(Builder::family))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Family").build()).build();

    private static final SdkField<String> MAX_SIZE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MaxSize").getter(getter(EC2Capacity::maxSize)).setter(setter(Builder::maxSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxSize").build()).build();

    private static final SdkField<String> QUANTITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Quantity").getter(getter(EC2Capacity::quantity)).setter(setter(Builder::quantity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Quantity").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAMILY_FIELD, MAX_SIZE_FIELD,
            QUANTITY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String family;

    private final String maxSize;

    private final String quantity;

    private EC2Capacity(BuilderImpl builder) {
        this.family = builder.family;
        this.maxSize = builder.maxSize;
        this.quantity = builder.quantity;
    }

    /**
     * <p>
     * The family of the EC2 capacity.
     * </p>
     * 
     * @return The family of the EC2 capacity.
     */
    public final String family() {
        return family;
    }

    /**
     * <p>
     * The maximum size of the EC2 capacity.
     * </p>
     * 
     * @return The maximum size of the EC2 capacity.
     */
    public final String maxSize() {
        return maxSize;
    }

    /**
     * <p>
     * The quantity of the EC2 capacity.
     * </p>
     * 
     * @return The quantity of the EC2 capacity.
     */
    public final String quantity() {
        return quantity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(family());
        hashCode = 31 * hashCode + Objects.hashCode(maxSize());
        hashCode = 31 * hashCode + Objects.hashCode(quantity());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EC2Capacity)) {
            return false;
        }
        EC2Capacity other = (EC2Capacity) obj;
        return Objects.equals(family(), other.family()) && Objects.equals(maxSize(), other.maxSize())
                && Objects.equals(quantity(), other.quantity());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EC2Capacity").add("Family", family()).add("MaxSize", maxSize()).add("Quantity", quantity())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Family":
            return Optional.ofNullable(clazz.cast(family()));
        case "MaxSize":
            return Optional.ofNullable(clazz.cast(maxSize()));
        case "Quantity":
            return Optional.ofNullable(clazz.cast(quantity()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EC2Capacity, T> g) {
        return obj -> g.apply((EC2Capacity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EC2Capacity> {
        /**
         * <p>
         * The family of the EC2 capacity.
         * </p>
         * 
         * @param family
         *        The family of the EC2 capacity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder family(String family);

        /**
         * <p>
         * The maximum size of the EC2 capacity.
         * </p>
         * 
         * @param maxSize
         *        The maximum size of the EC2 capacity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxSize(String maxSize);

        /**
         * <p>
         * The quantity of the EC2 capacity.
         * </p>
         * 
         * @param quantity
         *        The quantity of the EC2 capacity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quantity(String quantity);
    }

    static final class BuilderImpl implements Builder {
        private String family;

        private String maxSize;

        private String quantity;

        private BuilderImpl() {
        }

        private BuilderImpl(EC2Capacity model) {
            family(model.family);
            maxSize(model.maxSize);
            quantity(model.quantity);
        }

        public final String getFamily() {
            return family;
        }

        public final void setFamily(String family) {
            this.family = family;
        }

        @Override
        public final Builder family(String family) {
            this.family = family;
            return this;
        }

        public final String getMaxSize() {
            return maxSize;
        }

        public final void setMaxSize(String maxSize) {
            this.maxSize = maxSize;
        }

        @Override
        public final Builder maxSize(String maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public final String getQuantity() {
            return quantity;
        }

        public final void setQuantity(String quantity) {
            this.quantity = quantity;
        }

        @Override
        public final Builder quantity(String quantity) {
            this.quantity = quantity;
            return this;
        }

        @Override
        public EC2Capacity build() {
            return new EC2Capacity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
