/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.outposts;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.outposts.model.CancelOrderRequest;
import software.amazon.awssdk.services.outposts.model.CancelOrderResponse;
import software.amazon.awssdk.services.outposts.model.CreateOrderRequest;
import software.amazon.awssdk.services.outposts.model.CreateOrderResponse;
import software.amazon.awssdk.services.outposts.model.CreateOutpostRequest;
import software.amazon.awssdk.services.outposts.model.CreateOutpostResponse;
import software.amazon.awssdk.services.outposts.model.CreateSiteRequest;
import software.amazon.awssdk.services.outposts.model.CreateSiteResponse;
import software.amazon.awssdk.services.outposts.model.DeleteOutpostRequest;
import software.amazon.awssdk.services.outposts.model.DeleteOutpostResponse;
import software.amazon.awssdk.services.outposts.model.DeleteSiteRequest;
import software.amazon.awssdk.services.outposts.model.DeleteSiteResponse;
import software.amazon.awssdk.services.outposts.model.GetCatalogItemRequest;
import software.amazon.awssdk.services.outposts.model.GetCatalogItemResponse;
import software.amazon.awssdk.services.outposts.model.GetConnectionRequest;
import software.amazon.awssdk.services.outposts.model.GetConnectionResponse;
import software.amazon.awssdk.services.outposts.model.GetOrderRequest;
import software.amazon.awssdk.services.outposts.model.GetOrderResponse;
import software.amazon.awssdk.services.outposts.model.GetOutpostInstanceTypesRequest;
import software.amazon.awssdk.services.outposts.model.GetOutpostInstanceTypesResponse;
import software.amazon.awssdk.services.outposts.model.GetOutpostRequest;
import software.amazon.awssdk.services.outposts.model.GetOutpostResponse;
import software.amazon.awssdk.services.outposts.model.GetSiteAddressRequest;
import software.amazon.awssdk.services.outposts.model.GetSiteAddressResponse;
import software.amazon.awssdk.services.outposts.model.GetSiteRequest;
import software.amazon.awssdk.services.outposts.model.GetSiteResponse;
import software.amazon.awssdk.services.outposts.model.ListAssetsRequest;
import software.amazon.awssdk.services.outposts.model.ListAssetsResponse;
import software.amazon.awssdk.services.outposts.model.ListCatalogItemsRequest;
import software.amazon.awssdk.services.outposts.model.ListCatalogItemsResponse;
import software.amazon.awssdk.services.outposts.model.ListOrdersRequest;
import software.amazon.awssdk.services.outposts.model.ListOrdersResponse;
import software.amazon.awssdk.services.outposts.model.ListOutpostsRequest;
import software.amazon.awssdk.services.outposts.model.ListOutpostsResponse;
import software.amazon.awssdk.services.outposts.model.ListSitesRequest;
import software.amazon.awssdk.services.outposts.model.ListSitesResponse;
import software.amazon.awssdk.services.outposts.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.outposts.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.outposts.model.StartConnectionRequest;
import software.amazon.awssdk.services.outposts.model.StartConnectionResponse;
import software.amazon.awssdk.services.outposts.model.TagResourceRequest;
import software.amazon.awssdk.services.outposts.model.TagResourceResponse;
import software.amazon.awssdk.services.outposts.model.UntagResourceRequest;
import software.amazon.awssdk.services.outposts.model.UntagResourceResponse;
import software.amazon.awssdk.services.outposts.model.UpdateOutpostRequest;
import software.amazon.awssdk.services.outposts.model.UpdateOutpostResponse;
import software.amazon.awssdk.services.outposts.model.UpdateSiteAddressRequest;
import software.amazon.awssdk.services.outposts.model.UpdateSiteAddressResponse;
import software.amazon.awssdk.services.outposts.model.UpdateSiteRackPhysicalPropertiesRequest;
import software.amazon.awssdk.services.outposts.model.UpdateSiteRackPhysicalPropertiesResponse;
import software.amazon.awssdk.services.outposts.model.UpdateSiteRequest;
import software.amazon.awssdk.services.outposts.model.UpdateSiteResponse;
import software.amazon.awssdk.services.outposts.paginators.GetOutpostInstanceTypesPublisher;
import software.amazon.awssdk.services.outposts.paginators.ListAssetsPublisher;
import software.amazon.awssdk.services.outposts.paginators.ListCatalogItemsPublisher;
import software.amazon.awssdk.services.outposts.paginators.ListOrdersPublisher;
import software.amazon.awssdk.services.outposts.paginators.ListOutpostsPublisher;
import software.amazon.awssdk.services.outposts.paginators.ListSitesPublisher;

/**
 * Service client for accessing Outposts asynchronously. This can be created using the static {@link #builder()}
 * method.The asynchronous client performs non-blocking I/O when configured with any {@link SdkAsyncHttpClient}
 * supported in the SDK. However, full non-blocking is not guaranteed as the async client may perform blocking calls in
 * some cases such as credentials retrieval and endpoint discovery as part of the async API call.
 *
 * <p>
 * Amazon Web Services Outposts is a fully managed service that extends Amazon Web Services infrastructure, APIs, and
 * tools to customer premises. By providing local access to Amazon Web Services managed infrastructure, Amazon Web
 * Services Outposts enables customers to build and run applications on premises using the same programming interfaces
 * as in Amazon Web Services Regions, while using local compute and storage resources for lower latency and local data
 * processing needs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface OutpostsAsyncClient extends AwsClient {
    String SERVICE_NAME = "outposts";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "outposts";

    /**
     * <p>
     * Cancels the specified order for an Outpost.
     * </p>
     *
     * @param cancelOrderRequest
     * @return A Java Future containing the result of the CancelOrder operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>ConflictException Updating or deleting this resource can cause an inconsistent state.</li>
     *         <li>AccessDeniedException You do not have permission to perform this operation.</li>
     *         <li>NotFoundException The specified request is not valid.</li>
     *         <li>InternalServerException An internal error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OutpostsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OutpostsAsyncClient.CancelOrder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/CancelOrder" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CancelOrderResponse> cancelOrder(CancelOrderRequest cancelOrderRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels the specified order for an Outpost.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelOrderRequest.Builder} avoiding the need to
     * create one manually via {@link CancelOrderRequest#builder()}
     * </p>
     *
     * @param cancelOrderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.outposts.model.CancelOrderRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CancelOrder operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>ConflictException Updating or deleting this resource can cause an inconsistent state.</li>
     *         <li>AccessDeniedException You do not have permission to perform this operation.</li>
     *         <li>NotFoundException The specified request is not valid.</li>
     *         <li>InternalServerException An internal error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OutpostsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OutpostsAsyncClient.CancelOrder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/CancelOrder" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CancelOrderResponse> cancelOrder(Consumer<CancelOrderRequest.Builder> cancelOrderRequest) {
        return cancelOrder(CancelOrderRequest.builder().applyMutation(cancelOrderRequest).build());
    }

    /**
     * <p>
     * Creates an order for an Outpost.
     * </p>
     *
     * @param createOrderRequest
     * @return A Java Future containing the result of the CreateOrder operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>ConflictException Updating or deleting this resource can cause an inconsistent state.</li>
     *         <li>AccessDeniedException You do not have permission to perform this operation.</li>
     *         <li>NotFoundException The specified request is not valid.</li>
     *         <li>InternalServerException An internal error has occurred.</li>
     *         <li>ServiceQuotaExceededException You have exceeded a service quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OutpostsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OutpostsAsyncClient.CreateOrder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/CreateOrder" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateOrderResponse> createOrder(CreateOrderRequest createOrderRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an order for an Outpost.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateOrderRequest.Builder} avoiding the need to
     * create one manually via {@link CreateOrderRequest#builder()}
     * </p>
     *
     * @param createOrderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.outposts.model.CreateOrderRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateOrder operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>ConflictException Updating or deleting this resource can cause an inconsistent state.</li>
     *         <li>AccessDeniedException You do not have permission to perform this operation.</li>
     *         <li>NotFoundException The specified request is not valid.</li>
     *         <li>InternalServerException An internal error has occurred.</li>
     *         <li>ServiceQuotaExceededException You have exceeded a service quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OutpostsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OutpostsAsyncClient.CreateOrder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/CreateOrder" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateOrderResponse> createOrder(Consumer<CreateOrderRequest.Builder> createOrderRequest) {
        return createOrder(CreateOrderRequest.builder().applyMutation(createOrderRequest).build());
    }

    /**
     * <p>
     * Creates an Outpost.
     * </p>
     * <p>
     * You can specify either an Availability one or an AZ ID.
     * </p>
     *
     * @param createOutpostRequest
     * @return A Java Future containing the result of the CreateOutpost operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>ConflictException Updating or deleting this resource can cause an inconsistent state.</li>
     *         <li>NotFoundException The specified request is not valid.</li>
     *         <li>AccessDeniedException You do not have permission to perform this operation.</li>
     *         <li>InternalServerException An internal error has occurred.</li>
     *         <li>ServiceQuotaExceededException You have exceeded a service quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OutpostsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OutpostsAsyncClient.CreateOutpost
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/CreateOutpost" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateOutpostResponse> createOutpost(CreateOutpostRequest createOutpostRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Outpost.
     * </p>
     * <p>
     * You can specify either an Availability one or an AZ ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateOutpostRequest.Builder} avoiding the need to
     * create one manually via {@link CreateOutpostRequest#builder()}
     * </p>
     *
     * @param createOutpostRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.outposts.model.CreateOutpostRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateOutpost operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>ConflictException Updating or deleting this resource can cause an inconsistent state.</li>
     *         <li>NotFoundException The specified request is not valid.</li>
     *         <li>AccessDeniedException You do not have permission to perform this operation.</li>
     *         <li>InternalServerException An internal error has occurred.</li>
     *         <li>ServiceQuotaExceededException You have exceeded a service quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OutpostsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OutpostsAsyncClient.CreateOutpost
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/CreateOutpost" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateOutpostResponse> createOutpost(Consumer<CreateOutpostRequest.Builder> createOutpostRequest) {
        return createOutpost(CreateOutpostRequest.builder().applyMutation(createOutpostRequest).build());
    }

    /**
     * <p>
     * Creates a site for an Outpost.
     * </p>
     *
     * @param createSiteRequest
     * @return A Java Future containing the result of the CreateSite operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>ConflictException Updating or deleting this resource can cause an inconsistent state.</li>
     *         <li>AccessDeniedException You do not have permission to perform this operation.</li>
     *         <li>InternalServerException An internal error has occurred.</li>
     *         <li>ServiceQuotaExceededException You have exceeded a service quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OutpostsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OutpostsAsyncClient.CreateSite
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/CreateSite" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateSiteResponse> createSite(CreateSiteRequest createSiteRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a site for an Outpost.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSiteRequest.Builder} avoiding the need to
     * create one manually via {@link CreateSiteRequest#builder()}
     * </p>
     *
     * @param createSiteRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.outposts.model.CreateSiteRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateSite operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>ConflictException Updating or deleting this resource can cause an inconsistent state.</li>
     *         <li>AccessDeniedException You do not have permission to perform this operation.</li>
     *         <li>InternalServerException An internal error has occurred.</li>
     *         <li>ServiceQuotaExceededException You have exceeded a service quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OutpostsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OutpostsAsyncClient.CreateSite
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/CreateSite" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateSiteResponse> createSite(Consumer<CreateSiteRequest.Builder> createSiteRequest) {
        return createSite(CreateSiteRequest.builder().applyMutation(createSiteRequest).build());
    }

    /**
     * <p>
     * Deletes the specified Outpost.
     * </p>
     *
     * @param deleteOutpostRequest
     * @return A Java Future containing the result of the DeleteOutpost operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>ConflictException Updating or deleting this resource can cause an inconsistent state.</li>
     *         <li>NotFoundException The specified request is not valid.</li>
     *         <li>AccessDeniedException You do not have permission to perform this operation.</li>
     *         <li>InternalServerException An internal error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OutpostsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OutpostsAsyncClient.DeleteOutpost
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/DeleteOutpost" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteOutpostResponse> deleteOutpost(DeleteOutpostRequest deleteOutpostRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified Outpost.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteOutpostRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteOutpostRequest#builder()}
     * </p>
     *
     * @param deleteOutpostRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.outposts.model.DeleteOutpostRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteOutpost operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>ConflictException Updating or deleting this resource can cause an inconsistent state.</li>
     *         <li>NotFoundException The specified request is not valid.</li>
     *         <li>AccessDeniedException You do not have permission to perform this operation.</li>
     *         <li>InternalServerException An internal error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OutpostsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OutpostsAsyncClient.DeleteOutpost
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/DeleteOutpost" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteOutpostResponse> deleteOutpost(Consumer<DeleteOutpostRequest.Builder> deleteOutpostRequest) {
        return deleteOutpost(DeleteOutpostRequest.builder().applyMutation(deleteOutpostRequest).build());
    }

    /**
     * <p>
     * Deletes the specified site.
     * </p>
     *
     * @param deleteSiteRequest
     * @return A Java Future containing the result of the DeleteSite operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>ConflictException Updating or deleting this resource can cause an inconsistent state.</li>
     *         <li>NotFoundException The specified request is not valid.</li>
     *         <li>AccessDeniedException You do not have permission to perform this operation.</li>
     *         <li>InternalServerException An internal error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OutpostsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OutpostsAsyncClient.DeleteSite
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/DeleteSite" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteSiteResponse> deleteSite(DeleteSiteRequest deleteSiteRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified site.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSiteRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteSiteRequest#builder()}
     * </p>
     *
     * @param deleteSiteRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.outposts.model.DeleteSiteRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteSite operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>ConflictException Updating or deleting this resource can cause an inconsistent state.</li>
     *         <li>NotFoundException The specified request is not valid.</li>
     *         <li>AccessDeniedException You do not have permission to perform this operation.</li>
     *         <li>InternalServerException An internal error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OutpostsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OutpostsAsyncClient.DeleteSite
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/DeleteSite" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteSiteResponse> deleteSite(Consumer<DeleteSiteRequest.Builder> deleteSiteRequest) {
        return deleteSite(DeleteSiteRequest.builder().applyMutation(deleteSiteRequest).build());
    }

    /**
     * <p>
     * Gets information about the specified catalog item.
     * </p>
     *
     * @param getCatalogItemRequest
     * @return A Java Future containing the result of the GetCatalogItem operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>NotFoundException The specified request is not valid.</li>
     *         <li>InternalServerException An internal error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OutpostsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OutpostsAsyncClient.GetCatalogItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/GetCatalogItem" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetCatalogItemResponse> getCatalogItem(GetCatalogItemRequest getCatalogItemRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the specified catalog item.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCatalogItemRequest.Builder} avoiding the need to
     * create one manually via {@link GetCatalogItemRequest#builder()}
     * </p>
     *
     * @param getCatalogItemRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.outposts.model.GetCatalogItemRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetCatalogItem operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>NotFoundException The specified request is not valid.</li>
     *         <li>InternalServerException An internal error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OutpostsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OutpostsAsyncClient.GetCatalogItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/GetCatalogItem" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetCatalogItemResponse> getCatalogItem(Consumer<GetCatalogItemRequest.Builder> getCatalogItemRequest) {
        return getCatalogItem(GetCatalogItemRequest.builder().applyMutation(getCatalogItemRequest).build());
    }

    /**
     * <note>
     * <p>
     * Amazon Web Services uses this action to install Outpost servers.
     * </p>
     * </note>
     * <p>
     * Gets information about the specified connection.
     * </p>
     * <p>
     * Use CloudTrail to monitor this action or Amazon Web Services managed policy for Amazon Web Services Outposts to
     * secure it. For more information, see <a
     * href="https://docs.aws.amazon.com/outposts/latest/userguide/security-iam-awsmanpol.html"> Amazon Web Services
     * managed policies for Amazon Web Services Outposts</a> and <a
     * href="https://docs.aws.amazon.com/outposts/latest/userguide/logging-using-cloudtrail.html"> Logging Amazon Web
     * Services Outposts API calls with Amazon Web Services CloudTrail</a> in the <i>Amazon Web Services Outposts User
     * Guide</i>.
     * </p>
     *
     * @param getConnectionRequest
     * @return A Java Future containing the result of the GetConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have permission to perform this operation.</li>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>NotFoundException The specified request is not valid.</li>
     *         <li>InternalServerException An internal error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OutpostsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OutpostsAsyncClient.GetConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/GetConnection" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetConnectionResponse> getConnection(GetConnectionRequest getConnectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * Amazon Web Services uses this action to install Outpost servers.
     * </p>
     * </note>
     * <p>
     * Gets information about the specified connection.
     * </p>
     * <p>
     * Use CloudTrail to monitor this action or Amazon Web Services managed policy for Amazon Web Services Outposts to
     * secure it. For more information, see <a
     * href="https://docs.aws.amazon.com/outposts/latest/userguide/security-iam-awsmanpol.html"> Amazon Web Services
     * managed policies for Amazon Web Services Outposts</a> and <a
     * href="https://docs.aws.amazon.com/outposts/latest/userguide/logging-using-cloudtrail.html"> Logging Amazon Web
     * Services Outposts API calls with Amazon Web Services CloudTrail</a> in the <i>Amazon Web Services Outposts User
     * Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConnectionRequest.Builder} avoiding the need to
     * create one manually via {@link GetConnectionRequest#builder()}
     * </p>
     *
     * @param getConnectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.outposts.model.GetConnectionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have permission to perform this operation.</li>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>NotFoundException The specified request is not valid.</li>
     *         <li>InternalServerException An internal error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OutpostsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OutpostsAsyncClient.GetConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/GetConnection" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetConnectionResponse> getConnection(Consumer<GetConnectionRequest.Builder> getConnectionRequest) {
        return getConnection(GetConnectionRequest.builder().applyMutation(getConnectionRequest).build());
    }

    /**
     * <p>
     * Gets information about the specified order.
     * </p>
     *
     * @param getOrderRequest
     * @return A Java Future containing the result of the GetOrder operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>NotFoundException The specified request is not valid.</li>
     *         <li>InternalServerException An internal error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OutpostsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OutpostsAsyncClient.GetOrder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/GetOrder" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetOrderResponse> getOrder(GetOrderRequest getOrderRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the specified order.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetOrderRequest.Builder} avoiding the need to
     * create one manually via {@link GetOrderRequest#builder()}
     * </p>
     *
     * @param getOrderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.outposts.model.GetOrderRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetOrder operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>NotFoundException The specified request is not valid.</li>
     *         <li>InternalServerException An internal error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OutpostsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OutpostsAsyncClient.GetOrder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/GetOrder" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetOrderResponse> getOrder(Consumer<GetOrderRequest.Builder> getOrderRequest) {
        return getOrder(GetOrderRequest.builder().applyMutation(getOrderRequest).build());
    }

    /**
     * <p>
     * Gets information about the specified Outpost.
     * </p>
     *
     * @param getOutpostRequest
     * @return A Java Future containing the result of the GetOutpost operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>NotFoundException The specified request is not valid.</li>
     *         <li>AccessDeniedException You do not have permission to perform this operation.</li>
     *         <li>InternalServerException An internal error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OutpostsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OutpostsAsyncClient.GetOutpost
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/GetOutpost" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetOutpostResponse> getOutpost(GetOutpostRequest getOutpostRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the specified Outpost.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetOutpostRequest.Builder} avoiding the need to
     * create one manually via {@link GetOutpostRequest#builder()}
     * </p>
     *
     * @param getOutpostRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.outposts.model.GetOutpostRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetOutpost operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>NotFoundException The specified request is not valid.</li>
     *         <li>AccessDeniedException You do not have permission to perform this operation.</li>
     *         <li>InternalServerException An internal error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OutpostsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OutpostsAsyncClient.GetOutpost
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/GetOutpost" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetOutpostResponse> getOutpost(Consumer<GetOutpostRequest.Builder> getOutpostRequest) {
        return getOutpost(GetOutpostRequest.builder().applyMutation(getOutpostRequest).build());
    }

    /**
     * <p>
     * Gets the instance types for the specified Outpost.
     * </p>
     *
     * @param getOutpostInstanceTypesRequest
     * @return A Java Future containing the result of the GetOutpostInstanceTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>NotFoundException The specified request is not valid.</li>
     *         <li>AccessDeniedException You do not have permission to perform this operation.</li>
     *         <li>InternalServerException An internal error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OutpostsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OutpostsAsyncClient.GetOutpostInstanceTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/GetOutpostInstanceTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetOutpostInstanceTypesResponse> getOutpostInstanceTypes(
            GetOutpostInstanceTypesRequest getOutpostInstanceTypesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the instance types for the specified Outpost.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetOutpostInstanceTypesRequest.Builder} avoiding
     * the need to create one manually via {@link GetOutpostInstanceTypesRequest#builder()}
     * </p>
     *
     * @param getOutpostInstanceTypesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.outposts.model.GetOutpostInstanceTypesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetOutpostInstanceTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>NotFoundException The specified request is not valid.</li>
     *         <li>AccessDeniedException You do not have permission to perform this operation.</li>
     *         <li>InternalServerException An internal error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OutpostsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OutpostsAsyncClient.GetOutpostInstanceTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/GetOutpostInstanceTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetOutpostInstanceTypesResponse> getOutpostInstanceTypes(
            Consumer<GetOutpostInstanceTypesRequest.Builder> getOutpostInstanceTypesRequest) {
        return getOutpostInstanceTypes(GetOutpostInstanceTypesRequest.builder().applyMutation(getOutpostInstanceTypesRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getOutpostInstanceTypes(software.amazon.awssdk.services.outposts.model.GetOutpostInstanceTypesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.outposts.paginators.GetOutpostInstanceTypesPublisher publisher = client.getOutpostInstanceTypesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.outposts.paginators.GetOutpostInstanceTypesPublisher publisher = client.getOutpostInstanceTypesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.outposts.model.GetOutpostInstanceTypesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.outposts.model.GetOutpostInstanceTypesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getOutpostInstanceTypes(software.amazon.awssdk.services.outposts.model.GetOutpostInstanceTypesRequest)}
     * operation.</b>
     * </p>
     *
     * @param getOutpostInstanceTypesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>NotFoundException The specified request is not valid.</li>
     *         <li>AccessDeniedException You do not have permission to perform this operation.</li>
     *         <li>InternalServerException An internal error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OutpostsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OutpostsAsyncClient.GetOutpostInstanceTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/GetOutpostInstanceTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default GetOutpostInstanceTypesPublisher getOutpostInstanceTypesPaginator(
            GetOutpostInstanceTypesRequest getOutpostInstanceTypesRequest) {
        return new GetOutpostInstanceTypesPublisher(this, getOutpostInstanceTypesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getOutpostInstanceTypes(software.amazon.awssdk.services.outposts.model.GetOutpostInstanceTypesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.outposts.paginators.GetOutpostInstanceTypesPublisher publisher = client.getOutpostInstanceTypesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.outposts.paginators.GetOutpostInstanceTypesPublisher publisher = client.getOutpostInstanceTypesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.outposts.model.GetOutpostInstanceTypesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.outposts.model.GetOutpostInstanceTypesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getOutpostInstanceTypes(software.amazon.awssdk.services.outposts.model.GetOutpostInstanceTypesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetOutpostInstanceTypesRequest.Builder} avoiding
     * the need to create one manually via {@link GetOutpostInstanceTypesRequest#builder()}
     * </p>
     *
     * @param getOutpostInstanceTypesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.outposts.model.GetOutpostInstanceTypesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>NotFoundException The specified request is not valid.</li>
     *         <li>AccessDeniedException You do not have permission to perform this operation.</li>
     *         <li>InternalServerException An internal error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OutpostsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OutpostsAsyncClient.GetOutpostInstanceTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/GetOutpostInstanceTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default GetOutpostInstanceTypesPublisher getOutpostInstanceTypesPaginator(
            Consumer<GetOutpostInstanceTypesRequest.Builder> getOutpostInstanceTypesRequest) {
        return getOutpostInstanceTypesPaginator(GetOutpostInstanceTypesRequest.builder()
                .applyMutation(getOutpostInstanceTypesRequest).build());
    }

    /**
     * <p>
     * Gets information about the specified Outpost site.
     * </p>
     *
     * @param getSiteRequest
     * @return A Java Future containing the result of the GetSite operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>NotFoundException The specified request is not valid.</li>
     *         <li>AccessDeniedException You do not have permission to perform this operation.</li>
     *         <li>InternalServerException An internal error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OutpostsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OutpostsAsyncClient.GetSite
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/GetSite" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetSiteResponse> getSite(GetSiteRequest getSiteRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the specified Outpost site.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSiteRequest.Builder} avoiding the need to create
     * one manually via {@link GetSiteRequest#builder()}
     * </p>
     *
     * @param getSiteRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.outposts.model.GetSiteRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetSite operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>NotFoundException The specified request is not valid.</li>
     *         <li>AccessDeniedException You do not have permission to perform this operation.</li>
     *         <li>InternalServerException An internal error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OutpostsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OutpostsAsyncClient.GetSite
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/GetSite" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetSiteResponse> getSite(Consumer<GetSiteRequest.Builder> getSiteRequest) {
        return getSite(GetSiteRequest.builder().applyMutation(getSiteRequest).build());
    }

    /**
     * <p>
     * Gets the site address of the specified site.
     * </p>
     *
     * @param getSiteAddressRequest
     * @return A Java Future containing the result of the GetSiteAddress operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>AccessDeniedException You do not have permission to perform this operation.</li>
     *         <li>NotFoundException The specified request is not valid.</li>
     *         <li>InternalServerException An internal error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OutpostsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OutpostsAsyncClient.GetSiteAddress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/GetSiteAddress" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetSiteAddressResponse> getSiteAddress(GetSiteAddressRequest getSiteAddressRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the site address of the specified site.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSiteAddressRequest.Builder} avoiding the need to
     * create one manually via {@link GetSiteAddressRequest#builder()}
     * </p>
     *
     * @param getSiteAddressRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.outposts.model.GetSiteAddressRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetSiteAddress operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>AccessDeniedException You do not have permission to perform this operation.</li>
     *         <li>NotFoundException The specified request is not valid.</li>
     *         <li>InternalServerException An internal error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OutpostsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OutpostsAsyncClient.GetSiteAddress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/GetSiteAddress" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetSiteAddressResponse> getSiteAddress(Consumer<GetSiteAddressRequest.Builder> getSiteAddressRequest) {
        return getSiteAddress(GetSiteAddressRequest.builder().applyMutation(getSiteAddressRequest).build());
    }

    /**
     * <p>
     * Lists the hardware assets for the specified Outpost.
     * </p>
     * <p>
     * Use filters to return specific results. If you specify multiple filters, the results include only the resources
     * that match all of the specified filters. For a filter where you can specify multiple values, the results include
     * items that match any of the values that you specify for the filter.
     * </p>
     *
     * @param listAssetsRequest
     * @return A Java Future containing the result of the ListAssets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>AccessDeniedException You do not have permission to perform this operation.</li>
     *         <li>NotFoundException The specified request is not valid.</li>
     *         <li>InternalServerException An internal error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OutpostsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OutpostsAsyncClient.ListAssets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/ListAssets" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListAssetsResponse> listAssets(ListAssetsRequest listAssetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the hardware assets for the specified Outpost.
     * </p>
     * <p>
     * Use filters to return specific results. If you specify multiple filters, the results include only the resources
     * that match all of the specified filters. For a filter where you can specify multiple values, the results include
     * items that match any of the values that you specify for the filter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListAssetsRequest#builder()}
     * </p>
     *
     * @param listAssetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.outposts.model.ListAssetsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListAssets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>AccessDeniedException You do not have permission to perform this operation.</li>
     *         <li>NotFoundException The specified request is not valid.</li>
     *         <li>InternalServerException An internal error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OutpostsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OutpostsAsyncClient.ListAssets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/ListAssets" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListAssetsResponse> listAssets(Consumer<ListAssetsRequest.Builder> listAssetsRequest) {
        return listAssets(ListAssetsRequest.builder().applyMutation(listAssetsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listAssets(software.amazon.awssdk.services.outposts.model.ListAssetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.outposts.paginators.ListAssetsPublisher publisher = client.listAssetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.outposts.paginators.ListAssetsPublisher publisher = client.listAssetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.outposts.model.ListAssetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.outposts.model.ListAssetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssets(software.amazon.awssdk.services.outposts.model.ListAssetsRequest)} operation.</b>
     * </p>
     *
     * @param listAssetsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>AccessDeniedException You do not have permission to perform this operation.</li>
     *         <li>NotFoundException The specified request is not valid.</li>
     *         <li>InternalServerException An internal error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OutpostsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OutpostsAsyncClient.ListAssets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/ListAssets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAssetsPublisher listAssetsPaginator(ListAssetsRequest listAssetsRequest) {
        return new ListAssetsPublisher(this, listAssetsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listAssets(software.amazon.awssdk.services.outposts.model.ListAssetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.outposts.paginators.ListAssetsPublisher publisher = client.listAssetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.outposts.paginators.ListAssetsPublisher publisher = client.listAssetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.outposts.model.ListAssetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.outposts.model.ListAssetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssets(software.amazon.awssdk.services.outposts.model.ListAssetsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListAssetsRequest#builder()}
     * </p>
     *
     * @param listAssetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.outposts.model.ListAssetsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>AccessDeniedException You do not have permission to perform this operation.</li>
     *         <li>NotFoundException The specified request is not valid.</li>
     *         <li>InternalServerException An internal error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OutpostsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OutpostsAsyncClient.ListAssets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/ListAssets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAssetsPublisher listAssetsPaginator(Consumer<ListAssetsRequest.Builder> listAssetsRequest) {
        return listAssetsPaginator(ListAssetsRequest.builder().applyMutation(listAssetsRequest).build());
    }

    /**
     * <p>
     * Lists the items in the catalog.
     * </p>
     * <p>
     * Use filters to return specific results. If you specify multiple filters, the results include only the resources
     * that match all of the specified filters. For a filter where you can specify multiple values, the results include
     * items that match any of the values that you specify for the filter.
     * </p>
     *
     * @param listCatalogItemsRequest
     * @return A Java Future containing the result of the ListCatalogItems operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>NotFoundException The specified request is not valid.</li>
     *         <li>InternalServerException An internal error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OutpostsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OutpostsAsyncClient.ListCatalogItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/ListCatalogItems" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListCatalogItemsResponse> listCatalogItems(ListCatalogItemsRequest listCatalogItemsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the items in the catalog.
     * </p>
     * <p>
     * Use filters to return specific results. If you specify multiple filters, the results include only the resources
     * that match all of the specified filters. For a filter where you can specify multiple values, the results include
     * items that match any of the values that you specify for the filter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCatalogItemsRequest.Builder} avoiding the need
     * to create one manually via {@link ListCatalogItemsRequest#builder()}
     * </p>
     *
     * @param listCatalogItemsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.outposts.model.ListCatalogItemsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListCatalogItems operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>NotFoundException The specified request is not valid.</li>
     *         <li>InternalServerException An internal error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OutpostsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OutpostsAsyncClient.ListCatalogItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/ListCatalogItems" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListCatalogItemsResponse> listCatalogItems(
            Consumer<ListCatalogItemsRequest.Builder> listCatalogItemsRequest) {
        return listCatalogItems(ListCatalogItemsRequest.builder().applyMutation(listCatalogItemsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCatalogItems(software.amazon.awssdk.services.outposts.model.ListCatalogItemsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.outposts.paginators.ListCatalogItemsPublisher publisher = client.listCatalogItemsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.outposts.paginators.ListCatalogItemsPublisher publisher = client.listCatalogItemsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.outposts.model.ListCatalogItemsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.outposts.model.ListCatalogItemsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCatalogItems(software.amazon.awssdk.services.outposts.model.ListCatalogItemsRequest)} operation.</b>
     * </p>
     *
     * @param listCatalogItemsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>NotFoundException The specified request is not valid.</li>
     *         <li>InternalServerException An internal error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OutpostsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OutpostsAsyncClient.ListCatalogItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/ListCatalogItems" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCatalogItemsPublisher listCatalogItemsPaginator(ListCatalogItemsRequest listCatalogItemsRequest) {
        return new ListCatalogItemsPublisher(this, listCatalogItemsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCatalogItems(software.amazon.awssdk.services.outposts.model.ListCatalogItemsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.outposts.paginators.ListCatalogItemsPublisher publisher = client.listCatalogItemsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.outposts.paginators.ListCatalogItemsPublisher publisher = client.listCatalogItemsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.outposts.model.ListCatalogItemsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.outposts.model.ListCatalogItemsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCatalogItems(software.amazon.awssdk.services.outposts.model.ListCatalogItemsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCatalogItemsRequest.Builder} avoiding the need
     * to create one manually via {@link ListCatalogItemsRequest#builder()}
     * </p>
     *
     * @param listCatalogItemsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.outposts.model.ListCatalogItemsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>NotFoundException The specified request is not valid.</li>
     *         <li>InternalServerException An internal error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OutpostsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OutpostsAsyncClient.ListCatalogItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/ListCatalogItems" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCatalogItemsPublisher listCatalogItemsPaginator(Consumer<ListCatalogItemsRequest.Builder> listCatalogItemsRequest) {
        return listCatalogItemsPaginator(ListCatalogItemsRequest.builder().applyMutation(listCatalogItemsRequest).build());
    }

    /**
     * <p>
     * Lists the Outpost orders for your Amazon Web Services account.
     * </p>
     *
     * @param listOrdersRequest
     * @return A Java Future containing the result of the ListOrders operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>NotFoundException The specified request is not valid.</li>
     *         <li>AccessDeniedException You do not have permission to perform this operation.</li>
     *         <li>InternalServerException An internal error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OutpostsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OutpostsAsyncClient.ListOrders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/ListOrders" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListOrdersResponse> listOrders(ListOrdersRequest listOrdersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the Outpost orders for your Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOrdersRequest.Builder} avoiding the need to
     * create one manually via {@link ListOrdersRequest#builder()}
     * </p>
     *
     * @param listOrdersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.outposts.model.ListOrdersRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListOrders operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>NotFoundException The specified request is not valid.</li>
     *         <li>AccessDeniedException You do not have permission to perform this operation.</li>
     *         <li>InternalServerException An internal error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OutpostsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OutpostsAsyncClient.ListOrders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/ListOrders" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListOrdersResponse> listOrders(Consumer<ListOrdersRequest.Builder> listOrdersRequest) {
        return listOrders(ListOrdersRequest.builder().applyMutation(listOrdersRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listOrders(software.amazon.awssdk.services.outposts.model.ListOrdersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.outposts.paginators.ListOrdersPublisher publisher = client.listOrdersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.outposts.paginators.ListOrdersPublisher publisher = client.listOrdersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.outposts.model.ListOrdersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.outposts.model.ListOrdersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOrders(software.amazon.awssdk.services.outposts.model.ListOrdersRequest)} operation.</b>
     * </p>
     *
     * @param listOrdersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>NotFoundException The specified request is not valid.</li>
     *         <li>AccessDeniedException You do not have permission to perform this operation.</li>
     *         <li>InternalServerException An internal error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OutpostsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OutpostsAsyncClient.ListOrders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/ListOrders" target="_top">AWS API
     *      Documentation</a>
     */
    default ListOrdersPublisher listOrdersPaginator(ListOrdersRequest listOrdersRequest) {
        return new ListOrdersPublisher(this, listOrdersRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listOrders(software.amazon.awssdk.services.outposts.model.ListOrdersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.outposts.paginators.ListOrdersPublisher publisher = client.listOrdersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.outposts.paginators.ListOrdersPublisher publisher = client.listOrdersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.outposts.model.ListOrdersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.outposts.model.ListOrdersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOrders(software.amazon.awssdk.services.outposts.model.ListOrdersRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOrdersRequest.Builder} avoiding the need to
     * create one manually via {@link ListOrdersRequest#builder()}
     * </p>
     *
     * @param listOrdersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.outposts.model.ListOrdersRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>NotFoundException The specified request is not valid.</li>
     *         <li>AccessDeniedException You do not have permission to perform this operation.</li>
     *         <li>InternalServerException An internal error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OutpostsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OutpostsAsyncClient.ListOrders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/ListOrders" target="_top">AWS API
     *      Documentation</a>
     */
    default ListOrdersPublisher listOrdersPaginator(Consumer<ListOrdersRequest.Builder> listOrdersRequest) {
        return listOrdersPaginator(ListOrdersRequest.builder().applyMutation(listOrdersRequest).build());
    }

    /**
     * <p>
     * Lists the Outposts for your Amazon Web Services account.
     * </p>
     * <p>
     * Use filters to return specific results. If you specify multiple filters, the results include only the resources
     * that match all of the specified filters. For a filter where you can specify multiple values, the results include
     * items that match any of the values that you specify for the filter.
     * </p>
     *
     * @param listOutpostsRequest
     * @return A Java Future containing the result of the ListOutposts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>AccessDeniedException You do not have permission to perform this operation.</li>
     *         <li>InternalServerException An internal error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OutpostsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OutpostsAsyncClient.ListOutposts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/ListOutposts" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListOutpostsResponse> listOutposts(ListOutpostsRequest listOutpostsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the Outposts for your Amazon Web Services account.
     * </p>
     * <p>
     * Use filters to return specific results. If you specify multiple filters, the results include only the resources
     * that match all of the specified filters. For a filter where you can specify multiple values, the results include
     * items that match any of the values that you specify for the filter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOutpostsRequest.Builder} avoiding the need to
     * create one manually via {@link ListOutpostsRequest#builder()}
     * </p>
     *
     * @param listOutpostsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.outposts.model.ListOutpostsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListOutposts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>AccessDeniedException You do not have permission to perform this operation.</li>
     *         <li>InternalServerException An internal error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OutpostsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OutpostsAsyncClient.ListOutposts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/ListOutposts" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListOutpostsResponse> listOutposts(Consumer<ListOutpostsRequest.Builder> listOutpostsRequest) {
        return listOutposts(ListOutpostsRequest.builder().applyMutation(listOutpostsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listOutposts(software.amazon.awssdk.services.outposts.model.ListOutpostsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.outposts.paginators.ListOutpostsPublisher publisher = client.listOutpostsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.outposts.paginators.ListOutpostsPublisher publisher = client.listOutpostsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.outposts.model.ListOutpostsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.outposts.model.ListOutpostsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOutposts(software.amazon.awssdk.services.outposts.model.ListOutpostsRequest)} operation.</b>
     * </p>
     *
     * @param listOutpostsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>AccessDeniedException You do not have permission to perform this operation.</li>
     *         <li>InternalServerException An internal error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OutpostsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OutpostsAsyncClient.ListOutposts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/ListOutposts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListOutpostsPublisher listOutpostsPaginator(ListOutpostsRequest listOutpostsRequest) {
        return new ListOutpostsPublisher(this, listOutpostsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listOutposts(software.amazon.awssdk.services.outposts.model.ListOutpostsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.outposts.paginators.ListOutpostsPublisher publisher = client.listOutpostsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.outposts.paginators.ListOutpostsPublisher publisher = client.listOutpostsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.outposts.model.ListOutpostsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.outposts.model.ListOutpostsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOutposts(software.amazon.awssdk.services.outposts.model.ListOutpostsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOutpostsRequest.Builder} avoiding the need to
     * create one manually via {@link ListOutpostsRequest#builder()}
     * </p>
     *
     * @param listOutpostsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.outposts.model.ListOutpostsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>AccessDeniedException You do not have permission to perform this operation.</li>
     *         <li>InternalServerException An internal error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OutpostsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OutpostsAsyncClient.ListOutposts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/ListOutposts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListOutpostsPublisher listOutpostsPaginator(Consumer<ListOutpostsRequest.Builder> listOutpostsRequest) {
        return listOutpostsPaginator(ListOutpostsRequest.builder().applyMutation(listOutpostsRequest).build());
    }

    /**
     * <p>
     * Lists the Outpost sites for your Amazon Web Services account. Use filters to return specific results.
     * </p>
     * <p>
     * Use filters to return specific results. If you specify multiple filters, the results include only the resources
     * that match all of the specified filters. For a filter where you can specify multiple values, the results include
     * items that match any of the values that you specify for the filter.
     * </p>
     *
     * @param listSitesRequest
     * @return A Java Future containing the result of the ListSites operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>AccessDeniedException You do not have permission to perform this operation.</li>
     *         <li>InternalServerException An internal error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OutpostsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OutpostsAsyncClient.ListSites
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/ListSites" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListSitesResponse> listSites(ListSitesRequest listSitesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the Outpost sites for your Amazon Web Services account. Use filters to return specific results.
     * </p>
     * <p>
     * Use filters to return specific results. If you specify multiple filters, the results include only the resources
     * that match all of the specified filters. For a filter where you can specify multiple values, the results include
     * items that match any of the values that you specify for the filter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSitesRequest.Builder} avoiding the need to
     * create one manually via {@link ListSitesRequest#builder()}
     * </p>
     *
     * @param listSitesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.outposts.model.ListSitesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListSites operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>AccessDeniedException You do not have permission to perform this operation.</li>
     *         <li>InternalServerException An internal error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OutpostsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OutpostsAsyncClient.ListSites
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/ListSites" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListSitesResponse> listSites(Consumer<ListSitesRequest.Builder> listSitesRequest) {
        return listSites(ListSitesRequest.builder().applyMutation(listSitesRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listSites(software.amazon.awssdk.services.outposts.model.ListSitesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.outposts.paginators.ListSitesPublisher publisher = client.listSitesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.outposts.paginators.ListSitesPublisher publisher = client.listSitesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.outposts.model.ListSitesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.outposts.model.ListSitesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSites(software.amazon.awssdk.services.outposts.model.ListSitesRequest)} operation.</b>
     * </p>
     *
     * @param listSitesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>AccessDeniedException You do not have permission to perform this operation.</li>
     *         <li>InternalServerException An internal error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OutpostsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OutpostsAsyncClient.ListSites
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/ListSites" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSitesPublisher listSitesPaginator(ListSitesRequest listSitesRequest) {
        return new ListSitesPublisher(this, listSitesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listSites(software.amazon.awssdk.services.outposts.model.ListSitesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.outposts.paginators.ListSitesPublisher publisher = client.listSitesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.outposts.paginators.ListSitesPublisher publisher = client.listSitesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.outposts.model.ListSitesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.outposts.model.ListSitesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSites(software.amazon.awssdk.services.outposts.model.ListSitesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSitesRequest.Builder} avoiding the need to
     * create one manually via {@link ListSitesRequest#builder()}
     * </p>
     *
     * @param listSitesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.outposts.model.ListSitesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>AccessDeniedException You do not have permission to perform this operation.</li>
     *         <li>InternalServerException An internal error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OutpostsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OutpostsAsyncClient.ListSites
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/ListSites" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSitesPublisher listSitesPaginator(Consumer<ListSitesRequest.Builder> listSitesRequest) {
        return listSitesPaginator(ListSitesRequest.builder().applyMutation(listSitesRequest).build());
    }

    /**
     * <p>
     * Lists the tags for the specified resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal error has occurred.</li>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>NotFoundException The specified request is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OutpostsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OutpostsAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags for the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.outposts.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal error has occurred.</li>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>NotFoundException The specified request is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OutpostsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OutpostsAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <note>
     * <p>
     * Amazon Web Services uses this action to install Outpost servers.
     * </p>
     * </note>
     * <p>
     * Starts the connection required for Outpost server installation.
     * </p>
     * <p>
     * Use CloudTrail to monitor this action or Amazon Web Services managed policy for Amazon Web Services Outposts to
     * secure it. For more information, see <a
     * href="https://docs.aws.amazon.com/outposts/latest/userguide/security-iam-awsmanpol.html"> Amazon Web Services
     * managed policies for Amazon Web Services Outposts</a> and <a
     * href="https://docs.aws.amazon.com/outposts/latest/userguide/logging-using-cloudtrail.html"> Logging Amazon Web
     * Services Outposts API calls with Amazon Web Services CloudTrail</a> in the <i>Amazon Web Services Outposts User
     * Guide</i>.
     * </p>
     *
     * @param startConnectionRequest
     * @return A Java Future containing the result of the StartConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have permission to perform this operation.</li>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>NotFoundException The specified request is not valid.</li>
     *         <li>InternalServerException An internal error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OutpostsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OutpostsAsyncClient.StartConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/StartConnection" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartConnectionResponse> startConnection(StartConnectionRequest startConnectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * Amazon Web Services uses this action to install Outpost servers.
     * </p>
     * </note>
     * <p>
     * Starts the connection required for Outpost server installation.
     * </p>
     * <p>
     * Use CloudTrail to monitor this action or Amazon Web Services managed policy for Amazon Web Services Outposts to
     * secure it. For more information, see <a
     * href="https://docs.aws.amazon.com/outposts/latest/userguide/security-iam-awsmanpol.html"> Amazon Web Services
     * managed policies for Amazon Web Services Outposts</a> and <a
     * href="https://docs.aws.amazon.com/outposts/latest/userguide/logging-using-cloudtrail.html"> Logging Amazon Web
     * Services Outposts API calls with Amazon Web Services CloudTrail</a> in the <i>Amazon Web Services Outposts User
     * Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartConnectionRequest.Builder} avoiding the need
     * to create one manually via {@link StartConnectionRequest#builder()}
     * </p>
     *
     * @param startConnectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.outposts.model.StartConnectionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the StartConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have permission to perform this operation.</li>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>NotFoundException The specified request is not valid.</li>
     *         <li>InternalServerException An internal error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OutpostsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OutpostsAsyncClient.StartConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/StartConnection" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartConnectionResponse> startConnection(
            Consumer<StartConnectionRequest.Builder> startConnectionRequest) {
        return startConnection(StartConnectionRequest.builder().applyMutation(startConnectionRequest).build());
    }

    /**
     * <p>
     * Adds tags to the specified resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal error has occurred.</li>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>NotFoundException The specified request is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OutpostsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OutpostsAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds tags to the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.outposts.model.TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal error has occurred.</li>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>NotFoundException The specified request is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OutpostsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OutpostsAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes tags from the specified resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal error has occurred.</li>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>NotFoundException The specified request is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OutpostsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OutpostsAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes tags from the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.outposts.model.UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal error has occurred.</li>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>NotFoundException The specified request is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OutpostsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OutpostsAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates an Outpost.
     * </p>
     *
     * @param updateOutpostRequest
     * @return A Java Future containing the result of the UpdateOutpost operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>ConflictException Updating or deleting this resource can cause an inconsistent state.</li>
     *         <li>NotFoundException The specified request is not valid.</li>
     *         <li>AccessDeniedException You do not have permission to perform this operation.</li>
     *         <li>InternalServerException An internal error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OutpostsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OutpostsAsyncClient.UpdateOutpost
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/UpdateOutpost" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateOutpostResponse> updateOutpost(UpdateOutpostRequest updateOutpostRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an Outpost.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateOutpostRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateOutpostRequest#builder()}
     * </p>
     *
     * @param updateOutpostRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.outposts.model.UpdateOutpostRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateOutpost operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>ConflictException Updating or deleting this resource can cause an inconsistent state.</li>
     *         <li>NotFoundException The specified request is not valid.</li>
     *         <li>AccessDeniedException You do not have permission to perform this operation.</li>
     *         <li>InternalServerException An internal error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OutpostsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OutpostsAsyncClient.UpdateOutpost
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/UpdateOutpost" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateOutpostResponse> updateOutpost(Consumer<UpdateOutpostRequest.Builder> updateOutpostRequest) {
        return updateOutpost(UpdateOutpostRequest.builder().applyMutation(updateOutpostRequest).build());
    }

    /**
     * <p>
     * Updates the specified site.
     * </p>
     *
     * @param updateSiteRequest
     * @return A Java Future containing the result of the UpdateSite operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>ConflictException Updating or deleting this resource can cause an inconsistent state.</li>
     *         <li>NotFoundException The specified request is not valid.</li>
     *         <li>AccessDeniedException You do not have permission to perform this operation.</li>
     *         <li>InternalServerException An internal error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OutpostsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OutpostsAsyncClient.UpdateSite
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/UpdateSite" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateSiteResponse> updateSite(UpdateSiteRequest updateSiteRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified site.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSiteRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateSiteRequest#builder()}
     * </p>
     *
     * @param updateSiteRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.outposts.model.UpdateSiteRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateSite operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>ConflictException Updating or deleting this resource can cause an inconsistent state.</li>
     *         <li>NotFoundException The specified request is not valid.</li>
     *         <li>AccessDeniedException You do not have permission to perform this operation.</li>
     *         <li>InternalServerException An internal error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OutpostsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OutpostsAsyncClient.UpdateSite
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/UpdateSite" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateSiteResponse> updateSite(Consumer<UpdateSiteRequest.Builder> updateSiteRequest) {
        return updateSite(UpdateSiteRequest.builder().applyMutation(updateSiteRequest).build());
    }

    /**
     * <p>
     * Updates the address of the specified site.
     * </p>
     * <p>
     * You can't update a site address if there is an order in progress. You must wait for the order to complete or
     * cancel the order.
     * </p>
     * <p>
     * You can update the operating address before you place an order at the site, or after all Outposts that belong to
     * the site have been deactivated.
     * </p>
     *
     * @param updateSiteAddressRequest
     * @return A Java Future containing the result of the UpdateSiteAddress operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>AccessDeniedException You do not have permission to perform this operation.</li>
     *         <li>NotFoundException The specified request is not valid.</li>
     *         <li>ConflictException Updating or deleting this resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An internal error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OutpostsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OutpostsAsyncClient.UpdateSiteAddress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/UpdateSiteAddress" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateSiteAddressResponse> updateSiteAddress(UpdateSiteAddressRequest updateSiteAddressRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the address of the specified site.
     * </p>
     * <p>
     * You can't update a site address if there is an order in progress. You must wait for the order to complete or
     * cancel the order.
     * </p>
     * <p>
     * You can update the operating address before you place an order at the site, or after all Outposts that belong to
     * the site have been deactivated.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSiteAddressRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateSiteAddressRequest#builder()}
     * </p>
     *
     * @param updateSiteAddressRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.outposts.model.UpdateSiteAddressRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateSiteAddress operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>AccessDeniedException You do not have permission to perform this operation.</li>
     *         <li>NotFoundException The specified request is not valid.</li>
     *         <li>ConflictException Updating or deleting this resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An internal error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OutpostsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OutpostsAsyncClient.UpdateSiteAddress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/UpdateSiteAddress" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateSiteAddressResponse> updateSiteAddress(
            Consumer<UpdateSiteAddressRequest.Builder> updateSiteAddressRequest) {
        return updateSiteAddress(UpdateSiteAddressRequest.builder().applyMutation(updateSiteAddressRequest).build());
    }

    /**
     * <p>
     * Update the physical and logistical details for a rack at a site. For more information about hardware requirements
     * for racks, see <a
     * href="https://docs.aws.amazon.com/outposts/latest/userguide/outposts-requirements.html#checklist">Network
     * readiness checklist</a> in the Amazon Web Services Outposts User Guide.
     * </p>
     * <p>
     * To update a rack at a site with an order of <code>IN_PROGRESS</code>, you must wait for the order to complete or
     * cancel the order.
     * </p>
     *
     * @param updateSiteRackPhysicalPropertiesRequest
     * @return A Java Future containing the result of the UpdateSiteRackPhysicalProperties operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>ConflictException Updating or deleting this resource can cause an inconsistent state.</li>
     *         <li>NotFoundException The specified request is not valid.</li>
     *         <li>AccessDeniedException You do not have permission to perform this operation.</li>
     *         <li>InternalServerException An internal error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OutpostsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OutpostsAsyncClient.UpdateSiteRackPhysicalProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/UpdateSiteRackPhysicalProperties"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateSiteRackPhysicalPropertiesResponse> updateSiteRackPhysicalProperties(
            UpdateSiteRackPhysicalPropertiesRequest updateSiteRackPhysicalPropertiesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update the physical and logistical details for a rack at a site. For more information about hardware requirements
     * for racks, see <a
     * href="https://docs.aws.amazon.com/outposts/latest/userguide/outposts-requirements.html#checklist">Network
     * readiness checklist</a> in the Amazon Web Services Outposts User Guide.
     * </p>
     * <p>
     * To update a rack at a site with an order of <code>IN_PROGRESS</code>, you must wait for the order to complete or
     * cancel the order.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSiteRackPhysicalPropertiesRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateSiteRackPhysicalPropertiesRequest#builder()}
     * </p>
     *
     * @param updateSiteRackPhysicalPropertiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.outposts.model.UpdateSiteRackPhysicalPropertiesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateSiteRackPhysicalProperties operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException A parameter is not valid.</li>
     *         <li>ConflictException Updating or deleting this resource can cause an inconsistent state.</li>
     *         <li>NotFoundException The specified request is not valid.</li>
     *         <li>AccessDeniedException You do not have permission to perform this operation.</li>
     *         <li>InternalServerException An internal error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OutpostsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OutpostsAsyncClient.UpdateSiteRackPhysicalProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/UpdateSiteRackPhysicalProperties"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateSiteRackPhysicalPropertiesResponse> updateSiteRackPhysicalProperties(
            Consumer<UpdateSiteRackPhysicalPropertiesRequest.Builder> updateSiteRackPhysicalPropertiesRequest) {
        return updateSiteRackPhysicalProperties(UpdateSiteRackPhysicalPropertiesRequest.builder()
                .applyMutation(updateSiteRackPhysicalPropertiesRequest).build());
    }

    @Override
    default OutpostsServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link OutpostsAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static OutpostsAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link OutpostsAsyncClient}.
     */
    static OutpostsAsyncClientBuilder builder() {
        return new DefaultOutpostsAsyncClientBuilder();
    }
}
