/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.outposts.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCatalogItemsRequest extends OutpostsRequest implements
        ToCopyableBuilder<ListCatalogItemsRequest.Builder, ListCatalogItemsRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListCatalogItemsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListCatalogItemsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxResults").build()).build();

    private static final SdkField<List<String>> ITEM_CLASS_FILTER_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ItemClassFilter")
            .getter(getter(ListCatalogItemsRequest::itemClassFilterAsStrings))
            .setter(setter(Builder::itemClassFilterWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("ItemClassFilter").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SUPPORTED_STORAGE_FILTER_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SupportedStorageFilter")
            .getter(getter(ListCatalogItemsRequest::supportedStorageFilterAsStrings))
            .setter(setter(Builder::supportedStorageFilterWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("SupportedStorageFilter").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> EC2_FAMILY_FILTER_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("EC2FamilyFilter")
            .getter(getter(ListCatalogItemsRequest::ec2FamilyFilter))
            .setter(setter(Builder::ec2FamilyFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("EC2FamilyFilter").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            MAX_RESULTS_FIELD, ITEM_CLASS_FILTER_FIELD, SUPPORTED_STORAGE_FILTER_FIELD, EC2_FAMILY_FILTER_FIELD));

    private final String nextToken;

    private final Integer maxResults;

    private final List<String> itemClassFilter;

    private final List<String> supportedStorageFilter;

    private final List<String> ec2FamilyFilter;

    private ListCatalogItemsRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.itemClassFilter = builder.itemClassFilter;
        this.supportedStorageFilter = builder.supportedStorageFilter;
        this.ec2FamilyFilter = builder.ec2FamilyFilter;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * Returns the value of the MaxResults property for this object.
     * 
     * @return The value of the MaxResults property for this object.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Filters the results by item class.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasItemClassFilter} method.
     * </p>
     * 
     * @return Filters the results by item class.
     */
    public final List<CatalogItemClass> itemClassFilter() {
        return CatalogItemClassListCopier.copyStringToEnum(itemClassFilter);
    }

    /**
     * For responses, this returns true if the service returned a value for the ItemClassFilter property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasItemClassFilter() {
        return itemClassFilter != null && !(itemClassFilter instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filters the results by item class.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasItemClassFilter} method.
     * </p>
     * 
     * @return Filters the results by item class.
     */
    public final List<String> itemClassFilterAsStrings() {
        return itemClassFilter;
    }

    /**
     * <p>
     * Filters the results by storage option.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedStorageFilter} method.
     * </p>
     * 
     * @return Filters the results by storage option.
     */
    public final List<SupportedStorageEnum> supportedStorageFilter() {
        return SupportedStorageListCopier.copyStringToEnum(supportedStorageFilter);
    }

    /**
     * For responses, this returns true if the service returned a value for the SupportedStorageFilter property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSupportedStorageFilter() {
        return supportedStorageFilter != null && !(supportedStorageFilter instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filters the results by storage option.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedStorageFilter} method.
     * </p>
     * 
     * @return Filters the results by storage option.
     */
    public final List<String> supportedStorageFilterAsStrings() {
        return supportedStorageFilter;
    }

    /**
     * For responses, this returns true if the service returned a value for the EC2FamilyFilter property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEc2FamilyFilter() {
        return ec2FamilyFilter != null && !(ec2FamilyFilter instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filters the results by EC2 family (for example, M5).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEc2FamilyFilter} method.
     * </p>
     * 
     * @return Filters the results by EC2 family (for example, M5).
     */
    public final List<String> ec2FamilyFilter() {
        return ec2FamilyFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(hasItemClassFilter() ? itemClassFilterAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSupportedStorageFilter() ? supportedStorageFilterAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEc2FamilyFilter() ? ec2FamilyFilter() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCatalogItemsRequest)) {
            return false;
        }
        ListCatalogItemsRequest other = (ListCatalogItemsRequest) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && hasItemClassFilter() == other.hasItemClassFilter()
                && Objects.equals(itemClassFilterAsStrings(), other.itemClassFilterAsStrings())
                && hasSupportedStorageFilter() == other.hasSupportedStorageFilter()
                && Objects.equals(supportedStorageFilterAsStrings(), other.supportedStorageFilterAsStrings())
                && hasEc2FamilyFilter() == other.hasEc2FamilyFilter()
                && Objects.equals(ec2FamilyFilter(), other.ec2FamilyFilter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCatalogItemsRequest").add("NextToken", nextToken()).add("MaxResults", maxResults())
                .add("ItemClassFilter", hasItemClassFilter() ? itemClassFilterAsStrings() : null)
                .add("SupportedStorageFilter", hasSupportedStorageFilter() ? supportedStorageFilterAsStrings() : null)
                .add("EC2FamilyFilter", hasEc2FamilyFilter() ? ec2FamilyFilter() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "ItemClassFilter":
            return Optional.ofNullable(clazz.cast(itemClassFilterAsStrings()));
        case "SupportedStorageFilter":
            return Optional.ofNullable(clazz.cast(supportedStorageFilterAsStrings()));
        case "EC2FamilyFilter":
            return Optional.ofNullable(clazz.cast(ec2FamilyFilter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCatalogItemsRequest, T> g) {
        return obj -> g.apply((ListCatalogItemsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OutpostsRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListCatalogItemsRequest> {
        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * Sets the value of the MaxResults property for this object.
         *
         * @param maxResults
         *        The new value for the MaxResults property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Filters the results by item class.
         * </p>
         * 
         * @param itemClassFilter
         *        Filters the results by item class.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder itemClassFilterWithStrings(Collection<String> itemClassFilter);

        /**
         * <p>
         * Filters the results by item class.
         * </p>
         * 
         * @param itemClassFilter
         *        Filters the results by item class.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder itemClassFilterWithStrings(String... itemClassFilter);

        /**
         * <p>
         * Filters the results by item class.
         * </p>
         * 
         * @param itemClassFilter
         *        Filters the results by item class.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder itemClassFilter(Collection<CatalogItemClass> itemClassFilter);

        /**
         * <p>
         * Filters the results by item class.
         * </p>
         * 
         * @param itemClassFilter
         *        Filters the results by item class.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder itemClassFilter(CatalogItemClass... itemClassFilter);

        /**
         * <p>
         * Filters the results by storage option.
         * </p>
         * 
         * @param supportedStorageFilter
         *        Filters the results by storage option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedStorageFilterWithStrings(Collection<String> supportedStorageFilter);

        /**
         * <p>
         * Filters the results by storage option.
         * </p>
         * 
         * @param supportedStorageFilter
         *        Filters the results by storage option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedStorageFilterWithStrings(String... supportedStorageFilter);

        /**
         * <p>
         * Filters the results by storage option.
         * </p>
         * 
         * @param supportedStorageFilter
         *        Filters the results by storage option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedStorageFilter(Collection<SupportedStorageEnum> supportedStorageFilter);

        /**
         * <p>
         * Filters the results by storage option.
         * </p>
         * 
         * @param supportedStorageFilter
         *        Filters the results by storage option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedStorageFilter(SupportedStorageEnum... supportedStorageFilter);

        /**
         * <p>
         * Filters the results by EC2 family (for example, M5).
         * </p>
         * 
         * @param ec2FamilyFilter
         *        Filters the results by EC2 family (for example, M5).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2FamilyFilter(Collection<String> ec2FamilyFilter);

        /**
         * <p>
         * Filters the results by EC2 family (for example, M5).
         * </p>
         * 
         * @param ec2FamilyFilter
         *        Filters the results by EC2 family (for example, M5).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2FamilyFilter(String... ec2FamilyFilter);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OutpostsRequest.BuilderImpl implements Builder {
        private String nextToken;

        private Integer maxResults;

        private List<String> itemClassFilter = DefaultSdkAutoConstructList.getInstance();

        private List<String> supportedStorageFilter = DefaultSdkAutoConstructList.getInstance();

        private List<String> ec2FamilyFilter = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListCatalogItemsRequest model) {
            super(model);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            itemClassFilterWithStrings(model.itemClassFilter);
            supportedStorageFilterWithStrings(model.supportedStorageFilter);
            ec2FamilyFilter(model.ec2FamilyFilter);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Collection<String> getItemClassFilter() {
            if (itemClassFilter instanceof SdkAutoConstructList) {
                return null;
            }
            return itemClassFilter;
        }

        public final void setItemClassFilter(Collection<String> itemClassFilter) {
            this.itemClassFilter = CatalogItemClassListCopier.copy(itemClassFilter);
        }

        @Override
        public final Builder itemClassFilterWithStrings(Collection<String> itemClassFilter) {
            this.itemClassFilter = CatalogItemClassListCopier.copy(itemClassFilter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder itemClassFilterWithStrings(String... itemClassFilter) {
            itemClassFilterWithStrings(Arrays.asList(itemClassFilter));
            return this;
        }

        @Override
        public final Builder itemClassFilter(Collection<CatalogItemClass> itemClassFilter) {
            this.itemClassFilter = CatalogItemClassListCopier.copyEnumToString(itemClassFilter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder itemClassFilter(CatalogItemClass... itemClassFilter) {
            itemClassFilter(Arrays.asList(itemClassFilter));
            return this;
        }

        public final Collection<String> getSupportedStorageFilter() {
            if (supportedStorageFilter instanceof SdkAutoConstructList) {
                return null;
            }
            return supportedStorageFilter;
        }

        public final void setSupportedStorageFilter(Collection<String> supportedStorageFilter) {
            this.supportedStorageFilter = SupportedStorageListCopier.copy(supportedStorageFilter);
        }

        @Override
        public final Builder supportedStorageFilterWithStrings(Collection<String> supportedStorageFilter) {
            this.supportedStorageFilter = SupportedStorageListCopier.copy(supportedStorageFilter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedStorageFilterWithStrings(String... supportedStorageFilter) {
            supportedStorageFilterWithStrings(Arrays.asList(supportedStorageFilter));
            return this;
        }

        @Override
        public final Builder supportedStorageFilter(Collection<SupportedStorageEnum> supportedStorageFilter) {
            this.supportedStorageFilter = SupportedStorageListCopier.copyEnumToString(supportedStorageFilter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedStorageFilter(SupportedStorageEnum... supportedStorageFilter) {
            supportedStorageFilter(Arrays.asList(supportedStorageFilter));
            return this;
        }

        public final Collection<String> getEc2FamilyFilter() {
            if (ec2FamilyFilter instanceof SdkAutoConstructList) {
                return null;
            }
            return ec2FamilyFilter;
        }

        public final void setEc2FamilyFilter(Collection<String> ec2FamilyFilter) {
            this.ec2FamilyFilter = EC2FamilyListCopier.copy(ec2FamilyFilter);
        }

        @Override
        public final Builder ec2FamilyFilter(Collection<String> ec2FamilyFilter) {
            this.ec2FamilyFilter = EC2FamilyListCopier.copy(ec2FamilyFilter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2FamilyFilter(String... ec2FamilyFilter) {
            ec2FamilyFilter(Arrays.asList(ec2FamilyFilter));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListCatalogItemsRequest build() {
            return new ListCatalogItemsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
