/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.outposts.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.outposts.OutpostsClient;
import software.amazon.awssdk.services.outposts.internal.UserAgentUtils;
import software.amazon.awssdk.services.outposts.model.ListSitesRequest;
import software.amazon.awssdk.services.outposts.model.ListSitesResponse;
import software.amazon.awssdk.services.outposts.model.Site;

public class ListSitesIterable
implements SdkIterable<ListSitesResponse> {
    private final OutpostsClient client;
    private final ListSitesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSitesIterable(OutpostsClient client, ListSitesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSitesResponseFetcher();
    }

    public Iterator<ListSitesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Site> sites() {
        Function<ListSitesResponse, Iterator> getIterator = response -> {
            if (response != null && response.sites() != null) {
                return response.sites().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSitesResponseFetcher
    implements SyncPageFetcher<ListSitesResponse> {
        private ListSitesResponseFetcher() {
        }

        public boolean hasNextPage(ListSitesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSitesResponse nextPage(ListSitesResponse previousPage) {
            if (previousPage == null) {
                return ListSitesIterable.this.client.listSites(ListSitesIterable.this.firstRequest);
            }
            return ListSitesIterable.this.client.listSites((ListSitesRequest)((Object)ListSitesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

