/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.outposts.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.outposts.OutpostsClient;
import software.amazon.awssdk.services.outposts.internal.UserAgentUtils;
import software.amazon.awssdk.services.outposts.model.ListOutpostsRequest;
import software.amazon.awssdk.services.outposts.model.ListOutpostsResponse;
import software.amazon.awssdk.services.outposts.model.Outpost;

public class ListOutpostsIterable
implements SdkIterable<ListOutpostsResponse> {
    private final OutpostsClient client;
    private final ListOutpostsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListOutpostsIterable(OutpostsClient client, ListOutpostsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListOutpostsResponseFetcher();
    }

    public Iterator<ListOutpostsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Outpost> outposts() {
        Function<ListOutpostsResponse, Iterator> getIterator = response -> {
            if (response != null && response.outposts() != null) {
                return response.outposts().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListOutpostsResponseFetcher
    implements SyncPageFetcher<ListOutpostsResponse> {
        private ListOutpostsResponseFetcher() {
        }

        public boolean hasNextPage(ListOutpostsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListOutpostsResponse nextPage(ListOutpostsResponse previousPage) {
            if (previousPage == null) {
                return ListOutpostsIterable.this.client.listOutposts(ListOutpostsIterable.this.firstRequest);
            }
            return ListOutpostsIterable.this.client.listOutposts((ListOutpostsRequest)((Object)ListOutpostsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

