/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.outposts.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.outposts.OutpostsClient;
import software.amazon.awssdk.services.outposts.internal.UserAgentUtils;
import software.amazon.awssdk.services.outposts.model.ListOrdersRequest;
import software.amazon.awssdk.services.outposts.model.ListOrdersResponse;
import software.amazon.awssdk.services.outposts.model.OrderSummary;

public class ListOrdersIterable
implements SdkIterable<ListOrdersResponse> {
    private final OutpostsClient client;
    private final ListOrdersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListOrdersIterable(OutpostsClient client, ListOrdersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListOrdersResponseFetcher();
    }

    public Iterator<ListOrdersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<OrderSummary> orders() {
        Function<ListOrdersResponse, Iterator> getIterator = response -> {
            if (response != null && response.orders() != null) {
                return response.orders().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListOrdersResponseFetcher
    implements SyncPageFetcher<ListOrdersResponse> {
        private ListOrdersResponseFetcher() {
        }

        public boolean hasNextPage(ListOrdersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListOrdersResponse nextPage(ListOrdersResponse previousPage) {
            if (previousPage == null) {
                return ListOrdersIterable.this.client.listOrders(ListOrdersIterable.this.firstRequest);
            }
            return ListOrdersIterable.this.client.listOrders((ListOrdersRequest)((Object)ListOrdersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

