/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.outposts.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a line item.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LineItem implements SdkPojo, Serializable, ToCopyableBuilder<LineItem.Builder, LineItem> {
    private static final SdkField<String> CATALOG_ITEM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CatalogItemId").getter(getter(LineItem::catalogItemId)).setter(setter(Builder::catalogItemId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogItemId").build()).build();

    private static final SdkField<String> LINE_ITEM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LineItemId").getter(getter(LineItem::lineItemId)).setter(setter(Builder::lineItemId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LineItemId").build()).build();

    private static final SdkField<Integer> QUANTITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Quantity").getter(getter(LineItem::quantity)).setter(setter(Builder::quantity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Quantity").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(LineItem::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<ShipmentInformation> SHIPMENT_INFORMATION_FIELD = SdkField
            .<ShipmentInformation> builder(MarshallingType.SDK_POJO).memberName("ShipmentInformation")
            .getter(getter(LineItem::shipmentInformation)).setter(setter(Builder::shipmentInformation))
            .constructor(ShipmentInformation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShipmentInformation").build())
            .build();

    private static final SdkField<List<LineItemAssetInformation>> ASSET_INFORMATION_LIST_FIELD = SdkField
            .<List<LineItemAssetInformation>> builder(MarshallingType.LIST)
            .memberName("AssetInformationList")
            .getter(getter(LineItem::assetInformationList))
            .setter(setter(Builder::assetInformationList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssetInformationList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LineItemAssetInformation> builder(MarshallingType.SDK_POJO)
                                            .constructor(LineItemAssetInformation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PREVIOUS_LINE_ITEM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PreviousLineItemId").getter(getter(LineItem::previousLineItemId))
            .setter(setter(Builder::previousLineItemId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreviousLineItemId").build())
            .build();

    private static final SdkField<String> PREVIOUS_ORDER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PreviousOrderId").getter(getter(LineItem::previousOrderId)).setter(setter(Builder::previousOrderId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreviousOrderId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ITEM_ID_FIELD,
            LINE_ITEM_ID_FIELD, QUANTITY_FIELD, STATUS_FIELD, SHIPMENT_INFORMATION_FIELD, ASSET_INFORMATION_LIST_FIELD,
            PREVIOUS_LINE_ITEM_ID_FIELD, PREVIOUS_ORDER_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String catalogItemId;

    private final String lineItemId;

    private final Integer quantity;

    private final String status;

    private final ShipmentInformation shipmentInformation;

    private final List<LineItemAssetInformation> assetInformationList;

    private final String previousLineItemId;

    private final String previousOrderId;

    private LineItem(BuilderImpl builder) {
        this.catalogItemId = builder.catalogItemId;
        this.lineItemId = builder.lineItemId;
        this.quantity = builder.quantity;
        this.status = builder.status;
        this.shipmentInformation = builder.shipmentInformation;
        this.assetInformationList = builder.assetInformationList;
        this.previousLineItemId = builder.previousLineItemId;
        this.previousOrderId = builder.previousOrderId;
    }

    /**
     * <p>
     * The ID of the catalog item.
     * </p>
     * 
     * @return The ID of the catalog item.
     */
    public final String catalogItemId() {
        return catalogItemId;
    }

    /**
     * <p>
     * The ID of the line item.
     * </p>
     * 
     * @return The ID of the line item.
     */
    public final String lineItemId() {
        return lineItemId;
    }

    /**
     * <p>
     * The quantity of the line item.
     * </p>
     * 
     * @return The quantity of the line item.
     */
    public final Integer quantity() {
        return quantity;
    }

    /**
     * <p>
     * The status of the line item.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link LineItemStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the line item.
     * @see LineItemStatus
     */
    public final LineItemStatus status() {
        return LineItemStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the line item.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link LineItemStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the line item.
     * @see LineItemStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Information about a line item shipment.
     * </p>
     * 
     * @return Information about a line item shipment.
     */
    public final ShipmentInformation shipmentInformation() {
        return shipmentInformation;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssetInformationList property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAssetInformationList() {
        return assetInformationList != null && !(assetInformationList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about assets.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssetInformationList} method.
     * </p>
     * 
     * @return Information about assets.
     */
    public final List<LineItemAssetInformation> assetInformationList() {
        return assetInformationList;
    }

    /**
     * <p>
     * The ID of the previous line item.
     * </p>
     * 
     * @return The ID of the previous line item.
     */
    public final String previousLineItemId() {
        return previousLineItemId;
    }

    /**
     * <p>
     * The ID of the previous order item.
     * </p>
     * 
     * @return The ID of the previous order item.
     */
    public final String previousOrderId() {
        return previousOrderId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(catalogItemId());
        hashCode = 31 * hashCode + Objects.hashCode(lineItemId());
        hashCode = 31 * hashCode + Objects.hashCode(quantity());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(shipmentInformation());
        hashCode = 31 * hashCode + Objects.hashCode(hasAssetInformationList() ? assetInformationList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(previousLineItemId());
        hashCode = 31 * hashCode + Objects.hashCode(previousOrderId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LineItem)) {
            return false;
        }
        LineItem other = (LineItem) obj;
        return Objects.equals(catalogItemId(), other.catalogItemId()) && Objects.equals(lineItemId(), other.lineItemId())
                && Objects.equals(quantity(), other.quantity()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(shipmentInformation(), other.shipmentInformation())
                && hasAssetInformationList() == other.hasAssetInformationList()
                && Objects.equals(assetInformationList(), other.assetInformationList())
                && Objects.equals(previousLineItemId(), other.previousLineItemId())
                && Objects.equals(previousOrderId(), other.previousOrderId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LineItem").add("CatalogItemId", catalogItemId()).add("LineItemId", lineItemId())
                .add("Quantity", quantity()).add("Status", statusAsString()).add("ShipmentInformation", shipmentInformation())
                .add("AssetInformationList", hasAssetInformationList() ? assetInformationList() : null)
                .add("PreviousLineItemId", previousLineItemId()).add("PreviousOrderId", previousOrderId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CatalogItemId":
            return Optional.ofNullable(clazz.cast(catalogItemId()));
        case "LineItemId":
            return Optional.ofNullable(clazz.cast(lineItemId()));
        case "Quantity":
            return Optional.ofNullable(clazz.cast(quantity()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "ShipmentInformation":
            return Optional.ofNullable(clazz.cast(shipmentInformation()));
        case "AssetInformationList":
            return Optional.ofNullable(clazz.cast(assetInformationList()));
        case "PreviousLineItemId":
            return Optional.ofNullable(clazz.cast(previousLineItemId()));
        case "PreviousOrderId":
            return Optional.ofNullable(clazz.cast(previousOrderId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LineItem, T> g) {
        return obj -> g.apply((LineItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LineItem> {
        /**
         * <p>
         * The ID of the catalog item.
         * </p>
         * 
         * @param catalogItemId
         *        The ID of the catalog item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogItemId(String catalogItemId);

        /**
         * <p>
         * The ID of the line item.
         * </p>
         * 
         * @param lineItemId
         *        The ID of the line item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lineItemId(String lineItemId);

        /**
         * <p>
         * The quantity of the line item.
         * </p>
         * 
         * @param quantity
         *        The quantity of the line item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quantity(Integer quantity);

        /**
         * <p>
         * The status of the line item.
         * </p>
         * 
         * @param status
         *        The status of the line item.
         * @see LineItemStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LineItemStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the line item.
         * </p>
         * 
         * @param status
         *        The status of the line item.
         * @see LineItemStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LineItemStatus
         */
        Builder status(LineItemStatus status);

        /**
         * <p>
         * Information about a line item shipment.
         * </p>
         * 
         * @param shipmentInformation
         *        Information about a line item shipment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shipmentInformation(ShipmentInformation shipmentInformation);

        /**
         * <p>
         * Information about a line item shipment.
         * </p>
         * This is a convenience method that creates an instance of the {@link ShipmentInformation.Builder} avoiding the
         * need to create one manually via {@link ShipmentInformation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ShipmentInformation.Builder#build()} is called immediately and
         * its result is passed to {@link #shipmentInformation(ShipmentInformation)}.
         * 
         * @param shipmentInformation
         *        a consumer that will call methods on {@link ShipmentInformation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #shipmentInformation(ShipmentInformation)
         */
        default Builder shipmentInformation(Consumer<ShipmentInformation.Builder> shipmentInformation) {
            return shipmentInformation(ShipmentInformation.builder().applyMutation(shipmentInformation).build());
        }

        /**
         * <p>
         * Information about assets.
         * </p>
         * 
         * @param assetInformationList
         *        Information about assets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetInformationList(Collection<LineItemAssetInformation> assetInformationList);

        /**
         * <p>
         * Information about assets.
         * </p>
         * 
         * @param assetInformationList
         *        Information about assets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetInformationList(LineItemAssetInformation... assetInformationList);

        /**
         * <p>
         * Information about assets.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.outposts.model.LineItemAssetInformation.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.outposts.model.LineItemAssetInformation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.outposts.model.LineItemAssetInformation.Builder#build()} is called
         * immediately and its result is passed to {@link #assetInformationList(List<LineItemAssetInformation>)}.
         * 
         * @param assetInformationList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.outposts.model.LineItemAssetInformation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assetInformationList(java.util.Collection<LineItemAssetInformation>)
         */
        Builder assetInformationList(Consumer<LineItemAssetInformation.Builder>... assetInformationList);

        /**
         * <p>
         * The ID of the previous line item.
         * </p>
         * 
         * @param previousLineItemId
         *        The ID of the previous line item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder previousLineItemId(String previousLineItemId);

        /**
         * <p>
         * The ID of the previous order item.
         * </p>
         * 
         * @param previousOrderId
         *        The ID of the previous order item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder previousOrderId(String previousOrderId);
    }

    static final class BuilderImpl implements Builder {
        private String catalogItemId;

        private String lineItemId;

        private Integer quantity;

        private String status;

        private ShipmentInformation shipmentInformation;

        private List<LineItemAssetInformation> assetInformationList = DefaultSdkAutoConstructList.getInstance();

        private String previousLineItemId;

        private String previousOrderId;

        private BuilderImpl() {
        }

        private BuilderImpl(LineItem model) {
            catalogItemId(model.catalogItemId);
            lineItemId(model.lineItemId);
            quantity(model.quantity);
            status(model.status);
            shipmentInformation(model.shipmentInformation);
            assetInformationList(model.assetInformationList);
            previousLineItemId(model.previousLineItemId);
            previousOrderId(model.previousOrderId);
        }

        public final String getCatalogItemId() {
            return catalogItemId;
        }

        public final void setCatalogItemId(String catalogItemId) {
            this.catalogItemId = catalogItemId;
        }

        @Override
        public final Builder catalogItemId(String catalogItemId) {
            this.catalogItemId = catalogItemId;
            return this;
        }

        public final String getLineItemId() {
            return lineItemId;
        }

        public final void setLineItemId(String lineItemId) {
            this.lineItemId = lineItemId;
        }

        @Override
        public final Builder lineItemId(String lineItemId) {
            this.lineItemId = lineItemId;
            return this;
        }

        public final Integer getQuantity() {
            return quantity;
        }

        public final void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }

        @Override
        public final Builder quantity(Integer quantity) {
            this.quantity = quantity;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(LineItemStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final ShipmentInformation.Builder getShipmentInformation() {
            return shipmentInformation != null ? shipmentInformation.toBuilder() : null;
        }

        public final void setShipmentInformation(ShipmentInformation.BuilderImpl shipmentInformation) {
            this.shipmentInformation = shipmentInformation != null ? shipmentInformation.build() : null;
        }

        @Override
        public final Builder shipmentInformation(ShipmentInformation shipmentInformation) {
            this.shipmentInformation = shipmentInformation;
            return this;
        }

        public final List<LineItemAssetInformation.Builder> getAssetInformationList() {
            List<LineItemAssetInformation.Builder> result = LineItemAssetInformationListCopier
                    .copyToBuilder(this.assetInformationList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssetInformationList(Collection<LineItemAssetInformation.BuilderImpl> assetInformationList) {
            this.assetInformationList = LineItemAssetInformationListCopier.copyFromBuilder(assetInformationList);
        }

        @Override
        public final Builder assetInformationList(Collection<LineItemAssetInformation> assetInformationList) {
            this.assetInformationList = LineItemAssetInformationListCopier.copy(assetInformationList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetInformationList(LineItemAssetInformation... assetInformationList) {
            assetInformationList(Arrays.asList(assetInformationList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetInformationList(Consumer<LineItemAssetInformation.Builder>... assetInformationList) {
            assetInformationList(Stream.of(assetInformationList)
                    .map(c -> LineItemAssetInformation.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getPreviousLineItemId() {
            return previousLineItemId;
        }

        public final void setPreviousLineItemId(String previousLineItemId) {
            this.previousLineItemId = previousLineItemId;
        }

        @Override
        public final Builder previousLineItemId(String previousLineItemId) {
            this.previousLineItemId = previousLineItemId;
            return this;
        }

        public final String getPreviousOrderId() {
            return previousOrderId;
        }

        public final void setPreviousOrderId(String previousOrderId) {
            this.previousOrderId = previousOrderId;
        }

        @Override
        public final Builder previousOrderId(String previousOrderId) {
            this.previousOrderId = previousOrderId;
            return this;
        }

        @Override
        public LineItem build() {
            return new LineItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
