/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.outposts.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum OrderType {
    OUTPOST("OUTPOST"),
    REPLACEMENT("REPLACEMENT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, OrderType> VALUE_MAP;
    private final String value;

    private OrderType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OrderType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<OrderType> knownValues() {
        EnumSet<OrderType> knownValues = EnumSet.allOf(OrderType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(OrderType.class, OrderType::toString);
    }
}

