/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.outposts.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a line item.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LineItem implements SdkPojo, Serializable, ToCopyableBuilder<LineItem.Builder, LineItem> {
    private static final SdkField<String> CATALOG_ITEM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CatalogItemId").getter(getter(LineItem::catalogItemId)).setter(setter(Builder::catalogItemId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogItemId").build()).build();

    private static final SdkField<String> LINE_ITEM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LineItemId").getter(getter(LineItem::lineItemId)).setter(setter(Builder::lineItemId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LineItemId").build()).build();

    private static final SdkField<Integer> QUANTITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Quantity").getter(getter(LineItem::quantity)).setter(setter(Builder::quantity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Quantity").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(LineItem::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ITEM_ID_FIELD,
            LINE_ITEM_ID_FIELD, QUANTITY_FIELD, STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String catalogItemId;

    private final String lineItemId;

    private final Integer quantity;

    private final String status;

    private LineItem(BuilderImpl builder) {
        this.catalogItemId = builder.catalogItemId;
        this.lineItemId = builder.lineItemId;
        this.quantity = builder.quantity;
        this.status = builder.status;
    }

    /**
     * <p>
     * The ID of the catalog item.
     * </p>
     * 
     * @return The ID of the catalog item.
     */
    public final String catalogItemId() {
        return catalogItemId;
    }

    /**
     * <p>
     * The ID of the line item.
     * </p>
     * 
     * @return The ID of the line item.
     */
    public final String lineItemId() {
        return lineItemId;
    }

    /**
     * <p>
     * The quantity of the line item.
     * </p>
     * 
     * @return The quantity of the line item.
     */
    public final Integer quantity() {
        return quantity;
    }

    /**
     * <p>
     * The status of the line item.
     * </p>
     * 
     * @return The status of the line item.
     */
    public final String status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(catalogItemId());
        hashCode = 31 * hashCode + Objects.hashCode(lineItemId());
        hashCode = 31 * hashCode + Objects.hashCode(quantity());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LineItem)) {
            return false;
        }
        LineItem other = (LineItem) obj;
        return Objects.equals(catalogItemId(), other.catalogItemId()) && Objects.equals(lineItemId(), other.lineItemId())
                && Objects.equals(quantity(), other.quantity()) && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LineItem").add("CatalogItemId", catalogItemId()).add("LineItemId", lineItemId())
                .add("Quantity", quantity()).add("Status", status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CatalogItemId":
            return Optional.ofNullable(clazz.cast(catalogItemId()));
        case "LineItemId":
            return Optional.ofNullable(clazz.cast(lineItemId()));
        case "Quantity":
            return Optional.ofNullable(clazz.cast(quantity()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LineItem, T> g) {
        return obj -> g.apply((LineItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LineItem> {
        /**
         * <p>
         * The ID of the catalog item.
         * </p>
         * 
         * @param catalogItemId
         *        The ID of the catalog item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogItemId(String catalogItemId);

        /**
         * <p>
         * The ID of the line item.
         * </p>
         * 
         * @param lineItemId
         *        The ID of the line item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lineItemId(String lineItemId);

        /**
         * <p>
         * The quantity of the line item.
         * </p>
         * 
         * @param quantity
         *        The quantity of the line item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quantity(Integer quantity);

        /**
         * <p>
         * The status of the line item.
         * </p>
         * 
         * @param status
         *        The status of the line item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);
    }

    static final class BuilderImpl implements Builder {
        private String catalogItemId;

        private String lineItemId;

        private Integer quantity;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(LineItem model) {
            catalogItemId(model.catalogItemId);
            lineItemId(model.lineItemId);
            quantity(model.quantity);
            status(model.status);
        }

        public final String getCatalogItemId() {
            return catalogItemId;
        }

        public final void setCatalogItemId(String catalogItemId) {
            this.catalogItemId = catalogItemId;
        }

        @Override
        @Transient
        public final Builder catalogItemId(String catalogItemId) {
            this.catalogItemId = catalogItemId;
            return this;
        }

        public final String getLineItemId() {
            return lineItemId;
        }

        public final void setLineItemId(String lineItemId) {
            this.lineItemId = lineItemId;
        }

        @Override
        @Transient
        public final Builder lineItemId(String lineItemId) {
            this.lineItemId = lineItemId;
            return this;
        }

        public final Integer getQuantity() {
            return quantity;
        }

        public final void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }

        @Override
        @Transient
        public final Builder quantity(Integer quantity) {
            this.quantity = quantity;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public LineItem build() {
            return new LineItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
