/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.outposts.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum PaymentOption {
    ALL_UPFRONT("ALL_UPFRONT"),
    NO_UPFRONT("NO_UPFRONT"),
    PARTIAL_UPFRONT("PARTIAL_UPFRONT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private PaymentOption(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PaymentOption fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(PaymentOption.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PaymentOption> knownValues() {
        return Stream.of(PaymentOption.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

