/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.outposts.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateOrderRequest extends OutpostsRequest implements
        ToCopyableBuilder<CreateOrderRequest.Builder, CreateOrderRequest> {
    private static final SdkField<String> OUTPOST_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutpostIdentifier").getter(getter(CreateOrderRequest::outpostIdentifier))
            .setter(setter(Builder::outpostIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutpostIdentifier").build()).build();

    private static final SdkField<List<LineItemRequest>> LINE_ITEMS_FIELD = SdkField
            .<List<LineItemRequest>> builder(MarshallingType.LIST)
            .memberName("LineItems")
            .getter(getter(CreateOrderRequest::lineItems))
            .setter(setter(Builder::lineItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LineItems").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LineItemRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(LineItemRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PAYMENT_OPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PaymentOption").getter(getter(CreateOrderRequest::paymentOptionAsString))
            .setter(setter(Builder::paymentOption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PaymentOption").build()).build();

    private static final SdkField<String> PAYMENT_TERM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PaymentTerm").getter(getter(CreateOrderRequest::paymentTermAsString))
            .setter(setter(Builder::paymentTerm))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PaymentTerm").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPOST_IDENTIFIER_FIELD,
            LINE_ITEMS_FIELD, PAYMENT_OPTION_FIELD, PAYMENT_TERM_FIELD));

    private final String outpostIdentifier;

    private final List<LineItemRequest> lineItems;

    private final String paymentOption;

    private final String paymentTerm;

    private CreateOrderRequest(BuilderImpl builder) {
        super(builder);
        this.outpostIdentifier = builder.outpostIdentifier;
        this.lineItems = builder.lineItems;
        this.paymentOption = builder.paymentOption;
        this.paymentTerm = builder.paymentTerm;
    }

    /**
     * <p>
     * The ID or the Amazon Resource Name (ARN) of the Outpost.
     * </p>
     * 
     * @return The ID or the Amazon Resource Name (ARN) of the Outpost.
     */
    public final String outpostIdentifier() {
        return outpostIdentifier;
    }

    /**
     * For responses, this returns true if the service returned a value for the LineItems property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasLineItems() {
        return lineItems != null && !(lineItems instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The line items that make up the order.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLineItems} method.
     * </p>
     * 
     * @return The line items that make up the order.
     */
    public final List<LineItemRequest> lineItems() {
        return lineItems;
    }

    /**
     * <p>
     * The payment option for the order.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #paymentOption}
     * will return {@link PaymentOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #paymentOptionAsString}.
     * </p>
     * 
     * @return The payment option for the order.
     * @see PaymentOption
     */
    public final PaymentOption paymentOption() {
        return PaymentOption.fromValue(paymentOption);
    }

    /**
     * <p>
     * The payment option for the order.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #paymentOption}
     * will return {@link PaymentOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #paymentOptionAsString}.
     * </p>
     * 
     * @return The payment option for the order.
     * @see PaymentOption
     */
    public final String paymentOptionAsString() {
        return paymentOption;
    }

    /**
     * <p>
     * The payment terms for the order.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #paymentTerm} will
     * return {@link PaymentTerm#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #paymentTermAsString}.
     * </p>
     * 
     * @return The payment terms for the order.
     * @see PaymentTerm
     */
    public final PaymentTerm paymentTerm() {
        return PaymentTerm.fromValue(paymentTerm);
    }

    /**
     * <p>
     * The payment terms for the order.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #paymentTerm} will
     * return {@link PaymentTerm#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #paymentTermAsString}.
     * </p>
     * 
     * @return The payment terms for the order.
     * @see PaymentTerm
     */
    public final String paymentTermAsString() {
        return paymentTerm;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(outpostIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(hasLineItems() ? lineItems() : null);
        hashCode = 31 * hashCode + Objects.hashCode(paymentOptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(paymentTermAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateOrderRequest)) {
            return false;
        }
        CreateOrderRequest other = (CreateOrderRequest) obj;
        return Objects.equals(outpostIdentifier(), other.outpostIdentifier()) && hasLineItems() == other.hasLineItems()
                && Objects.equals(lineItems(), other.lineItems())
                && Objects.equals(paymentOptionAsString(), other.paymentOptionAsString())
                && Objects.equals(paymentTermAsString(), other.paymentTermAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateOrderRequest").add("OutpostIdentifier", outpostIdentifier())
                .add("LineItems", hasLineItems() ? lineItems() : null).add("PaymentOption", paymentOptionAsString())
                .add("PaymentTerm", paymentTermAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OutpostIdentifier":
            return Optional.ofNullable(clazz.cast(outpostIdentifier()));
        case "LineItems":
            return Optional.ofNullable(clazz.cast(lineItems()));
        case "PaymentOption":
            return Optional.ofNullable(clazz.cast(paymentOptionAsString()));
        case "PaymentTerm":
            return Optional.ofNullable(clazz.cast(paymentTermAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateOrderRequest, T> g) {
        return obj -> g.apply((CreateOrderRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OutpostsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateOrderRequest> {
        /**
         * <p>
         * The ID or the Amazon Resource Name (ARN) of the Outpost.
         * </p>
         * 
         * @param outpostIdentifier
         *        The ID or the Amazon Resource Name (ARN) of the Outpost.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outpostIdentifier(String outpostIdentifier);

        /**
         * <p>
         * The line items that make up the order.
         * </p>
         * 
         * @param lineItems
         *        The line items that make up the order.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lineItems(Collection<LineItemRequest> lineItems);

        /**
         * <p>
         * The line items that make up the order.
         * </p>
         * 
         * @param lineItems
         *        The line items that make up the order.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lineItems(LineItemRequest... lineItems);

        /**
         * <p>
         * The line items that make up the order.
         * </p>
         * This is a convenience that creates an instance of the {@link List<LineItemRequest>.Builder} avoiding the need
         * to create one manually via {@link List<LineItemRequest>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LineItemRequest>.Builder#build()} is called immediately and
         * its result is passed to {@link #lineItems(List<LineItemRequest>)}.
         * 
         * @param lineItems
         *        a consumer that will call methods on {@link List<LineItemRequest>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lineItems(List<LineItemRequest>)
         */
        Builder lineItems(Consumer<LineItemRequest.Builder>... lineItems);

        /**
         * <p>
         * The payment option for the order.
         * </p>
         * 
         * @param paymentOption
         *        The payment option for the order.
         * @see PaymentOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PaymentOption
         */
        Builder paymentOption(String paymentOption);

        /**
         * <p>
         * The payment option for the order.
         * </p>
         * 
         * @param paymentOption
         *        The payment option for the order.
         * @see PaymentOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PaymentOption
         */
        Builder paymentOption(PaymentOption paymentOption);

        /**
         * <p>
         * The payment terms for the order.
         * </p>
         * 
         * @param paymentTerm
         *        The payment terms for the order.
         * @see PaymentTerm
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PaymentTerm
         */
        Builder paymentTerm(String paymentTerm);

        /**
         * <p>
         * The payment terms for the order.
         * </p>
         * 
         * @param paymentTerm
         *        The payment terms for the order.
         * @see PaymentTerm
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PaymentTerm
         */
        Builder paymentTerm(PaymentTerm paymentTerm);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OutpostsRequest.BuilderImpl implements Builder {
        private String outpostIdentifier;

        private List<LineItemRequest> lineItems = DefaultSdkAutoConstructList.getInstance();

        private String paymentOption;

        private String paymentTerm;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateOrderRequest model) {
            super(model);
            outpostIdentifier(model.outpostIdentifier);
            lineItems(model.lineItems);
            paymentOption(model.paymentOption);
            paymentTerm(model.paymentTerm);
        }

        public final String getOutpostIdentifier() {
            return outpostIdentifier;
        }

        public final void setOutpostIdentifier(String outpostIdentifier) {
            this.outpostIdentifier = outpostIdentifier;
        }

        @Override
        @Transient
        public final Builder outpostIdentifier(String outpostIdentifier) {
            this.outpostIdentifier = outpostIdentifier;
            return this;
        }

        public final List<LineItemRequest.Builder> getLineItems() {
            List<LineItemRequest.Builder> result = LineItemRequestListDefinitionCopier.copyToBuilder(this.lineItems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLineItems(Collection<LineItemRequest.BuilderImpl> lineItems) {
            this.lineItems = LineItemRequestListDefinitionCopier.copyFromBuilder(lineItems);
        }

        @Override
        @Transient
        public final Builder lineItems(Collection<LineItemRequest> lineItems) {
            this.lineItems = LineItemRequestListDefinitionCopier.copy(lineItems);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder lineItems(LineItemRequest... lineItems) {
            lineItems(Arrays.asList(lineItems));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder lineItems(Consumer<LineItemRequest.Builder>... lineItems) {
            lineItems(Stream.of(lineItems).map(c -> LineItemRequest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getPaymentOption() {
            return paymentOption;
        }

        public final void setPaymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
        }

        @Override
        @Transient
        public final Builder paymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
            return this;
        }

        @Override
        @Transient
        public final Builder paymentOption(PaymentOption paymentOption) {
            this.paymentOption(paymentOption == null ? null : paymentOption.toString());
            return this;
        }

        public final String getPaymentTerm() {
            return paymentTerm;
        }

        public final void setPaymentTerm(String paymentTerm) {
            this.paymentTerm = paymentTerm;
        }

        @Override
        @Transient
        public final Builder paymentTerm(String paymentTerm) {
            this.paymentTerm = paymentTerm;
            return this;
        }

        @Override
        @Transient
        public final Builder paymentTerm(PaymentTerm paymentTerm) {
            this.paymentTerm(paymentTerm == null ? null : paymentTerm.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateOrderRequest build() {
            return new CreateOrderRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
