/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.outposts.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a line item asset.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LineItemAssetInformation implements SdkPojo, Serializable,
        ToCopyableBuilder<LineItemAssetInformation.Builder, LineItemAssetInformation> {
    private static final SdkField<String> ASSET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssetId").getter(getter(LineItemAssetInformation::assetId)).setter(setter(Builder::assetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssetId").build()).build();

    private static final SdkField<List<String>> MAC_ADDRESS_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("MacAddressList")
            .getter(getter(LineItemAssetInformation::macAddressList))
            .setter(setter(Builder::macAddressList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MacAddressList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_ID_FIELD,
            MAC_ADDRESS_LIST_FIELD));

    private static final long serialVersionUID = 1L;

    private final String assetId;

    private final List<String> macAddressList;

    private LineItemAssetInformation(BuilderImpl builder) {
        this.assetId = builder.assetId;
        this.macAddressList = builder.macAddressList;
    }

    /**
     * <p>
     * The ID of the asset.
     * </p>
     * 
     * @return The ID of the asset.
     */
    public final String assetId() {
        return assetId;
    }

    /**
     * For responses, this returns true if the service returned a value for the MacAddressList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMacAddressList() {
        return macAddressList != null && !(macAddressList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * MAC addresses of the asset.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMacAddressList} method.
     * </p>
     * 
     * @return MAC addresses of the asset.
     */
    public final List<String> macAddressList() {
        return macAddressList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(assetId());
        hashCode = 31 * hashCode + Objects.hashCode(hasMacAddressList() ? macAddressList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LineItemAssetInformation)) {
            return false;
        }
        LineItemAssetInformation other = (LineItemAssetInformation) obj;
        return Objects.equals(assetId(), other.assetId()) && hasMacAddressList() == other.hasMacAddressList()
                && Objects.equals(macAddressList(), other.macAddressList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LineItemAssetInformation").add("AssetId", assetId())
                .add("MacAddressList", hasMacAddressList() ? macAddressList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AssetId":
            return Optional.ofNullable(clazz.cast(assetId()));
        case "MacAddressList":
            return Optional.ofNullable(clazz.cast(macAddressList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LineItemAssetInformation, T> g) {
        return obj -> g.apply((LineItemAssetInformation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LineItemAssetInformation> {
        /**
         * <p>
         * The ID of the asset.
         * </p>
         * 
         * @param assetId
         *        The ID of the asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetId(String assetId);

        /**
         * <p>
         * MAC addresses of the asset.
         * </p>
         * 
         * @param macAddressList
         *        MAC addresses of the asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder macAddressList(Collection<String> macAddressList);

        /**
         * <p>
         * MAC addresses of the asset.
         * </p>
         * 
         * @param macAddressList
         *        MAC addresses of the asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder macAddressList(String... macAddressList);
    }

    static final class BuilderImpl implements Builder {
        private String assetId;

        private List<String> macAddressList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LineItemAssetInformation model) {
            assetId(model.assetId);
            macAddressList(model.macAddressList);
        }

        public final String getAssetId() {
            return assetId;
        }

        public final void setAssetId(String assetId) {
            this.assetId = assetId;
        }

        @Override
        public final Builder assetId(String assetId) {
            this.assetId = assetId;
            return this;
        }

        public final Collection<String> getMacAddressList() {
            if (macAddressList instanceof SdkAutoConstructList) {
                return null;
            }
            return macAddressList;
        }

        public final void setMacAddressList(Collection<String> macAddressList) {
            this.macAddressList = MacAddressListCopier.copy(macAddressList);
        }

        @Override
        public final Builder macAddressList(Collection<String> macAddressList) {
            this.macAddressList = MacAddressListCopier.copy(macAddressList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder macAddressList(String... macAddressList) {
            macAddressList(Arrays.asList(macAddressList));
            return this;
        }

        @Override
        public LineItemAssetInformation build() {
            return new LineItemAssetInformation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
